/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.layout.format.FileLinkPreferences;
import org.jabref.logic.layout.format.NameFormatterPreferences;

public class LayoutFormatterPreferences {
    private final NameFormatterPreferences nameFormatterPreferences;
    private final JournalAbbreviationPreferences journalAbbreviationPreferences;
    private final FileLinkPreferences fileLinkPreferences;
    private final Map<String, String> customExportNameFormatters = new HashMap<String, String>();
    private final JournalAbbreviationLoader journalAbbreviationLoader;

    public LayoutFormatterPreferences(NameFormatterPreferences nameFormatterPreferences, JournalAbbreviationPreferences journalAbbreviationPreferences, FileLinkPreferences fileLinkPreferences, JournalAbbreviationLoader journalAbbreviationLoader) {
        this.nameFormatterPreferences = nameFormatterPreferences;
        this.journalAbbreviationPreferences = journalAbbreviationPreferences;
        this.fileLinkPreferences = fileLinkPreferences;
        this.journalAbbreviationLoader = journalAbbreviationLoader;
    }

    public NameFormatterPreferences getNameFormatterPreferences() {
        return this.nameFormatterPreferences;
    }

    public JournalAbbreviationPreferences getJournalAbbreviationPreferences() {
        return this.journalAbbreviationPreferences;
    }

    public FileLinkPreferences getFileLinkPreferences() {
        return this.fileLinkPreferences;
    }

    public JournalAbbreviationLoader getJournalAbbreviationLoader() {
        return this.journalAbbreviationLoader;
    }

    public void clearCustomExportNameFormatters() {
        this.customExportNameFormatters.clear();
    }

    public void putCustomExportNameFormatter(String formatterName, String contents) {
        this.customExportNameFormatters.put(formatterName, contents);
    }

    public Optional<String> getCustomExportNameFormatter(String formatterName) {
        return Optional.ofNullable(this.customExportNameFormatters.get(formatterName));
    }
}

