/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.protectedterms;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.util.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedTermsList
implements Comparable<ProtectedTermsList> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedTermsList.class);
    private String description;
    private final List<String> termsList;
    private final String location;
    private final boolean internalList;
    private boolean enabled;

    public ProtectedTermsList(String description, List<String> termList, String location, boolean internalList) {
        this.description = Objects.requireNonNull(description);
        this.termsList = Objects.requireNonNull(termList);
        this.location = Objects.requireNonNull(location);
        this.internalList = internalList;
    }

    public ProtectedTermsList(String description, List<String> termList, String location) {
        this(description, termList, location, false);
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTermList() {
        return this.termsList;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTermListing() {
        return String.join((CharSequence)"\n", this.termsList);
    }

    @Override
    public int compareTo(ProtectedTermsList otherList) {
        return this.getDescription().compareTo(otherList.getDescription());
    }

    public boolean isInternalList() {
        return this.internalList;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean createAndWriteHeading(String newDescription) {
        this.description = newDescription;
        return this.addProtectedTerm("# " + newDescription, true);
    }

    public boolean addProtectedTerm(String term) {
        return this.addProtectedTerm(term, false);
    }

    public boolean addProtectedTerm(String term, boolean create) {
        Objects.requireNonNull(term);
        if (this.internalList) {
            return false;
        }
        Path p = Paths.get(this.location, new String[0]);
        String s2 = OS.NEWLINE + term;
        try (BufferedWriter writer = Files.newBufferedWriter(p, StandardCharsets.UTF_8, create ? StandardOpenOption.CREATE : StandardOpenOption.APPEND);){
            writer.write(s2);
            this.termsList.add(term);
        }
        catch (IOException ioe) {
            LOGGER.warn("Problem adding protected term to list", ioe);
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProtectedTermsList)) {
            return false;
        }
        ProtectedTermsList otherList = (ProtectedTermsList)o;
        return this.location.equals(otherList.location) && this.description.equals(otherList.description);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.description);
    }
}

