/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.model.entry.EntryConverter;

public interface EntryType
extends Comparable<EntryType> {
    public String getName();

    public Set<String> getOptionalFields();

    public Set<String> getRequiredFields();

    default public Set<String> getRequiredFieldsFlat() {
        List requiredFlat = this.getRequiredFields().stream().map(field2 -> field2.split("/")).flatMap(Arrays::stream).collect(Collectors.toList());
        return Collections.unmodifiableSet(new LinkedHashSet(requiredFlat));
    }

    default public Set<String> getAllFields() {
        List allFields = Stream.concat(this.getRequiredFieldsFlat().stream(), this.getOptionalFields().stream()).collect(Collectors.toList());
        return Collections.unmodifiableSet(new LinkedHashSet(allFields));
    }

    public Set<String> getPrimaryOptionalFields();

    public Set<String> getSecondaryOptionalFields();

    default public Set<String> getDeprecatedFields() {
        LinkedHashSet<String> deprecatedFields = new LinkedHashSet<String>(EntryConverter.FIELD_ALIASES_TEX_TO_LTX.keySet());
        deprecatedFields.add("year");
        deprecatedFields.add("month");
        deprecatedFields.retainAll(this.getOptionalFieldsAndAliases());
        return deprecatedFields;
    }

    default public Set<String> getSecondaryOptionalNotDeprecatedFields() {
        LinkedHashSet<String> optionalFieldsNotPrimaryOrDeprecated = new LinkedHashSet<String>(this.getSecondaryOptionalFields());
        optionalFieldsNotPrimaryOrDeprecated.removeAll(this.getDeprecatedFields());
        return optionalFieldsNotPrimaryOrDeprecated;
    }

    default public Set<String> getOptionalFieldsAndAliases() {
        LinkedHashSet<String> optionalFieldsAndAliases = new LinkedHashSet<String>();
        for (String field2 : this.getOptionalFields()) {
            optionalFieldsAndAliases.add(field2);
            if (!EntryConverter.FIELD_ALIASES_LTX_TO_TEX.containsKey(field2)) continue;
            optionalFieldsAndAliases.add(EntryConverter.FIELD_ALIASES_LTX_TO_TEX.get(field2));
        }
        return optionalFieldsAndAliases;
    }
}

