/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.IReferenceDescriptor;
import org.xmind.gef.draw2d.IRelayerableFigure;
import org.xmind.gef.draw2d.IRotatable;
import org.xmind.gef.draw2d.IRotatableReferenceDescriptor;
import org.xmind.gef.draw2d.IRotatableReferencedFigure;
import org.xmind.gef.draw2d.IRotatableReferencedLayout;
import org.xmind.gef.draw2d.IShadowedFigure;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.gef.draw2d.graphics.GrayedGraphics;
import org.xmind.ui.decorations.ITopicDecoration;

public class TopicFigure
extends DecoratedShapeFigure
implements ITitledFigure,
IMinimizable,
IShadowedFigure,
IRotatableReferencedFigure,
IRelayerableFigure,
ITransparentableFigure {
    protected static final int FLAG_MINIMIZED = MAX_FLAG << 1;
    protected static final int FLAG_RELAYERED;
    private ITextFigure title = null;
    private PrecisionRotator rotator = null;
    private int selfAlpha = 255;
    private int treeAlpha = 255;

    static {
        MAX_FLAG = FLAG_RELAYERED = MAX_FLAG << 2;
    }

    public ITextFigure getTitle() {
        return this.title;
    }

    public void setTitle(ITextFigure title) {
        if (title == this.title) {
            return;
        }
        this.title = title;
        this.revalidate();
        this.repaint();
    }

    protected PrecisionRotator r() {
        if (this.rotator == null) {
            this.rotator = new PrecisionRotator();
        }
        return this.rotator;
    }

    public ITopicDecoration getDecoration() {
        return (ITopicDecoration)super.getDecoration();
    }

    protected Insets calculatePreferredInsets() {
        if (this.isMinimized()) {
            return NO_INSETS;
        }
        return super.calculatePreferredInsets();
    }

    public boolean isMinimized() {
        return this.getFlag(FLAG_MINIMIZED);
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized()) {
            return;
        }
        this.setFlag(FLAG_MINIMIZED, minimized);
        this.revalidate();
        this.repaint();
    }

    public boolean isShadowShowing() {
        IFigure p = this.getParent();
        while (p != null) {
            if (p instanceof IShadowedFigure && !((IShadowedFigure)p).isShadowShowing()) {
                return false;
            }
            p = p.getParent();
        }
        return this.isShowing();
    }

    public void paintShadow(Graphics graphics) {
        if (this.getDecoration() != null && this.getDecoration() instanceof IShadowedDecoration) {
            ((IShadowedDecoration)this.getDecoration()).paintShadow((IFigure)this, graphics);
        }
    }

    public String toString() {
        if (this.title != null) {
            return "TopicFigure(" + this.title.getText() + ")";
        }
        return super.toString();
    }

    public PrecisionRectangle getNormalPreferredBounds(Point reference) {
        PrecisionInsets ins = this.getNormalReferenceDescription();
        return new PrecisionRectangle((double)reference.x - ins.left, (double)reference.y - ins.top, ins.getWidth(), ins.getHeight());
    }

    public PrecisionInsets getNormalReferenceDescription() {
        if (this.getReferenceDescriptor() instanceof IRotatableReferenceDescriptor) {
            return ((IRotatableReferenceDescriptor)this.getReferenceDescriptor()).getNormalReferenceDescription((IFigure)this);
        }
        return new PrecisionInsets(this.getReferenceDescription());
    }

    public PrecisionDimension getNormalPreferredSize(int wHint, int hHint) {
        if (this.getLayoutManager() instanceof IRotatableReferencedLayout) {
            return ((IRotatableReferencedLayout)this.getLayoutManager()).getNormalPreferredSize((IFigure)this, wHint, hHint);
        }
        return new PrecisionDimension(this.getPreferredSize(wHint, hHint));
    }

    public double getRotationDegrees() {
        return this.r().getAngle();
    }

    public void setRotationDegrees(double degrees) {
        double oldAngle = this.getRotationDegrees();
        this.r().setAngle(degrees);
        if (this.getBorder() instanceof IRotatable) {
            ((IRotatable)this.getBorder()).setRotationDegrees(degrees);
        }
        if (this.getLayoutManager() instanceof IRotatable) {
            ((IRotatable)this.getLayoutManager()).setRotationDegrees(degrees);
        }
        if (this.getReferenceDescriptor() instanceof IRotatable) {
            ((IRotatable)this.getReferenceDescriptor()).setRotationDegrees(degrees);
        }
        for (Object child : this.getChildren()) {
            if (!(child instanceof IRotatable)) continue;
            ((IRotatable)child).setRotationDegrees(degrees);
        }
        if (degrees != oldAngle) {
            this.revalidate();
            this.repaint();
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        if (figure instanceof IRotatable) {
            ((IRotatable)figure).setRotationDegrees(this.getRotationDegrees());
        }
    }

    public void setLayoutManager(LayoutManager manager) {
        super.setLayoutManager(manager);
        if (manager instanceof IRotatable) {
            ((IRotatable)manager).setRotationDegrees(this.getRotationDegrees());
        }
    }

    public void setReferenceDescriptor(IReferenceDescriptor descriptor) {
        super.setReferenceDescriptor(descriptor);
        if (descriptor instanceof IRotatable) {
            ((IRotatable)descriptor).setRotationDegrees(this.getRotationDegrees());
        }
    }

    public boolean isRelayered() {
        return this.getFlag(FLAG_RELAYERED);
    }

    public void setRelayered(boolean relayered) {
        if (relayered == this.isRelayered()) {
            return;
        }
        this.setFlag(FLAG_RELAYERED, relayered);
        this.repaint();
    }

    public void paintRelayered(Graphics graphics) {
        super.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.isRelayered()) {
            return;
        }
        if (this.getMainAlpha() < 255) {
            AlphaGraphics ag = new AlphaGraphics(graphics);
            ag.setMainAlpha(this.getMainAlpha());
            ag.setAlpha(graphics.getAlpha());
            try {
                this.doPaint((Graphics)ag);
            }
            finally {
                ag.dispose();
            }
        } else {
            this.doPaint(graphics);
        }
    }

    private void doPaint(Graphics graphics) {
        if (this.isEnabled()) {
            super.paint(graphics);
        } else {
            GrayedGraphics gg = new GrayedGraphics(graphics);
            try {
                super.paint((Graphics)gg);
            }
            finally {
                gg.dispose();
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.getSubAlpha() < 255) {
            AlphaGraphics ag = new AlphaGraphics(graphics);
            ag.setMainAlpha(this.getSubAlpha());
            try {
                this.doPaintFigure((Graphics)ag);
            }
            finally {
                ag.dispose();
            }
        } else {
            this.doPaintFigure(graphics);
        }
    }

    private void doPaintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
    }

    public int getMainAlpha() {
        return this.treeAlpha;
    }

    public int getSubAlpha() {
        return this.selfAlpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.treeAlpha) {
            return;
        }
        this.treeAlpha = alpha;
        this.repaint();
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.selfAlpha) {
            return;
        }
        this.selfAlpha = alpha;
        this.repaint();
    }
}

