/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QL_FCOE_VMKMGMT_H
#define __QL_FCOE_VMKMGMT_H

#include "ql_fcoe_vmkmgmt_struct.h"

#define	QL_FCOE_GET_HBACNT	(VMK_MGMT_RESERVED_CALLBACKS + 1)
#define	QL_FCOE_GET_HOSTNO	(VMK_MGMT_RESERVED_CALLBACKS + 2)
#define	QL_FCOE_GET_PCI_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 3)
#define	QL_FCOE_GET_PORT_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 4)
#define	QL_FCOE_GET_PORT_STATS	(VMK_MGMT_RESERVED_CALLBACKS + 5)
#define	QL_FCOE_GET_TGT_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 6)
#define	QL_FCOE_GET_FCF_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 7)
#define	QL_FCOE_SEND_SCSI_CMD	(VMK_MGMT_RESERVED_CALLBACKS + 8)

#define	QL_FCOE_NUM_CALLBACKS	8

/* The name used to describe Common interface. */
#define	QL_FCOE_INTERFACE_NAME	"ql_fcoe"

#define QL_FCOE_INTERFACE_VENDOR	"QLogic"

struct ql_fcoe_hba_cnt_cb {
	UINT32 hba_cnt;
	UINT32 status;
} __attribute__((__packed__));

struct ql_fcoe_hostno_cb {
	UINT64 inst;
	UINT32 host_no;
	UINT32 status;
} __attribute__((__packed__));

struct ql_fcoe_pci_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_pci_info pci;
} __attribute__((__packed__));	/* 72 */

struct ql_fcoe_port_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_port_info port;
} __attribute__((__packed__));	/* 520 */

struct ql_fcoe_port_stats_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_port_stats stats;
} __attribute__((__packed__));	/* 520 */

struct ql_fcoe_tgt_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_tgt_info tgt;
} __attribute__((__packed__));	/* 72 */

struct ql_fcoe_fcf_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_fcf_info fcf;
} __attribute__((__packed__));	/* 72 */

struct ql_fcoe_scsi_cmd_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_fcoe_scsi_cmd cmnd;
} __attribute__((__packed__));	/* 262444 */

/* Callback function declarations */
#ifdef VMKERNEL
int ql_fcoe_get_hba_cnt(UINT64, UINT64, struct ql_fcoe_hba_cnt_cb *);
int ql_fcoe_get_hostno(UINT64, UINT64, struct ql_fcoe_hostno_cb *);
int ql_fcoe_get_pci_info(UINT64, UINT64, struct ql_fcoe_pci_info_cb *);
int ql_fcoe_get_port_info(UINT64, UINT64, struct ql_fcoe_port_info_cb *);
int ql_fcoe_get_port_stats(UINT64, UINT64, struct ql_fcoe_port_stats_cb *);
int ql_fcoe_get_tgt_info(UINT64, UINT64, struct ql_fcoe_tgt_info_cb *);
int ql_fcoe_get_fcf_info(UINT64, UINT64, struct ql_fcoe_fcf_info_cb *);
int ql_fcoe_send_scsi_cmd(UINT64, UINT64, struct ql_fcoe_scsi_cmd_cb *);
#else
#define ql_fcoe_get_hba_cnt	NULL
#define ql_fcoe_get_hostno	NULL
#define ql_fcoe_get_pci_info	NULL
#define ql_fcoe_get_port_info	NULL
#define ql_fcoe_get_port_stats	NULL
#define ql_fcoe_get_tgt_info	NULL
#define ql_fcoe_get_fcf_info	NULL
#define ql_fcoe_send_scsi_cmd	NULL
#endif	/* VMKERNEL */

vmk_MgmtCallbackInfo ql_fcoe_callbacks[QL_FCOE_NUM_CALLBACKS] = {
	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_hba_cnt,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_hba_cnt_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_HBACNT,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_hostno,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_hostno_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_HOSTNO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_pci_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_pci_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_PCI_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_port_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_port_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_PORT_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_port_stats,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_port_stats_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_PORT_STATS,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_tgt_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_tgt_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_TGT_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_get_fcf_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_fcf_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_GET_FCF_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_fcoe_send_scsi_cmd,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_fcoe_scsi_cmd_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_FCOE_SEND_SCSI_CMD,
	},
};

vmk_MgmtApiSignature ql_fcoe_sig = {
	.version = VMK_REVISION_FROM_NUMBERS(1,0,0,0),
	.name.string = QL_FCOE_INTERFACE_NAME,
	.vendor.string = QL_FCOE_INTERFACE_VENDOR,
	.numCallbacks = QL_FCOE_NUM_CALLBACKS,
	.callbacks = ql_fcoe_callbacks,
};

#endif /* __QL_FCOE_VMKMGMT_H */
