/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QL_ISCSI_VMKMGMT_STRUCT_H
#define __QL_ISCSI_VMKMGMT_STRUCT_H

#include "ql_iscsi_basetypes.h"

struct ql_iscsi_pci_info {
	UINT16 vendor_id;
	UINT16 device_id;
	UINT16 subvendor_id;
	UINT16 subsystem_id;
	UINT16 domain_num;
	UINT16 bus_num;
	UINT16 device_num;
	UINT16 function_num;
	UINT16 revision;
	UINT16 port_num;
	UINT32 pcie_speed;
	UINT32 pcie_width;
	UINT32 chip_rev_id;
	UINT8 reserved[32];
} __attribute__((__packed__));	/* 64 */

struct ql_iscsi_port_info {
	UINT8 manufacturer[QLEVIS_SIZE_64];
	UINT8 model_name[QLEVIS_SIZE_32];
	UINT8 model_desc[QLEVIS_SIZE_128];
	UINT8 serial_num[QLEVIS_SIZE_32];
	UINT8 driver_version[QLEVIS_SIZE_32];
	UINT8 driver_date[QLEVIS_SIZE_32];
	UINT8 driver_name[QLEVIS_SIZE_16];
	UINT8 driver_loaded;
	UINT8 fw_version[QLEVIS_SIZE_32];
	UINT8 iqn[QLEVIS_SIZE_256];
	UINT8 mac[QLEVIS_SIZE_6];
	UINT16 ipv4_port;
	UINT8 is_dhcp;
	UINT8 ipv4addr[QLEVIS_SIZE_4];
	UINT8 subnet[QLEVIS_SIZE_4];
	UINT8 gateway[QLEVIS_SIZE_4];
	UINT16 ipv6_port;
	UINT8 ipv6addr[QLEVIS_SIZE_16];
	UINT8 ipv6_linklocal[QLEVIS_SIZE_16];
	UINT8 ipv6_router[QLEVIS_SIZE_16];
	UINT8 vlan_enabled;
	UINT8 vlan_priority;
	UINT16 port_state;
	UINT16 port_sup_speed;
	UINT16 port_speed;
	UINT32 session_cnt;
	UINT32 mtu;
	UINT32 vlan;
	UINT32 mfw_version;
	UINT8 hba_name[QLEVIS_SIZE_32];
	UINT8 reserved[16];
} __attribute__((__packed__));	/* 512 */

/* Session State */
#define QL_ISCSI_SESS_INITIAL		0x01
#define QL_ISCSI_SESS_IN_FFP		0x02
#define QL_ISCSI_SESS_IN_RECOVERY	0x04
#define QL_ISCSI_SESS_IN_SHUTDOWN	0x08
#define QL_ISCSI_SESS_IN_LOGOUT		0x40
#define QL_ISCSI_SESS_DESTROYED		0x80
#define QL_ISCSI_SESS_TARGET_DESTROYED	0x100

/* Session Recovery State */
#define QL_ISCSI_SESS_RECOVERY_START		0x01
#define QL_ISCSI_SESS_RECOVERY_OPEN_ISCSI	0x02
#define QL_ISCSI_SESS_RECOVERY_COMPLETE		0x04
#define QL_ISCSI_SESS_RECOVERY_FAILED		0x08
#define QL_ISCSI_SESS_RECOVERY_MASK		0xFFFF

struct ql_iscsi_sess_info {
	UINT32 sess_num;
	UINT64 sess_unique;
	UINT8 init_iqn[QLEVIS_SIZE_256];
	UINT16 init_ipv4_port;
	UINT8 init_ipv4addr[QLEVIS_SIZE_4];
	UINT16 init_ipv6_port;
	UINT8 init_ipv6addr[QLEVIS_SIZE_16];
	UINT8 init_mac[QLEVIS_SIZE_6];
	UINT8 tgt_iqn[QLEVIS_SIZE_256];
	UINT16 tgt_ipv4_port;
	UINT8 tgt_ipv4addr[QLEVIS_SIZE_4];
	UINT16 tgt_ipv6_port;
	UINT8 tgt_ipv6addr[QLEVIS_SIZE_16];
	UINT8 tgt_mac[QLEVIS_SIZE_6];
	UINT8 isid[13];
	UINT32 state;
	UINT64 recovery_state;
	UINT64 old_recovery_state;
	UINT32 tmf_active;
	UINT32 do_recovery_inprogess;
	UINT32 device_offline;
	UINT32 max_iscsi_tasks;
	UINT32 num_free_cmds;
	UINT32 allocated_cmds;
	UINT32 total_cmds_allocated;
	UINT32 total_cmds_freed;
	UINT32 sq_size;
	UINT32 login_noop_pending;
	UINT32 tmf_pending;
	UINT32 logout_pending;
	UINT32 nop_resp_pending;
	UINT32 pend_cmd_count;
	UINT32 active_cmd_count;
	UINT32 cmd_cleanup_req;
	UINT32 cmd_cleanup_cmpl;
	UINT32 total_cmds_sent;
	UINT32 total_cmds_queued;
	UINT32 total_cmds_completed;
	UINT32 total_cmds_failed;
	UINT32 total_cmds_completed_by_chip;
	UINT32 cmdsn;
	UINT32 exp_cmdsn;
	UINT32 max_cmdsn;
	UINT32 initial_r2t;
	UINT32 max_r2t;
	UINT32 imm_data;
	UINT32 first_burst_len;
	UINT32 max_burst_len;
	UINT32 time2wait;
	UINT32 time2retain;
	UINT32 pdu_inorder;
	UINT32 dataseq_inorder;
	UINT32 erl;
	UINT32 tgt_prtl_grp;
	UINT32 num_active_conn;
	UINT32 max_conns;
	UINT64 last_nooput_requested;
	UINT64 last_nooput_posted;
	UINT64 last_noopin_indicated;
	UINT64 last_noopin_processed;
	UINT32 last_nooput_sn;
	UINT32 noopout_resp_count;
	UINT32 unsol_noopout_count;
	UINT32 noopout_requested_count;
	UINT32 noopout_posted_count;
	UINT32 noopin_indicated_count;
	UINT32 noopin_processed_count;
	UINT32 tgt_noopin_count;
	UINT32 alloc_scsi_task_failed;
	UINT32 cid;
	UINT32 iscsi_cid;
	UINT8 reserved[179];
} __attribute__((__packed__));	/* 1024 bytes */

struct ql_iscsi_tgt_info {
	UINT32 scsi_bus_num;
	UINT32 scsi_tgt_num;
	UINT8 iqn[QLEVIS_SIZE_256];
	UINT8 mac[QLEVIS_SIZE_6];
	UINT8 isid[13];
	UINT16 ipv4_port;
	UINT8 ipv4addr[QLEVIS_SIZE_4];
	UINT16 ipv6_port;
	UINT8 ipv6addr[QLEVIS_SIZE_16];
	UINT16 port_type;
	UINT32 lun_count;
	UINT8 reserved[71];
} __attribute__((__packed__));	/* 384 */

/* SCSI Command data direction */
#define QL_ISCSI_DATA_DIRECTION_NONE	0
#define QL_ISCSI_DATA_DIRECTION_IN	1
#define QL_ISCSI_DATA_DIRECTION_OUT	2

struct ql_iscsi_scsi_cmd {
	UINT32 bus;
	UINT32 tgt;
	UINT32 lun;
	UINT8 direction;
	UINT8 cdb_len;
	UINT8 cdb[QLEVIS_SIZE_16];
	UINT16 sense_len;
	UINT8 sense[QLEVIS_SIZE_256];
	UINT32 data_len;
	UINT8 data_buffer[QLEVIS_SIZE_256K];
} __attribute__((__packed__));	/* 262436 */

#endif /* __QL_ISCSI_VMKMGMT_STRUCT_H */
