/*******************************************************************************
 * The information contained in this file is confidential and proprietary to
 * QLogic Corporation.  No part of this file may be reproduced or
 * distributed, in any form or by any means for any purpose, without the
 * express written permission of QLogic Corporation.
 *
 * (c) COPYRIGHT 2015 QLogic Corporation, ALL RIGHTS RESERVED.
 *******************************************************************************/
/* **********************************************************
 * Copyright 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * qfle3.h --
 *
 *      Header file for native qfle3 driver.
 */

#ifndef _QFLE3_H_
#define _QFLE3_H_

#include "vmkapi.h"
#include "qfle3_stats.h"
#include "qfle3_osal.h"
#include "qfle3_ecore_reg.h"
#include "qfle3_ecore_hsi.h"
#include "qfle3_ecore_link.h"
#include "qfle3_ecore_sp.h"
#include "qfle3_ecore_hw_dump.h"
#include "qfle3_dcbx.h"
#ifdef QFLE3_CNIC
#define QFLE3_NIC_DRV
#include "qfle3_cnic.h"
#endif

#define VMK_API_2_4_0_0 VMK_REVISION_FROM_NUMBERS(2, 4, 0, 0)
#define QFLE3_CNIC_DEVICE_IDENTIFIER "com.qlogic.cnicDev"

#define QFLE3_MAX_FILTERS_PER_QUEUE   272

#define QFLE3_INVALID_FILTER_ID 0xFFFF

/* debug logging codepaths */
#define QFLE3_DBG_LOAD   0x00000001     /* load and unload    */
#define QFLE3_DBG_INTR   0x00000002     /* interrupt handling */
#define QFLE3_DBG_SP     0x00000004     /* slowpath handling  */
#define QFLE3_DBG_STATS  0x00000008     /* stats updates      */
#define QFLE3_DBG_TX     0x00000010     /* packet transmit    */
#define QFLE3_DBG_RX     0x00000020     /* packet receive     */
#define QFLE3_DBG_LINK   0x00000040     /* phy/link handling  */
#define QFLE3_DBG_IOCTL  0x00000080     /* not used     */
#define QFLE3_DBG_MBUF   0x00000100     /* dumping mbuf info  */
#define QFLE3_DBG_REGS   0x00000200     /* register access    */
#define QFLE3_DBG_LRO    0x00000400     /* lro processing     */
#define QFLE3_DBG_UPLINK 0x00000800     /* uplink debug       */
#define QFLE3_DBG_QUEUE  0x00001000     /* qeueu debug       */
#define QFLE3_DBG_HW	 0x00002000     /* hw debug       */
#define QFLE3_DBG_MCP	 0x00004000     /* cmp debug  */
#define QFLE3_DBG_START	 0x00008000     /* start process debug  */
#define QFLE3_DBG_ASSERT 0x00010000     /* debug assert       */
#define QFLE3_DBG_POLL   0x00020000     /* debug poll       */
#define QFLE3_DBG_TX_SG  0x00040000     /* debug TXSG       */
#define QFLE3_DBG_DEAD   0x00080000     /* debug crash       */
#define QFLE3_DBG_VLAN   0x00100000     /* debug vlan       */
#define QFLE3_DBG_SM     0x00200000     /* state machine      */
#define QFLE3_DBG_NVM	 0x00400000     /* nvm access      */
#ifdef QFLE3_SRIOV
#define QFLE3_DBG_IOV    0x00800000     /* SRIOV        */
#endif //QFLE3_SRIOV
#define QFLE3_DBG_MGMT   0x01000000     /* mgmt interface   */
#define QFLE3_DBG_CNIC   0x02000000     /* CNIC */
#define QFLE3_DBG_DCB    0x04000000     /* DCB */
#define QFLE3_DBG_KERNEL 0x08000000     /* Kernel Cmds */
#define QFLE3_DBG_ALL    0xFFFFFFFF     /* flying monkeys     */

#define QFLE3_STATE_CLOSED              0
#define QFLE3_STATE_OPENING_WAIT4_LOAD  0x1000
#define QFLE3_STATE_OPENING_WAIT4_PORT  0x2000
#define QFLE3_STATE_OPEN                0x3000
#define QFLE3_STATE_CLOSING_WAIT4_HALT  0x4000
#define QFLE3_STATE_CLOSING_WAIT4_DELETE 0x5000

#define QFLE3_STATE_DIAG                0xe000
#define QFLE3_STATE_ERROR               0xf000


#define RXQ	0
#define TXQ	1

#define ALLOC_RXQ RXQ
#define ALLOC_TXQ TXQ
#define NUM_MACS	8


#define QFLE3_MAX_LSO_SIZE		0xFFFF
#define QFLE3_MIN_LSO_SEG_CNT		2

/*
 * Macros
 */
#define MIN(_a, _b)	(((_a) < (_b)) ? (_a) :(_b))
#define MAX(_a, _b)	(((_a) > (_b)) ? (_a) :(_b))
#define QFLE3_IS_NAME_EMPTY(name)   (*((name).string) == '\0')
#define QFLE3_NAME_TO_STRING(name)  ((name).string)

#define QFLE3_BC_VER            0x040200

#define QFLE3_RX_FILTER_ACTIVE                     0x0001
#define QFLE3_RX_FILTER_IS_MAC                     0x0002
#define QFLE3_RX_FILTER_IS_MACVLAN         0x0004
#define QFLE3_RX_FILTER_IS_VXLAN           0x0008

#define QFLE3_IS_FILTER_ACTIVE(FP, IDX)                 \
   (FP->rx_filters[IDX].flags & QFLE3_RX_FILTER_ACTIVE)

#define QFLE3_PCIR_COMMAND (0x4)
#define QFLE3_PCI_REG_COMMAND_BUS_MASTER (0x4)

#define QFLE3_SBDF_FMT       "%04x:%02x:%02x.%x"
#define QFLE3_PCIID_FMT      "%04x:%04x %04x:%04x"

#define PCIX_FLAG                       (1 << 0)
#define PCI_32BIT_FLAG                  (1 << 1)
#define ONE_PORT_FLAG                   (1 << 2)
#define NO_WOL_FLAG                     (1 << 3)
#define LEGACY_DISABLE_TPA_FLAG         (1 << 4)
#define USING_MSIX_FLAG                 (1 << 5)
#define USING_MSI_FLAG                  (1 << 6)
#define DISABLE_MSI_FLAG                (1 << 7)
#define NO_MCP_FLAG                     (1 << 9)
#define MF_FUNC_DIS                     (1 << 11)
#define OWN_CNIC_IRQ                    (1 << 12)
#define NO_ISCSI_OOO_FLAG               (1 << 13)
#define NO_ISCSI_FLAG                   (1 << 14)
#define NO_FCOE_FLAG                    (1 << 15)
#define CNA_ENABLED                     (1 << 16)
#define BC_SUPPORTS_PFC_STATS           (1 << 17)
#define TX_SWITCHING                    (1 << 18)
#define BC_SUPPORTS_FCOE_FEATURES       (1 << 19)
#define USING_SINGLE_MSIX_FLAG          (1 << 20)
#define BC_SUPPORTS_DCBX_MSG_NON_PMF    (1 << 21)
#ifdef QFLE3_SRIOV
#define SRIOV_ENABLED_FLAG              (1 << 22)
#endif //QFLE3_SRIOV
#define BC_SUPPORTS_RMMOD_CMD           (1 << 23)
#define HAS_PHYS_PORT_ID                (1 << 24)
#define MCP_SUPPORTS_S_CHANNEL_DOWN     (1 << 25)

#define QFLE3_RX_MODE_NONE              0
#define QFLE3_RX_MODE_NORMAL            1
#define QFLE3_RX_MODE_ALLMULTI          2
#define QFLE3_RX_MODE_PROMISC           3
#define QFLE3_MAX_MULTICAST             64

#define QFLE3_LOAD_NORMAL               0
#define QFLE3_LOAD_DIAG                 2
#define QFLE3_LOAD_LOOPBACK_EXT         3

#define QFLE3_PHY_REG_SHIFT      0
#define QFLE3_PHY_DEV_ADDR_SHIFT 16
#define QFLE3_PHY_PHY_ADDR_SHIFT 21

#ifndef BIT
#define BIT(x)  (1 << (x))
#endif

enum qfle3_lock_rank_t {
   QFLE3_LOCK_RANK_INVALID = 0,
   QFLE3_LOCK_RANK_LOW = 1,
   QFLE3_LOCK_RANK_HIGH,
};


#ifdef QFLE3_SRIOV
#define VMK_PCI_CFG_SPACE_SIZE 256
#define VMK_PCI_CFG_SPACE_EXP_SIZE 4096
#define QFLE3_MAX_NUM_OF_PFS	16
#define QFLE3_VF_CID_WND        4 /* log num of queues per VF. HW config. */
#define QFLE3_CIDS_PER_VF       (1 << QFLE3_VF_CID_WND)
/* We need to reserve doorbell addresses for all VF and queue combinations */
#define QFLE3_VF_CIDS           (QFLE3_MAX_NUM_OF_VFS * QFLE3_CIDS_PER_VF)
#define QFLE3_FIRST_VF_CID      QFLE3_VF_CIDS
#define TLV_BUFFER_SIZE         1024
#define FLRD_VFS_DWORDS 	(QFLE3_MAX_NUM_OF_VFS / 32)
#define FW_PF_MAX_HANDLE        8
#define FW_VF_HANDLE(abs_vfid)  \
        (abs_vfid + FW_PF_MAX_HANDLE)
#define HW_VF_HANDLE(adapter, abs_vfid) \
        (vmk_uint16)(QFLE3_ABS_FUNC((adapter)) | (1<<3) | ((vmk_uint16)(abs_vfid) << 4))
#define QFLE3_VF_MAX_QUEUES             16
#define QFLE3_VF_MAX_TPA_AGG_QUEUES     8
#define MAX_TLVS_IN_LIST 	50
#define QFLE3_MAX_NUM_VF_QUEUES 64

#ifndef PCI_SRIOV_NUM_BARS
#define PCI_SRIOV_NUM_BARS      6
#endif

#ifndef PCI_IOV_RESOURCES
#define PCI_IOV_RESOURCES       7
#endif

#ifndef PCI_EXT_CAP_ID_SRIOV
#define PCI_EXT_CAP_ID_SRIOV    16
#endif

#ifndef PCI_SRIOV_CAP
#define PCI_SRIOV_CAP           0x04
#endif

#ifndef PCI_SRIOV_CTRL
#define PCI_SRIOV_CTRL          0x08
#endif

#ifndef PCI_SRIOV_INITIAL_VF
#define PCI_SRIOV_INITIAL_VF    0x0c
#endif

#ifndef PCI_SRIOV_TOTAL_VF
#define PCI_SRIOV_TOTAL_VF      0x0e
#endif

#ifndef PCI_SRIOV_FUNC_LINK
#define PCI_SRIOV_FUNC_LINK     0x12
#endif

#ifndef PCI_SRIOV_VF_OFFSET
#define PCI_SRIOV_VF_OFFSET     0x14
#endif

#ifndef PCI_SRIOV_VF_STRIDE
#define PCI_SRIOV_VF_STRIDE     0x16
#endif

#ifndef PCI_SRIOV_SUP_PGSIZE
#define PCI_SRIOV_SUP_PGSIZE    0x1c
#endif
#define MBX_MSG_ALIGN   8
#define MBX_MSG_ALIGNED_SIZE    (ROUNDUP(sizeof(struct qfle3_vf_mbx_msg), \
                                MBX_MSG_ALIGN))
#define BULLETIN_CONTENT_SIZE   (sizeof(struct pf_vf_bulletin_content))

#define VFPF_MAC_FILTER         VFPF_Q_FILTER_DEST_MAC_VALID
#define VFPF_VLAN_FILTER        VFPF_Q_FILTER_VLAN_TAG_VALID
#define VFPF_VLAN_MAC_FILTER    (VFPF_VLAN_FILTER | VFPF_MAC_FILTER)

#define BULLETIN_CONTENT_SIZE           (sizeof(struct pf_vf_bulletin_content))
#define BULLETIN_CONTENT_LEGACY_SIZE    (32)
#define BULLETIN_ATTEMPTS       5 /* crc failures before throwing towel */
#define BULLETIN_CRC_SEED       0

#define VFPF_QUEUE_FLG_TPA              0x0001
#define VFPF_QUEUE_FLG_TPA_IPV6         0x0002
#define VFPF_QUEUE_FLG_TPA_GRO          0x0004
#define VFPF_QUEUE_FLG_CACHE_ALIGN      0x0008
#define VFPF_QUEUE_FLG_STATS            0x0010
#define VFPF_QUEUE_FLG_OV               0x0020
#define VFPF_QUEUE_FLG_VLAN             0x0040
#define VFPF_QUEUE_FLG_COS              0x0080
#define VFPF_QUEUE_FLG_HC               0x0100
#define VFPF_QUEUE_FLG_DHC              0x0200
#define VFPF_QUEUE_FLG_LEADING_RSS      0x0400

#define VFPF_RX_MASK_ACCEPT_NONE                0x00000000
#define VFPF_RX_MASK_ACCEPT_MATCHED_UNICAST     0x00000001
#define VFPF_RX_MASK_ACCEPT_MATCHED_MULTICAST   0x00000002
#define VFPF_RX_MASK_ACCEPT_ALL_UNICAST         0x00000004
#define VFPF_RX_MASK_ACCEPT_ALL_MULTICAST       0x00000008
#define VFPF_RX_MASK_ACCEPT_BROADCAST           0x00000010
#define VFPF_RX_MASK_ACCEPT_ANY_VLAN            0x00000020

#define QFLE3_MAC_FMT           "%02x:%02x:%02x:%02x:%02x:%02x"
#define QFLE3_MAC_PRN_LIST(mac) (mac)[0], (mac)[1], (mac)[2], (mac)[3], (mac)[4], (mac)[5]

#define QFLE3_ESX_GET_STORM_STAT_64(x, y) \
	(HILO_U64(old_##x->y.hi, \
		  old_##x->y.lo) + \
	 HILO_U64(le32toh(x->y.hi), \
		  le32toh(x->y.lo)))
#define QFLE3_ESX_GET_STORM_STAT_32(x, y) \
	(old_##x->y + le32toh(x->y))


#endif //QFLE3_SRIOV

#define QFLE3_MAX_NUM_OF_VFS    64


/*Utility MACROs. Move to other file?*/
#define MAX_OF(x, y) ((x) > (y))? (x):(y)
#define MIN_OF(x, y) ((x) < (y))? (x):(y)
#define DIV_ROUND_UP(n, d) (((n) + (d) - 1) / (d))
#define ROUNDUP(x, y) ((((x) + ((y) - 1)) / (y)) * (y))


#define L1_CACHE_SHIFT (qfle3_ilog2((VMK_L1_CACHELINE_SIZE)))
#define __ALIGN_MASK(x,mask)    (((x)+(mask))&~(mask))
#define ECORE_ALIGN(x,a)              __ALIGN_MASK(x,(typeof(x))(a)-1)

#define QFLE3_PAGE_SHIFT      12
#define QFLE3_PAGE_SIZE       (1 << QFLE3_PAGE_SHIFT)
#define QFLE3_PAGE_MASK       (~(QFLE3_PAGE_SIZE - 1))
#define QFLE3_PAGE_ALIGN(addr)    (((addr) + QFLE3_PAGE_SIZE - 1) & QFLE3_PAGE_MASK)

#define QFLE3_RX_ALIGN_SHIFT        MAX_OF(6, MIN_OF(8, L1_CACHE_SHIFT))

/*
 * FW uses 2 Cache lines Alignment for start packet and size
 * *
 */
#define QFLE3_FW_RX_ALIGN_START (1UL << QFLE3_RX_ALIGN_SHIFT)

#define QFLE3_FW_RX_ALIGN_END (1UL << QFLE3_RX_ALIGN_SHIFT)

#define QFLE3_PXP_DRAM_ALIGN        (QFLE3_RX_ALIGN_SHIFT - 5)

#define QFLE3_NOMCP(A)                    ((A)->flags & NO_MCP_FLAG)

#define QFLE3_NVRAM_1MB_SIZE                    0x20000 /* 1M bit in bytes */
#define QFLE3_NVRAM_TIMEOUT_COUNT               30000
#define QFLE3_NVRAM_PAGE_SIZE                   256

#define QFLE3_DB_SHIFT                  3       /* 8 bytes */

#define DOORBELL(adapter, cid, val)                                     \
   do {                                                                 \
      (*(vmk_uint32 *)(adapter->db_base + (adapter->db_size * (cid)))) = ((vmk_uint32)(val)); \
   } while (0)

#define FP_SB_MAX_E1x		16

#define QFLE3_PATH0_LOAD_CNT_MASK     0x000000ff
#define QFLE3_PATH1_LOAD_CNT_MASK     0x0000ff00
#define QFLE3_PATH0_LOAD_CNT_SHIFT    0
#define QFLE3_PATH1_LOAD_CNT_SHIFT    8
#define QFLE3_RECOVERY_GLOB_REG	MISC_REG_GENERIC_POR_1
#define QFLE3_PATH0_RST_IN_PROG_BIT     0x00010000
#define QFLE3_PATH1_RST_IN_PROG_BIT     0x00020000
#define QFLE3_GLOBAL_RESET_BIT          0x00040000

#ifdef QFLE3_SRIOV
int qfle3_set_pf_tx_switching(struct qfle3_adapter *adapter, vmk_Bool enable);
#endif //QFLE3_SRIOV

union cdu_context {
   struct eth_context eth;
   char pad[1024];
};

struct hw_context {
   union cdu_context *vcxt;
   vmk_IOA cxt_mapping;
   vmk_ByteCount size;
};
#define QFLE3_NUM_RX_VMK_ETH_QUEUES(A)    ((A)->num_rxqs_vmk)
#define QFLE3_NUM_TX_VMK_ETH_QUEUES(A)    ((A)->num_txqs_vmk)
#define QFLE3_NUM_RX_ETH_QUEUES(A)        ((A)->num_rxqs_drv)
#define QFLE3_NUM_TX_ETH_QUEUES(A)        ((A)->num_txqs_drv)
#define QFLE3_NUM_CNIC_QUEUES(A)       ((A)->num_cnicqs)
#define QFLE3_NUM_ETH_QUEUES(bp)		(QFLE3_NUM_RX_ETH_QUEUES(bp) + QFLE3_NUM_TX_ETH_QUEUES(bp))
//#define QFLE3_1st_NON_L2_ETH_CID(bp)	(QFLE3_NUM_NON_CNIC_QUEUES(bp) * QFLE3_MULTI_TX_COS)
#define QFLE3_TOTAL_ETH_QUEUES(A)           (QFLE3_NUM_RX_ETH_QUEUES(A) + QFLE3_NUM_TX_ETH_QUEUES(A))
#define QFLE3_TX_Q_NUM_TO_FP_NUM(A, txqnum)  (txqnum + QFLE3_NUM_RX_ETH_QUEUES(A))
#define QFLE3_RX_Q_NUM_TO_FP_NUM(A, rxqnum)  (rxqnum)
#define QFLE3_GET_FP_FROM_QID(A, QID)     (&A->fp[QID])
#define QFLE3_GET_FP_FROM_RQID(A, QID)     (&A->fp[QID])
#define QFLE3_GET_FP_FROM_TQID(A, QID)     (&A->fp[QID + QFLE3_NUM_RX_ETH_QUEUES(A)])

#define QFLE3_DEFAULT_RX_QID(A)           0
#define QFLE3_DEFAULT_TX_QID(A)           QFLE3_NUM_RX_ETH_QUEUES(A)

#define QFLE3_RSS_FP_NUM(rssnum)          (QFLE3_NUM_RX_VMK_ETH_QUEUES(adapter) + rssnum - 1)

#define FOREACH_RX_ND_VMK_QUEUE(i,qid,fpq)   for (i = 1; i<adapter->num_rxqs_vmk; i++) { \
                                                         qid = i; \
                                                         fpq = &adapter->fp[i]; 
                                               
#define FOREACH_TX_ND_VMK_QUEUE(i,qid,fpq)   for (i = 1; i<adapter->num_txqs_vmk;  i++) { \
                                                         qid = i + QFLE3_NUM_RX_ETH_QUEUES(adapter);  \
                                                         fpq = &adapter->fp[qid]; 
                                                
#define FOREACH_RX_VMK_QUEUE(i,qid,fpq)      for (i = 0; i<adapter->num_rxqs_vmk; i++) { \
                                                         qid = i; \
                                                         fpq = &adapter->fp[i];  
                                              
#define FOREACH_ETH_QUEUE(i,qid,fpq)         for (i = 0; i<QFLE3_TOTAL_ETH_QUEUES(adapter); i++){ \
                                                         qid = i;  \
                                                         fpq = &adapter->fp[i]; 

#define FOREACH_RX_ETH_QUEUE(i,qid,fpq)      for (i = 0; i<adapter->num_rxqs_drv; i++){ \
                                                         qid = i;  \
                                                         fpq = &adapter->fp[i]; 
                                                 
#define FOREACH_TX_ETH_QUEUE(i,qid,fpq)      for (i = 0; i<adapter->num_txqs_drv; i++) {\
                                                         qid = i + QFLE3_NUM_RX_ETH_QUEUES(adapter); \
                                                         fpq = &adapter->fp[qid]; 
                                                         
#define FOREACH_TX_VMK_QUEUE(i,qid,fpq)      for (i = 0; i<adapter->num_txqs_vmk; i++) {\
                                                         qid = i + QFLE3_NUM_RX_ETH_QUEUES(adapter); \
                                                         fpq = &adapter->fp[qid]; 
                                              
#define FOREACH_RX_QUEUE(i,qid,fpq)          for (i = 0; i<QFLE3_NUM_RX_ETH_QUEUES(adapter); i++){ \
                                                            qid = i;\
                                                            fpq = &adapter->fp[i]; 
                                                 
#define FOREACH_TX_QUEUE(i,qid,fpq)          for (i = 0; i<QFLE3_NUM_TX_ETH_QUEUES(adapter); i++) { \
                                                   qid = i + QFLE3_NUM_RX_ETH_QUEUES(adapter); \
                                                   fpq = &adapter->fp[qid]; 

#define FOREACH_RSS_QUEUE(i,qid,fpq)      for (i = QFLE3_NUM_RX_VMK_ETH_QUEUES(adapter); \
                                                            i<QFLE3_NUM_RX_ETH_QUEUES(adapter); i++) { \
                                                            qid = i;  \
                                                            fpq = &adapter->fp[i]; 
#define for_each_cos_in_tx_queue(fp, var) \
   for ((var) = 0; (var) < (fp)->max_cos; (var)++)

#define ILT_MAX_LINES		256
#define ILT_MAX_L2_LINES	32
#define CDU_ILT_PAGE_SZ_HW 2
#define CDU_ILT_PAGE_SZ            (8192 << CDU_ILT_PAGE_SZ_HW) /* 32K */
#define ILT_PAGE_CIDS              (CDU_ILT_PAGE_SZ / sizeof(union cdu_context))

#define CNIC_ISCSI_CID_MAX 256
#define CNIC_FCOE_CID_MAX  2048
#define CNIC_CID_MAX       (CNIC_ISCSI_CID_MAX + CNIC_FCOE_CID_MAX)
#define CNIC_ILT_LINES     DIV_ROUND_UP(CNIC_CID_MAX, ILT_PAGE_CIDS)

#define QM_ILT_PAGE_SZ_HW   0
#define QM_ILT_PAGE_SZ      (4096 << QM_ILT_PAGE_SZ_HW) /* 4K */
#define QM_CID_ROUND        1024

/* TM (timers) host DB constants */
#define TM_ILT_PAGE_SZ_HW	0
#define TM_ILT_PAGE_SZ		(4096 << TM_ILT_PAGE_SZ_HW) /* 4K */
#define TM_CONN_NUM		(QFLE3_FIRST_VF_CID + \
				 QFLE3_VF_CIDS + \
				 CNIC_ISCSI_CID_MAX)
#define TM_ILT_SZ		(8 * TM_CONN_NUM)
#define TM_ILT_LINES		DIV_ROUND_UP(TM_ILT_SZ, TM_ILT_PAGE_SZ)

/* SRC (Searcher) host DB constants */
#define SRC_ILT_PAGE_SZ_HW	0
#define SRC_ILT_PAGE_SZ		(4096 << SRC_ILT_PAGE_SZ_HW) /* 4K */
#define SRC_HASH_BITS		10
#define SRC_CONN_NUM		(1 << SRC_HASH_BITS) /* 1024 */
#define SRC_ILT_SZ		(sizeof(struct src_ent) * SRC_CONN_NUM)
#define SRC_T2_SZ		SRC_ILT_SZ
#define SRC_ILT_LINES		DIV_ROUND_UP(SRC_ILT_SZ, SRC_ILT_PAGE_SZ)

#define QFLE3_MULTI_TX_COS	3
#define QFLE3_MAX_QUEUE_COUNT(adapter)	adapter->igu_sb_cnt
#define QFLE3_MAX_RSS_COUNT(adapter)	((adapter)->igu_sb_cnt - CNIC_SUPPORT(adapter))

#ifndef QFLE3_CNIC
#define UIO_CID_PAD(A)     0
#endif
#define QFLE3_L2_CID_COUNT(adapter)	((QFLE3_NUM_RX_ETH_QUEUES(adapter) + \
                                       QFLE3_NUM_TX_ETH_QUEUES(adapter)) \
                                       * QFLE3_MULTI_TX_COS \
                                       + CNIC_SUPPORT(adapter) * (4 + UIO_CID_PAD(adapter)))

#define QFLE3_L2_MAX_CID(adapter)    (QFLE3_MAX_RSS_COUNT(adapter) * QFLE3_MULTI_TX_COS  \
                                       + CNIC_SUPPORT(adapter) * (4 + UIO_CID_PAD(adapter)))
#define L2_ILT_LINES(adapter)    (DIV_ROUND_UP(QFLE3_L2_CID_COUNT(adapter), \
					       ILT_PAGE_CIDS))

/* rules for calculating the cids of tx-only connections */
#define CID_TO_FP(cid, A)		((cid) % QFLE3_NUM_ETH_QUEUES(A))
#define CID_COS_TO_TX_ONLY_CID(cid, cos, A) \
         (cid + cos * QFLE3_NUM_ETH_QUEUES(A))

/* fp index inside class of service range */
#define FP_COS_TO_TXQ(fp, cos, A) \
         ((fp)->qid + cos * QFLE3_NUM_ETH_QUEUES(A))
         
#define QFLE3_PATH(A)	((A)->pf_num & 1)
#define QFLE3_PORT(A)	((A)->pf_id & 1)
#define QFLE3_FUNC(A)	((A)->pf_id)
#define QFLE3_VN(A)		((A)->pf_id >> 1)
#define QFLE3_ABS_FUNC(A)		((A)->pf_num)
#define QFLE3_MAX_VN_NUM(A)       (CHIP_MODE_IS_4_PORT(A) ? 2 : 4)
#define QFLE3_L_ID(A)         (QFLE3_VN(A) << 2)
#define QFLE3_FW_MB_IDX_VN(A, vn)     (QFLE3_PORT(A) +                  \
				       (vn) * ((CHIP_IS_E1x(A) || (CHIP_MODE_IS_4_PORT(A))) ? 2  : 1))
#define QFLE3_FW_MB_IDX(A)        QFLE3_FW_MB_IDX_VN(A, QFLE3_VN(A))


#define QFLE3_ILT(A)		((A)->ilt)
#define ILT_NUM_PAGE_ENTRIES    (3072)
#define ILT_PER_FUNC        (ILT_NUM_PAGE_ENTRIES/8)
#define FUNC_ILT_BASE(func)        (func * ILT_PER_FUNC)

#define INT_BLOCK_HC            0
#define INT_BLOCK_IGU           1
#define INT_BLOCK_MODE_NORMAL       0
#define INT_BLOCK_MODE_BW_COMP      2
#define CHIP_INT_MODE_IS_NBC(A)                         \
   !((A)->hw_info.int_block & INT_BLOCK_MODE_BW_COMP)
#define CHIP_INT_MODE_IS_BC(A) (!CHIP_INT_MODE_IS_NBC(A))

#define CHIP_4_PORT_MODE            0x0
#define CHIP_2_PORT_MODE            0x1
#define CHIP_PORT_MODE_NONE         0x2
#define QFLE3_CHIP_MODE(A)           (A->hw_info.port_mode)
#define CHIP_MODE_IS_4_PORT(A) (QFLE3_CHIP_MODE(A) == CHIP_4_PORT_MODE)

#define CHIP_ID(A)         (A->hw_info.chip_id & 0xfffffff0)

#define CHIP_NUM(A)            (A->hw_info.chip_id >> 16)
#define CHIP_NUM_57710          0x164e
#define CHIP_NUM_57711          0x164f
#define CHIP_NUM_57711E         0x1650
#define CHIP_NUM_57712          0x1662
#define CHIP_NUM_57712_MF       0x1663
#define CHIP_NUM_57713          0x1651
#define CHIP_NUM_57713E         0x1652
#define CHIP_NUM_57800          0x168a
#define CHIP_NUM_57800_MF       0x16a5
#define CHIP_NUM_57810          0x168e
#define CHIP_NUM_57810_MF       0x16ae
#define CHIP_NUM_57811          0x163d
#define CHIP_NUM_57811_MF       0x163e
#define CHIP_NUM_57840_OBSOLETE     0x168d
#define CHIP_NUM_57840_MF_OBSOLETE  0x16ab
#define CHIP_NUM_57840_4_10     0x16a1
#define CHIP_NUM_57840_2_20     0x16a2
#define CHIP_NUM_57840_MF       0x16a4

#define CHIP_IS_E1(A)          (CHIP_NUM(A) == CHIP_NUM_57710)

#define CHIP_IS_57711(A)       (CHIP_NUM(A) == CHIP_NUM_57711)
#define CHIP_IS_57711E(A)      (CHIP_NUM(A) == CHIP_NUM_57711E)
#define CHIP_IS_E1H(A)         (CHIP_IS_57711(A) ||     \
				CHIP_IS_57711E(A))

#define CHIP_IS_E1x(A)                 (CHIP_IS_E1((A)) || CHIP_IS_E1H((A)))

#define CHIP_IS_57712(A)       (CHIP_NUM(A) == CHIP_NUM_57712)
#define CHIP_IS_57712_MF(A)        (CHIP_NUM(A) == CHIP_NUM_57712_MF)
#define CHIP_IS_E2(A)          (CHIP_IS_57712(A) ||     \
				CHIP_IS_57712_MF(A))


#define CHIP_IS_57800(A)       (CHIP_NUM(A) == CHIP_NUM_57800)
#define CHIP_IS_57800_MF(A)        (CHIP_NUM(A) == CHIP_NUM_57800_MF)
#define CHIP_IS_57810(A)       (CHIP_NUM(A) == CHIP_NUM_57810)
#define CHIP_IS_57810_MF(A)        (CHIP_NUM(A) == CHIP_NUM_57810_MF)
#define CHIP_IS_57811(A)       (CHIP_NUM(A) == CHIP_NUM_57811)
#define CHIP_IS_57811_MF(A)        (CHIP_NUM(A) == CHIP_NUM_57811_MF)
#define CHIP_IS_57811xx(A)     (CHIP_IS_57811(A) ||     \
				CHIP_IS_57811_MF(A))
#define CHIP_IS_57840(A)                        \
   ((CHIP_NUM(A) == CHIP_NUM_57840_4_10) ||     \
    (CHIP_NUM(A) == CHIP_NUM_57840_2_20) ||     \
    (CHIP_NUM(A) == CHIP_NUM_57840_OBSOLETE))
#define CHIP_IS_57840_MF(A)    ((CHIP_NUM(A) == CHIP_NUM_57840_MF) ||   \
				(CHIP_NUM(A) == CHIP_NUM_57840_MF_OBSOLETE))


#define CHIP_IS_E3(A)          (CHIP_IS_57800((A)) ||   \
				CHIP_IS_57800_MF(A) ||  \
				CHIP_IS_57810(A) ||     \
				CHIP_IS_57810_MF(A) ||  \
				CHIP_IS_57811xx(A) ||   \
				CHIP_IS_57840(A) ||     \
				CHIP_IS_57840_MF((A)))

#define USES_WARPCORE(A)               (CHIP_IS_E3(A))
#define IS_E1H_OFFSET                   (!CHIP_IS_E1(A))

#define CHIP_REV_SHIFT                  12
#define CHIP_REV_MASK                   (0xF << CHIP_REV_SHIFT)
#define CHIP_REV_VAL(A)                (A->hw_info.chip_id & CHIP_REV_MASK)
#define CHIP_REV_Ax                     (0x0 << CHIP_REV_SHIFT)
#define CHIP_REV_Bx                     (0x1 << CHIP_REV_SHIFT)
/* assume maximum 5 revisions */
#define CHIP_REV_IS_SLOW(A)            (CHIP_REV_VAL(A) > 0x00005000)
/* Emul versions are A=>0xe, B=>0xc, C=>0xa, D=>8, E=>6 */
#define CHIP_REV_IS_EMUL(A)            ((CHIP_REV_IS_SLOW(A)) &&        \
					!(CHIP_REV_VAL(A) & 0x00001000))
/* FPGA versions are A=>0xf, B=>0xd, C=>0xb, D=>9, E=>7 */
#define CHIP_REV_IS_FPGA(A)            ((CHIP_REV_IS_SLOW(A)) &&        \
					(CHIP_REV_VAL(A) & 0x00001000))

#define CHIP_TIME(A)                   ((CHIP_REV_IS_EMUL(A)) ? 2000 :  \
					((CHIP_REV_IS_FPGA(A)) ? 200 : 1))

#define CHIP_METAL(A)                  (A->common.chip_id & 0x00000ff0)
#define CHIP_BOND_ID(A)                (A->common.chip_id & 0x0000000f)
#define CHIP_REV_SIM(A)                (((CHIP_REV_MASK - CHIP_REV_VAL(A)) >> \
					 (CHIP_REV_SHIFT + 1))          \
					<< CHIP_REV_SHIFT)
#define CHIP_REV(A)                    (CHIP_REV_IS_SLOW(A) ?   \
					CHIP_REV_SIM(A) :       \
					CHIP_REV_VAL(A))
#define CHIP_IS_E3B0(A)                (CHIP_IS_E3(A) &&                \
					(CHIP_REV(A) == CHIP_REV_Bx))
#define CHIP_IS_E3A0(A)                (CHIP_IS_E3(A) &&                \
					(CHIP_REV(A) == CHIP_REV_Ax))

#define IS_MF(A)       (A->mf_mode != 0)
#define ECORE_IS_MF_SI_MODE(A)        (A->mf_mode == MULTI_FUNCTION_SI)
#define IS_MF_SD(A)        (A->mf_mode == MULTI_FUNCTION_SD)
#define IS_MF_AFEX(A)      (A->mf_mode == MULTI_FUNCTION_AFEX)
#define IS_MF_UFP(A)		(IS_MF_SD(A) && \
				 A->mf_sub_mode == SUB_MF_MODE_UFP)
#define IS_MF_NPAR1_DOT_5(A)	(ECORE_IS_MF_SI_MODE(A) && \
				 A->mf_sub_mode == SUB_MF_MODE_NPAR1_DOT_5)
#define IS_MF_BD(A)		(IS_MF_SD(A) && \
				 A->mf_sub_mode == SUB_MF_MODE_BD)

/* Determines whether BW configuration arrives in 100Mb units or in
 * percentages from actual physical link speed.
 */
#define IS_MF_PERCENT_BW(A) (IS_MF_SI(A) || IS_MF_UFP(A) || IS_MF_BD(A))

/* SUB MF modes is needed, since some MF modes require no HW/FW
 * configuration changes, but driver behavior is slightly different
 */
enum {
    SUB_MF_MODE_UNKNOWN = 0,
    SUB_MF_MODE_UFP,
    SUB_MF_MODE_NPAR1_DOT_5,
    SUB_MF_MODE_BD,
};

struct qfle3_vlan_entry {
    vmk_ListLinks link;
    u16 vid;
    vmk_Bool hw;
};

/* Congestion management fairness mode */
#define CMNG_FNS_NONE                   0
#define CMNG_FNS_MINMAX                 1

#define QFLE3_SP(A, var)       (&A->sp->var)
#define QFLE3_SP_MAPPING(A, var)                                \
   (A->sp_mapping + vmk_offsetof(struct qfle3_slowpath, var))
#define QFLE3_IS_MF_SD_PROTOCOL_ISCSI(adapter) \
      (QFLE3_MF_SD_PROTOCOL(adapter) == FUNC_MF_CFG_PROTOCOL_ISCSI)
   
   
#define IS_MF_ISCSI_SD(adapter) (IS_MF_SD(adapter) && \
      QFLE3_IS_MF_SD_PROTOCOL_ISCSI(adapter)(adapter))
#define IS_MF_FCOE_SD(adapter) (IS_MF_SD(adapter) && \
      QFLE3_IS_MF_SD_PROTOCOL_FCOE(adapter))
#define IS_MF_ISCSI_SI(adapter) (IS_MF_SI(adapter) && \
      QFLE3_IS_MF_EXT_PROTOCOL_ISCSI(adapter))
   
#define IS_MF_ISCSI_ONLY(adapter)    (IS_MF_ISCSI_SD(adapter) ||  \
      IS_MF_ISCSI_SI(adapter))
   
#define QFLE3_MF_EXT_PROTOCOL_MASK  \
            (MACP_FUNC_CFG_FLAGS_ETHERNET |  \
             MACP_FUNC_CFG_FLAGS_ISCSI_OFFLOAD |   \
             MACP_FUNC_CFG_FLAGS_FCOE_OFFLOAD)
   
#define QFLE3_MF_EXT_PROT(adapter)  ((adapter)->mf_ext_config &   \
            QFLE3_MF_EXT_PROTOCOL_MASK)
   
#define QFLE3_HAS_MF_EXT_PROTOCOL_FCOE(adapter) \
         (QFLE3_MF_EXT_PROT(adapter) & MACP_FUNC_CFG_FLAGS_FCOE_OFFLOAD)
   
#define QFLE3_IS_MF_EXT_PROTOCOL_FCOE(adapter)  \
         (QFLE3_MF_EXT_PROT(adapter) == MACP_FUNC_CFG_FLAGS_FCOE_OFFLOAD)
   
#define QFLE3_IS_MF_EXT_PROTOCOL_ISCSI(adapter) \
         (QFLE3_MF_EXT_PROT(adapter) == MACP_FUNC_CFG_FLAGS_ISCSI_OFFLOAD)
   
#define IS_MF_FCOE_AFEX(adapter) \
      (IS_MF_AFEX(adapter) && QFLE3_IS_MF_EXT_PROTOCOL_FCOE(adapter))
   
#define IS_MF_SD_STORAGE_PERSONALITY_ONLY(adapter) \
            (IS_MF_SD(adapter) &&   \
            (QFLE3_IS_MF_SD_PROTOCOL_ISCSI(adapter) ||   \
            QFLE3_IS_MF_SD_PROTOCOL_FCOE(adapter)))
   
#define IS_MF_SI_STORAGE_PERSONALITY_ONLY(adapter) \
            (IS_MF_SI(adapter) &&   \
            (QFLE3_IS_MF_EXT_PROTOCOL_ISCSI(adapter) ||  \
            QFLE3_IS_MF_EXT_PROTOCOL_FCOE(adapter)))
   
#define IS_MF_STORAGE_PERSONALITY_ONLY(adapter) \
            (IS_MF_SD_STORAGE_PERSONALITY_ONLY(adapter) ||  \
            IS_MF_SI_STORAGE_PERSONALITY_ONLY(adapter))

#define REG_ADDR(A, offset)	(((A)->reg_base) + (offset))

#define REG_RD(A, offset)	(*(vmk_uint32 *)(REG_ADDR(A, offset)))
#define REG_RD8(A, offset)	(*(vmk_uint8 *)(REG_ADDR(A, offset)))
#define REG_RD16(A, offset)	(*(vmk_uint16 *)(REG_ADDR(A, offset)))

#define REG_WR(A, offset, val)		(*(vmk_uint32 *)(REG_ADDR(A, offset))) = (val)
#define REG_WR8(A, offset, val)		(*(vmk_uint8 *)(REG_ADDR(A, offset))) = (val)
#define REG_WR16(A, offset, val)	(*(vmk_uint16 *)(REG_ADDR(A, offset))) = (val)

#define OOO_IDX_OFFSET               0
#define FCOE_IDX_OFFSET                1
#define FWD_IDX_OFFSET                 2

#define OOO_IDX(A)      (QFLE3_NUM_ETH_QUEUES(A) + OOO_IDX_OFFSET)  
#define qfle3_ooo_fp(A)    (&A->fp[OOO_IDX(A)])
#define qfle3_ooo(A, var)	(qfle3_ooo_fp(A)->var)
#define qfle3_ooo_inner_sp_obj(A)	(&A->sp_objs[OOO_IDX(A)])
#define qfle3_ooo_sp_obj(A, var)	(qfle3_ooo_inner_sp_obj(A)->var)

#define FCOE_IDX(A)		(QFLE3_NUM_ETH_QUEUES(A) + FCOE_IDX_OFFSET)
#define qfle3_fcoe_fp(A)	(&A->fp[FCOE_IDX(A)])
#define qfle3_fcoe(A, var)	(qfle3_fcoe_fp(A)->var)
#define qfle3_fcoe_inner_sp_obj(A)	(&A->sp_objs[FCOE_IDX(A)])
#define qfle3_fcoe_sp_obj(A, var)	(qfle3_fcoe_inner_sp_obj(A)->var)

#define FWD_IDX(A)		(QFLE3_NUM_ETH_QUEUES(A)  + FWD_IDX_OFFSET)
#define qfle3_fwd_fp(A)	(&A->fp[FWD_IDX(A)])
#define qfle3_fwd(A, var)	(qfle3_fwd_fp(A)->var)
#define qfle3_fwd_inner_sp_obj(A)	(&A->sp_objs[FWD_IDX(A)])
#define qfle3_fwd_sp_obj(A, var)	(qfle3_fwd_inner_sp_obj(A)->var)


#define IS_OOO_FP(fp)		((fp)->qid == OOO_IDX((fp)->adapter))
#define IS_FCOE_FP(fp)		((fp)->qid == FCOE_IDX((fp)->adapter))
#define IS_FWD_FP(fp)		((fp)->qid == FWD_IDX((fp)->adapter))
#define IS_FWD_IDX(idx)		((idx) == FWD_IDX(adapter))
#define IS_OOO_IDX(idx)		((idx) == OOO_IDX(adapter))
#define IS_FCOE_IDX(idx)    ((idx) == FCOE_IDX(adapter))
enum {
	FCOE_TXQ_IDX_OFFSET,
	FWD_TXQ_IDX_OFFSET,
	OOO_TXQ_IDX_OFFSET,
};
#define MAX_ETH_TXQ_IDX(A)	(QFLE3_NUM_NON_CNIC_QUEUES(A) * (A)->max_cos)
#define FCOE_TXQ_IDX(A)	(MAX_ETH_TXQ_IDX(A) + FCOE_TXQ_IDX_OFFSET)
#define FWD_TXQ_IDX(A)		(MAX_ETH_TXQ_IDX(A) + FWD_TXQ_IDX_OFFSET)
#define OOO_TXQ_IDX(A)		(MAX_ETH_TXQ_IDX(A) + OOO_TXQ_IDX_OFFSET)

void
qfle3_link_status_update(struct qfle3_adapter *adapter);
void
qfle3_reg_wr_ind(struct qfle3_adapter *adapter, vmk_uint32 addr, vmk_uint32 val);

void
qfle3_post_dmae(struct qfle3_adapter *adapter, struct dmae_command *dmae, vmk_int32 idx);

vmk_uint32
qfle3_dmae_opcode_add_comp(vmk_uint32 opcode, vmk_uint8 comp_type);

void
qfle3_write_dmae_phys_len(struct qfle3_adapter *adapter,
			  vmk_IOA phys_addr, vmk_uint32 addr, vmk_uint32 len);

void qfle3_set_rx_mode_inner(struct qfle3_adapter *adapter);

int qfle3_del_all_vlans(struct qfle3_adapter *adapter, struct qfle3_fastpath *rq);

#ifdef QFLE3_SRIOV
static inline int is_zero_ether_addr(const vmk_uint8 *addr)
{
        return !(addr[0] | addr[1] | addr[2] | addr[3] | addr[4] | addr[5]);
}
#endif //QFLE3_SRIOV

/**
 * qfle3_extract_max_cfg - extract MAX BW part from MF configuration.
 *
 * @adapter:     driver handle
 * @mf_cfg: MF configuration
 *
*/
static inline vmk_uint16 qfle3_extract_max_cfg(struct qfle3_adapter * adapter, vmk_uint32 mf_cfg)
{
    vmk_uint16 max_cfg = (mf_cfg & FUNC_MF_CFG_MAX_BW_MASK) >>
                  FUNC_MF_CFG_MAX_BW_SHIFT;
    if (!max_cfg) {
        max_cfg = 100;
    }
    return max_cfg;
}

void qfle3_update_max_mf_config(struct qfle3_adapter *adapter, vmk_uint32 value);


static inline void
ecore_reg_wr_ind(struct qfle3_adapter *adapter, vmk_uint32 addr, vmk_uint32 val)
{
   qfle3_reg_wr_ind(adapter, addr, val);
}

static inline void
ecore_write_dmae_phys_len(struct qfle3_adapter *adapter,
			  vmk_IOA phys_addr, vmk_uint32 addr, vmk_uint32 len)
{

   qfle3_write_dmae_phys_len(adapter, phys_addr, addr, len);
}

static inline vmk_Bool
ECORE_IS_VALID_ETHER_ADDR(const vmk_uint8 * addr)
{
   vmk_Bool b_is_zero_addr =
      !(addr[0] | addr[1] | addr[2] | addr[3] | addr[4] | addr[5]);
   vmk_Bool b_is_mcast_addr = 0x01 & addr[0];

   return !b_is_zero_addr && !b_is_mcast_addr;
}

static inline void
ecore_set_fw_mac_addr(vmk_uint16 * fw_hi, vmk_uint16 * fw_mid,
		      vmk_uint16 * fw_lo, vmk_uint8 * mac)
{
   ((vmk_uint8 *) fw_hi)[0] = mac[1];
   ((vmk_uint8 *) fw_hi)[1] = mac[0];
   ((vmk_uint8 *) fw_mid)[0] = mac[3];
   ((vmk_uint8 *) fw_mid)[1] = mac[2];
   ((vmk_uint8 *) fw_lo)[0] = mac[5];
   ((vmk_uint8 *) fw_lo)[1] = mac[4];
}



#define REG_RD_DMAE(A, offset, valp, len32)                     \
   do {                                                         \
      qfle3_read_dmae(A, offset, len32);                        \
      vmk_Memcpy(valp, QFLE3_SP(A, wb_data[0]), (len32) * 4);	\
   } while (0)

#define REG_WR_DMAE(A, offset, valp, len32)                     \
   do {                                                         \
      vmk_Memcpy(QFLE3_SP(A, wb_data[0]), valp, (len32) * 4);	\
      qfle3_write_dmae(A, QFLE3_SP_MAPPING(A, wb_data),		\
		       offset, len32);                          \
   } while (0)

#define REG_WR_DMAE_LEN(A, offset, valp, len32) \
   REG_WR_DMAE(A, offset, valp, len32)

#define VIRT_WR_DMAE_LEN(A, data, addr, len32, le32_swap)	\
   do {                                                         \
      vmk_Memcpy(GUNZIP_BUF(A), data, (len32) * 4);		\
      ecore_write_big_buf_wb(A, addr, len32);                   \
   } while (0)


#define SHMEM_ADDR(A, field)       (A->hw_info.shmem_base +             \
				    vmk_offsetof(struct shmem_region, field))
#define SHMEM_RD(A, field)     REG_RD(A, SHMEM_ADDR(A, field))
#define SHMEM_WR(A, field, val)    REG_WR(A, SHMEM_ADDR(A, field), val)

#define SHMEM2_ADDR(A, field)      (A->hw_info.shmem2_base +            \
				    vmk_offsetof(struct shmem2_region, field))
#define SHMEM2_RD(A, field)        REG_RD(A, SHMEM2_ADDR(A, field))
#define SHMEM2_WR(A, field, val)   REG_WR(A, SHMEM2_ADDR(A, field), val)
#define MF_CFG_ADDR(A, field)      (A->hw_info.mf_cfg_base +            \
				    vmk_offsetof(struct mf_cfg, field))
#define MF2_CFG_ADDR(A, field)     (A->hw_info.mf2_cfg_base +           \
				    vmk_offsetof(struct mf2_cfg, field))

#define MF_CFG_RD(A, field)        REG_RD(A, MF_CFG_ADDR(A, field))
#define MF_CFG_WR(A, field, val)   REG_WR(A,                            \
					  MF_CFG_ADDR(A, field), (val))
#define MF2_CFG_RD(A, field)       REG_RD(A, MF2_CFG_ADDR(A, field))

#define SHMEM2_HAS(A, field)       ((A)->hw_info.shmem2_base &&         \
				    (SHMEM2_RD((A), size) >             \
				     vmk_offsetof(struct shmem2_region, field)))

#define QM_ILT_PAGE_SZ_HW  0
#define QM_ILT_PAGE_SZ             (4096 << QM_ILT_PAGE_SZ_HW)  /* 4K */

#define HC_SEG_ACCESS_DEF       0       /*Driver decision 0-3 */
#define HC_SEG_ACCESS_ATTN      4
#define HC_SEG_ACCESS_NORM      0       /*Driver decision 0-1 */

#define INIT_MODE_FLAGS(A)	((A)->init_mode_flags)

#define QFLE3_FW_MB_IDX_VN(A, vn)		(QFLE3_PORT(A) +        \
						 (vn) * ((CHIP_IS_E1x(A) || (CHIP_MODE_IS_4_PORT(A))) ? 2  : 1))
#define QFLE3_FW_MB_IDX(A)		QFLE3_FW_MB_IDX_VN(A, QFLE3_VN(A))

#define IRO (adapter->iro_arr)

#define ELINK_ADVERTISED_10baseT_Half    (1 << 1)
#define ELINK_ADVERTISED_10baseT_Full    (1 << 2)
#define ELINK_ADVERTISED_100baseT_Half   (1 << 3)
#define ELINK_ADVERTISED_100baseT_Full   (1 << 4)
#define ELINK_ADVERTISED_1000baseT_Half  (1 << 5)
#define ELINK_ADVERTISED_1000baseT_Full  (1 << 6)
#define ELINK_ADVERTISED_TP              (1 << 7)
#define ELINK_ADVERTISED_FIBRE           (1 << 8)
#define ELINK_ADVERTISED_Autoneg         (1 << 9)
#define ELINK_ADVERTISED_Asym_Pause      (1 << 10)
#define ELINK_ADVERTISED_Pause           (1 << 11)
#define ELINK_ADVERTISED_2500baseX_Full  (1 << 15)
#define ELINK_ADVERTISED_10000baseT_Full (1 << 16)
#define ELINK_ADVERTISED_1000baseKX_Full   (1 << 17)
#define ELINK_ADVERTISED_10000baseKX4_Full    (1 << 18)
#define ELINK_ADVERTISED_10000baseKR_Full     (1 << 19)
#define ELINK_ADVERTISED_20000baseKR2_Full        (1 << 22)


/* DMAE command defines */
#define DMAE_TIMEOUT                    -1
#define DMAE_PCI_ERROR                  -2      /* E2 and onward */
#define DMAE_NOT_RDY                    -3
#define DMAE_PCI_ERR_FLAG               0x80000000

#define DMAE_SRC_PCI                    0
#define DMAE_SRC_GRC                    1

#define DMAE_DST_NONE                   0
#define DMAE_DST_PCI                    1
#define DMAE_DST_GRC                    2

#define DMAE_COMP_PCI                   0
#define DMAE_COMP_GRC                   1
#define DMAE_COMP_REGULAR               0
#define DMAE_COM_SET_ERR                1

#define DMAE_CMD_SRC_PCI                (DMAE_SRC_PCI <<                \
					 DMAE_COMMAND_SRC_SHIFT)
#define DMAE_CMD_SRC_GRC                (DMAE_SRC_GRC <<                \
					 DMAE_COMMAND_SRC_SHIFT)

#define DMAE_CMD_DST_PCI                (DMAE_DST_PCI <<                \
					 DMAE_COMMAND_DST_SHIFT)
#define DMAE_CMD_DST_GRC                (DMAE_DST_GRC <<                \
					 DMAE_COMMAND_DST_SHIFT)

#define DMAE_CMD_C_DST_PCI              (DMAE_COMP_PCI <<               \
					 DMAE_COMMAND_C_DST_SHIFT)
#define DMAE_CMD_C_DST_GRC              (DMAE_COMP_GRC <<               \
					 DMAE_COMMAND_C_DST_SHIFT)

#define DMAE_CMD_C_ENABLE               DMAE_COMMAND_C_TYPE_ENABLE

#define DMAE_CMD_ENDIANITY_NO_SWAP      (0 << DMAE_COMMAND_ENDIANITY_SHIFT)
#define DMAE_CMD_ENDIANITY_B_SWAP       (1 << DMAE_COMMAND_ENDIANITY_SHIFT)
#define DMAE_CMD_ENDIANITY_DW_SWAP      (2 << DMAE_COMMAND_ENDIANITY_SHIFT)
#define DMAE_CMD_ENDIANITY_B_DW_SWAP    (3 << DMAE_COMMAND_ENDIANITY_SHIFT)

#define DMAE_CMD_PORT_0                 0
#define DMAE_CMD_PORT_1                 DMAE_COMMAND_PORT

#define DMAE_CMD_SRC_RESET              DMAE_COMMAND_SRC_RESET
#define DMAE_CMD_DST_RESET              DMAE_COMMAND_DST_RESET
#define DMAE_CMD_E1HVN_SHIFT            DMAE_COMMAND_E1HVN_SHIFT

#define DMAE_SRC_PF                     0
#define DMAE_SRC_VF                     1

#define DMAE_DST_PF                     0
#define DMAE_DST_VF                     1

#define DMAE_C_SRC                      0
#define DMAE_C_DST                      1
#define DMAE_LEN32_RD_MAX               0x80
#define DMAE_LEN32_WR_MAX(A)           (CHIP_IS_E1(A) ? 0x400 : 0x2000)

#define DMAE_COMP_VAL                   0x60d0d0ae      /* E2 and on - upper bit
							 * indicates error
							 */

#define MAX_DMAE_C_PER_PORT             8
#define INIT_DMAE_C(A)                 (QFLE3_PORT(A) * MAX_DMAE_C_PER_PORT + \
                                          QFLE3_VN(A))
#define PMF_DMAE_C(A)                   (QFLE3_PORT(A) * MAX_DMAE_C_PER_PORT + \
                                          E1HVN_MAX)
#define QFLE3_RSS_SUPPORTED(A) ((A)->num_rssqs_nd > 1)
#define QFLE3_DEVICE_MAX_DEF_RSS_QUEUES 4 /* MAX number of default RSS queues including the leading queue*/
#define CNIC_MAX_QUEUES              3
#if (ESX_DDK_VERSION >= 2017)
#define QFLE3_DEVICE_MAX_TX_QUEUES 10
#define QFLE3_DEVICE_MAX_RX_QUEUES 10   
                                           /* 1 RSS capable Default Queue + 6 Regular Netqueues + 3 RSS Capable Net Queues (Excludes 4*3 Secondary RSS Queues)
                                           Actual Total Number of NIC RX Queues which will be enabled on adapter when in SF Mode and both DRSS
                                           and 3 NetQ RSS enabled will be:
                                           1 Default Queue + 3 Secondary Queues for Default Queue + 6 Regular Netqueues +
                                           3 *(1 RSS Primary Netqueeu + 3 RSS Secondary Netqueues ) = 22
                                        */
#define QFLE3_DEVICE_MAX_RSS_QUEUES 4   /* MAX number of  RSS queues including 1 Primary and 3 secondary Queues in single NetQ_RSS Pool*/
#define QFLE3_DEVICE_MAX_RSS_ENGINE  4  
                                           /* MAX Number of RSS Engines suppored per Physical Port (Including one for Default Netqueue )
                                           i.e. 3 NetQ RSS Engines + 1 Default Queue RSS Engine
                                           Actual number is 72 RSS Engines per HW Engine however
                                           limiting this to 4 per PF due to ESX Vector Limitation */


#define QFLE3_DEVICE_MAX_QUEUES (QFLE3_DEVICE_MAX_TX_QUEUES +   \
                                                     QFLE3_DEVICE_MAX_RX_QUEUES +   \
                                 (QFLE3_DEVICE_MAX_RSS_ENGINE - 1) * (QFLE3_DEVICE_MAX_RSS_QUEUES - 1) +\
                                 (QFLE3_DEVICE_MAX_DEF_RSS_QUEUES - 1) + \
                                 CNIC_MAX_QUEUES \
                                )
#define QFLE3_DEVICE_MAX_ETH_QUEUES (QFLE3_DEVICE_MAX_TX_QUEUES +   \
                                                     QFLE3_DEVICE_MAX_RX_QUEUES +   \
                                 (QFLE3_DEVICE_MAX_RSS_ENGINE - 1) * (QFLE3_DEVICE_MAX_RSS_QUEUES - 1) +\
                                 (QFLE3_DEVICE_MAX_DEF_RSS_QUEUES - 1) \
                                )

#define QFLE3_MAX_RSS_ENGINE_IDS   72

#else

#define QFLE3_DEVICE_MAX_TX_QUEUES 8
#define QFLE3_DEVICE_MAX_RX_QUEUES 8
#define QFLE3_DEVICE_MAX_RSS_QUEUES 4 /* MAX number of non default RSS queues including the leading queue*/
#define QFLE3_DEVICE_MAX_QUEUES (QFLE3_DEVICE_MAX_TX_QUEUES +   \
                                                     QFLE3_DEVICE_MAX_RX_QUEUES +   \
                                 (QFLE3_DEVICE_MAX_RSS_QUEUES - 1) +\
                                 (QFLE3_DEVICE_MAX_DEF_RSS_QUEUES - 1) + \
                                 CNIC_MAX_QUEUES \
				)
				
#define QFLE3_DEVICE_MAX_ETH_QUEUES (QFLE3_DEVICE_MAX_TX_QUEUES +   \
                                                     QFLE3_DEVICE_MAX_RX_QUEUES +   \
                                 (QFLE3_DEVICE_MAX_RSS_QUEUES - 1) +\
                                 (QFLE3_DEVICE_MAX_DEF_RSS_QUEUES - 1) \
				)
#endif
#ifndef QFLE3_CNIC
#define QFLE3_CNIC_VECT          0
#else
#define QFLE3_CNIC_VECT          1
#endif
#define QFLE3_MAX_MSIX_VECT  (QFLE3_DEVICE_MAX_ETH_QUEUES + QFLE3_CNIC_VECT + 1)


#define EMAC_RD(cb, reg)	REG_RD(cb, emac_base + reg)
#define EMAC_WR(cb, reg, val)	REG_WR(cb, emac_base + reg, val)
#define PCI_CAP_ID_PM	0x01	// Power Management capability
#define PCI_PM_PMC		2		// PM Capabilities Register
#define PCI_PM_CAP_PME_D3cold	0x8000	// PME# from D3 (cold)
#define PCI_PM_CTRL		4		// PM control and status register
#define PCI_PM_CTRL_PME_ENABLE	0x0100	// PME pin enable
#define PCI_PM_CTRL_PME_STATUS	0x8000	// PME pin status

#define  PCI_PM_CTRL_STATE_MASK 0x0003
/*
 * Regular debug prints
 */

#define _QFLE3_DBG(adapter, logID, mask, lvl, fmt, ...)                 \
   do {                                                                 \
      if ((adapter)->debug_mask & (mask)) {                             \
	 vmk_LogLevel(VMK_LOG_URGENCY_NORMAL,                           \
		      (logID), (lvl),                                   \
		      "%s: %s:%d: [%s] " fmt "\n",                      \
		      vmk_LogGetName(logID),                            \
		      __FUNCTION__, __LINE__,                           \
		      !QFLE3_IS_NAME_EMPTY((adapter)->uplinkName) ?     \
		      QFLE3_NAME_TO_STRING((adapter)->uplinkName) :     \
		      !QFLE3_IS_NAME_EMPTY((adapter)->pdev_name) ?      \
		      QFLE3_NAME_TO_STRING((adapter)->pdev_name) :      \
		      "unknown", ##__VA_ARGS__);                        \
      }                                                                 \
   } while (0)

#if 0
#define QFLE3_DBG(adapter, mask, lvl, fmt, ...)         \
   _QFLE3_DBG((adapter), qfle3_mod_info.logID,          \
	      (mask), (lvl), fmt, ##__VA_ARGS__)
#else
#define QFLE3_DBG(mask, fmt, ...)                               \
   _QFLE3_DBG((adapter), qfle3_mod_info.logID, (mask),          \
	      vmk_LogGetCurrentLogLevel(qfle3_mod_info.logID),  \
	      fmt, ##__VA_ARGS__)
#endif

#define QFLE3_DBG_THROTTLED(adapter, mask, lvl, fmt, ...)       \
   _QFLE3_DBG((adapter), qfle3_mod_info.logThrottledID,         \
	      (mask), (lvl), fmt, ##__VA_ARGS__)

#define QFLE3_DEBUG(mask, lvl, fmt, ...)                        \
   do {                                                         \
      if (qfle3_debugMask & (mask)) {                           \
	 vmk_LogLevel(VMK_LOG_URGENCY_DEBUG,                    \
		      qfle3_mod_info.logID, (lvl),              \
		      "%s: %s:%d: " fmt "\n",                   \
		      vmk_LogGetName(qfle3_mod_info.logID),     \
		      __FUNCTION__, __LINE__, ##__VA_ARGS__);   \
      }                                                         \
		      } while (0)

#define _QFLE3_INFO(adapter, logID, fmt, ...)                   \
      do {                                                      \
	  vmk_Log((logID), "[%s] "fmt,                          \
		  !QFLE3_IS_NAME_EMPTY((adapter)->uplinkName) ? \
		  QFLE3_NAME_TO_STRING((adapter)->uplinkName) : \
		  !QFLE3_IS_NAME_EMPTY((adapter)->pdev_name) ?  \
		  QFLE3_NAME_TO_STRING((adapter)->pdev_name) :  \
		  "", ##__VA_ARGS__);                           \
		  } while (0)
#define QFLE3_INFO(fmt, ...)                            \
      _QFLE3_INFO((adapter), qfle3_mod_info.logID,      \
		  fmt, ##__VA_ARGS__)

/*
 * Errors (never masked)
 */
#define _QFLE3_ERR(adapter, logID, fmt, ...)                            \
      do {                                                              \
	  vmk_Warning((logID), "[%s] "fmt,                              \
		      !QFLE3_IS_NAME_EMPTY((adapter)->uplinkName) ?     \
			 QFLE3_NAME_TO_STRING((adapter)->uplinkName) :  \
			 !QFLE3_IS_NAME_EMPTY((adapter)->pdev_name) ?   \
			 QFLE3_NAME_TO_STRING((adapter)->pdev_name) :   \
			 "unknown", ##__VA_ARGS__);                     \
	  } while (0)

#if 0
#define QFLE3_ERR(adapter, fmt, ...)            \
   _QFLE3_ERR((adapter), qfle3_mod_info.logID,  \
	      fmt, ##__VA_ARGS__)
#else
#define QFLE3_ERR(fmt, ...)                             \
      _QFLE3_ERR((adapter), qfle3_mod_info.logID,       \
		 fmt, ##__VA_ARGS__)
#endif

#define QFLE3_ERR_THROTTLED(adapter, fmt, ...)                  \
      _QFLE3_ERR((adapter), qfle3_mod_info.logThrottledID,      \
		 fmt, ##__VA_ARGS__)

#define QFLE3_ERROR(fmt, ...)                                   \
      do {                                                      \
	 vmk_Warning(qfle3_mod_info.logID, fmt, ##__VA_ARGS__); \
      } while (0)

#define QFLE3_WARN(fmt, ...)                                    \
   do {                                                         \
      vmk_Warning(qfle3_mod_info.logID, fmt, ##__VA_ARGS__);    \
   } while (0)

#if 0
#define ECORE_MSG(adapter, fmt, ...)                    \
	 _QFLE3_DBG((adapter), qfle3_mod_info.logID,    \
		    (1), (1), fmt, ##__VA_ARGS__)
#else
#define ECORE_MSG(adapter, fmt, ...)                            \
	 do {                                                   \
	    if (adapter) {                                      \
	       QFLE3_DBG(QFLE3_DBG_SP, fmt, ##__VA_ARGS__);     \
	    } else {                                            \
	       QFLE3_ERROR(fmt, ##__VA_ARGS__);                 \
	    }                                                   \
	 } while (0)
#endif

#define ECORE_ERR(fmt, ...)                     \
	 QFLE3_ERROR(fmt, ##__VA_ARGS__)

#define ATTN_NIG_FOR_FUNC       (1L << 8)
#define ATTN_SW_TIMER_4_FUNC        (1L << 9)
#define GPIO_2_FUNC         (1L << 10)
#define GPIO_3_FUNC         (1L << 11)
#define GPIO_4_FUNC         (1L << 12)
#define ATTN_GENERAL_ATTN_1     (1L << 13)
#define ATTN_GENERAL_ATTN_2     (1L << 14)
#define ATTN_GENERAL_ATTN_3     (1L << 15)
#define ATTN_GENERAL_ATTN_4     (1L << 13)
#define ATTN_GENERAL_ATTN_5     (1L << 14)
#define ATTN_GENERAL_ATTN_6     (1L << 15)

#define ATTN_HARD_WIRED_MASK        0xff00
#define ATTENTION_ID            4

#define QFLE3_PMF_LINK_ASSERT                                           \
      GENERAL_ATTEN_OFFSET(LINK_SYNC_ATTENTION_BIT_FUNC_0 + QFLE3_FUNC(adapter))

#define STROM_ASSERT_ARRAY_SIZE            50

#define QFLE3_MC_ASSERT_BITS                                            \
      (GENERAL_ATTEN_OFFSET(TSTORM_FATAL_ASSERT_ATTENTION_BIT) |        \
       GENERAL_ATTEN_OFFSET(USTORM_FATAL_ASSERT_ATTENTION_BIT) |        \
       GENERAL_ATTEN_OFFSET(CSTORM_FATAL_ASSERT_ATTENTION_BIT) |        \
       GENERAL_ATTEN_OFFSET(XSTORM_FATAL_ASSERT_ATTENTION_BIT))

#define QFLE3_MCP_ASSERT                                        \
      GENERAL_ATTEN_OFFSET(MCP_FATAL_ASSERT_ATTENTION_BIT)

#define QFLE3_GRC_TIMEOUT   GENERAL_ATTEN_OFFSET(LATCHED_ATTN_TIMEOUT_GRC)
#define QFLE3_GRC_RSV       (GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RBCR) |  \
			     GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RBCT) |  \
			     GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RBCN) |  \
			     GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RBCU) |  \
			     GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RBCP) |  \
			     GENERAL_ATTEN_OFFSET(LATCHED_ATTN_RSVD_GRC))

#if 0
#define HW_INTERRUT_ASSERT_SET_0                                \
	    (AEU_INPUTS_ATTN_BITS_TSDM_HW_INTERRUPT |           \
	     AEU_INPUTS_ATTN_BITS_TCM_HW_INTERRUPT |            \
	     AEU_INPUTS_ATTN_BITS_TSEMI_HW_INTERRUPT |          \
	     AEU_INPUTS_ATTN_BITS_BRB_HW_INTERRUPT |            \
	     AEU_INPUTS_ATTN_BITS_PBCLIENT_HW_INTERRUPT)
#define HW_PRTY_ASSERT_SET_0    (AEU_INPUTS_ATTN_BITS_BRB_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_PARSER_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_TSDM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_SEARCHER_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_TSEMI_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_TCM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_PBCLIENT_PARITY_ERROR)
#define HW_INTERRUT_ASSERT_SET_1                        \
      (AEU_INPUTS_ATTN_BITS_QM_HW_INTERRUPT |           \
       AEU_INPUTS_ATTN_BITS_TIMERS_HW_INTERRUPT |       \
       AEU_INPUTS_ATTN_BITS_XSDM_HW_INTERRUPT |         \
       AEU_INPUTS_ATTN_BITS_XCM_HW_INTERRUPT |          \
       AEU_INPUTS_ATTN_BITS_XSEMI_HW_INTERRUPT |        \
       AEU_INPUTS_ATTN_BITS_USDM_HW_INTERRUPT |         \
       AEU_INPUTS_ATTN_BITS_UCM_HW_INTERRUPT |          \
       AEU_INPUTS_ATTN_BITS_USEMI_HW_INTERRUPT |        \
       AEU_INPUTS_ATTN_BITS_UPB_HW_INTERRUPT |          \
       AEU_INPUTS_ATTN_BITS_CSDM_HW_INTERRUPT |         \
       AEU_INPUTS_ATTN_BITS_CCM_HW_INTERRUPT)

#define HW_PRTY_ASSERT_SET_1    (AEU_INPUTS_ATTN_BITS_PBF_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_QM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_TIMERS_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_XSDM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_XCM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_XSEMI_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_DOORBELLQ_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_NIG_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_VAUX_PCI_CORE_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_DEBUG_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_USDM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_UCM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_USEMI_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_UPB_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_CSDM_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_CCM_PARITY_ERROR)
#define HW_INTERRUT_ASSERT_SET_2                                \
   (AEU_INPUTS_ATTN_BITS_CSEMI_HW_INTERRUPT |                   \
    AEU_INPUTS_ATTN_BITS_CDU_HW_INTERRUPT |                     \
    AEU_INPUTS_ATTN_BITS_DMAE_HW_INTERRUPT |                    \
    AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_HW_INTERRUPT |       \
    AEU_INPUTS_ATTN_BITS_MISC_HW_INTERRUPT)
#define HW_PRTY_ASSERT_SET_2    (AEU_INPUTS_ATTN_BITS_CSEMI_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_PXP_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_CFC_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_CDU_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_DMAE_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_IGU_PARITY_ERROR | \
				 AEU_INPUTS_ATTN_BITS_MISC_PARITY_ERROR)

#define HW_PRTY_ASSERT_SET_3 (AEU_INPUTS_ATTN_BITS_MCP_LATCHED_ROM_PARITY | \
			      AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_RX_PARITY | \
			      AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_TX_PARITY | \
			      AEU_INPUTS_ATTN_BITS_MCP_LATCHED_SCPAD_PARITY)

#define HW_PRTY_ASSERT_SET_4 (AEU_INPUTS_ATTN_BITS_PGLUE_PARITY_ERROR | \
			      AEU_INPUTS_ATTN_BITS_ATC_PARITY_ERROR)
#endif

#define HW_PRTY_ASSERT_SET_3_WITHOUT_SCPAD              \
   (AEU_INPUTS_ATTN_BITS_MCP_LATCHED_ROM_PARITY |       \
    AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_RX_PARITY |    \
    AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_TX_PARITY)

#define DEF_USB_FUNC_OFF    offsetof(struct cstorm_def_status_block_u, func)
#define DEF_CSB_FUNC_OFF    offsetof(struct cstorm_def_status_block_c, func)
#define DEF_XSB_FUNC_OFF    offsetof(struct xstorm_def_status_block, func)
#define DEF_TSB_FUNC_OFF    offsetof(struct tstorm_def_status_block, func)

#define DEF_USB_IGU_INDEX_OFF                                   \
   offsetof(struct cstorm_def_status_block_u, igu_index)
#define DEF_CSB_IGU_INDEX_OFF                                   \
   offsetof(struct cstorm_def_status_block_c, igu_index)
#define DEF_XSB_IGU_INDEX_OFF                           \
   offsetof(struct xstorm_def_status_block, igu_index)
#define DEF_TSB_IGU_INDEX_OFF                           \
   offsetof(struct tstorm_def_status_block, igu_index)

#define DEF_USB_SEGMENT_OFF                             \
   offsetof(struct cstorm_def_status_block_u, segment)
#define DEF_CSB_SEGMENT_OFF                             \
   offsetof(struct cstorm_def_status_block_c, segment)
#define DEF_XSB_SEGMENT_OFF                             \
   offsetof(struct xstorm_def_status_block, segment)
#define DEF_TSB_SEGMENT_OFF                             \
   offsetof(struct tstorm_def_status_block, segment)

#define QFLE3_SP_DSB_INDEX                      \
   (&adapter->def_status_blk->sp_sb.            \
    index_values[HC_SP_INDEX_ETH_DEF_CONS])



/*Ecore helper functions/MACROs */
/*
 * the phys address is shifted right 12 bits and has an added
 * 1=valid bit added to the 53rd bit
 * then since this is a wide register(TM)
 * we split it into two 32 bit writes
 */
#define ONCHIP_ADDR1(x)     ((vmk_uint32)(((vmk_uint64)x >> 12) & 0xFFFFFFFF))
#define ONCHIP_ADDR2(x)     ((vmk_uint32)((1 << 20) | ((vmk_uint64)x >> 44)))

/* This is needed for determining of last_max */
#define SUB_S16(a, b)       (vmk_int16)((vmk_int16)(a) - (vmk_int16)(b))
#define SUB_S32(a, b)       (vmk_int32)((vmk_int32)(a) - (vmk_int32)(b))


#define DELAY(A) vmk_WorldSleep((A));

#define ECORE_CPU_TO_LE32(X)	((X))
#define ECORE_CPU_TO_LE16(X)	((X))

#define ECORE_ILT_ZALLOC(X, Y, SIZE)                                    \
   do {                                                                 \
      X = qfle3_alloc_dma_mapping(adapter, adapter->dmaEngineCoherent, SIZE, Y); \
      if (X)                                                            \
	 vmk_Memset(X, 0, SIZE);                                        \
   } while (0)

#define ECORE_ILT_FREE(X, Y, SIZE)                                      \
   do {                                                                 \
      if (X) {                                                          \
	 qfle3_free_dma_mapping(adapter, adapter->dmaEngineCoherent,X, Y, SIZE); \
	 X = NULL;                                                      \
	 Y = 0;                                                         \
      }                                                                 \
   } while (0)


#define SM_RX_ID 0
#define SM_TX_ID 1

/* defines for multiple tx priority indices */
#define FIRST_TX_ONLY_COS_INDEX         1
#define FIRST_TX_COS_INDEX              0


//#define CID_TO_FP(cid, adapter)              ((cid) % QFLE3_NUM_ETH_QUEUES(adapter))

//#define CNIC_ENABLED(A)    ((A)->cnic_enabled)
#define CNIC_SUPPORT(A)    ((A)->cnic_support)
#define CNIC_LOADED(A)     ((A)->cnic_loaded)
#define FCOE_INIT(A)		   ((A)->fcoe_init)
#define OOO_INIT(A)			((A)->ooo_init)


//#define CONFIGURE_NIC_MODE(A)      (!CHIP_IS_E1x(A) && !CNIC_LOADED(A))
#define CONFIGURE_NIC_MODE(A)      (!CHIP_IS_E1x(A)) // force to NIC mode for now
#define U64_LO(x)           ((vmk_uint32)(((vmk_uint64)(x)) & 0xffffffff))
#define U64_HI(x)           ((vmk_uint32)(((vmk_uint64)(x)) >> 32))
#define HILO_U64(hi, lo)        ((((vmk_uint64)(hi)) << 32) + (lo))
#define ILOG2(X)				qfle3_ilog2((X))
#ifndef ARRSIZE
#define ARRSIZE(_arr)			(sizeof(_arr) / sizeof((_arr)[0]))
#endif
#define ECORE_MEMSET(A, B, C)	vmk_Memset(A, B, C)
#define ECORE_MEMZERO(A, B)	vmk_Memset(A, 0, B)
#define ECORE_MEMCPY	vmk_Memcpy
#define ECORE_MEMCMP	vmk_Memcmp
#define ECORE_RMB() vmk_CPUMemFenceRead()
#define ECORE_WMB() vmk_CPUMemFenceWrite()
#define ECORE_MMIOWB() vmk_CPUMemFenceReadWrite()
#define ECORE_SMP_MB() vmk_CPUMemFenceReadWrite()
#define ECORE_SMP_MB__before_atomic() vmk_CPUMemFenceReadWrite()
#define ECORE_SMP_MB__after_atomic() vmk_CPUMemFenceReadWrite()
#define ECORE_MB() vmk_CPUMemFenceReadWrite()
#define DMAE_READY(A)			((A)->dmae_ready)
#define GUNZIP_BUF(A)			((A)->gz_buf)
#define GUNZIP_PHYS(A)			((A)->gz_dma_addr)
#define GUNZIP_OUTLEN(A)		(0)
#define FW_BUF_SIZE       0x40000
#define min(x, y) ((x) < (y))? (x):(y)
//	#define max(x, y) ((x) > (y)) ? (x) : (y)
#define INIT_OPS(A)                 ((A)->fw_init_data.init_ops)
#define INIT_OPS_OFFSETS(A)         ((A)->fw_init_data.init_ops_offsets)
#define INIT_DATA(A)                ((A)->fw_init_data.init_data)
#define INIT_TSEM_INT_TABLE_DATA(A) ((A)->fw_init_data.tsem_int_table_data)
#define INIT_TSEM_PRAM_DATA(A)      ((A)->fw_init_data.tsem_pram_data)
#define INIT_USEM_INT_TABLE_DATA(A) ((A)->fw_init_data.usem_int_table_data)
#define INIT_USEM_PRAM_DATA(A)      ((A)->fw_init_data.usem_pram_data)
#define INIT_XSEM_INT_TABLE_DATA(A) ((A)->fw_init_data.xsem_int_table_data)
#define INIT_XSEM_PRAM_DATA(A)      ((A)->fw_init_data.xsem_pram_data)
#define INIT_CSEM_INT_TABLE_DATA(A) ((A)->fw_init_data.csem_int_table_data)
#define INIT_CSEM_PRAM_DATA(A)      ((A)->fw_init_data.csem_pram_data)

#define ECORE_SWCID_SHIFT   17
#define ECORE_SWCID_MASK    ((0x1 << ECORE_SWCID_SHIFT) - 1)

#define SW_CID(x)           ((x) & ECORE_SWCID_MASK)

#define HW_CID(A, X)           ((QFLE3_PORT(A) << 23) |                 \
				(QFLE3_VN(A) << ECORE_SWCID_SHIFT) |    \
				(X))
#define QFLE3_BTR           4

#define SP_DESC_CNT     (QFLE3_PAGE_SIZE / sizeof(struct eth_spe))
#define MAX_SP_DESC_CNT         (SP_DESC_CNT - 1)
#define MAX_SPQ_PENDING         8

/* SP SB indices */

/* General SP events - stats query, cfc delete, etc  */
#define HC_SP_INDEX_ETH_DEF_CONS        3

/* EQ completions */
#define HC_SP_INDEX_EQ_CONS         7

/* FCoE L2 connection completions */
#define HC_SP_INDEX_ETH_FCOE_TX_CQ_CONS     6
#define HC_SP_INDEX_ETH_FCOE_RX_CQ_CONS     4
/* iSCSI L2 */
#define HC_SP_INDEX_ETH_ISCSI_CQ_CONS       5
#define HC_SP_INDEX_ETH_ISCSI_RX_CQ_CONS    1

/*
 * Event queue (EQ or event ring) MC hsi
 * NUM_EQ_PAGES and EQ_DESC_CNT_PAGE must be power of 2
 */
#define NUM_EQ_PAGES        1
#define EQ_DESC_CNT_PAGE    (QFLE3_PAGE_SIZE / sizeof(union event_ring_elem))
#define EQ_DESC_MAX_PAGE    (EQ_DESC_CNT_PAGE - 1)
#define NUM_EQ_DESC     (EQ_DESC_CNT_PAGE * NUM_EQ_PAGES)
#define EQ_DESC_MASK        (NUM_EQ_DESC - 1)
#define MAX_EQ_AVAIL        (EQ_DESC_MAX_PAGE * NUM_EQ_PAGES - 2)

/* depends on EQ_DESC_CNT_PAGE being a power of 2 */
#define NEXT_EQ_IDX(x)      ((((x) & EQ_DESC_MAX_PAGE) ==               \
			      (EQ_DESC_MAX_PAGE - 1)) ? (x) + 2 : (x) + 1)

/* depends on the above and on NUM_EQ_PAGES being a power of 2 */
#define EQ_DESC(x)      ((x) & EQ_DESC_MASK)

#define QFLE3_EQ_INDEX                          \
   (&adapter->def_status_blk->sp_sb.            \
    index_values[HC_SP_INDEX_EQ_CONS])



#define ECORE_FCOE_CID(A)	0

/*linked list realted */
#define ECORE_LIST_INIT(H)	vmk_ListInit((H))

#define ECORE_LIST_IS_EMPTY(_head) vmk_ListIsEmpty(_head)

#define ECORE_LIST_PUSH_TAIL(_link, _head)      \
   vmk_ListInsert(_link, vmk_ListAtRear(_head))

#define ECORE_LIST_PUSH_HEAD(_link, _head)              \
   vmk_ListInsert(_link, vmk_ListAtFront(_head))

#define ECORE_LIST_REMOVE_ENTRY(_link, _head) vmk_ListRemove(_link)

#define ECORE_LIST_FOR_EACH_ENTRY(_pos, _head, _member, cast)           \
   for (_pos = VMK_LIST_ENTRY(vmk_ListFirst(_head), cast, _member);     \
	&_pos->_member != (_head);                                      \
	_pos = VMK_LIST_ENTRY(_pos->_member.nextPtr, cast, _member))

#define ECORE_LIST_FOR_EACH_ENTRY_SAFE(_pos, _n, _head, _member, cast)  \
   for (_pos = VMK_LIST_ENTRY(vmk_ListFirst(_head), cast, _member),     \
	   _n = VMK_LIST_ENTRY(_pos->_member.nextPtr, cast, _member);   \
	&_pos->_member != (_head);                                      \
	_pos = _n, _n = VMK_LIST_ENTRY(_n->_member.nextPtr, cast, _member))

#define ECORE_LIST_FIRST_ENTRY(_head, cast, _link)      \
   (cast *)vmk_ListFirst(_head)

#define ECORE_LIST_NEXT(_head, _member, cast)                   \
   VMK_LIST_ENTRY((_head)->_member.nextPtr, cast, _member)

#define ECORE_LIST_INSERT_ENTRY_AFTER(_link, _head, _list)      \
   vmk_ListInsert(_link, vmk_ListAtFront(_head))
#define __ECORE_LIST_SPLICE(_list, _prev, _next)        \
   do {                                                 \
      vmk_ListLinks *first = (_list)->nextPtr;          \
      vmk_ListLinks *last = (_list)->prevPtr;           \
      first->prevPtr = (_prev);                         \
      last->nextPtr = (_next);                          \
      (_next)->prevPtr = last;                          \
      (_prev)->nextPtr = first;                         \
   } while (0)

#define ECORE_LIST_SPLICE_TAIL_INIT(_list, _head)                       \
   do {                                                                 \
      if (!vmk_ListIsEmpty((_list))) {                                  \
	 __ECORE_LIST_SPLICE((_list), (_head)->prevPtr, (_head));       \
	 vmk_ListInit((_list));                                         \
      }                                                                 \
   } while (0)

#define ECORE_LIST_SPLICE_INIT(_list, _head)                            \
   do {                                                                 \
      if (!vmk_ListIsEmpty((_list))) {                                  \
	 __ECORE_LIST_SPLICE((_list), (_head), (_head)->nextPtr);       \
	 vmk_ListInit((_list));                                         \
      }                                                                 \
   } while (0)

static inline vmk_Bool
ECORE_LIST_IS_LAST(vmk_ListLinks * list, vmk_ListLinks * head)
{
   if (!vmk_ListIsEmpty(list)) {
      if (list->nextPtr == head)
	 return VMK_TRUE;
   }
   return VMK_FALSE;
}

vmk_uint32
calc_crc32(vmk_uint8 * crc32_packet, vmk_uint32 crc32_length,
	   vmk_uint32 crc32_seed, vmk_uint8 complement);

static inline vmk_uint32
ECORE_CRC32_LE(vmk_uint32 seed, vmk_uint8 * mac, vmk_uint32 len)
{
   vmk_uint32 packet_buf[2] = { 0 };
   vmk_Memcpy(((vmk_uint8 *) (&packet_buf[0])) + 2, &mac[0], 2);
   vmk_Memcpy(&packet_buf[1], &mac[2], 4);
   return bswap32(calc_crc32((vmk_uint8 *) packet_buf, 8, seed, 0));
}

#define ECORE_DBG_BREAK_IF(X) VMK_ASSERT(!(X))
#define ECORE_BUG_ON(X) VMK_ASSERT((!(X)))
#define ECORE_BUG()	VMK_ASSERT(0);

#define ECORE_SPIN_LOCK_INIT(LP, A)	\
        qfle3_create_spinlock("ecore", \
                        QFLE3_NAME_TO_STRING((A)->pdev_name), \
                        QFLE3_LOCK_RANK_LOW, (LP))
#if (VMKAPI_REVISION >= VMK_API_2_4_0_0)
#define ECORE_MUTEX_INIT(LP)  \
        vmk_SemaCreate((LP), qfle3_mod_info.heapID, "ecore", 1)
#else
#define ECORE_MUTEX_INIT(LP)  \
           vmk_SemaCreate((LP), vmk_ModuleCurrentID, "ecore", 1)
#endif

#define	ECORE_SPIN_LOCK_BH(LP)	vmk_SpinlockLock(*LP)
#define	ECORE_SPIN_UNLOCK_BH(LP)	vmk_SpinlockUnlock(*LP)
#define ETH_ALEN	VMK_ETH_ADDR_LENGTH
#define ECORE_ZALLOC(SZ, F, A) qfle3_heap_alloc((SZ))
#define ECORE_CALLOC(LEN, SZ, F, A) qfle3_heap_alloc(((SZ) * (LEN)))
#define ECORE_FREE(A, PTR, SZ)	qfle3_heap_free((PTR))
#define ECORE_MSLEEP(SLP)	vmk_WorldSleep(1000 * (SLP))
#define ECORE_WAIT(A, SLP)	vmk_WorldSleep((SLP))
/*TODO: find suitable replacement*/
#define ECORE_MIGHT_SLEEP()
#define ECORE_MUTEX_LOCK(LCK)	vmk_SemaLock(LCK)
#define ECORE_MUTEX_UNLOCK(LCK)	vmk_SemaUnlock(LCK)
#define ECORE_LIKELY VMK_LIKELY
#define ECORE_UNLIKELY VMK_UNLIKELY
#define ECORE_PATH_ID(A) QFLE3_PATH((A))
#define ECORE_ABS_FUNC_ID(A) QFLE3_ABS_FUNC((A))
#define ECORE_FUNC_ID(A) QFLE3_FUNC((A))
#define ECORE_PORT_ID(A) QFLE3_PORT((A))
#define ECORE_MAX_MULTICAST     64
#define ECORE_MAX_EMUL_MULTI	16
#define ECORE_MC_HASH_SIZE                       8
#define ECORE_MC_HASH_OFFSET(A, I)	(BAR_TSTRORM_INTMEM +           \
					 TSTORM_APPROXIMATE_MATCH_MULTICAST_FILTERING_OFFSET(QFLE3_FUNC(A)) + i*4)
#define ECORE_REG_WR_DMAE_LEN(A, offset, valp, len32)   \
   REG_WR_DMAE(A, offset, valp, len32)
#define GET_NUM_VFS_PER_PATH(A)	64
#define GET_NUM_VFS_PER_PF(A)	0       //No SRIOV support for now
#define VF_MAC_CREDIT_CNT       1
#define VF_VLAN_CREDIT_CNT      2


#define ECORE_SET_CTX_VALIDATION(A, CXTP, CID)	\
   qfle3_set_ctx_validation(A, CXTP, CID)
#define ECORE_UPDATE_COALESCE_SB_INDEX(A, FSB, SIDX, DIS, USEC)	\
   qfle3_update_coalesce_sb_index(A, FSB, SIDX, DIS, USEC)


#include "qfle3_ecore_sp.h"
//typedef struct qfle3_adapter qfle3_adapter;

#define BCM_PAGE_SHIFT       12
#define BCM_PAGE_SIZE        (1 << BCM_PAGE_SHIFT)
#define BCM_PAGE_MASK        (~(BCM_PAGE_SIZE - 1))
#define BCM_PAGE_ALIGN(addr) ((addr + BCM_PAGE_SIZE - 1) & BCM_PAGE_MASK)

#define BD_MIN_RX_NUM_PAGES	2		/* these numbers should be revisited */
#define BD_MAX_RX_NUM_PAGES	32
#define BD_MIN_TX_NUM_PAGES	2		/* these numbers should be revisited */
#define BD_MAX_TX_NUM_PAGES	64

/*****************/
/*
 * TX BD defines
 */
/*****************/
#define TX_BD_DEFAULT_NUM_PAGES  16    /* must be a power of 2 */
#define TX_BD_MIN_PAGES          16
#define TX_BD_MAX_PAGES          64
#define TX_BD_NUM_PAGES       (adapter->tx_bd_num_pages)
#define TX_BD_TOTAL_PER_PAGE  (BCM_PAGE_SIZE / sizeof(union eth_tx_bd_types))
#define TX_BD_USABLE_PER_PAGE (TX_BD_TOTAL_PER_PAGE - 1)
#define TX_BD_TOTAL           (TX_BD_TOTAL_PER_PAGE * TX_BD_NUM_PAGES)
#define TX_BD_USABLE          (TX_BD_USABLE_PER_PAGE * TX_BD_NUM_PAGES)
#define TX_BD_MAX             (TX_BD_TOTAL - 1)
#define MAX_TX_AVAIL          (TX_BD_USABLE_PER_PAGE * TX_BD_NUM_PAGES -2)

#define TX_BD_NEXT(x)                                                   \
   ((((x) & TX_BD_USABLE_PER_PAGE) == (TX_BD_USABLE_PER_PAGE - 1)) ?    \
    ((x) + 2) : ((x) + 1))
#define TX_BD(x)      ((x) & TX_BD_MAX)
#define TX_BD_PAGE(x) (((x) & ~TX_BD_USABLE_PER_PAGE) >> 8)
#define TX_BD_IDX(x)  ((x) & TX_BD_USABLE_PER_PAGE)
#define TX_BD_POFF(x)		((x) & TX_BD_USABLE_PER_PAGE)
/*
 * Trigger pending transmits when the number of available BDs is greater
 * than 1/8 of the total number of usable BDs.
 */
#define BXE_TX_CLEANUP_THRESHOLD 64 //(adapter->tx_ring_size / 8)
#define BXE_TX_TIMEOUT 5

/*****************/
/*
 * RX BD defines
 */
/*****************/

/* dropless fc calculations for BDs
 *
 * Number of BDs should as number of buffers in BRB:
 * Low threshold takes into account NEXT_PAGE_RX_DESC_CNT
 * "next" elements on each page
 */

#define NUM_BD_REQ              BRB_SIZE(adapter)
#define NUM_BD_PG_REQ           ((NUM_BD_REQ + RX_BD_USABLE_PER_PAGE - 1) / \
				 RX_BD_USABLE_PER_PAGE)
#define BD_TH_LO(adapter)            (NUM_BD_REQ +                      \
				      NUM_BD_PG_REQ * RX_BD_NEXT_PAGE_DESC_CNT+ \
				      FW_DROP_LEVEL(adapter))
#define BD_TH_HI(adapter)            (BD_TH_LO(adapter) + DROPLESS_FC_HEADROOM)

#define MIN_RX_AVAIL            ((adapter)->dropless_fc ? BD_TH_HI(adapter) + 128 : 128)

#define MIN_RX_SIZE_TPA_HW		(CHIP_IS_E1(sc) ?               \
					 ETH_MIN_RX_CQES_WITH_TPA_E1 :  \
					 ETH_MIN_RX_CQES_WITH_TPA_E1H_E2)
#define MIN_RX_SIZE_NONTPA_HW	ETH_MIN_RX_CQES_WITHOUT_TPA
#define MIN_RX_SIZE_TPA			(max(MIN_RX_SIZE_TPA_HW, MIN_RX_AVAIL))
#define MIN_RX_SIZE_NONTPA		(max(MIN_RX_SIZE_NONTPA_HW, MIN_RX_AVAIL))

#define RX_BD_DEFAULT_NUM_PAGES  8     /* must be a power of 2 */
#define RX_BD_MIN_PAGES          8
#define RX_BD_MAX_PAGES          32
#define RX_BD_NUM_PAGES       (adapter->rx_bd_num_pages)

#define RX_BD_TOTAL_PER_PAGE  (BCM_PAGE_SIZE / sizeof(struct eth_rx_bd))
#define RX_BD_NEXT_PAGE_DESC_CNT 2
#define RX_BD_USABLE_PER_PAGE (RX_BD_TOTAL_PER_PAGE - RX_BD_NEXT_PAGE_DESC_CNT)
#define RX_BD_PER_PAGE_MASK   (RX_BD_TOTAL_PER_PAGE - 1)
#define RX_BD_TOTAL           (RX_BD_TOTAL_PER_PAGE * RX_BD_NUM_PAGES)
#define RX_BD_USABLE          (RX_BD_USABLE_PER_PAGE * RX_BD_NUM_PAGES)
#define RX_BD_MAX             (RX_BD_TOTAL - 1)
#define MAX_RX_AVAIL		  (RX_BD_USABLE_PER_PAGE * RX_BD_NUM_PAGES -2)

#define INIT_JUMBO_RX_RING_SIZE (max(max((MAX_RX_AVAIL/16), 512), MIN_RX_AVAIL))
#define INIT_RX_RING_SIZE		(max((MAX_RX_AVAIL/4), MIN_RX_AVAIL))


#define RX_BD_NEXT(x)                                                   \
   ((((x) & RX_BD_PER_PAGE_MASK) == (RX_BD_USABLE_PER_PAGE - 1)) ?      \
    ((x) + 3) : ((x) + 1))
#define RX_BD(x)      ((x) & RX_BD_MAX)
#define RX_BD_PAGE(x) (((x) & ~RX_BD_PER_PAGE_MASK) >> 9)
#define RX_BD_IDX(x)  ((x) & RX_BD_PER_PAGE_MASK)


static const vmk_uint32 dmae_reg_go_c[] = {
   DMAE_REG_GO_C0, DMAE_REG_GO_C1, DMAE_REG_GO_C2, DMAE_REG_GO_C3,
   DMAE_REG_GO_C4, DMAE_REG_GO_C5, DMAE_REG_GO_C6, DMAE_REG_GO_C7,
   DMAE_REG_GO_C8, DMAE_REG_GO_C9, DMAE_REG_GO_C10, DMAE_REG_GO_C11,
   DMAE_REG_GO_C12, DMAE_REG_GO_C13, DMAE_REG_GO_C14, DMAE_REG_GO_C15
};


/***************/
/* RCQ defines */
/***************/

/*
 * As long as CQE is X times bigger than BD entry we have to allocate X times
 * more pages for CQ ring in order to keep it balanced with BD ring
 */
#define CQE_BD_REL          (sizeof(union eth_rx_cqe) / \
			     sizeof(struct eth_rx_bd))
#define RCQ_NUM_PAGES       (RX_BD_NUM_PAGES * CQE_BD_REL)      /* power of 2 */
#define RCQ_TOTAL_PER_PAGE  (BCM_PAGE_SIZE / sizeof(union eth_rx_cqe))
#define RCQ_NEXT_PAGE_DESC_CNT 1
#define RCQ_USABLE_PER_PAGE (RCQ_TOTAL_PER_PAGE - RCQ_NEXT_PAGE_DESC_CNT)
#define RCQ_TOTAL           (RCQ_TOTAL_PER_PAGE * RCQ_NUM_PAGES)
#define RCQ_USABLE          (RCQ_USABLE_PER_PAGE * RCQ_NUM_PAGES)
#define RCQ_MAX             (RCQ_TOTAL - 1)
#define MAX_RCQ_AVAIL      (RCQ_USABLE_PER_PAGE * RCQ_NUM_PAGES -2)

#define RCQ_NEXT(x)                                                     \
   ((((x) & RCQ_USABLE_PER_PAGE) == (RCQ_USABLE_PER_PAGE - 1)) ?        \
    ((x) + 1 + RCQ_NEXT_PAGE_DESC_CNT) : ((x) + 1))
#define RCQ(x)      ((x) & RCQ_MAX)
#define RCQ_PAGE(x) (((x) & ~RCQ_USABLE_PER_PAGE) >> 7)
#define RCQ_IDX(x)  ((x) & RCQ_USABLE_PER_PAGE)

#define QFLE3_IS_CQE_COMPLETED(cqe_fp) (cqe_fp->marker == 0x0)
#define QFLE3_MARK_CQE_FREE(cqe_fp) (cqe_fp->marker = 0xFFFFFFFF)
#define FCOE_NUM_RX_PAGES_DEF  8
#define FCOE_NUM_TX_PAGES_DEF 16
#if 0
#define NUM_RCQ_RINGS RCQ_NUM_PAGES
#define NUM_RCQ_BD    RCQ_TOTAL
#define MAX_RCQ_BD    RCQ_MAX
#define MAX_RCQ_AVAIL RCQ_USABLE
#endif

/*
 * dropless fc calculations for RCQs
 * Number of RCQs should be as number of buffers in BRB:
 * Low threshold takes into account RCQ_NEXT_PAGE_DESC_CNT
 * "next" elements on each page
 */
#define NUM_RCQ_REQ(sc)                         \
   BRB_SIZE(sc)
#define NUM_RCQ_PG_REQ(sc)                                              \
   ((NUM_RCQ_REQ(sc) + RCQ_USABLE_PER_PAGE - 1) / RCQ_USABLE_PER_PAGE)
#define RCQ_TH_LO(sc)                                   \
   (NUM_RCQ_REQ(sc) +                                   \
    NUM_RCQ_PG_REQ(sc) * RCQ_NEXT_PAGE_DESC_CNT +       \
    FW_DROP_LEVEL(sc))
#define RCQ_TH_HI(sc)                           \
   (RCQ_TH_LO(sc) + DROPLESS_FC_HEADROOM)

#define CQE_CMD(x) (le32toh(x) >> COMMON_RAMROD_ETH_RX_CQE_CMD_ID_SHIFT)

#define CQE_TYPE(cqe_fp_flags)   ((cqe_fp_flags) & ETH_FAST_PATH_RX_CQE_TYPE)
#define CQE_TYPE_START(cqe_type) ((cqe_type) == RX_ETH_CQE_TYPE_ETH_START_AGG)
#define CQE_TYPE_STOP(cqe_type)  ((cqe_type) == RX_ETH_CQE_TYPE_ETH_STOP_AGG)
#define CQE_TYPE_SLOW(cqe_type)  ((cqe_type) == RX_ETH_CQE_TYPE_ETH_RAMROD)
#define CQE_TYPE_FAST(cqe_type)  ((cqe_type) == RX_ETH_CQE_TYPE_ETH_FASTPATH)

/* dropless fc FW/HW related params */
#define BRB_SIZE(sc)         (CHIP_IS_E3(sc) ? 1024 : 512)
#define MAX_AGG_QS(sc)       (CHIP_IS_E1(sc) ?                          \
			      ETH_MAX_AGGREGATION_QUEUES_E1 :           \
			      ETH_MAX_AGGREGATION_QUEUES_E1H_E2)
#define FW_DROP_LEVEL(sc)    (3 + MAX_SPQ_PENDING + MAX_AGG_QS(sc))
#define FW_PREFETCH_CNT      16
#define DROPLESS_FC_HEADROOM 100

#define HC_INDEX_ETH_RX_CQ_CONS         1

#define HC_INDEX_OOO_TX_CQ_CONS         4

#define HC_INDEX_ETH_TX_CQ_CONS_COS0    5

#define HC_INDEX_ETH_TX_CQ_CONS_COS1    6

#define HC_INDEX_ETH_TX_CQ_CONS_COS2    7

#define HC_INDEX_ETH_FIRST_TX_CQ_CONS   HC_INDEX_ETH_TX_CQ_CONS_COS0

#define QFLE3_RX_SB_INDEX                               \
   (&fp->sb_index_values[HC_INDEX_ETH_RX_CQ_CONS])

#define QFLE3_TX_SB_INDEX_COS0                          \
   (&fp->sb_index_values[HC_INDEX_ETH_TX_CQ_CONS_COS0])

#define QFLE3_TX_SB_INDEX_BASE QFLE3_TX_SB_INDEX_COS0


/******************/
/* RX SGE defines */
/******************/

#define RX_SGE_NUM_PAGES       2        /* must be a power of 2 */
#define RX_SGE_TOTAL_PER_PAGE  (BCM_PAGE_SIZE / sizeof(struct eth_rx_sge))
#define RX_SGE_NEXT_PAGE_DESC_CNT 2
#define RX_SGE_USABLE_PER_PAGE (RX_SGE_TOTAL_PER_PAGE - RX_SGE_NEXT_PAGE_DESC_CNT)
#define RX_SGE_PER_PAGE_MASK   (RX_SGE_TOTAL_PER_PAGE - 1)
#define RX_SGE_TOTAL           (RX_SGE_TOTAL_PER_PAGE * RX_SGE_NUM_PAGES)
#define RX_SGE_USABLE          (RX_SGE_USABLE_PER_PAGE * RX_SGE_NUM_PAGES)
#define RX_SGE_MAX             (RX_SGE_TOTAL - 1)
#define RX_SGE(x)              ((x) & RX_SGE_MAX)

#define RX_SGE_NEXT(x)                                                  \
   ((((x) & RX_SGE_PER_PAGE_MASK) == (RX_SGE_USABLE_PER_PAGE - 1))      \
    ? (x) + 1 + RX_SGE_NEXT_PAGE_DESC_CNT : (x) + 1)

#define RX_SGE_MASK_ELEM_SZ    64
#define RX_SGE_MASK_ELEM_SHIFT 6
#define RX_SGE_MASK_ELEM_MASK  ((vmk_uint64)RX_SGE_MASK_ELEM_SZ - 1)

/*
 * Creates a bitmask of all ones in less significant bits.
 * idx - index of the most significant bit in the created mask.
 */
#define RX_SGE_ONES_MASK(idx)                                           \
   (((vmk_uint64)0x1 << (((idx) & RX_SGE_MASK_ELEM_MASK) + 1)) - 1)
#define RX_SGE_MASK_ELEM_ONE_MASK ((vmk_uint64)(~0))

/* Number of uint64_t elements in SGE mask array. */
#define RX_SGE_MASK_LEN                                                 \
   ((RX_SGE_NUM_PAGES * RX_SGE_TOTAL_PER_PAGE) / RX_SGE_MASK_ELEM_SZ)
#define RX_SGE_MASK_LEN_MASK      (RX_SGE_MASK_LEN - 1)
#define RX_SGE_NEXT_MASK_ELEM(el) (((el) + 1) & RX_SGE_MASK_LEN_MASK)


/*
 * dropless fc calculations for SGEs
 * Number of required SGEs is the sum of two:
 * 1. Number of possible opened aggregations (next packet for
 *    these aggregations will probably consume SGE immidiatelly)
 * 2. Rest of BRB blocks divided by 2 (block will consume new SGE only
 *    after placement on BD for new TPA aggregation)
 * Takes into account RX_SGE_NEXT_PAGE_DESC_CNT "next" elements on each page
 */
#define NUM_SGE_REQ(sc)                                         \
   (MAX_AGG_QS(sc) + (BRB_SIZE(sc) - MAX_AGG_QS(sc)) / 2)
#define NUM_SGE_PG_REQ(sc)                                              \
   ((NUM_SGE_REQ(sc) + RX_SGE_USABLE_PER_PAGE - 1) / RX_SGE_USABLE_PER_PAGE)
#define SGE_TH_LO(sc)                                                   \
   (NUM_SGE_REQ(sc) + NUM_SGE_PG_REQ(sc) * RX_SGE_NEXT_PAGE_DESC_CNT)
#define SGE_TH_HI(sc)                           \
   (SGE_TH_LO(sc) + DROPLESS_FC_HEADROOM)

#define PAGES_PER_SGE_SHIFT  0
#define PAGES_PER_SGE        (1 << PAGES_PER_SGE_SHIFT)
#define SGE_PAGE_SIZE        BCM_PAGE_SIZE
#define SGE_PAGE_SHIFT       BCM_PAGE_SHIFT
#define SGE_PAGE_ALIGN(addr) BCM_PAGE_ALIGN(addr)
#define SGE_PAGES            (SGE_PAGE_SIZE * PAGES_PER_SGE)
#define TPA_AGG_SIZE         min((8 * SGE_PAGES), 0xffff)


/* L2 header size + 2*VLANs (8 bytes) + LLC SNAP (8 bytes) */
#define ETH_HLEN                  14
#define ETH_OVERHEAD              (ETH_HLEN + 8 + 8)
#define ETH_MIN_PACKET_SIZE       60
#define ETH_MAX_PACKET_SIZE       1500
#define ETH_MAX_JUMBO_PACKET_SIZE 9600
/* TCP with Timestamp Option (32) + IPv6 (40) */
#define ETH_MAX_TPA_HEADER_SIZE   72

/* max supported alignment is 256 (8 shift) */
//#define BXE_RX_ALIGN_SHIFT ((CACHE_LINE_SHIFT < 8) ? CACHE_LINE_SHIFT : 8)
#define BXE_RX_ALIGN_SHIFT 8
/* FW uses 2 cache lines alignment for start packet and size  */
#define BXE_FW_RX_ALIGN_START (1 << BXE_RX_ALIGN_SHIFT)
#define BXE_FW_RX_ALIGN_END   (1 << BXE_RX_ALIGN_SHIFT)

#define BXE_PXP_DRAM_ALIGN (BXE_RX_ALIGN_SHIFT - 5)     /* XXX ??? */


typedef enum {
   QFLE3_STATE_BIT_RESETTING,
   QFLE3_STATE_BIT_QUIESCED,
   QFLE3_STATE_BIT_ATTACHED,
   QFLE3_STATE_BIT_LOADED,
   QFLE3_STATE_BIT_IOSTARTED,
   QFLE3_STATE_BIT_ERROR,
   QFLE3_STATE_MAX,
} qfle3_DevState;

enum qfle3_lock_type {
   QFLE3_LOCK_TYPE_SPINLOCK,
   QFLE3_LOCK_TYPE_SEMAPHORE,
   QFLE3_LOCK_TYPE_RW_SEMAPHORE,
};

struct qfle3_lock {
   vmk_ListLinks link;
   union {
      vmk_Lock spin_lock;
      vmk_Semaphore sema;
      vmk_SemaphoreRW rw_sema;
   };
   enum qfle3_lock_type type;
};

struct qfle3_prev_path_list {
   vmk_ListLinks link;
   vmk_uint8 bus;
   vmk_uint8 slot;
   vmk_uint8 path;
   vmk_uint8 aer;
   vmk_uint8 undi;
};

struct qfle3_mac_vals {
	vmk_uint32 xmac_addr;
	vmk_uint32 xmac_val;
	vmk_uint32 emac_addr;
	vmk_uint32 emac_val;
	vmk_uint32 umac_addr[2];
	vmk_uint32 umac_val[2];
	vmk_uint32 bmac_addr;
	vmk_uint32 bmac_val[2];
};

typedef enum {
   QFLE3_MAP_INVALID = 0,
   QFLE3_MAP_NONE,
   QFLE3_MAP_ELEM,
} qfle3_buf_map_type;


#define QFLE3_MAX_SEGMENTS     12 /* 13-1 for parsing buffer */
#define QFLE3_TSO_MAX_SEGMENTS 32
#define QFLE3_TSO_MAX_SIZE     (65536 - 1)

#define CSUM_IPV4 0x00000001
#define CSUM_IPV6 0x00000002
#define CSUM_TCP 0x00000004
#define CSUM_UDP 0x00000008


typedef struct {
   vmk_uint16 len;
   vmk_IOA ioa;
} qfle3_txsegs;

typedef struct {
   vmk_uint32 mapType;
   vmk_uint16 first_bd;
   vmk_PktHandle *pkt;
   vmk_uint8 flags;
/* set on the first BD descriptor when there is a split BD */
#define BXE_TSO_SPLIT_BD (1 << 0)
   qfle3_txsegs tx_segs[QFLE3_TSO_MAX_SEGMENTS];
   vmk_uint16 nsegs;
} qfle3_txbuf_info;

typedef enum {
   QFLE3_RX_BUF_NONE = 0,
   QFLE3_RX_BUF_PKT = 1,
   QFLE3_RX_BUF_PAGE = 2,
} qfle3_rxbuf_type;

typedef struct {
   qfle3_rxbuf_type bufType;
   vmk_uint16 len;
   union {
      vmk_PktHandle *pkt;
      vmk_MPN page;
   };
   vmk_IOA dmaAddr;
} qfle3_rxbuf_info;

typedef struct {
   vmk_Name driverName;
   vmk_Driver driverID;
   vmk_HeapID heapID;
   vmk_MemPool memPoolID;
   vmk_LogComponent logID;
   vmk_LogComponent logThrottledID;
   vmk_LockDomainID lockDomain;
   vmk_DumpFileHandle recoveryDumpFile;
   vmk_DumpFileHandle dumpFile;
   vmk_ListLinks adapterList;
   vmk_ListLinks ecore_lock_list;
   vmk_Lock drv_lock;
   vmk_Semaphore prev_mutex;
   vmk_ListLinks prev_list;
   vmk_RebootHandler reboot_handler;
   vmk_TimerQueue timer_queue;
} qfle3_mod_info_t;

typedef enum {
   QFLE3_IMM_AUTO = 0,
   QFLE3_IMM_ACTIVE = 1,
   QFLE3_IMM_LAZY = 2,
} qfle3_IntrMaskMode;

typedef enum {
   QFLE3_IT_AUTO = 0,
   QFLE3_IT_INTX = 1,
   QFLE3_IT_MSI = 2,
   QFLE3_IT_MSIX = 3,
} qfle3_IntrType;

typedef struct {
   qfle3_IntrType intrType;
   vmk_uint8 numIntrs;
   vmk_uint8 eventIntrIdx;
   vmk_uint8 modLevels[QFLE3_MAX_MSIX_VECT];
   vmk_Name eventMSIXVectorName;
   vmk_IntrCookie cookies[QFLE3_MAX_MSIX_VECT];
   void *handlerData[QFLE3_MAX_MSIX_VECT];
} qfle3_intr;

struct qfle3_link_report_data {
   vmk_uint16 line_speed;                 /* Effective line speed */
//TODO replace with bitvector
   unsigned long link_report_flags;/* QFLE3_LINK_REPORT_XXX flags */
};

enum {
   QFLE3_LINK_REPORT_FD,           /* Full DUPLEX */
   QFLE3_LINK_REPORT_LINK_DOWN,
   QFLE3_LINK_REPORT_RX_FC_ON,
   QFLE3_LINK_REPORT_TX_FC_ON,
};
#define QFLE3_PHY_LOOPBACK		0
#define QFLE3_MAC_LOOPBACK		1
#define QFLE3_EXT_LOOPBACK		2
#define QFLE3_PHY_LOOPBACK_FAILED	1
#define QFLE3_MAC_LOOPBACK_FAILED	2
#define QFLE3_EXT_LOOPBACK_FAILED	3
#define QFLE3_LOOPBACK_FAILED		(QFLE3_MAC_LOOPBACK_FAILED | \
					 QFLE3_PHY_LOOPBACK_FAILED)

struct qfle3_port {
   vmk_uint32 pmf;
   vmk_uint32 link_config[ELINK_LINK_CONFIG_SIZE];
   vmk_uint32 supported[ELINK_LINK_CONFIG_SIZE];
   vmk_uint32 advertising[ELINK_LINK_CONFIG_SIZE];
   vmk_uint32 phy_addr;
   /*
    * used to synchronize phy accesses
    */
   vmk_Semaphore phy_mutex;
   vmk_uint32 port_stx;
   struct nig_stats        old_nig_stats;
};

#define MAX_DYNAMIC_ATTN_GRPS       8

/* IGU MSIX STATISTICS on 57712: 64 for VFs; 4 for PFs; 4 for Attentions */
#define QFLE3_IGU_STAS_MSG_VF_CNT 64
#define QFLE3_IGU_STAS_MSG_PF_CNT 4

#define MAX_IGU_ATTN_ACK_TO       100

struct qfle3_func_init_params {
   /*
    * dma
    */
   vmk_Bool spq_active;
   vmk_IOA spq_map;
   vmk_uint16 spq_prod;

   vmk_uint16 func_id;          /* abs fid */
   vmk_uint16 pf_id;
};

struct attn_route {
   vmk_uint32 sig[5];
};

struct iro {
   vmk_uint32 base;
   vmk_uint16 m1;
   vmk_uint16 m2;
   vmk_uint16 m3;
   vmk_uint16 size;
};

struct qfle3_mf_info {
   vmk_uint32 mf_config[E1HVN_MAX];


};

/* firmware stats related data structures */
enum {
   QFLE3_PORT_QUERY_IDX,
   QFLE3_PF_QUERY_IDX,
   QFLE3_FCOE_QUERY_IDX,
   QFLE3_FIRST_QUEUE_QUERY_IDX,
};

struct qfle3_fw_stats_req {
   struct stats_query_header hdr;
   struct stats_query_entry  query[FP_SB_MAX_E1x +
				   QFLE3_FIRST_QUEUE_QUERY_IDX];
};

struct qfle3_fw_stats_data {
   struct stats_counter          storm_counters;
   struct per_port_stats         port;
   struct per_pf_stats           pf;
   struct fcoe_statistics_params fcoe;
   struct per_queue_stats        queue_stats[1];
};

/* IGU MSIX STATISTICS on 57712: 64 for VFs; 4 for PFs; 4 for Attentions */
#define QFLE3_IGU_STAS_MSG_VF_CNT 64
#define QFLE3_IGU_STAS_MSG_PF_CNT 4

#define MAX_DMAE_C 8
struct qfle3_slowpath {
   vmk_uint32 wb_comp;
   vmk_uint32 wb_data[4];
   union {
      struct mac_configuration_cmd            e1x;
      struct eth_classify_rules_ramrod_data   e2;
   } mac_rdata;

   union {
      struct eth_classify_rules_ramrod_data   e2;
   } vlan_rdata;

   union {
      struct eth_classify_rules_ramrod_data    e2;
   } pvlan_rdata;

   union {
      struct tstorm_eth_mac_filter_config     e1x;
      struct eth_filter_rules_ramrod_data     e2;
   } rx_mode_rdata;

   union {
      struct mac_configuration_cmd            e1;
      struct eth_multicast_rules_ramrod_data  e2;
   } mcast_rdata;

   union {
      struct client_init_ramrod_data  init_data;
      struct client_update_ramrod_data update_data;
      struct tpa_update_ramrod_data tpa_data;
   } q_rdata;

   union {
      struct function_start_data func_start;
      /*
       * pfc configuration for DCBX ramrod
       */
      struct flow_control_configuration pfc_config;
   } func_rdata;

   union {
      struct afex_vif_list_ramrod_data viflist_data;
      struct function_update_data func_update;
   } func_afex_rdata;
   /* slowpath stats related data structres */
   /* used by the DMAE command executer */
   struct dmae_command dmae[MAX_DMAE_C];
   /* statistics completion */
   vmk_uint32 stats_comp;

   /* firmware defined statistics blocks */
   union mac_stats        mac_stats;
   struct nig_stats       nig_stats;
   struct host_port_stats port_stats;
   struct host_func_stats func_stats;
   //struct host_func_stats func_stats_base;
   union drv_info_to_mcp  drv_info_to_mcp;
   struct eth_rss_update_ramrod_data       defq_rss_rdata;
#if (ESX_DDK_VERSION >= 2017)
   struct eth_rss_update_ramrod_data       rss_rdata[QFLE3_DEVICE_MAX_RSS_ENGINE+1];
#else
   struct eth_rss_update_ramrod_data       rss_rdata;
   struct eth_rss_update_ramrod_data       reserved[4];
#endif

};

struct qfle3_fw_init_data {
   struct raw_op *init_ops;
   vmk_uint16 *init_ops_offsets;
   vmk_uint32 *init_data;
   vmk_uint32 init_mode_flags;
   const vmk_uint8 *tsem_int_table_data;
   const vmk_uint8 *tsem_pram_data;
   const vmk_uint8 *usem_int_table_data;
   const vmk_uint8 *usem_pram_data;
   const vmk_uint8 *xsem_int_table_data;
   const vmk_uint8 *xsem_pram_data;
   const vmk_uint8 *csem_int_table_data;
   const vmk_uint8 *csem_pram_data;
};

#define PHY_FW_VER_LEN 20

struct qfle3_hw_info {
   vmk_uint32 chip_id;
   vmk_uint32 flash_size;
   vmk_uint32 shmem_base;
   vmk_uint32 shmem2_base;
   vmk_uint32 mf_cfg_base;
   vmk_uint32 mf2_cfg_base;

   vmk_uint32 hw_config;

   vmk_uint32 bc_ver;

   vmk_uint8 int_block;

   vmk_uint8 port_mode;

   vmk_uint32 boot_mode;
};

enum qfle3_recovery_state {
   QFLE3_RECOVERY_DONE,
   QFLE3_RECOVERY_INIT,
   QFLE3_RECOVERY_WAIT,
   QFLE3_RECOVERY_FAILED,
   QFLE3_RECOVERY_NIC_LOADING
};

struct ecore_ilt;

union qfle3_host_hc_status_block {
   /*
    * pointer to fp status block e2
    */
   struct host_hc_status_block_e2 *e2_sb;
   /*
    * pointer to fp status block e1x
    */
   struct host_hc_status_block_e1x *e1x_sb;
};

union qfle3_db_prod {
   struct doorbell_set_prod data;
   vmk_uint32 raw;
};

#define SET_FLAG(value, mask, flag)             \
   do {                                         \
      (value) &= ~(mask);                       \
      (value) |= ((flag) << (mask##_SHIFT));    \
   } while (0)

#define GET_FLAG(value, mask)                   \
   (((value) & (mask)) >> (mask##_SHIFT))

#define GET_FIELD(value, fname)                         \
   (((value) & (fname##_MASK)) >> (fname##_SHIFT))

struct qfle3_sw_tpa_info {
   qfle3_rxbuf_info bd;
   vmk_uint8 state;
#define QFLE3_TPA_STATE_START 1
#define QFLE3_TPA_STATE_STOP  2
   vmk_uint8 placement_offset;
   vmk_uint16 parsing_flags;
   vmk_uint16 vlan_tag;
   vmk_uint16 len_on_bd;
};

typedef struct {
   vmk_uint16 encap_packet_inner_ip_offset;
   vmk_uint16 encap_packet_inner_ip_fragment_id;
   vmk_uint16 encap_packet_inner_pseudo_csum;
   vmk_uint16 encap_packet_inner_L4_offset;
   vmk_uint16 encap_packet_inner_L4_length;
   vmk_uint16 encap_packet_inner_L4_protocol;
   vmk_uint16 encap_packet_header_length;
   vmk_uint16 encap_packet_outer_ip_hdr_to_payload;
   vmk_uint16 encap_packet_outer_ip_offset;
   vmk_uint16 encap_packet_outer_ip_length;
   vmk_uint16 encap_packet_outer_ip_csum_wo_len_flags_frag;
   vmk_uint16 encap_packet_outer_udp_hdr_offset;
   vmk_uint32 encap_packet_tcp_send_seq;
   vmk_uint8 encap_packet_tcp_flag;
} qfle3_pkt_tx_info_t;

struct qfle3_txStats
{
   vmk_uint32 tx_errs;
   vmk_uint64 tx_bytes;
   vmk_uint64 tx_pkts;
   vmk_uint32 vxlan_tx_pkts;
} VMK_ATTRIBUTE_L1_ALIGNED;

typedef struct qfle3_rx_filter{
   vmk_uint8 mac[VMK_ETH_ADDR_LENGTH];
   vmk_uint8 inner_mac[VMK_ETH_ADDR_LENGTH];
   vmk_uint16 vxlan_id;
   vmk_uint32 flags;
} qfle3_rx_filter_t;

enum qfle3_tpa_mode_t {
   TPA_MODE_DISABLED,
   TPA_MODE_LRO,
   TPA_MODE_GRO
};

typedef struct qfle3_encap_stats {
   vmk_uint64 vxlan_tx_pkts;
   vmk_uint64 geneve_tx_pkts;
   vmk_uint64 encap_expected_tso;
   vmk_uint64 encap_expected_cso;
} qfle3_encap_stats_t;

typedef struct qfle3_drv_stats {
   vmk_uint64  rx_pkts;
   vmk_uint64  rx_bytes;
   vmk_uint64  tx_pkts;
   vmk_uint64  tx_bytes;

   vmk_uint64  tx_done_pkts;
   vmk_uint64  expected_tso;
   vmk_uint64  expected_cso;

   vmk_uint64  rx_Errors;
   vmk_uint64  tx_Errors;
   vmk_uint64  rx_Drops;
   vmk_uint64  tx_Drops;
   vmk_uint64  rx_MulticastPkts;
   vmk_uint64  rx_BroadcastPkts;
   vmk_uint64  tx_MulticastPkts;
   vmk_uint64  tx_BroadcastPkts;
   vmk_uint64  collisions;
   vmk_uint64  rx_LengthErrors;
   vmk_uint64  rx_OverflowErrors;
   vmk_uint64  rx_CRCErrors;
   vmk_uint64  rx_FrameAlignErrors;
   vmk_uint64  rx_FifoErrors;
   vmk_uint64  rx_MissErrors;
   vmk_uint64  tx_AbortedErrors;
   vmk_uint64  tx_CarrierErrors;
   vmk_uint64  tx_FifoErrors;
   vmk_uint64  tx_HeartbeatErrors;
   vmk_uint64  tx_WindowErrors;
   qfle3_encap_stats_t encap_stats;
} qfle3_drv_stats_t;
struct protocol_count {
    vmk_uint32  protocols[64];
    vmk_uint64  protocol_pkt_count[64];
    vmk_uint16  protocol_count;
};
/* private states */
typedef struct qfle3_drv_stats_priv {
   vmk_uint64  rssq_rx_bytes;
   vmk_uint64  tpa_rx_pkts;
   vmk_uint64  tpa_rx_bytes;
   vmk_uint64  tso_seg_overlimit;
   vmk_uint64  tx_pkt_rcvd;
   vmk_uint64  tx_pkt_accepted;
   vmk_uint64  tx_pkt_completed;
   vmk_uint64  tx_fcoe_redirected;
   vmk_uint64  tx_pkt_padded;
   struct protocol_count tx_p;
   struct protocol_count rx_p;
} qfle3_drv_stats_priv_t;

struct qfle3_fp_txdata {
   
   vmk_uint32              cid;
   vmk_uint32              txq_index;
   vmk_uint8               cos;
   struct qfle3_fastpath * parent_fp;
   /*
    * Tx data buffer tracker
    */
   qfle3_txbuf_info *      txbuf_chain;
   /*
    * Tx BD table
    */
   union eth_tx_bd_types * tx_chain;
   vmk_IOA                 tx_chain_ioa;
   
   /*
    * Pointer to the transmit consumer in the status block
    */
   vmk_uint16 *            tx_cons_sb;
   union qfle3_db_prod     tx_db;
   vmk_uint32              tx_ring_size;
   
   /*
    * Transmit packet producer index (used in eth_tx_bd).
    */
   vmk_uint16              tx_pkt_prod;
   vmk_uint16              tx_pkt_cons;

   /* detecting tx hang */
   vmk_uint16              prev_tx_pkt_cons;
   vmk_uint16              queue_stuck;

   /*
    * Transmit buffer descriptor producer index.
    */
   vmk_uint16              tx_bd_prod;
   vmk_uint16              tx_bd_cons;
};

/*
 * This is the HSI fastpath data structure. There can be up to MAX QUEUEs
 * instances of the fastpath structure when using multiple queues.
 */
struct qfle3_fastpath {
   /*
    * pointer back to parent structure
    */
   vmk_Name name;               /*to identify interrupt */
   struct qfle3_adapter *adapter;
   vmk_uint32 qid;
#define QFLE3_FP_STATE_CLOSED  0x01
#define QFLE3_FP_STATE_IRQ     0x02
#define QFLE3_FP_STATE_OPENING 0x04
#define QFLE3_FP_STATE_OPEN    0x08
#define QFLE3_FP_STATE_HALTING 0x10
#define QFLE3_FP_STATE_HALTED  0x20
   vmk_Lock fp_lock;
   vmk_UplinkSharedQueueData *sqd;
   vmk_NetPoll netpoll;
   vmk_Bool pollDisabled;
   vmk_uint32 fp_state;
   struct {
      vmk_Bool   tq_stopped_by_tx : 1;
      vmk_Bool   q_started_by_vmk :1;
   } soft_state;

   /*
    * Status Block
    */
   union qfle3_host_hc_status_block status_block;
   vmk_IOA status_block_ioa;

   vmk_uint32                     cid;

   vmk_uint8                      cl_id;          /* eth client id */
   vmk_uint8                      cl_qzone_id;
   vmk_uint8 igu_sb_id;         /* status block number in HW */
   vmk_uint8 fw_sb_id;          /* status block number in FW */
   vmk_uint16 fp_hc_idx;
   vmk_uint16 *sb_index_values;
   vmk_uint16 *sb_running_index;


   /**** Tx Queue Begin ****/
   struct qfle3_fp_txdata *txdata_ptr[QFLE3_MULTI_TX_COS];

   /**** Rx Queue Begin ****/
   /*
    * Rx BD table
    */
   struct eth_rx_bd *rx_chain;
   vmk_IOA rx_chain_ioa;
   /*
    * Rx data buffer tracker
    */
   vmk_uint32 rx_buf_size;
   vmk_uint32 rx_buf_alloc_size;
   qfle3_rxbuf_info *rxbuf_chain;
   /*
    * driver copy of the receive buffer descriptor prod/cons indices
    */
   vmk_uint16 rx_pkts_avail;
   vmk_uint16 rx_bd_prod;
   vmk_uint16 rx_bd_cons;
   vmk_uint32 ustorm_rx_prods_offset;

   /*
    * Rx Completion Queue chain (rcq bds)
    */
   union eth_rx_cqe *rcq_chain;
   vmk_IOA rcq_chain_ioa;
   /*
    * driver copy of the receive completion queue prod/cons indices
    */
   vmk_uint16 rx_cq_prod;
   vmk_uint16 rx_cq_cons;
   /*
    * Pointer to the receive consumer in the status block
    */
   vmk_uint16 *rx_cq_cons_sb;

   /**** Rx Queue End ****/

   /*
    * transmit timeout until chip reset
    */
   int watchdog_timer;
   /* fastpath stats related data structures */
   struct tstorm_per_queue_stats old_tclient;
   struct ustorm_per_queue_stats old_uclient;
   struct xstorm_per_queue_stats old_xclient;
   struct qfle3_eth_q_stats      eth_q_stats;
   struct qfle3_eth_q_stats_old  eth_q_stats_old;

   qfle3_drv_stats_t    drv_stats;
   qfle3_drv_stats_priv_t drv_stats_priv;
   /*
    * TPA
    */
   /*
    * receive scatter/gather entry chain (for TPA)
    */
   struct eth_rx_sge *rx_sge_chain;
   vmk_IOA rx_sge_chain_ioa;

   vmk_uint64 sge_mask[RX_SGE_MASK_LEN];
   vmk_uint16 rx_sge_prod;
   /*
    * rx sge mbufs
    */
   qfle3_rxbuf_info rx_sge_mbuf_chain[RX_SGE_TOTAL];

   /*
    * rx tpa mbufs (use the larger size for TPA queue length)
    */
   int tpa_enable;              /* disabled per fastpath upon error */
   struct qfle3_sw_tpa_info rx_tpa_info[ETH_MAX_AGGREGATION_QUEUES_E1H_E2];
   vmk_uint64 rx_tpa_queue_used;

   vmk_uint16 last_max_sge;
   int max_cos;
   struct qfle3_txStats tx_stats;
   qfle3_rx_filter_t rx_filters[QFLE3_MAX_FILTERS_PER_QUEUE];
   vmk_uint32 num_rx_filters;
   vmk_uint8 is_leading_rss;
   vmk_uint8 is_defq_rss;
   vmk_uint8 num_rss;
   vmk_uint32 rss_engine_id;
   vmk_uint8 collect_stats;
#if (ESX_DDK_VERSION >= 2017)
   vmk_uint8  q_in_use;
   vmk_uint32 sec_quque_ids[QFLE3_DEVICE_MAX_RSS_QUEUES];
#else
   vmk_uint8  reserved1;
   vmk_uint32 reserved2[QFLE3_DEVICE_MAX_RSS_QUEUES];
#endif
};


#define QFLE3_FP(sc, nr, var) ((sc)->fp[(nr)].var)
#define QFLE3_SP_OBJ(sc, fp) ((sc)->sp_objs[(fp)->qid])

struct bxe_sp_objs {
   struct ecore_vlan_mac_obj mac_obj;   /* MACs object */
   struct ecore_vlan_mac_obj vxlan_filter_obj;   /* VXLAN filter object */
   struct ecore_queue_sp_obj q_obj;     /* Queue State object */

   /* VLANs object */
   struct ecore_vlan_mac_obj vlan_obj;

   /* Private VLAN object */
   struct ecore_vlan_mac_obj pvlan_obj;

};                              /* struct bxe_sp_objs */



#define QFLE3_STATS_SIZE (5 * 4096)

#define QFLE3_FLAGS_CSUM_OFFLOAD_ENABLED        (1 << 0)
#define QFLE3_FLAGS_TSO_ENABLED                 (1 << 1)
#define QFLE3_FLAGS_VXLAN_OFFLOAD_ENABLED       (1 << 2)
#define QFLE3_FLAGS_GENEVE_OFFLOAD_ENABLED      (1 << 3)

#define QFLE3_IS_VXLAN_OFFLOAD_ENABLED(adapter) (adapter->offloadflags & \
						 QFLE3_FLAGS_VXLAN_OFFLOAD_ENABLED)
#define QFLE3_IS_GENEVE_OFFLOAD_ENABLED(adapter) (adapter->offloadflags & \
						 QFLE3_FLAGS_GENEVE_OFFLOAD_ENABLED)
#define QFLE3_IS_ENCAP_OFFLOAD_ENABLED(adapter) (QFLE3_IS_VXLAN_OFFLOAD_ENABLED(adapter) || \
						 QFLE3_IS_GENEVE_OFFLOAD_ENABLED(adapter))
#define QFLE3_UPLINK_MTU_CHANGED			0x00000001
#define QFLE3_UPLINK_RINGSIZE_CHANGED		0x00000002
#define QFLE3_UPLINK_VLAN_CONFIG_CHANGED	0x00000004
typedef struct qfle3_cached_data {
   vmk_uint32     mtu;
   vmk_uint32     rx_ring_page_num;
   vmk_uint32     tx_ring_page_num;
   vmk_uint32     en_vlan;
} qfle3_cached_data;

#ifdef QFLE3_SRIOV

enum {
        PFVF_STATUS_WAITING = 0,
        PFVF_STATUS_SUCCESS,
        PFVF_STATUS_FAILURE,
        PFVF_STATUS_NOT_SUPPORTED,
        PFVF_STATUS_NO_RESOURCE
};

struct pf_vf_bulletin_content {
   vmk_uint32 crc;                        /* crc of structure to ensure is not in
                                         * mid-update
                                         */
   vmk_uint16 version;
   vmk_uint16 length;

   vmk_uint64 valid_bitmap;              /* bitmap indicating wich fields
                                         * hold valid values
                                         */

#define MAC_ADDR_VALID          0       /* alert the vf that a new mac address
                                         * is available for it
                                         */
#define VLAN_VALID              1       /* when set, the vf should no access the
                                         * vfpf channel
                                         */
#define CHANNEL_DOWN            2       /* vfpf channel is disabled. VFs are not
                                         * to attempt to send messages on the
                                         * channel after this bit is set
                                         */
#define LINK_VALID              3       /* alert the VF thet a new link status
                                         * update is available for it
                                         */
   vmk_uint8 mac[ETH_ALEN];
   vmk_uint8 mac_padding[2];
   vmk_uint16 vlan;
   vmk_uint8 vlan_padding[6];
   vmk_uint16 link_speed;                  /* Effective line speed */
   vmk_uint8 link_speed_padding[6];
   vmk_uint32 link_flags;                  /* VFPF_LINK_REPORT_XXX flags */
#define VFPF_LINK_REPORT_LINK_DOWN       (1 << 0)
#define VFPF_LINK_REPORT_FULL_DUPLEX     (1 << 1)
#define VFPF_LINK_REPORT_RX_FC_ON        (1 << 2)
#define VFPF_LINK_REPORT_TX_FC_ON        (1 << 3)
   vmk_uint8 link_flags_padding[4];
};



struct hw_sb_info {
   vmk_uint8 hw_sb_id;    /* aka absolute igu id, used to ack the sb */
   vmk_uint8 sb_qid;      /* used to update DHC for sb */
};

enum channel_tlvs {
   CHANNEL_TLV_NONE, /* ends tlv sequence */
   CHANNEL_TLV_ACQUIRE,
   CHANNEL_TLV_INIT,
   CHANNEL_TLV_SETUP_Q,
   CHANNEL_TLV_SET_Q_FILTERS,
   CHANNEL_TLV_ACTIVATE_Q,
   CHANNEL_TLV_DEACTIVATE_Q,
   CHANNEL_TLV_TEARDOWN_Q,
   CHANNEL_TLV_CLOSE,
   CHANNEL_TLV_RELEASE,
   CHANNEL_TLV_UPDATE_RSS_DEPRECATED,
   CHANNEL_TLV_PF_RELEASE_VF,
   CHANNEL_TLV_LIST_END,
   CHANNEL_TLV_FLR,
   CHANNEL_TLV_PF_SET_MAC,
   CHANNEL_TLV_PF_SET_VLAN,
   CHANNEL_TLV_UPDATE_RSS,
   CHANNEL_TLV_PHYS_PORT_ID,
   CHANNEL_TLV_UPDATE_TPA,
   CHANNEL_TLV_FP_HSI_SUPPORT,
   CHANNEL_TLV_MAX
};
#if 0
char *channel_tlvs_string[] = {
   "CHANNEL_TLV_NONE", /* ends tlv sequence */
   "CHANNEL_TLV_ACQUIRE",
   "CHANNEL_TLV_INIT",
   "CHANNEL_TLV_SETUP_Q",
   "CHANNEL_TLV_SET_Q_FILTERS",
   "CHANNEL_TLV_ACTIVATE_Q",
   "CHANNEL_TLV_DEACTIVATE_Q",
   "CHANNEL_TLV_TEARDOWN_Q",
   "CHANNEL_TLV_CLOSE",
   "CHANNEL_TLV_RELEASE",
   "CHANNEL_TLV_UPDATE_RSS_DEPRECATED",
   "CHANNEL_TLV_PF_RELEASE_VF",
   "CHANNEL_TLV_LIST_END",
   "CHANNEL_TLV_FLR",
   "CHANNEL_TLV_PF_SET_MAC",
   "CHANNEL_TLV_PF_SET_VLAN",
   "CHANNEL_TLV_UPDATE_RSS",
   "CHANNEL_TLV_PHYS_PORT_ID",
   "CHANNEL_TLV_UPDATE_TPA",
   "CHANNEL_TLV_FP_HSI_SUPPORT",
   "CHANNEL_TLV_MAX"
};

#endif
/* vf pf channel tlvs */
/* general tlv header (used for both vf->pf request and pf->vf response) */
struct channel_tlv {
   vmk_uint16 type;
   vmk_uint16 length;
};

/* header of first vf->pf tlv carries the offset used to calculate reponse
 * buffer address
 */
struct vfpf_first_tlv {
   struct channel_tlv tl;
   vmk_uint32 resp_msg_offset;
};

/* header of pf->vf tlvs, carries the status of handling the request */
struct pfvf_tlv {
   struct channel_tlv tl;
   vmk_uint8 status;
   vmk_uint8 padding[3];
};

/* response tlv used for most tlvs */
struct pfvf_general_resp_tlv {
   struct pfvf_tlv hdr;
};

/* acquire response tlv - carries the allocated resources */
struct pfvf_acquire_resp_tlv {
   struct pfvf_tlv hdr;
   struct pf_vf_pfdev_info {
      vmk_uint32 chip_num;
      vmk_uint32 pf_cap;
      #define PFVF_CAP_RSS          0x00000001
      #define PFVF_CAP_DHC          0x00000002
      #define PFVF_CAP_TPA          0x00000004
      #define PFVF_CAP_TPA_UPDATE   0x00000008
      #define PFVF_CAP_VLAN_FILTER  0x00000010

#ifndef QFLE3_UPSTREAM /* ! _UPSTREAM */
      /* bit set only by ESX hypervisor. This means that a VF *may* be
      * able to configure its own mac even if the hypervisor has
      * already set one for it. In linux this is never allowed, but
      * in ESX it may be allowed. Capabilities such as this which
      * don't exist in linux will consume bits from the bitmap from
      * starting from msb
      */
      #define PFVF_CAP_ALLOW_MAC  0x80000000
#endif

      char fw_ver[32];
      vmk_uint16 db_size;
      vmk_uint8  indices_per_sb;
      vmk_uint8  padding;
      } pfdev_info;
      struct pf_vf_resc {
         /* in case of status NO_RESOURCE in message hdr, pf will fill
         * this struct with suggested amount of resources for next
         * acquire request
         */
         #define PFVF_MAX_QUEUES_PER_VF         16
         #define PFVF_MAX_SBS_PER_VF            16
         struct hw_sb_info hw_sbs[PFVF_MAX_SBS_PER_VF];
         vmk_uint8      hw_qid[PFVF_MAX_QUEUES_PER_VF];
         vmk_uint8      num_rxqs;
         vmk_uint8      num_txqs;
         vmk_uint8      num_sbs;
         vmk_uint8      num_mac_filters;
         vmk_uint8      num_vlan_filters;
         vmk_uint8      num_mc_filters;
         vmk_uint8      permanent_mac_addr[ETH_ALEN];
         vmk_uint8      current_mac_addr[ETH_ALEN];
         vmk_uint16     pf_link_speed;
         vmk_uint32     pf_link_supported;
      } resc;
};

/* used to terminate and pad a tlv list */
struct channel_list_end_tlv {
   struct channel_tlv tl;
   vmk_uint8 padding[4];
};

struct tlv_buffer_size {
   vmk_uint8 tlv_buffer[TLV_BUFFER_SIZE];
};

union pfvf_tlvs {
        struct pfvf_general_resp_tlv    general_resp;
        struct pfvf_acquire_resp_tlv    acquire_resp;
        struct channel_list_end_tlv     list_end;
        struct tlv_buffer_size          tlv_buf_size;
};

struct vf_pf_resc_request {
   vmk_uint8  num_rxqs;
   vmk_uint8  num_txqs;
   vmk_uint8  num_sbs;
   vmk_uint8  num_mac_filters;
   vmk_uint8  num_vlan_filters;
   vmk_uint8  num_mc_filters; /* No limit  so superfluous */
};

/* Acquire */
struct vfpf_acquire_tlv {
   struct vfpf_first_tlv first_tlv;

   struct vf_pf_vfdev_info {
                /* the following fields are for debug purposes */
      vmk_uint8 vf_id;       /* ME register value */
      vmk_uint8 vf_os;       /* e.g. Linux, W2K8 */
#define VF_OS_SUBVERSION_MASK   (0x1f)
#define VF_OS_MASK              (0xe0)
#define VF_OS_SHIFT             (5)
#define VF_OS_UNDEFINED         (0 << VF_OS_SHIFT)
#define VF_OS_WINDOWS           (1 << VF_OS_SHIFT)

      vmk_uint8 fp_hsi_ver;
      vmk_uint8 caps;
#define VF_CAP_SUPPORT_EXT_BULLETIN     (1 << 0)
#define VF_CAP_SUPPORT_VLAN_FILTER      (1 << 1)
   } vfdev_info;

   struct vf_pf_resc_request resc_request;

   vmk_uint64 bulletin_addr;
};

/* simple operation request on queue */
struct vfpf_q_op_tlv {
   struct vfpf_first_tlv   first_tlv;
   vmk_uint8 vf_qid;
   vmk_uint8 padding[3];
};

/* receive side scaling tlv */
struct vfpf_rss_tlv {
   struct vfpf_first_tlv   first_tlv;
   vmk_uint32                     rss_flags;
#define VFPF_RSS_MODE_DISABLED  (1 << 0)
#define VFPF_RSS_MODE_REGULAR   (1 << 1)
#define VFPF_RSS_SET_SRCH       (1 << 2)
#define VFPF_RSS_IPV4           (1 << 3)
#define VFPF_RSS_IPV4_TCP       (1 << 4)
#define VFPF_RSS_IPV4_UDP       (1 << 5)
#define VFPF_RSS_IPV6           (1 << 6)
#define VFPF_RSS_IPV6_TCP       (1 << 7)
#define VFPF_RSS_IPV6_UDP       (1 << 8)
   vmk_uint8                      rss_result_mask;
   vmk_uint8                      ind_table_size;
   vmk_uint8                      rss_key_size;
   vmk_uint8                      padding;
   vmk_uint8                      ind_table[T_ETH_INDIRECTION_TABLE_SIZE];
   vmk_uint32                     rss_key[T_ETH_RSS_KEY]; /* hash values */
};


#define VFPF_INIT_FLG_STATS_COALESCE    (1 << 0) /* when set the VFs queues
                                                  * stats will be coalesced on
                                                  * the leading RSS queue
                                                  */
/* Init VF */
struct vfpf_init_tlv {
   struct vfpf_first_tlv first_tlv;
   vmk_uint64 sb_addr[PFVF_MAX_SBS_PER_VF]; /* vf_sb based */
   vmk_uint64 spq_addr;
   vmk_uint64 stats_addr;
   vmk_uint16 stats_stride;
   vmk_uint32 flags;
   vmk_uint32 padding [2];
};

/* Setup Queue */
struct vfpf_setup_q_tlv {
   struct vfpf_first_tlv first_tlv;

   struct vf_pf_rxq_params {
       /* physical addresses */
       vmk_uint64 rcq_addr;
       vmk_uint64 rcq_np_addr;
       vmk_uint64 rxq_addr;
       vmk_uint64 sge_addr;

      /* sb + hc info */
      vmk_uint8  vf_sb;              /* index in hw_sbs[] */
      vmk_uint8  sb_index;           /* Index in the SB */
      vmk_uint16 hc_rate;            /* desired interrupts per sec. */
                                     /* valid iff VFPF_QUEUE_FLG_HC */
      /* rx buffer info */
      vmk_uint16 mtu;
      vmk_uint16 buf_sz;
      vmk_uint16 flags;              /* VFPF_QUEUE_FLG_X flags */
      vmk_uint16 stat_id;            /* valid iff VFPF_QUEUE_FLG_STATS */

      /* valid iff VFPF_QUEUE_FLG_TPA */
      vmk_uint16 sge_buf_sz;
      vmk_uint16 tpa_agg_sz;
      vmk_uint8 max_sge_pkt;

      vmk_uint8 drop_flags;          /* VFPF_QUEUE_DROP_X, for Linux VMs
                                     * all the flags are turned off
                                     */

      vmk_uint8 cache_line_log;      /* VFPF_QUEUE_FLG_CACHE_ALIGN */
      vmk_uint8 padding;
   } rxq;

   struct vf_pf_txq_params {
      /* physical addresses */
      vmk_uint64 txq_addr;

      /* sb + hc info */
      vmk_uint8  vf_sb;              /* index in hw_sbs[] */
      vmk_uint8  sb_index;           /* Index in the SB */
      vmk_uint16 hc_rate;            /* desired interrupts per sec. */
                                     /* valid iff VFPF_QUEUE_FLG_HC */
      vmk_uint32 flags;              /* VFPF_QUEUE_FLG_X flags */
      vmk_uint16 stat_id;            /* valid iff VFPF_QUEUE_FLG_STATS */
      vmk_uint8  traffic_type;       /* see in setup_context() */
      vmk_uint8  padding;
   } txq;

   vmk_uint8 vf_qid;                      /* index in hw_qid[] */
   vmk_uint8 param_valid;
   #define VFPF_RXQ_VALID          0x01
   #define VFPF_TXQ_VALID          0x02
   vmk_uint8 padding[2];
};

/* Set Queue Filters */
struct vfpf_q_mac_vlan_filter {
   vmk_uint32 flags;
   #define VFPF_Q_FILTER_DEST_MAC_VALID    0x01
   #define VFPF_Q_FILTER_VLAN_TAG_VALID    0x02
   #define VFPF_Q_FILTER_SET               0x100   /* set/clear */
   vmk_uint8  mac[ETH_ALEN];
   vmk_uint16 vlan_tag;
};

#define _UP_ETH_ALEN    (6)

/* configure queue filters */
struct vfpf_set_q_filters_tlv {
   struct vfpf_first_tlv first_tlv;

   vmk_uint32 flags;
   #define VFPF_SET_Q_FILTERS_MAC_VLAN_CHANGED     0x01
   #define VFPF_SET_Q_FILTERS_MULTICAST_CHANGED    0x02
   #define VFPF_SET_Q_FILTERS_RX_MASK_CHANGED      0x04

   vmk_uint8 vf_qid;                      /* index in hw_qid[] */
   vmk_uint8 n_mac_vlan_filters;
   vmk_uint8 n_multicast;
   vmk_uint8 padding;

   #define PFVF_MAX_MAC_FILTERS                    16
   #define PFVF_MAX_VLAN_FILTERS                   16
   #define PFVF_MAX_FILTERS                        (PFVF_MAX_MAC_FILTERS +\
                                                    PFVF_MAX_VLAN_FILTERS)
   struct vfpf_q_mac_vlan_filter filters[PFVF_MAX_FILTERS];

   #define PFVF_MAX_MULTICAST_PER_VF               32
   vmk_uint8  multicast[PFVF_MAX_MULTICAST_PER_VF][_UP_ETH_ALEN];

   vmk_uint32 rx_mask;    /* see mask constants at the top of the file */
};

struct vfpf_tpa_tlv {
   struct vfpf_first_tlv   first_tlv;

   struct vf_pf_tpa_client_info {
      vmk_uint64 sge_addr[PFVF_MAX_QUEUES_PER_VF];
      vmk_uint8 update_ipv4;
      vmk_uint8 update_ipv6;
      vmk_uint8 max_tpa_queues;
      vmk_uint8 max_sges_for_packet;
      vmk_uint8 complete_on_both_clients;
      vmk_uint8 dont_verify_thr;
      vmk_uint8 tpa_mode;
      vmk_uint16 sge_buff_size;
      vmk_uint16 max_agg_size;
      vmk_uint16 sge_pause_thr_low;
      vmk_uint16 sge_pause_thr_high;
   } tpa_client_info;
};

/* close VF (disable VF) */
struct vfpf_close_tlv {
   struct vfpf_first_tlv   first_tlv;
   vmk_uint16              vf_id;  /* for debug */
   vmk_uint8 padding[2];
};

/* rlease the VF's acquired resources */
struct vfpf_release_tlv {
   struct vfpf_first_tlv   first_tlv;
   vmk_uint16              vf_id;  /* for debug */
   vmk_uint8 padding[2];
};

union vfpf_tlvs {
   struct vfpf_first_tlv           first_tlv;
   struct vfpf_acquire_tlv         acquire;
   struct vfpf_init_tlv            init;
   struct vfpf_close_tlv           close;
   struct vfpf_q_op_tlv            q_op;
   struct vfpf_setup_q_tlv         setup_q;
   struct vfpf_set_q_filters_tlv   set_q_filters;
   struct vfpf_release_tlv         release;
   struct vfpf_rss_tlv             update_rss;
   struct vfpf_tpa_tlv             update_tpa;
   struct channel_list_end_tlv     list_end;
   struct tlv_buffer_size          tlv_buf_size;
};

struct qfle3_vf_mbx_msg {
   union vfpf_tlvs req;
   union pfvf_tlvs resp;
};

struct qfle3_vf_mbx {
   struct qfle3_vf_mbx_msg *msg;
   vmk_IOA msg_mapping;

   /* VF GPA address */
   vmk_uint32 vf_addr_lo;
   vmk_uint32 vf_addr_hi;

   struct vfpf_first_tlv first_tlv;        /* saved VF request header */
};


/* bars */
struct qfle3_vf_bar {
   vmk_uint64 bar;
   vmk_uint32 size;
};


struct qfle3_vf_queue {
   struct eth_context              *cxt;

   /* MACs object */
   struct ecore_vlan_mac_obj       mac_obj;

   /* VLANs object */
   struct ecore_vlan_mac_obj       vlan_obj;

   /* VLAN-MACs object */
   struct ecore_vlan_mac_obj       vlan_mac_obj;

   unsigned long accept_flags;     /* last accept flags configured */

   /* Queue Slow-path State object */
   struct ecore_queue_sp_obj       sp_obj;

   vmk_uint32 cid;
   vmk_uint16 index;
   vmk_uint16 sb_idx;
   vmk_Bool is_leading;
   vmk_Bool sp_initialized;
};

/* VFOP definitions */
struct qfle3_vf_mac_vlan_filter {
   int type;
#define QFLE3_VF_FILTER_MAC     1 << 0
#define QFLE3_VF_FILTER_VLAN    1 << 1
#define QFLE3_VF_FILTER_VLAN_MAC \
        (QFLE3_VF_FILTER_MAC | QFLE3_VF_FILTER_VLAN) /*shortcut*/

   vmk_Bool add;
   vmk_uint8 *mac;
   vmk_uint16 vid;
};

struct qfle3_vf_mac_vlan_filters {
   int count;
   struct qfle3_vf_mac_vlan_filter filters[];
};


/* vf context */
struct qfle3_virtf {
   vmk_uint16 cfg_flags;
#define VF_CFG_STATS_COALESCE   0x1
#define VF_CFG_EXT_BULLETIN     0x2
#define VF_CFG_VLAN_FILTER      0x4
   vmk_uint8 link_cfg;            /* IFLA_VF_LINK_STATE_AUTO
                           * IFLA_VF_LINK_STATE_ENABLE
                           * IFLA_VF_LINK_STATE_DISABLE
                           */
   vmk_uint8 state;
#define VF_FREE         0       /* VF ready to be acquired holds no resc */
#define VF_ACQUIRED     1       /* VF acquired, but not initialized */
#define VF_ENABLED      2       /* VF Enabled */
#define VF_RESET        3       /* VF FLR'd, pending cleanup */

   vmk_Bool flr_clnup_stage;   /* true during flr cleanup */

   /* dma */
   vmk_IOA fw_stat_map;
   vmk_uint16 stats_stride;
   vmk_IOA bulletin_map;

   /* Allocated resources counters. Before the VF is acquired, the
   * counters hold the following values:
   *
   * - xxq_count = 0 as the queues memory is not allocated yet.
   *
   * - sb_count  = The number of status blocks configured for this VF in
   *               the IGU CAM. Initially read during probe.
   *
   * - xx_rules_count = The number of rules statically and equally
   *                    allocated for each VF, during PF load.
   */
   struct vf_pf_resc_request       alloc_resc;
#define vf_rxq_count(vf)                ((vf)->alloc_resc.num_rxqs)
#define vf_txq_count(vf)                ((vf)->alloc_resc.num_txqs)
#define vf_sb_count(vf)                 ((vf)->alloc_resc.num_sbs)
#define vf_mac_rules_cnt(vf)            ((vf)->alloc_resc.num_mac_filters)
#define vf_vlan_rules_cnt(vf)           ((vf)->alloc_resc.num_vlan_filters)
#define vf_mc_rules_cnt(vf)             ((vf)->alloc_resc.num_mc_filters)

   vmk_uint8 sb_count;            /* actual number of SBs */
   vmk_uint8 igu_base_id;         /* base igu status block id */

   struct qfle3_vf_queue   *vfqs;
#define LEADING_IDX                     0
#define qfle3_vfq_is_leading(vfq)       ((vfq)->index == LEADING_IDX)
#define qfle3_vfq(vf, nr, var)          ((vf)->vfqs[(nr)].var)
#define qfle3_leading_vfq(vf, var)      ((vf)->vfqs[LEADING_IDX].var)

   vmk_uint8 index;       /* index in the vf array */
   vmk_uint8 abs_vfid;
   vmk_uint8 sp_cl_id;
   vmk_uint32 error;      /* 0 means all's-well */
   vmk_uint16 pvid;

   /* BDF */
   unsigned int bus;
   unsigned int devfn;

   /* bars */
   struct qfle3_vf_bar bars[PCI_SRIOV_NUM_BARS];

   /* set-mac ramrod state 1-pending, 0-done */
   unsigned long   filter_state;

   /* leading rss client id ~~ the client id of the first rxq, must be
   * set for each txq.*/
   int leading_rss;

   /* MCAST object */
   int mcast_list_len;
   struct ecore_mcast_obj          mcast_obj;

   /* RSS configuration object */
   struct ecore_rss_config_obj     rss_conf_obj;

   /* slow-path operations */
   vmk_Semaphore                    op_mutex; /* one vfop at a time mutex */
   enum channel_tlvs                op_current;

   vmk_uint8 fp_hsi;

   struct ecore_credit_pool_obj    vf_vlans_pool;
   struct ecore_credit_pool_obj    vf_macs_pool;
   vmk_PCIDeviceAddr       vf_sbdf;
};


struct qfle3_sriov {
   vmk_uint32 first_vf_in_pf;

   /* standard SRIOV capability fields, mostly for debugging */
   int pos;                       /* capability position */
   int nres;                      /* number of resources */
   vmk_uint32 cap;                /* SR-IOV Capabilities */
   vmk_uint32 ctrl;               /* SR-IOV Control */
   vmk_uint32 total;              /* total VFs associated with the PF */
   vmk_uint32 initial;            /* initial VFs associated with the PF */
   vmk_uint16 nr_virtfn;          /* number of VFs available */
   vmk_uint32 offset;             /* first VF Routing ID offset */
   vmk_uint32 stride;             /* following VF stride */
   vmk_uint32 pgsz;               /* page size for BAR alignment */
   vmk_uint32 link;                /* Function Dependency Link */
};

struct qfle3_vf_sp {
   union {
      struct eth_classify_rules_ramrod_data   e2;
   } mac_rdata;
   union {
      struct eth_classify_rules_ramrod_data   e2;
   } vlan_rdata;
   union {
      struct eth_classify_rules_ramrod_data   e2;
   } vlan_mac_rdata;
   union {
      struct eth_filter_rules_ramrod_data     e2;
   } rx_mode_rdata;
   union {
      struct eth_multicast_rules_ramrod_data  e2;
   } mcast_rdata;
   union {
      struct client_init_ramrod_data  init_data;
      struct client_update_ramrod_data update_data;
   } q_data;
   union {
      struct eth_rss_update_ramrod_data e2;
   } rss_rdata;
};


struct hw_dma {
   void *addr;
   vmk_IOA mapping;
   vmk_ByteCount size;
};


struct qfle3_vfdb {
#define QFLE3_VFDB(adapter)             ((adapter)->vfdb)
   /* vf array */
   struct qfle3_virtf   *vfs;
#define QFLE3_VF(adapter, idx)          ((QFLE3_VFDB(adapter) && (adapter)->vfdb->vfs) ? \
                                        &((adapter)->vfdb->vfs[idx]) : NULL)
   /* queue array - for all vfs */
   struct qfle3_vf_queue   *vfqs;

   /* vf HW contexts */
   struct hw_dma   context[QFLE3_VF_CIDS/ILT_PAGE_CIDS];
#define QFLE3_VF_CXT_PAGE(adapter, i)   (&(adapter)->vfdb->context[i])
#define QFLE3_VF_BULLETIN_DMA(adapter)  (&((adapter)->vfdb->bulletin_dma))
#define QFLE3_VF_BULLETIN(adapter, vf) \
        (((struct pf_vf_bulletin_content *)(QFLE3_VF_BULLETIN_DMA(adapter)->addr)) \
         + (vf))

   /* SR-IOV information */
   struct qfle3_sriov   sriov;

   struct hw_dma        mbx_dma;
#define QFLE3_VF_MBX_DMA(adapter)       (&((adapter)->vfdb->mbx_dma))
   struct qfle3_vf_mbx     mbxs[QFLE3_MAX_NUM_OF_VFS];
#define QFLE3_VF_MBX(adapter, vfid)     (&((adapter)->vfdb->mbxs[vfid]))
   struct hw_dma           bulletin_dma;

   struct hw_dma           sp_dma;
#define qfle3_vf_sp(adapter, vf, field) ((adapter)->vfdb->sp_dma.addr +           \
                (vf)->index * sizeof(struct qfle3_vf_sp) +                        \
                vmk_offsetof(struct qfle3_vf_sp, field))
#define qfle3_vf_sp_map(adapter, vf, field) ((adapter)->vfdb->sp_dma.mapping +    \
                (vf)->index * sizeof(struct qfle3_vf_sp) +                        \
                vmk_offsetof(struct qfle3_vf_sp, field))

   vmk_uint32 flrd_vfs[FLRD_VFS_DWORDS];

   /* the number of msix vectors belonging to this PF designated for VFs */

   vmk_uint16 vf_sbs_pool;
   vmk_uint16 first_vf_igu_entry;

   /* sp_rtnl synchronization */
   vmk_Semaphore                   event_mutex;
   vmk_uint64                      event_occur;

   /* bulletin board update synchronization */
   vmk_Semaphore                    bulletin_mutex;


};

enum qfle3_iov_flag {
   QFLE3_IOV_HANDLE_VF_MSG,
   QFLE3_IOV_HANDLE_FLR,
};

struct vfpf_port_phys_id_resp_tlv {
   struct channel_tlv tl;
   vmk_uint8 id[ETH_ALEN];
   vmk_uint8 padding[2];
};

struct vfpf_fp_hsi_resp_tlv {
   struct channel_tlv tl;
   vmk_uint8 is_supported;
   vmk_uint8 padding[3];
};

enum {
        IFLA_VF_LINK_STATE_AUTO,
        IFLA_VF_LINK_STATE_DISABLE,
        IFLA_VF_LINK_STATE_ENABLE
};


/* struct qfle3_vf_queue_construct_params - prepare queue construction
 * parameters: q-init, q-setup and SB index
 */
struct qfle3_vf_queue_construct_params {
   struct ecore_queue_state_params      qstate;
   struct ecore_queue_setup_params      prep_qsetup;
};

/* CORE VF API */
typedef vmk_uint8 qfle3_mac_addr_t[ETH_ALEN];

int qfle3_iov_link_update_vf(struct qfle3_adapter *adapter, int idx);
void qfle3_iov_init_dq(struct qfle3_adapter *adapter);
void qfle3_iov_free_mem(struct qfle3_adapter *adapter);
int qfle3_iov_alloc_mem(struct qfle3_adapter *adapter);
int qfle3_vf_idx_by_abs_fid(struct qfle3_adapter *adapter, vmk_uint16 abs_vfid);
int qfle3_iov_eq_sp_event(struct qfle3_adapter *adapter, union event_ring_elem *elem);
void qfle3_schedule_iov_task(struct qfle3_adapter *adapter, enum qfle3_iov_flag flag);
void qfle3_iov_set_queue_sp_obj(struct qfle3_adapter *adapter, int vf_cid,struct ecore_queue_sp_obj **q_obj);
VMK_ReturnStatus qfle3_vf_unregister(vmk_PCIDevice vf);
VMK_ReturnStatus qfle3_passthru_ops(vmk_AddrCookie data, vmk_NetPTOP op, void *pargs);
void qfle3_iov_adjust_stats_req(struct qfle3_adapter *adapter);
int qfle3_iov_init_ilt(struct qfle3_adapter *adapter, vmk_uint16 line);

/* queue access */
static inline struct qfle3_vf_queue *vfq_get(struct qfle3_virtf *vf, vmk_uint8 index)
{
        return &(vf->vfqs[index]);
}
static inline vmk_uint8 vf_igu_sb(struct qfle3_virtf *vf, vmk_uint16 sb_idx)
{
        return vf->igu_base_id + sb_idx;
}

static inline vmk_uint8 vf_hc_qzone(struct qfle3_virtf *vf, vmk_uint16 sb_idx)
{
        return vf_igu_sb(vf, sb_idx);
}
static inline vmk_uint8 vfq_cl_id(struct qfle3_virtf *vf, struct qfle3_vf_queue *q)
{
        return vf->igu_base_id + q->index;
}

static inline vmk_uint8 vfq_qzone_id(struct qfle3_virtf *vf, struct qfle3_vf_queue *q)
{
   return vfq_cl_id(vf, q);
}

static inline vmk_uint8 vfq_stat_id(struct qfle3_virtf *vf, struct qfle3_vf_queue *q)
{
        if (vf->cfg_flags & VF_CFG_STATS_COALESCE)
                return vf->leading_rss;
        else
                return vfq_cl_id(vf, q);
}

#define QFLE3_ESX_SET_PASSTHRU_RC_STATE(adapter, vf_idx, rc, state)   \
   (adapter)->esx_vf[(vf_idx)].passthru_rc = (rc);      \
   (adapter)->esx_vf[(vf_idx)].passthru_state = (state);

struct qfle3_esx_vf {
   int                     passthru_rc;
   int                     passthru_state;
#define QFLE3_ESX_PASSTHRU_SET_MAC_MSG_FROM_VF  0x0001
#define QFLE3_ESX_PASSTHRU_SET_MAC_COMPLETE_OP  0x0002
#define QFLE3_ESX_PASSTHRU_SET_MTU_MSG_FROM_VF  0x0004
#define QFLE3_ESX_PASSTHRU_SET_MTU_COMPLETE_OP  0x0008
#define QFLE3_DEFAULT_VF_PASSTHRU_WAIT_EVENT_TIMEOUT    (500)
   int                     flags;
#define QFLE3_ESX_PASSTHRU_ALLOW_MTU            0x0001
#define QFLE3_ESX_PASSTHRU_VF_IN_USE            0x0002
   vmk_uint16              old_mtu;
#define QFLE3_ESX_PASSTHRU_MTU_UNINITIALIZED    0xFFFF
   int                     forced_mtu;
   int                     mtu_from_config;
   vmk_uint8               mac_from_config[ETH_ALEN];
   vmk_uint8               last_mac[ETH_ALEN];
#define QFLE3_ESX_VF_FW_TOTAL_STATS_SIZE        (QFLE3_VF_MAX_QUEUES * \
                                                 QFLE3_ESX_VF_FW_STATS_SIZE)
#define QFLE3_ESX_VF_FW_STATS_SIZE              (QFLE3_PAGE_ALIGN(sizeof(struct per_queue_stats)))
   void                    *vf_fw_stats;
   ecore_dma_addr_t        vf_fw_stats_mapping;
   void                    *old_vf_fw_stats; /* stored in CPU order */
   vmk_uint64 allowed_gvlans[64];
   vmk_uint64 requested_gvlans[64];
   vmk_uint8  any_vlan_req;
};

#define qfle3_fp(adapter, nr, var)   ((adapter)->fp[(nr)].var)
 
#endif  //QFLE3_SRIOV

#define QFLE3_VLAN_LIST_SIZE   256 /* As per Huawei VLAN mode Specification */
#define QFLE3_VLAN_MODE_NORMAL 0
#define QFLE3_VLAN_MODE_FILTER 1
#define QFLE3_VLAN_MODE_QINQ   2

struct qfle3_vlan_mode_info {
    vmk_uint16 pvid;
    vmk_uint8 pcp;
    vmk_Bool pvid_hw; /* Is PVID configured in hardware. */
    vmk_uint8 vlan_mode;
};

typedef struct qfle3_adapter {

   /*
    * PCI specific
    */
   vmk_PCIDevice pdev;
   vmk_PCIDeviceID pdev_id;
   vmk_PCIDeviceAddr pdev_addr;
   vmk_Name pdev_name;

   const struct iro *iro_arr;
   struct qfle3_hw_info hw_info;
   vmk_uint64 flags;
   vmk_uint32 offloadflags;

   vmk_uint8 *reg_base;
   vmk_uint8 *db_base;
   vmk_uint16 db_size;

   struct ecore_ilt *ilt;
   struct qfle3_port port;
   struct cmng_init    cmng;
   vmk_Bool hw_int_disabled;

   vmk_uint32 pf_id;
   vmk_uint32 pf_num;
   vmk_uint32 db_stride;

   vmk_uint8 igu_sb_cnt;
   vmk_uint32 base_fw_ndsb;
   vmk_uint8 igu_base_sb;
   vmk_uint32 qm_cid_count;

   vmk_uint32 fw_seq;
   vmk_uint32 func_stx;
   vmk_Semaphore mfw_cmd_mutex;
   vmk_Semaphore drv_info_mutex;
   vmk_Bool drv_info_mng_owner;
   vmk_uint32 mf_mode;

#define IS_MF(A)       (A->mf_mode != 0)
#define IS_MF_SI(A)        (A->mf_mode == MULTI_FUNCTION_SI)
#define ECORE_IS_MF_SI_MODE(A)        (A->mf_mode == MULTI_FUNCTION_SI)
#define IS_MF_SD(A)        (A->mf_mode == MULTI_FUNCTION_SD)
#define IS_MF_AFEX(A)      (A->mf_mode == MULTI_FUNCTION_AFEX)
   vmk_uint8  mf_sub_mode;
#define IS_MF_UFP(A)       (IS_MF_SD(A) && \
                 A->mf_sub_mode == SUB_MF_MODE_UFP)
#define IS_MF_BD(A)        (IS_MF_SD(A) && \
                 A->mf_sub_mode == SUB_MF_MODE_BD)
   vmk_uint16 mf_ov;


   /*
    * default status block
    */
   vmk_uint32 intr_sts;
//   struct host_sp_status_block *def_sb;

   /*
    * event queue
    */
   union event_ring_elem *eq;

   /*
    * Slowpat Data
    */
   struct qfle3_slowpath *sp;
   vmk_IOA sp_mapping;
   unsigned long sp_state;

   /*
    * FW data
    */
   vmk_uint32 init_mode_flags;
   /*
    * Link data
    */
   struct elink_params link_params;
   struct elink_vars link_vars;
   vmk_uint32 link_cnt;
   struct qfle3_link_report_data last_reported_link;
   vmk_uint8 phy_initialized;


   /*
    * global driver attribute
    */
#define QFLE3_MAX_MTU	9000
#define QFLE3_MIN_MTU	60
#define QFLE3_FCOE_MINI_JUMBO_MTU	2500

   vmk_uint32 mtu;
   vmk_uint32 tx_ring_size;
   vmk_Bool lro_enable;
   vmk_uint8	wol;
   vmk_uint32 pm_cap;
   enum qfle3_recovery_state recovery_state;  // TODO: remove
#define QFLE3_CXT_PARITY_TRIGGER 1
#define QFLE3_CXT_TXTO_TRIGGER 2
#define QFLE3_CXT_STSTO_TRIGGER 3
   
#define QFLE3_ERR_NONE	      0x0  /* No error detected by driver. */
#define QFLE3_ERR_TXQ_STUCK	0x1  /* Tx queue stuck detected by driver. */
#define QFLE3_ERR_NETDEV_TO	0x2  /* Netdev triggered Tx timeout. */
#define QFLE3_ERR_PARITY		0x4  /* Parity error detected. */
#define QFLE3_ERR_STATS_TO	   0x8  /* Statistics timeout detected. */
#define QFLE3_ERR_MC_ASSERT	0x10 /* MC assert attention received. */
#define QFLE3_ERR_PANIC		   0x20 /* Driver asserted. */
#define QFLE3_ERR_MCP_ASSERT	0x40 /* MCP assert attention received. */
#define QFLE3_ERR_PEER_RESET	0x80 /* Peer PF triggered reset. */
   vmk_uint32 trigger_error;
#define QFLE3_TRIGGER_ASSERT	0x01 /* trigger MC assert for testing */
#define QFLE3_TRIGGER_FATAL_HW_ERROR	0x02 /* trigger FATAL HW ERROR for testing */
   vmk_uint32 error_status;
   vmk_int32 tx_to_delay;
   vmk_BitVector *sp_rtnl_state;
   vmk_BitVector *recovery_status;
   vmk_Helper recovery_helper;
   vmk_uint32 recovery_count;
   vmk_TimeVal trans_start;
   vmk_Bool is_leader;   
   vmk_TimerCycles last_recovery_start;
   

   vmk_uint32 tx_bd_num_pages;
   vmk_uint32 rx_bd_num_pages;
   /*
    * Queue specific
    */
   qfle3_drv_stats_t drv_stats;
   qfle3_drv_stats_priv_t drv_stats_priv;

   vmk_uint32 total_filters;
   vmk_uint32 filters_per_netq;
   vmk_uint32 max_num_rss;

   vmk_uint8 pfunc_rel;         /* function relative */
   vmk_uint8 pfunc_abs;         /* function absolute */
   vmk_uint8 path_id;           /* function absolute */
#define SC_PATH(sc)     (sc->path_id)
#define SC_PORT(sc)     (sc->pfunc_rel & 1)
#define SC_FUNC(sc)     (sc->pfunc_rel)
#define SC_ABS_FUNC(sc) (sc->pfunc_abs)
#define SC_VN(sc)       (sc->pfunc_rel >> 1)
#define SC_L_ID(sc)     (SC_VN(sc) << 2)
#define PORT_ID(sc)     SC_PORT(sc)
#define PATH_ID(sc)     SC_PATH(sc)
#define VNIC_ID(sc)     SC_VN(sc)
#define FUNC_ID(sc)     SC_FUNC(sc)
#define ABS_FUNC_ID(sc) SC_ABS_FUNC(sc)
#define SC_FW_MB_IDX_VN(sc, vn)                                 \
   (SC_PORT(sc) + (vn) *                                        \
    ((CHIP_IS_E1x(sc) || (CHIP_MODE_IS_4_PORT(sc))) ? 2 : 1))
#define SC_FW_MB_IDX(sc) SC_FW_MB_IDX_VN(sc, SC_VN(sc))


   vmk_uint8 dmae_ready;
   vmk_Lock dmae_lock;

#define MULTI_MASK                      0x7f
#define MAX_RSS_P_SIZE          4
   vmk_uint32 defq_rss_idx_tbl[MAX_RSS_P_SIZE];
   vmk_uint8  defq_rss_raw_ind_tbl[T_ETH_INDIRECTION_TABLE_SIZE];
   vmk_uint32 defq_rss_key_tbl[T_ETH_RSS_KEY];

   vmk_uint32 num_rxqs_vmk;
   vmk_uint32 num_rxqs_drv;
   vmk_uint32 num_rssqs_nd;
   vmk_uint32 num_rssqs_def;
   vmk_uint32 num_txqs_vmk;
   vmk_uint32 num_txqs_drv;

   vmk_uint32 num_cnicqs;
   
   vmk_uint32 rx_mode;

   vmk_Bool fwdmp_enable;
   vmk_uint32 fwdmp_flags;
   void *fwdmp_buf;
	vmk_Bool		force_link_down;
   vmk_DMAEngine dmaEngine;
   vmk_DMAEngine dmaEngineCoherent;
   vmk_DMAEngine dmaEngine_rxbuf;

   /*
    * Uplink specific
    */
   vmk_Name uplinkName;
   vmk_Uplink uplink;
   vmk_Device uplinkDevice;
   vmk_UplinkRegData uplinkRegData;
   vmk_UplinkSharedData uplinkSharedData;
   qfle3_cached_data uplinkCachedData; // values cached from kernel commands to be applied at an approriet time
   vmk_uint32 uplinkCachedNewData;

   vmk_Lock uplinkSharedDataLock;       /* spin lock to synchronize writers */
   vmk_UplinkSupportedMode supportedModes[10];
#if (VMKAPI_REVISION >= VMK_API_2_4_0_0)
   vmk_UplinkAdvertisedMode advModes[10];
#endif
   vmk_uint32 supportedModesArraySz;
   vmk_Bool linkUp;
   vmk_uint32 linkSpeed;
   vmk_EthAddress hwMacAddr;

   /*
    * CNIC specific
    */
   vmk_uint8   sw_fcoe;
   vmk_uint8   cnic_support;
//   vmk_Bool    cnic_enabled;
   vmk_Bool    cnic_loaded;
   vmk_Semaphore cnic_mutex;
   
   vmk_EthAddress fip_mac;
   vmk_EthAddress iscsi_mac;
   void           *t2;
   vmk_IOA        t2_mapping;
#ifdef QFLE3_CNIC
   vmk_Bool        fcoe_init;
   vmk_Bool        ooo_init;
   struct ecore_vlan_mac_obj   iscsi_l2_mac_obj;
   vmk_Device  cnicDevice;
   union qfle3_host_hc_status_block cnic_sb;  // cnic status block
	vmk_IOA			cnic_sb_mapping;
   struct cnic_eth_dev *cnicEthDev;
   void *cnic_data;              // pointer to CNIC driver datastructure
   struct eth_spe *cnic_kwq;
   struct eth_spe *cnic_kwq_prod;
   struct eth_spe *cnic_kwq_cons;
   struct eth_spe *cnic_kwq_last;
   vmk_uint16  cnic_kwq_pending;
   vmk_uint16  cnic_spq_pending;
   struct nicOps nicOps;
   struct cnicOps *cnicOps;
   int  (*cnicIRQHandler) (void *data, void *status_blk);
#endif

   /*
    * Debug specific
    */

   vmk_uint32 debug_mask;

   /*
    * Per instance specific
    */
   vmk_Helper qfle3Helper;
   vmk_BitVector *state;
   vmk_ListLinks adapterLink;
   vmk_Device device;

   /*
    * periodic watch dog timer
    */
//#define PERIODIC_STOP 0
//#define PERIODIC_GO   1
//   vmk_atomic64 periodic_flags;
//   vmk_TimerQueue periodic_callout;
   vmk_Timer periodic_timer;

   vmk_uint8 igu_dsb_id;
   vmk_uint8 min_msix_vec_cnt;

   vmk_uint32 igu_base_addr;
   vmk_IOA def_status_blk_mapping;

   struct qfle3_mf_info mf_info;
   vmk_uint32  mf_ext_config;

   struct qfle3_fw_init_data fw_init_data;
   struct ecore_credit_pool_obj            vlans_pool;

   struct ecore_credit_pool_obj            macs_pool;

   /* RX_MODE object */
   struct ecore_rx_mode_obj                rx_mode_obj;

   /* MCAST object */
   struct ecore_mcast_obj                  mcast_obj;

   /* RSS configuration object */
   struct ecore_rss_config_obj             defq_rss_conf_obj;
   struct ecore_func_sp_obj func_obj;
   struct hw_context context[ILT_MAX_L2_LINES];
   vmk_uint8 path_has_ovlan;
   vmk_ListLinks vlan_reg;
   vmk_uint16 vlan_cnt;
   vmk_uint16 vlan_credit;
   vmk_uint8 accept_any_vlan;
   vmk_uint8 hw_vlan_en;
   vmk_int32 mrrs;
   vmk_uint8 panic;
   void *gz_buf;
   vmk_IOA gz_dma_addr;
   struct host_sp_status_block *def_status_blk;
#define DEF_SB_IGU_ID           16
#define DEF_SB_ID           HC_SP_SB_ID
   __le16 def_idx;
   __le16 def_att_idx;
   vmk_uint32 attn_state;
   struct attn_route attn_group[MAX_DYNAMIC_ATTN_GRPS];
   /*
    * slow path ring
    */
   struct eth_spe *spq;
   vmk_IOA spq_mapping;
   vmk_uint16 spq_prod_idx;
   struct eth_spe *spq_prod_bd;
   struct eth_spe *spq_last_bd;
   __le16 *dsb_sp_prod;
   vmk_atomic64 cq_spq_left;    /* ETH_XXX ramrods credit */
   /*
    * used to synchronize spq accesses
    */
   vmk_Lock spq_lock;
   /*
    * event queue
    */
   union event_ring_elem *eq_ring;
   vmk_IOA eq_mapping;
   vmk_uint16 eq_prod;
   vmk_uint16 eq_cons;
   __le16 *eq_cons_sb;
   vmk_atomic64                                     eq_spq_left;    /* COMMON_XXX ramrods credit */

   vmk_Helper periodic_task;
   vmk_Helper sp_helper;

   /* stats related data structure */
   /* total number of FW statistics requests */
   vmk_uint8 fw_stats_num;
   /* the virtual adderss of fw stats including request and data */
   void *fw_stats;
   /* the DMA address of fw stats inlcude request and data */
   vmk_IOA fw_stats_mapping;
   /*
    * This is a memory buffer that will contain both statistics ramrod
    * request and data.
    */

   /* we can work as other ramrod request and data. So delete this struct in qfle3*/
   //  struct bxe_dma fw_stats_dma;

   /*
    * FW statistics request shortcut (points at the beginning of fw_stats
    * buffer).
    */
   vmk_int32                  fw_stats_req_size;
   struct qfle3_fw_stats_req *fw_stats_req;
   vmk_IOA              fw_stats_req_mapping;
   /*
    * FW statistics data shortcut (points at the beginning of fw_stats
    * buffer + fw_stats_req_size).
    */
   vmk_int32                  fw_stats_data_size;
   struct qfle3_fw_stats_data *fw_stats_data;
   vmk_IOA               fw_stats_data_mapping;

   /* tracking a pending STAT_QUERY ramrod */
   vmk_uint16 stats_pending;
   /* number of completed statistics ramrods */
   vmk_uint16 stats_comp;
   vmk_uint16 stats_counter;
   vmk_uint8  stats_init;
   int      stats_state;
   vmk_Lock stats_lock;
#define QFLE3_STATS_LOCK(adapter)   vmk_SpinlockLock(adapter->stats_lock)
#define QFLE3_STATS_UNLOCK(adapter) vmk_SpinlockUnlock(adapter->stats_lock)

   struct qfle3_eth_stats         eth_stats;
   struct host_func_stats         func_stats;
   struct qfle3_eth_stats_old     eth_stats_old;
   struct qfle3_net_stats_old     net_stats_old;
   struct qfle3_fw_port_stats_old fw_stats_old;

   struct dmae_command stats_dmae; /* used by dmae command loader */
   int                 executer_idx;
   /* end stats related data structure */

   int                                     afex_def_vlan_tag;
   enum mf_cfg_afex_vlan_mode              afex_vlan_mode;
   vmk_uint32                              pending_max;

   vmk_uint32		rx_ring_size;

   vmk_uint8		dropless_fc;

   vmk_uint16                     tx_quick_cons_trip_int;
   vmk_uint16                     tx_quick_cons_trip;
   vmk_uint16                     tx_ticks_int;
   vmk_uint16                     tx_ticks;

   vmk_uint16                     rx_quick_cons_trip_int;
   vmk_uint16                     rx_quick_cons_trip;
   vmk_uint16                     rx_ticks_int;
   vmk_uint16                     rx_ticks;
#define QFLE3_MAX_COALESCE_TOUT		(0xff*QFLE3_BTR)

   /* state machine */

   vmk_Lock	   sm_lock;       /* spin lock to synchronize access to state machine states */
   vmk_Lock	   q_lock;        /* spin lock to synchronize access to queues */
   vmk_uint16  sm_state;			/* adapter state */
   vmk_uint16  prev_state;			/* previous adapter state */
   vmk_uint16  last_cmd;			/* the last cmd that was issued to the statemachine */
   vmk_uint16  cmd_status;			/* the current status of last cmd */
   vmk_uint32  load_code;

   vmk_uint16 def_wd_to;
   qfle3_intr intr;
#ifdef QFLE3_SRIOV
   vmk_uint32        mf_config[E1HVN_MAX];
   char              fw_ver[32];
   vmk_uint16        num_vf_req;
   vmk_uint16        num_vf_actual;
   int               sriov_pos;
   struct qfle3_vfdb *vfdb;
   vmk_AddrCookie    vf_cb;
   vmk_Lock          sriov_bc_lock;
   vmk_WorldID       bc_service_worldid;
   vmk_BitVector     *iov_task_state;
   vmk_uint8         flush_req;
   struct qfle3_esx_vf     *esx_vf;
   vmk_EthAddress    phys_port_id;
   vmk_Helper        stats_collection_helper;
#endif //QFLE3_SRIOV
   vmk_uint8 reboot_in_progress;
   vmk_uint8 vxlan_filters_en;
   vmk_uint32 lb_rcvd;
   vmk_PktHandle *lb_pkt;
   vmk_uint16 geneve_udp_dst_port;
   struct qfle3_dcbx_sb dcbx_sb;
   vmk_uint8 fwdmp_disabled;
   vmk_uint8  max_cos;
   struct qfle3_fastpath fp[QFLE3_DEVICE_MAX_QUEUES];
   struct bxe_sp_objs sp_objs[QFLE3_DEVICE_MAX_QUEUES];  //Not yet initialized
   struct qfle3_fp_txdata qfle3_txq[QFLE3_DEVICE_MAX_QUEUES * QFLE3_MULTI_TX_COS];
   vmk_UplinkSharedQueueInfo uplinkQueueInfo;
   vmk_UplinkSharedQueueData uplinkQueueData[QFLE3_DEVICE_MAX_QUEUES];
#if (ESX_DDK_VERSION >= 2017)
   struct ecore_rss_config_obj             netq_rss_conf_obj[QFLE3_DEVICE_MAX_RSS_ENGINE+1];
   vmk_uint32 netq_rss_idx_tbl[QFLE3_DEVICE_MAX_RSS_ENGINE+1][MAX_RSS_P_SIZE];
   vmk_uint8  netq_rss_raw_ind_tbl[QFLE3_DEVICE_MAX_RSS_ENGINE+1][T_ETH_INDIRECTION_TABLE_SIZE];
   vmk_uint32 netq_rss_key_tbl[QFLE3_DEVICE_MAX_RSS_ENGINE+1][T_ETH_RSS_KEY];

   vmk_uint32 num_rss_engines;
   vmk_uint32 rss_engine[QFLE3_MAX_RSS_ENGINE_IDS-1];
#else
   struct ecore_rss_config_obj             netq_rss_conf_obj;
   vmk_uint32 netq_rss_idx_tbl[MAX_RSS_P_SIZE];
   vmk_uint8  netq_rss_raw_ind_tbl[T_ETH_INDIRECTION_TABLE_SIZE];
   vmk_uint32 netq_rss_key_tbl[T_ETH_RSS_KEY];
   vmk_uint32 reserved[88768];
#endif
/* VLAN mode related information */
   struct qfle3_vlan_mode_info vlan_mode_info;
#define IS_VLAN_FILTER(bp) \
       ((bp)->vlan_mode_info.vlan_mode == QFLE3_VLAN_MODE_FILTER)
#define IS_VLAN_QINQ(bp) \
       ((bp)->vlan_mode_info.vlan_mode == QFLE3_VLAN_MODE_QINQ)
#define IS_VLAN_NORMAL(bp) \
       ((bp)->vlan_mode_info.vlan_mode == QFLE3_VLAN_MODE_NORMAL)
#define QFLE3_PVID(bp)         ((bp)->vlan_mode_info.pvid)
   vmk_uint32 reserved_qnq[10];
} VMK_ATTRIBUTE_L1_ALIGNED qfle3_adapter;

/* Firmware dump related */

#define NIC_NAME_SIZE 32

struct dmp_config {
   vmk_uint32     mode;
   vmk_uint32     wregs_count;
   const struct wreg_addr *pwreg_addrs;
   vmk_uint32     regs_timer_count;
   const vmk_uint32 *regs_timer_status_addrs;
   const vmk_uint32 *regs_timer_scan_addrs;
   vmk_uint32     page_mode_values_count;
   const vmk_uint32 *page_vals;
   vmk_uint32     page_write_regs_count;
   const vmk_uint32 *page_write_regs;
   vmk_uint32     page_read_regs_count;
   const struct reg_addr *page_read_regs;
};

struct fw_dmp_hdr {
   vmk_uint32     ver;
   vmk_uint32     len;
   char    name[NIC_NAME_SIZE];
   void    *adapter;
   vmk_uint32     chip_id;
   vmk_uint32     dmp_size;  /*actual firmware/chip dump size */
   vmk_uint32     flags;
#define FWDMP_FLAGS_SPACE_NEEDED  0x00000001
#define FWDMP_FLAGS_LIVE_DUMP     0x00000002
#define FWDMP_FLAGS_RECOVERY_DUMP 0x00000008

   vmk_uint32     reserved;
}  __attribute__((packed));

#define RD_IND(adapter, offset)      esx_reg_rd_ind(adapter, offset)
#define WR_IND(adapter, offset, val) esx_reg_wr_ind(adapter, offset, val)

#define DEFAULT_WAIT_INTERVAL_MICSEC 30

#define QFLE3_FWDMP_MARKER_END   0x454E44

#define QFLE3_ESX_FW_DMP_VER 0x70038

#define DRV_DUMP_TRACE_BUFFER_SIZE               (0x800)
#define DRV_DUMP_VFC_DATA_SIZE                   (0x10000)
#define DRV_DUMP_IGU_DATA_SIZE                   (0x10000)
/* DRV_DUMP_TRACE_BUFFER_SIZE should be same as DBG_DMP_TRACE_BUFFER_SIZE in hw_dump.c*/
#define DRV_DUMP_PRELIMINARY_DATA_SIZE           DRV_DUMP_TRACE_BUFFER_SIZE

#define DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT    (0x2000)
#define DRV_DUMP_SPLIT_REGISTERS_SIZE_E1  DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT
#define DRV_DUMP_SPLIT_REGISTERS_SIZE_E1H DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT
#define DRV_DUMP_SPLIT_REGISTERS_SIZE_E2  DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT
#define DRV_DUMP_SPLIT_REGISTERS_SIZE_E3A0 DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT
#define DRV_DUMP_SPLIT_REGISTERS_SIZE_E3B0 DRV_DUMP_SPLIT_REGISTERS_SIZE_DEFUALT

#define DRV_DUMP_EXTRA_BLOCKS_SIZE         (DRV_DUMP_VFC_DATA_SIZE +    \
					    DRV_DUMP_IGU_DATA_SIZE)
#define DRV_DUMP_CRASH_DMP_BUF_SIZE_E1     (0xB0000 +                   \
					    DRV_DUMP_PRELIMINARY_DATA_SIZE + \
					    DRV_DUMP_EXTRA_BLOCKS_SIZE + \
					    DRV_DUMP_SPLIT_REGISTERS_SIZE_E1)
#define DRV_DUMP_CRASH_DMP_BUF_SIZE_E1H    (0xE0000 +                   \
					    DRV_DUMP_PRELIMINARY_DATA_SIZE + \
					    DRV_DUMP_EXTRA_BLOCKS_SIZE + \
					    DRV_DUMP_SPLIT_REGISTERS_SIZE_E1H)
#define DRV_DUMP_CRASH_DMP_BUF_SIZE_E2     (0x100000 +                  \
					    DRV_DUMP_PRELIMINARY_DATA_SIZE + \
					    DRV_DUMP_EXTRA_BLOCKS_SIZE + \
					    DRV_DUMP_SPLIT_REGISTERS_SIZE_E2)
#define DRV_DUMP_CRASH_DMP_BUF_SIZE_E3A0   (0x140000 +                  \
					    DRV_DUMP_PRELIMINARY_DATA_SIZE + \
					    DRV_DUMP_EXTRA_BLOCKS_SIZE + \
					    DRV_DUMP_SPLIT_REGISTERS_SIZE_E3A0)
#define DRV_DUMP_CRASH_DMP_BUF_SIZE_E3B0   (0x140000 +                  \
					    DRV_DUMP_PRELIMINARY_DATA_SIZE + \
					    DRV_DUMP_EXTRA_BLOCKS_SIZE + \
					    DRV_DUMP_SPLIT_REGISTERS_SIZE_E3B0)

struct chip_core_dmp {
   struct fw_dmp_hdr       fw_hdr;
   vmk_uint32                     fw_dmp_buf[(DRV_DUMP_CRASH_DMP_BUF_SIZE_E3B0 -
					      sizeof(struct fw_dmp_hdr))];
};


/* GRC dump Capability flags (Also - values for enable_live_grcdump) */
#define GRC_DMP_DISABLED        0x0000  /* GRC dump is disabled */
#define GRC_DMP_PARITY_ENABLED  0x0001  /* Enabled parity error GRC dump */
#define GRC_DMP_TXTO_ENABLED    0x0002  /* Trigger dump on Tx tiemout */
#define GRC_DMP_STSTO_ENABLED   0x0004  /* Trigger dump on Stats timeout. */

/* Hidden Capability flags. */
#define GRC_DMP_ERROR_ENABLED   0x0010  /* Trigger dump on error detection. */
#define GRC_DMP_FRESH_ENABLED   0x0020  /* Enabled ethtool dump */


/* GRC dump Action flags. */
#define GRC_DMP_COLLECT_TRIGGER 0x0100  /* Mark for Dump collection */
#define GRC_DMP_COLLECT_VALID   0x0200  /* GRC dump is already saved */
#define GRC_DMP_CLOSE_DEVICE    0x0400  /* Mark for device close. */
#define GRC_DMP_STOP_STATS      0x0800  /* Stop stats for engine. */

#define GRC_DMP_ANY_ENABLED  (GRC_DMP_PARITY_ENABLED |  \
               GRC_DMP_ERROR_ENABLED | \
               GRC_DMP_TXTO_ENABLED | \
			      GRC_DMP_STSTO_ENABLED)

/* Context of GRC dump trigger. */
#define QFLE3_CXT_PARITY_TRIGGER 1
#define QFLE3_CXT_TXTO_TRIGGER 2
#define QFLE3_CXT_STSTO_TRIGGER 3

/* 'offset' values for ethtool -E option for GRC dump. */
#define GRC_ETHTOOL_SAVED_OFFSET 1
#define GRC_ETHTOOL_FRESH_OFFSET 2


#define QFLE3_MF_SD_PROTOCOL(adapter) \
   ((adapter)->mf_config[QFLE3_VN(adapter)] & FUNC_MF_CFG_PROTOCOL_MASK)

#define QFLE3_IS_MF_SD_PROTOCOL_FCOE(adapter) \
   (QFLE3_MF_SD_PROTOCOL(adapter) == FUNC_MF_CFG_PROTOCOL_FCOE)


/*
 * Shared data READ/WRITE
 */
#define QFLE3_SHARED_DATA_READ_BEGIN(adapter)                   \
   do {                                                         \
   vmk_uint32 __ver;                                            \
   vmk_UplinkSharedData *sd = &(adapter)->uplinkSharedData;     \
   do {                                                         \
   __ver = vmk_VersionedAtomicBeginTryRead(&sd->lock)

#define QFLE3_SHARED_DATA_READ_END(adapter)                     \
   } while (!vmk_VersionedAtomicEndTryRead(&sd->lock, __ver));  \
   } while (0)

#define QFLE3_SHARED_DATA_WRITE_BEGIN(adapter)                          \
   do {                                                                 \
      vmk_SpinlockLock((adapter)->uplinkSharedDataLock);                \
   vmk_VersionedAtomicBeginWrite(&(adapter)->uplinkSharedData.lock);	\
   } while (0)

#define QFLE3_SHARED_DATA_WRITE_END(adapter)                            \
   do {                                                                 \
   vmk_VersionedAtomicEndWrite(&(adapter)->uplinkSharedData.lock);	\
      vmk_SpinlockUnlock((adapter)->uplinkSharedDataLock);              \
   } while (0)

#define QFLE3_SHARED_DATA_WRITE_LOCKED_BEGIN(adapter)                   \
   do {                                                                 \
      vmk_SpinlockLock((adapter)->uplinkSharedDataLock);                \
      vmk_VersionedAtomicBeginWrite(&(adapter)->uplinkSharedData.lock); \
   } while (0)

#define QFLE3_SHARED_DATA_WRITE_LOCKED_END(adapter)                     \
   do {                                                                 \
      vmk_VersionedAtomicEndWrite(&(adapter)->uplinkSharedData.lock);   \
      vmk_SpinlockUnlock((adapter)->uplinkSharedDataLock);              \
   } while (0)

#define QFLE3_RX_QUEUE_SHARED_DATA(adapter)  (&(adapter)->uplinkQueueData[0])
#define QFLE3_TX_QUEUE_SHARED_DATA(adapter)                             \
   (&(adapter)->uplinkQueueData[(adapter)->uplinkQueueInfo.maxRxQueues])
   
VMK_ReturnStatus qfle3_acquire_hw_lock(struct qfle3_adapter *adapter, vmk_uint32 resource);
VMK_ReturnStatus qfle3_release_hw_lock(struct qfle3_adapter * adapter, vmk_uint32 resource);

static inline void
qfle3_update_drv_flags(struct qfle3_adapter *adapter,
             vmk_uint32 flags, vmk_uint32 set)
{
   if (SHMEM2_HAS(adapter, drv_flags)) {
      vmk_uint32 drv_flags;
      qfle3_acquire_hw_lock(adapter, HW_LOCK_RESOURCE_DRV_FLAGS);
      drv_flags = SHMEM2_RD(adapter, drv_flags);

      if (set)
    SET_FLAGS(drv_flags, flags);
      else
    RESET_FLAGS(drv_flags, flags);

      SHMEM2_WR(adapter, drv_flags, drv_flags);
      qfle3_release_hw_lock(adapter, HW_LOCK_RESOURCE_DRV_FLAGS);
   }
}

/* returns func by VN for current port */
static inline int func_by_vn(struct qfle3_adapter *adapter, int vn)
{
    return 2 * vn + QFLE3_PORT(adapter);
}

/**
 * qfle3_link_sync_notify - send notification to other functions.
 *
 * @adapter:     driver handle
 *
 */
static inline void qfle3_link_sync_notify(struct qfle3_adapter *adapter)
{
    int func;
    int vn;

    /* Set the attention towards other drivers on the same port */
    for (vn = VN_0; vn < QFLE3_MAX_VN_NUM(adapter); vn++) {
        if (vn == QFLE3_VN(adapter))
            continue;

        func = func_by_vn(adapter, vn);
        REG_WR(adapter, MISC_REG_AEU_GENERAL_ATTN_0 +
               (LINK_SYNC_ATTENTION_BIT_FUNC_0 + func)*4, 1);
    }
}

/*
 * State Operations
 */
static inline vmk_Bool
qfle3_activated(qfle3_adapter * adapter)
{
   return !vmk_BitVectorTest(adapter->state, QFLE3_STATE_BIT_QUIESCED);
}

/*
 * Queue ID operations
 */
#define QFLE3_TXQ0_INDEX(A)               QFLE3_NUM_RX_ETH_QUEUES(A)


static inline vmk_Bool
Qfle3IsDefaultRxQueue(qfle3_adapter * adapter, struct qfle3_fastpath *rxq)
{
   return rxq == adapter->fp;
}


static inline vmk_Bool
Qfle3IsDefaultTxQueue(qfle3_adapter * adapter, struct qfle3_fastpath *txq)
{
   return txq == &adapter->fp[QFLE3_TXQ0_INDEX(adapter)];
}

static inline vmk_uint32
Qfle3GetQIDValFromSQD(qfle3_adapter * adapter, vmk_UplinkSharedQueueData * sqd)
{
   return sqd - adapter->uplinkQueueData;
}

static inline struct qfle3_fastpath *
Qfle3GetRxQueueFromQID(qfle3_adapter * adapter, vmk_UplinkQueueID qid)
{
   int qidVal = vmk_UplinkQueueIDVal(qid);
   struct qfle3_fastpath *rxq = &adapter->fp[qidVal];

   VMK_ASSERT(vmk_UplinkQueueIDType(qid) == VMK_UPLINK_QUEUE_TYPE_RX);
   VMK_ASSERT(qidVal < adapter->uplinkQueueInfo.maxRxQueues && qidVal >= 0);

   return rxq;
}

static inline struct qfle3_fastpath *
Qfle3GetTxQueueFromQID(qfle3_adapter * adapter, vmk_UplinkQueueID qid)
{
   int qidVal = vmk_UplinkQueueIDVal(qid);
   struct qfle3_fastpath *txq = &adapter->fp[qidVal + QFLE3_NUM_RX_ETH_QUEUES(adapter)];

   VMK_ASSERT(vmk_UplinkQueueIDType(qid) == VMK_UPLINK_QUEUE_TYPE_TX);
   VMK_ASSERT(qidVal < (adapter->uplinkQueueInfo.maxTxQueues) && qidVal >= 0);

   return txq;
}
#define NO_ISCSI(adapter)        (adapter->flags & NO_ISCSI_FLAG)
#define NO_ISCSI_OOO(adapter)    (adapter->flags & NO_ISCSI_OOO_FLAG)
#define NO_FCOE(adapter)         (adapter->flags & NO_FCOE_FLAG)

#define IS_FCOE_PKT(ethType) \
      ((ethType == vmk_CPUToBE16(VMK_ETH_TYPE_FCOE)) || \
       (ethType == vmk_CPUToBE16(VMK_ETH_TYPE_FCOE_INIT)))

#ifdef QFLE3_CNIC
static inline vmk_uint8 qfle3_cnic_eth_cl_id(struct qfle3_adapter *bp, vmk_uint8 cl_idx)
{
	return HC_SB_MAX_SB_E2 + cl_idx +
		(bp->pf_num >> 1) * QFLE3_MAX_CNIC_ETH_CL_ID_IDX;
}
static inline vmk_uint8 qfle3_cnic_fw_sb_id(struct qfle3_adapter *bp)
{
	/* the 'first' id is allocated for the cnic */
	return bp->base_fw_ndsb;
}

static inline vmk_uint8 qfle3_cnic_igu_sb_id(struct qfle3_adapter *bp)
{
	return bp->igu_base_sb;
}



static inline vmk_Bool skip_rx_queue(struct qfle3_adapter *adapter, int idx)
{
	if ((NO_ISCSI_OOO(adapter) && IS_OOO_IDX(idx)) ||
	    (NO_FCOE(adapter) &&  IS_FCOE_IDX(idx)) ||
	    IS_FWD_IDX(idx))
		return VMK_TRUE;
	return VMK_FALSE;
}

static inline vmk_Bool skip_tx_queue(struct qfle3_adapter *adapter, int idx)
{
	if ((NO_ISCSI_OOO(adapter) && IS_FWD_IDX(idx)) ||
	    (NO_FCOE(adapter) &&  IS_FCOE_IDX(idx)) ||
	    IS_OOO_IDX(idx))
		return VMK_TRUE;

	return VMK_FALSE;
}

static inline vmk_Bool skip_queue(struct qfle3_adapter *adapter, int idx)
{
	if ((NO_FCOE(adapter) &&  IS_FCOE_IDX(idx)) ||
	    (NO_ISCSI_OOO(adapter) && (IS_OOO_IDX(idx) || IS_FWD_IDX(idx))))
		return VMK_TRUE;

	return VMK_FALSE;
}

void qfle3_dcbx_get_ets_pri_pg_tbl(struct qfle3_adapter *adapter,
                                u32 *set_configuration_ets_pg,
                                u32 *pri_pg_tbl);

void
qfle3_read_data(struct qfle3_adapter *adapter, u32 *buff,
                                        u32 addr, u32 len);

int qfle3_dcbx_read_mib(struct qfle3_adapter *adapter,
      u32 *base_mib_addr,
      u32 offset,
      int read_mib_type);

#define FOREACH_CNIC_QUEUE(i,qid,fpq)      for (i = QFLE3_NUM_ETH_QUEUES(adapter); \
                                                         i<QFLE3_NUM_ETH_QUEUES(adapter)+ QFLE3_NUM_CNIC_QUEUES(adapter); i++) { \
                                                         qid = i;  \
                                                         fpq = &adapter->fp[i]; \
                                                         if (skip_queue(adapter, i)) \
                                                            continue; 

#define FOREACH_RX_CNIC_QUEUE(i,qid,fpq)      for (i = QFLE3_NUM_ETH_QUEUES(adapter); \
                                                         i<QFLE3_NUM_ETH_QUEUES(adapter)+ QFLE3_NUM_CNIC_QUEUES(adapter); i++) { \
                                                         qid = i;  \
                                                         fpq = &adapter->fp[i]; \
                                                         if (skip_rx_queue(adapter, i)) \
                                                            continue; 

#define FOREACH_TX_CNIC_QUEUE(i,qid,fpq)      for (i = QFLE3_NUM_ETH_QUEUES(adapter); \
                                                         i<QFLE3_NUM_ETH_QUEUES(adapter)+ QFLE3_NUM_CNIC_QUEUES(adapter); i++) { \
                                                         qid = i;  \
                                                         fpq = &adapter->fp[i]; \
                                                         if (skip_tx_queue(adapter, i)) \
                                                            continue; 


#endif


extern vmk_DriverOps qfle3_drv_ops;
extern vmk_uint32 qfle3_debugMask;
extern vmk_uint32 load_mtu;
extern vmk_uint32 qfle3_intr_mode;
extern vmk_uint32 qfle3_txqueue_count;
extern vmk_uint32 qfle3_rxqueue_count;
extern vmk_uint8 hw_vlan_en;
extern vmk_uint32 qfle3_offload_en;
extern vmk_uint32 qfle3_max_rx_bufs;
extern vmk_int32 qfle3_multi_rx_filters;
extern vmk_uint32 enable_tpa;
extern vmk_uint32 enable_vxlan_filters;
extern vmk_uint32 enable_fw_dump;
extern vmk_uint32 qfle3_hc_rx_ticks;
extern vmk_uint32 qfle3_hc_tx_ticks;
extern vmk_uint32 qfle3_rx_budget;
extern vmk_uint32 qfle3_max_aggregation_size;
extern vmk_int32 qfle3_mrrs;
extern vmk_uint32 qfle3_udp_rss;
#if (VMKAPI_REVISION >= VMK_API_2_4_0_0)
extern vmk_UplinkMultiQueueOps qfle3_multiqueue_ops;
#else
extern vmk_UplinkQueueOps qfle3_multiqueue_ops;
#endif
extern qfle3_mod_info_t qfle3_mod_info;
extern vmk_UplinkOps qfle3_uplink_ops;
extern vmk_DeviceOps qfle3_uplink_device_ops;

vmk_uint16 qfle3_get_mf_speed(struct qfle3_adapter *adapter);
inline void *qfle3_mempool_alloc(vmk_uint32 size);      // IN: allocation size
inline void *qfle3_heap_alloc(vmk_uint32 size); // IN: allocation size
inline void *qfle3_heap_alloc_aligned(vmk_uint32 size,  // IN: allocation size
				      vmk_uint32 align);        // IN: alignment
inline void
qfle3_heap_free(void *p);      // IN: pointer to heap memory
inline void
qfle3_mempool_free(void *va,   // IN: VA to free
		   vmk_uint32 size);   // IN: allocated size
VMK_ReturnStatus qfle3_dma_map_ma(qfle3_adapter * adapter,      // IN: adapter
				  vmk_MA ma,    // IN: machine address
				  vmk_uint32 size,      // IN: size
				  vmk_DMADirection direction,   // IN: DMA mapping direction
				  vmk_DMAEngine engine, vmk_IOA * ioa); // OUT: starting IO address
VMK_ReturnStatus qfle3_dma_map_va(qfle3_adapter * adapter,      // IN: adapter
				  void *va,     // IN: virtual address
				  vmk_uint32 size,      // IN: size
				  vmk_DMADirection direction,   // IN: DMA mapping direction
				  vmk_DMAEngine engine, vmk_IOA * ioa); // OUT: starting IO address
void
qfle3_dma_unmap(qfle3_adapter * adapter,       // IN: adapter
		vmk_IOA ioAddr,        // IN: IO address
		vmk_uint32 size,       // IN: size
		vmk_DMADirection direction,    // IN: DMA mapping direction
		vmk_DMAEngine engine); // IN: coherent or not

void *qfle3_alloc_dma_mapping(qfle3_adapter * adapter,  // IN:  adapter
			      vmk_DMAEngine engine, vmk_uint32 size,    // IN:  size
			      vmk_IOA * ioAddr);        // OUT: IO address
void
qfle3_free_dma_mapping(qfle3_adapter * adapter,        // IN: adapter
		       vmk_DMAEngine engine, void *va, // IN: virtual address
		       vmk_IOA ioAddr, // IN: IO address
		       vmk_uint32 size);       // IN: size
void
qfle3_read_dmae(struct qfle3_adapter *adapter, vmk_uint32 src_addr, vmk_uint32 len32);

void
qfle3_write_dmae(struct qfle3_adapter *adapter,
		 vmk_IOA dma_addr, vmk_uint32 dst_addr, vmk_uint32 len32);
vmk_uint32
qfle3_dmae_opcode(struct qfle3_adapter * adapter,
		  vmk_uint8 src_type, vmk_uint8 dst_type,
		  vmk_Bool with_comp, vmk_uint8 comp_type);
void
qfle3_init_spinlock(vmk_Lock * lock,
		    struct qfle3_adapter *adapter,
		    const char *lckName, vmk_LockRank rank);

void qfle3_init_mutex(vmk_Semaphore * lock);

void qfle3_set_ctx_validation(struct qfle3_adapter *adapter,
			      struct eth_context *cxt, vmk_uint32 cid);

void qfle3_update_coalesce_sb_index(struct qfle3_adapter *adapter,
				    vmk_uint8 fw_sb_id, vmk_uint8 sb_index,
				    vmk_uint8 disable, vmk_uint16 usec);

void ecore_storm_memset_struct(struct qfle3_adapter *adapter,
			       vmk_uint32 addr, vmk_ByteCount size, vmk_uint32 * data);

vmk_int32 ecore_sp_post(struct qfle3_adapter *adapter, vmk_int32 command, vmk_int32 cid,
			vmk_IOA mapping, vmk_int32 cmd_type);

VMK_ReturnStatus qfle3_init_shared_queue_info(qfle3_adapter * adapter);
void qfle3_destroy_shared_queue_info(qfle3_adapter * adapter);
inline VMK_ReturnStatus qfle3_create_spinlock(const char *lckName,      // IN:  lock name
					      const char *devName,      // IN:  device name
					      vmk_LockRank rank,        // IN:  lock rank
					      vmk_Lock * lock); // OUT: created lock
inline VMK_ReturnStatus qfle3_pkt_alloc_and_map(qfle3_adapter * adapter,        // IN:  adapter
						vmk_ByteCountSmall len, // IN:  pkt length
						vmk_DMAEngine engine, vmk_PktHandle ** pkt,     // OUT: allocated pkt
						vmk_IOA * dmaAddr);     // OUT: starting IO address
inline VMK_ReturnStatus qfle3_page_alloc_and_map(qfle3_adapter * adapter,       // IN:  adapter
						 vmk_DMAEngine engine, vmk_MPN * page,  // OUT: allocated page
						 vmk_IOA * dmaAddr);    // OUT: starting IO address
inline void
qfle3_page_unmap_and_free(qfle3_adapter * adapter,     // IN:  adapter
			  vmk_MPN page,        // IN:  allocated page
			  vmk_IOA dmaAddr);    // IN:  starting IO address
vmk_Bool qfle3_tq_stopped(qfle3_adapter * adapter, vmk_uint32 id);
void
qfle3_tq_init_all(qfle3_adapter * adapter);
inline void
qfle3_enable_all_intrs(qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_tq_start(qfle3_adapter * adapter, vmk_uint32 id);
VMK_ReturnStatus qfle3_rq_start(qfle3_adapter * adapter, vmk_uint32 id);
vmk_Bool qfle3_tq_stopped(qfle3_adapter * adapter, vmk_uint32 id);
VMK_ReturnStatus qfle3_tq_stop(qfle3_adapter * adapter, vmk_uint32 id);
VMK_ReturnStatus qfle3_rq_stop(qfle3_adapter * adapter, vmk_uint32 id);
inline void
qfle3_disable_all_intrs(qfle3_adapter * adapter);
void
qfle3_tq_cleanup_all(qfle3_adapter * adapter);
inline void
qfle3_enable_intr(qfle3_adapter * adapter,     // IN: adapter
		  unsigned idx);       // IN: interrupt index
VMK_ReturnStatus qfle3_alloc_rx_bd_mbuf(struct qfle3_fastpath *fp, vmk_uint16 index);
inline vmk_uint16 qfle3_tx_avail(struct qfle3_adapter *adapter, struct qfle3_fp_txdata* txdata);
vmk_uint32
qfle3_rxeof(struct qfle3_adapter *adapter,
	    struct qfle3_fastpath *fp, vmk_uint32 rx_budget, vmk_Bool *sp_update,
	    vmk_Bool isPanic, vmk_PktList pktList);

inline void
qfle3_init_sge_ring_bit_mask(struct qfle3_fastpath *fp);
int
qfle3_alloc_rx_sge_mbuf(struct qfle3_fastpath *fp, vmk_uint16 index);
int
qfle3_alloc_rx_tpa_mbuf(struct qfle3_fastpath *fp, int queue);
vmk_Bool qfle3_netpoll_msix_rx_cb(vmk_AddrCookie priv, vmk_uint32 budget);
VMK_ReturnStatus qfle3_interrupt_ack(void *handlerData, vmk_IntrCookie intrCookie);
VMK_ReturnStatus qfle3_alloc_fp_buffers(struct qfle3_fastpath *fp);
VMK_ReturnStatus qfle3_free_fp_buffers(struct qfle3_fastpath *fp);
vmk_Bool qfle3_netpoll_rxcb(vmk_AddrCookie priv, vmk_uint32 budget);
vmk_Bool qfle3_netpoll_txrxcb(vmk_AddrCookie priv, vmk_uint32 budget);
void
qfle3_unmap_txbuf(qfle3_adapter * adapter, qfle3_txbuf_info * tbi, vmk_uint32 index, vmk_uint32 qid);
void
qfle3_free_rx_bd_chain(struct qfle3_fastpath *fp);
void
qfle3_free_tpa_pool(struct qfle3_fastpath *fp);
void
qfle3_free_sge_chain(struct qfle3_fastpath *fp);
VMK_ReturnStatus qfle3_register_interrupt(qfle3_adapter * adapter,      // IN: adapter
					  vmk_uint32 cookieIdx, // IN: which interrupt cookie
					  vmk_Name name,        // IN: interrupt name
					  void *handlerData,    // IN: private data for handler
					  vmk_IntrAcknowledge ack,      // IN: acknowledging function
					  vmk_IntrHandler handler);     // IN: interrupt handler
#define VLAN_VID_MASK   0x0fff
#define VLAN_PRIO_MASK              0xe000 /* Priority Code Point */
#define QFLE3_MAX_PRIORITY              8

void ecore_init_e2_firmware(struct qfle3_adapter *adapter);
inline vmk_uint16 qfle3_ack_int(struct qfle3_adapter *adapter);

VMK_ReturnStatus qfle3_create_helper(qfle3_adapter * adapter,
				     vmk_Helper * helper, const char *helper_name);
VMK_ReturnStatus
qfle3_destroy_helper(qfle3_adapter * adapter, vmk_Helper helper);
void
qfle3_unregister_interrupt(qfle3_adapter * adapter,    // IN: adapter
			   vmk_uint32 idx);    // IN: which cookie
inline void
qfle3_destroy_spinlock(vmk_Lock lock); // IN: lock to destroy
inline void

qfle3_ack_sb(struct qfle3_adapter *adapter, vmk_uint8 igu_sb_id, vmk_uint8 storm,
	     vmk_uint16 index, vmk_uint8 op, vmk_uint8 update);
void
qfle3_sp_helper_func(vmk_AddrCookie data);
void
qfle3_periodic_task_func(vmk_AddrCookie data);
VMK_ReturnStatus
qfle3_schedule_helper(qfle3_adapter * adapter, vmk_Helper helper,
		      vmk_HelperRequestFunc req_func, vmk_uint32 timeout);
void
qfle3_sp_interrupt(void *handlerData, vmk_IntrCookie intrCookie);
VMK_ReturnStatus
qfle3_single_interrupt_ack(void *handlerData, vmk_IntrCookie intrCookie);
void
qfle3_single_interrupt(void *handlerData, vmk_IntrCookie intrCookie);
void qfle3_free_txqs_mem(qfle3_adapter * adapter);
void qfle3_free_rxqs_mem(qfle3_adapter * adapter);
VMK_ReturnStatus
qfle3_alloc_txqs_mem(qfle3_adapter * adapter);
VMK_ReturnStatus
qfle3_alloc_rxqs_mem(qfle3_adapter * adapter);
void
qfle3_set_fp_rx_buf_size(struct qfle3_adapter *adapter, struct qfle3_fastpath *fp);
int qfle3_setup_queue(struct qfle3_adapter *adapter, struct qfle3_fastpath *fp, vmk_Bool leading);
int qfle3_stop_queue(struct qfle3_adapter *adapter, int fp_idx);
inline void
qfle3_update_fpsb_idx(struct qfle3_fastpath *fp);
void qfle3_init_sb(struct qfle3_adapter *adapter, vmk_IOA mapping, int vfid,
		   vmk_uint8 vf_valid, int fw_sb_id, int igu_sb_id);

void qfle3_sp_event(struct qfle3_fastpath *fp, union eth_rx_cqe *rr_cqe);

int qfle3_initial_phy_init(struct qfle3_adapter *adapter, int load_mode);
void qfle3_set_rx_mode(qfle3_adapter *adapter);
inline void
qfle3_update_rx_prod(struct qfle3_adapter * adapter, struct qfle3_fastpath *fp,
		     vmk_uint16 rx_bd_prod,
		     vmk_uint16 rx_cq_prod, vmk_uint16 rx_sge_prod);
void qfle3_link_set(struct qfle3_adapter *adapter);
void qfle3_force_link_reset(struct qfle3_adapter *adapter);
int qfle3_get_cur_phy_idx(struct qfle3_adapter *adapter);
int qfle3_get_link_cfg_idx(struct qfle3_adapter *adapter);
VMK_ReturnStatus
qfle3_fw_dump_handler(void *cookie, vmk_Bool live_dump);
void
qfle3_report_link(qfle3_adapter *adapter);
VMK_ReturnStatus
qfle3_rq_alloc(qfle3_adapter * adapter, // IN:  adapter
	       vmk_UplinkQueueID * qid, // OUT: allocated qid
	       vmk_NetPoll * netpoll,   // OUT: corresponding netpoll
	       vmk_UplinkQueueFeature feat);
VMK_ReturnStatus
qfle3_tq_alloc(qfle3_adapter * adapter, // IN:  adapter
	       vmk_UplinkQueueID * qid, // OUT: allocated qid
	       vmk_NetPoll * netpoll);   // OUT: corresponding netpoll
VMK_ReturnStatus
qfle3_rq_free(qfle3_adapter * adapter, vmk_UplinkQueueID qid);
VMK_ReturnStatus
qfle3_tq_free(qfle3_adapter * adapter, vmk_UplinkQueueID qid);
void qfle3_update_coalesce(struct qfle3_adapter *adapter);
VMK_ReturnStatus
qfle3_cancel_helper_requests(qfle3_adapter * adapter, vmk_Helper helper);
int qfle3_set_q_rx_mode(struct qfle3_adapter *adapter, vmk_uint8 cl_id,
			unsigned long rx_mode_flags,
			unsigned long rx_accept_flags,
			unsigned long tx_accept_flags,
			unsigned long ramrod_flags);
int qfle3_set_mac_one(struct qfle3_adapter *adapter, vmk_uint8 *mac,
		      struct ecore_vlan_mac_obj *obj, vmk_Bool set,
		      int mac_type, unsigned long *ramrod_flags);

int qfle3_set_vlan_one(struct qfle3_adapter *adapter, vmk_uint16 vlan,
                       struct ecore_vlan_mac_obj *obj, vmk_Bool set,
                       unsigned long *ramrod_flags);

VMK_ReturnStatus
qfle3_rq_create(qfle3_adapter *adapter, vmk_uint32 id);
VMK_ReturnStatus
qfle3_tq_create(qfle3_adapter *adapter, vmk_uint32 id);
VMK_ReturnStatus
qfle3_tq_resume(qfle3_adapter *adapter, vmk_uint32 id);


VMK_ReturnStatus
qfle3_tq_pause(qfle3_adapter *adapter, vmk_uint32 id);

#if (ESX_DDK_VERSION >= 2017)
VMK_ReturnStatus
qfle3_rss_get_engines_info(vmk_AddrCookie drv_data,
                           vmk_UplinkQueueRSSEnginesInfo   *enginesInfo);

VMK_ReturnStatus
qfle3_rss_get_engines_supported_config(vmk_AddrCookie drv_data,
                                       vmk_UplinkQueueID qID,
                                       vmk_UplinkQueueRSSEngineConfig  *engineConfig);

VMK_ReturnStatus
qfle3_rss_get_engines_cur_config(vmk_AddrCookie drv_data,
                                       vmk_UplinkQueueID qID,
                                       vmk_UplinkQueueRSSEngineConfig  *engineConfig);

VMK_ReturnStatus
qfle3_rss_set_engine_config(vmk_AddrCookie drv_data,
                                       vmk_UplinkQueueID qID,
                                       vmk_UplinkQueueRSSEngineConfigOp configOp,
                                       vmk_AddrCookie opArgs);

VMK_ReturnStatus
qfle3_rss_set_engine_ind_table(vmk_AddrCookie                drv_data,
                               vmk_UplinkQueueID             qID,
                               vmk_UplinkQueueRSSIndTable   *rssIndTable);


VMK_ReturnStatus
qfle3_rss_set_engine_ind_table_idx(vmk_AddrCookie        drv_data,
                                   vmk_UplinkQueueID     qID,
                                   vmk_uint16            tableIndex,
                                   vmk_uint8             queueIndex);

VMK_ReturnStatus
qfle3_rss_get_engine_ind_table(vmk_AddrCookie drv_data,
                                vmk_UplinkQueueID qID,
                                vmk_UplinkQueueRSSIndTable *rssIndTable);


#else
VMK_ReturnStatus
qfle3_rss_get_params(vmk_AddrCookie drv_data,
		     vmk_UplinkQueueRSSParams *params);
VMK_ReturnStatus
qfle3_rss_state_init(vmk_AddrCookie drv_data,
		     vmk_UplinkQueueRSSHashKey *rss_key,
		     vmk_UplinkQueueRSSIndTable *ind_table);
VMK_ReturnStatus
qfle3_rss_ind_tbl_update(vmk_AddrCookie drv_data,
			 vmk_UplinkQueueRSSIndTable *ind_table);
VMK_ReturnStatus
qfle3_rss_get_ind_tbl(vmk_AddrCookie drv_data,
		      vmk_UplinkQueueRSSIndTable *ind_table);
#endif
void qfle3_get_grcdump(struct qfle3_adapter *adapter, vmk_uint32 *dst, vmk_Bool live_dump);
void qfle3_reboot_handler(void *data);
int qfle3_del_all_macs(qfle3_adapter *adapter,
                       struct ecore_vlan_mac_obj *mac_obj,
                       int mac_type, vmk_Bool wait_for_comp);
vmk_Bool qfle3_port_after_undi(struct qfle3_adapter *adapter);
VMK_ReturnStatus qfle3_nvram_write(struct qfle3_adapter *adapter, vmk_uint32 offset, char *data_buf,
			     int buf_size);
VMK_ReturnStatus qfle3_nvram_read(struct qfle3_adapter *adapter, vmk_uint32 offset,
		char *ret_buf, vmk_uint32 buf_size, vmk_uint32 *out_len);
vmk_Bool qfle3_is_nvm_accessible(struct qfle3_adapter *adapter);

vmk_uint16 qfle3_cid_ilt_lines(struct qfle3_adapter *adapter);
struct eth_spe * qfle3_sp_get_next(struct qfle3_adapter *adapter);
void qfle3_sp_prod_update(struct qfle3_adapter *adapter);
void qfle3_ilt_wr(struct qfle3_adapter *adapter, vmk_uint32 index, vmk_IOA addr);
void qfle3_set_os_driver_state(struct qfle3_adapter *adapter, vmk_uint32 state);
VMK_ReturnStatus qfle3_alloc_cnicqs_mem(qfle3_adapter * adapter);
void qfle3_free_cnicqs_mem(qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_alloc_queue_mem(qfle3_adapter * adapter,
		      int req_type, struct qfle3_fastpath *fp);
void qfle3_free_queue_mem(struct qfle3_fastpath *fp, int type);
void qfle3_tq_init(struct qfle3_fastpath *fp);

int qfle3_set_vxlan_fltr_one(struct qfle3_adapter *adapter, vmk_uint8 *outer_mac,
			     struct ecore_vlan_mac_obj *obj, vmk_Bool set,
			     int mac_type, unsigned long *ramrod_flags,
			     vmk_uint8 *inner_mac, vmk_uint32 vxlan_id);
void qfle3_fill_fw_str(struct qfle3_adapter *adapter, char *buf, vmk_ByteCount buf_len);
void qfle3_int_disable(struct qfle3_adapter *adapter);
void qfle3_int_enable(struct qfle3_adapter *adapter);
void qfle3_netpoll_disable(qfle3_adapter * adapter);
void qfle3_netpoll_enable(qfle3_adapter * adapter);
void qfle3_acquire_phy_lock(struct qfle3_adapter *adapter);
void qfle3_release_phy_lock(struct qfle3_adapter *adapter);
int qfle3_phy_read(struct qfle3_adapter *adapter, int prtad,
               int devad, vmk_uint16 addr);
int qfle3_phy_write(struct qfle3_adapter *adapter, int prtad, int devad,
                vmk_uint16 addr, vmk_uint16 value);
void qfle3_calc_fc_adv(struct qfle3_adapter *adapter);
VMK_ReturnStatus qfle3_set_netpoll_interrupts(qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_tx_queue_start(qfle3_adapter *adapter, vmk_UplinkQueueID qID);
VMK_ReturnStatus qfle3_rx_queue_start(qfle3_adapter *adapter, vmk_UplinkQueueID qID);
vmk_uint8 qfle3_stats_id(struct qfle3_fastpath *fp);
vmk_uint32 qfle3_mfw_command(struct qfle3_adapter *adapter, vmk_uint32 command, vmk_uint32 param);
void qfle3_set_local_cmng(struct qfle3_adapter *adapter);
int qfle3_setup_tx_only(struct qfle3_adapter *adapter, struct qfle3_fastpath *fp,
			struct ecore_queue_state_params *q_params,
			struct ecore_queue_setup_tx_only_params *tx_only_params,
			int tx_index, vmk_Bool leading);
void qfle3_init_txdata(struct qfle3_adapter *adapter,
				     struct qfle3_fp_txdata *txdata, vmk_uint32 cid,
				     int txq_index, vmk_uint16 *tx_cons_sb,
				     struct qfle3_fastpath *fp);
VMK_ReturnStatus qfle3_rx_queue_stop(qfle3_adapter *adapter, vmk_UplinkQueueID qID);
VMK_ReturnStatus qfle3_tx_queue_stop(qfle3_adapter *adapter, vmk_UplinkQueueID qID);
int qfle3_has_tx_work_unload(struct qfle3_fp_txdata *txdata);
int qfle3_clean_tx_queue(qfle3_adapter * adapter, struct qfle3_fp_txdata *txdata);
void qfle3_timer(vmk_TimerCookie data);
int qfle3_parity_error(struct qfle3_adapter * adapter);
void qfle3_tx_error(struct qfle3_adapter * adapter);
void qfle3_reset_engine_pfs(struct qfle3_adapter * adapter);
void qfle3_tx_timeout(struct qfle3_adapter * adapter);
void qfle3_free_cnic_queue_mem(struct qfle3_fastpath *fp);

static inline vmk_int32
qfle3_tx_queue_has_work(struct qfle3_fp_txdata *txdata)
{
   vmk_uint16 hw_cons;
   //vmk_logmessage("tx_cons_sb is %d, tx_pkt_cons %d", le16toh(*fp->tx_cons_sb), fp->tx_pkt_cons);
   /*
    * status block fields can change
    */
   hw_cons = le16toh(*txdata->tx_cons_sb);
   return (hw_cons != txdata->tx_pkt_cons);
}

static inline vmk_uint8
qfle3_has_tx_work(struct qfle3_fastpath *fp)
{
   vmk_uint8 cos;
   /*
    * expand this for multi-cos if ever supported
    */
   for_each_cos_in_tx_queue(fp, cos)
      if (qfle3_tx_queue_has_work(fp->txdata_ptr[cos])) 
         return VMK_TRUE;

   return VMK_FALSE;
};
enum sp_rtnl_flag {
	QFLE3_SP_RTNL_SETUP_TC,
	QFLE3_SP_RTNL_TX_TIMEOUT,
	QFLE3_SP_RTNL_FAN_FAILURE,
	QFLE3_SP_RTNL_AFEX_F_UPDATE,
	QFLE3_SP_RTNL_ENABLE_SRIOV,
	QFLE3_SP_RTNL_VFPF_MCAST,
	QFLE3_SP_RTNL_VFPF_CHANNEL_DOWN,
	QFLE3_SP_RTNL_RX_MODE,
	QFLE3_SP_RTNL_HYPERVISOR_VLAN,
	QFLE3_SP_RTNL_VFPF_STORM_BYPASS_RX_MODE,
	QFLE3_SP_RTNL_TX_STOP,
	QFLE3_SP_RTNL_GET_DRV_VERSION,
	QFLE3_SP_RTNL_CHANGE_UDP_PORT,
	QFLE3_SP_RTNL_REC_ACTIVE,
	QFLE3_SP_RTNL_DETECT_TX_TIMEOUT,
	QFLE3_SP_RTNL_DONOT_RECOVER,
};

void qfle3_disable_fwdmp(qfle3_adapter *adapter);

//int qfle3_parity_check(struct qfle3_adapter * adapter);
#define QFLE3_PANIC_FWDMP_ENABLED(A) ((A)->fwdmp_enable)
void qfle3_panic(struct qfle3_adapter * adapter);
void qfle3_panic_dump(struct qfle3_adapter * adapter, vmk_Bool disable_int);
void qfle3_trigger_grcdump(qfle3_adapter *adapter, vmk_int32 error);
int qfle3_is_grc_disabled(struct qfle3_adapter * adapter);
VMK_ReturnStatus qfle3_disable_bus_master(qfle3_adapter * adapter);

//#define START_RECOVERY(adapter) vmk_BitVectorAtomicTestAndSet(adapter->recovery_status, QFLE3_SP_RTNL_REC_ACTIVE)

//#define STOP_RECOVERY(adapter) vmk_BitVectorAtomicTestAndClear(adapter->recovery_status, QFLE3_SP_RTNL_REC_ACTIVE)
void qfle3_schedule_sp_rtnl(struct qfle3_adapter * adapter, enum sp_rtnl_flag flag, vmk_uint32 verbose);
void qfle3_tx_disable(struct qfle3_adapter * adapter);
#define QFLE3_TRIGGER_TX_TO(A, error)             \
{                                                      \
   if ((A)->error_status) {                  \
      QFLE3_ERR("QFLE3_REC_ERR 0x%x ES:0x%x RS:%d\n", \
          (error), (A)->error_status, (A)->recovery_state); \
      (A)->error_status |= (error);     \
   } else {                                       \
      QFLE3_ERR("QFLE3_REC_TXTO 0x%x RS:%d\n", \
          (error), A->recovery_state); \
      (A)->error_status |= (error);   \
      qfle3_tx_disable(A); \
      qfle3_tx_timeout(A);  \
   }                                              \
} 
#define UNLOAD_NORMAL			0
#define UNLOAD_CLOSE			1
#define UNLOAD_RECOVERY			2


#endif                          // #ifndef _QFLE3_H_
