//
//  EmailThread.m
//  Cosmic Debris
//
//  Created by John Schilling on 11/25/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "EmailThread.h"
#import <Message/NSMailDelivery.h>

@implementation EmailThread


- (void)sendEmail:(NSArray *)objs
{
    NSDictionary *headers = [objs objectAtIndex:0];
    NSAttributedString *message = [objs objectAtIndex:1];

    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    
    [[NSRunLoop currentRunLoop] run];
    
    BOOL result = [NSMailDelivery deliverMessage:message headers:headers format:NSMIMEMailFormat protocol:nil];
    
    NSString *emailAddress = @"someone@somewhere.com";
NSString *mailToString = @"mailto:";
NSString *emailURLString = [mailToString stringByAppendingString:emailAddress];
NSURL *emailURL = [NSURL URLWithString:emailURLString];
[[NSWorkspace sharedWorkspace] openURL:emailURL];
    
    if (!result) {
        NSLog(@"Unknown error sending email message: %@", message);
    }
    
    [pool release];
    [NSThread exit];
    
    return;
}

@end
