/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Vector;
import shared.Bytes;
import shared.b;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static String initialWorkingDirectory = FileUtils.GetPresentWorkingDirectory();
    private static final long freespaceMargin = 10000000L;

    public static boolean HasPermissions2(String foldername, boolean printerror) {
        File file = new File(foldername);
        if (!file.exists()) {
            if (printerror) {
                m.err("Folder doesn't exist: ", foldername);
            }
            return false;
        }
        if (!file.canRead()) {
            if (printerror) {
                m.err("We don't have read permissions for this folder: ", foldername);
            }
            return false;
        }
        if (!file.canWrite()) {
            if (printerror) {
                m.err("We don't have permission to change this folder: ", foldername);
            }
            return false;
        }
        File testname = new File(foldername + "/TempTest.dat");
        boolean success = FileUtils.WriteFile(testname, new byte[]{104, 105, 33}, false, false, false, false);
        FileUtils.DeleteFile(testname, true);
        if (!success) {
            if (printerror) {
                m.err("We don't have permission to change this folder: ", foldername);
            }
            return false;
        }
        return true;
    }

    public static void SaveFileIfChanged(String filename, byte[] newcontents, boolean createdirs, boolean throwexception) {
        if (FileUtils.Exists(filename)) {
            boolean changed;
            byte[] oldcontents = FileUtils.ReadFile(filename);
            boolean bl = changed = !b.isEqual(oldcontents, newcontents);
            if (changed) {
                FileUtils.WriteFile(filename, newcontents, createdirs, throwexception);
            }
        } else {
            FileUtils.WriteFile(filename, newcontents, createdirs, throwexception);
        }
    }

    public static void ZeroFile(String filename) {
        FileUtils.ZeroFile(new File(filename));
    }

    public static void ZeroFile(File file) {
        FileUtils.WriteFile(file, new byte[0]);
    }

    public static String GetRelativePath(File ancestor, File descendant) {
        String result = "";
        File curfolder = descendant;
        if (curfolder.isFile()) {
            curfolder = curfolder.getParentFile();
        }
        while (!curfolder.equals(ancestor)) {
            result = curfolder.getName() + "/" + result;
            curfolder = curfolder.getParentFile();
        }
        if (descendant.isFile()) {
            result = result + descendant.getName();
        }
        return result.toString();
    }

    public static long GetFilesize(String filename) {
        File f = new File(filename);
        long result = f.length();
        return result;
    }

    public static String SanitizeFilename(String filename) {
        String result = filename;
        result = result.replace(":", "_");
        result = result.replace("/", "_");
        result = result.replace("\\", "_");
        result = result.replace("*", "_");
        result = result.replace("?", "_");
        result = result.replace("\"", "_");
        result = result.replace("<", "_");
        result = result.replace(">", "_");
        result = result.replace("|", "_");
        return result;
    }

    public static long GetModtime(String filename) {
        File f = new File(filename);
        long result = f.lastModified();
        return result;
    }

    public static String GetNextFilename(String folder, String prefix, String suffix) {
        int max = 1000000;
        for (int i = 0; i < 1000000; ++i) {
            String filename = folder + "/" + prefix + Integer.toString(i) + suffix;
            if (FileUtils.Exists(filename)) continue;
            return filename;
        }
        return null;
    }

    public static Vector<String> FindAllDecendants(File dir, boolean relativepath) {
        Vector<String> r = new Vector<String>();
        FileUtils.FindAllDecendants(r, dir, relativepath, "");
        return r;
    }

    private static void FindAllDecendants(Vector<String> r, File dir, boolean relativepath, String pathsofar) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                if (child.isDirectory()) {
                    FileUtils.FindAllDecendants(r, child, relativepath, pathsofar + child.getName() + "/");
                    continue;
                }
                FileUtils.FindAllDecendants(r, child, relativepath, pathsofar + child.getName());
            }
        } else if (relativepath) {
            r.add(pathsofar);
        } else {
            r.add(dir.getAbsolutePath());
        }
    }

    public static Vector<File> FindAllFiles(String folder, String ext, boolean recurse) {
        return FileUtils.FindAllFiles(folder, null, ext, recurse);
    }

    public static Vector<File> FindAllFiles(String folder, String prefix, String ext, boolean recurse) {
        return FileUtils.FindAllFiles(folder, prefix, ext, recurse, true);
    }

    public static Vector<File> FindAllFiles(String folder, String prefix, String ext, boolean recurse, boolean casesensitive) {
        Vector<File> result = new Vector<File>();
        FileUtils.FindAllFiles(result, folder, prefix, ext, recurse, casesensitive);
        return result;
    }

    public static void FindAllFiles(Vector<File> result, String folder, String prefix, String ext, boolean recurse, boolean casesensitive) {
        File fold = new File(folder);
        if (!fold.exists() || !fold.isDirectory()) {
            m.warn("Folder doesn't exist.");
            return;
        }
        for (File f : fold.listFiles()) {
            if (f.isDirectory()) {
                if (!recurse) continue;
                FileUtils.FindAllFiles(result, f.getAbsolutePath(), prefix, ext, recurse, casesensitive);
                continue;
            }
            if (!f.isFile()) continue;
            if (casesensitive) {
                if (prefix != null && !f.getName().startsWith(prefix) || ext != null && !f.getName().endsWith(ext)) continue;
                result.add(f);
                continue;
            }
            if (prefix != null && !f.getName().toLowerCase().startsWith(prefix.toLowerCase()) || ext != null && !f.getName().toLowerCase().endsWith(ext.toLowerCase())) continue;
            result.add(f);
        }
    }

    public static boolean HasFreeSpace(String filename, long minimum) {
        return FileUtils.HasFreeSpace(new File(filename), minimum);
    }

    public static boolean HasFreeSpace(File file, long minimum) {
        long usablespace = file.getUsableSpace();
        boolean result = usablespace > minimum + 10000000L;
        return result;
    }

    public static String GetInitialWorkingDirectory() {
        return initialWorkingDirectory;
    }

    public static String GetPresentWorkingDirectory() {
        return new File(".").getAbsolutePath();
    }

    public static boolean Exists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static void DeleteFile2(String absoluteFilename) {
        File f = new File(absoluteFilename);
        if (!f.isDirectory()) {
            boolean success;
            m.msg("Deleting ", absoluteFilename);
            if (f.exists() && f.isFile() && !(success = f.delete())) {
                m.warn("Unable to delete file: ", absoluteFilename);
            }
        }
    }

    public static void DeleteFile(String filename) {
        FileUtils.DeleteFile(filename, false);
    }

    public static void DeleteFile(String filename, boolean throwexception) {
        FileUtils.DeleteFile(new File(filename), throwexception);
    }

    public static void DeleteFile(File file, boolean throwexception) {
        boolean result;
        if (file.exists() && !(result = file.delete())) {
            m.err("Unable to delete file: ", file.getAbsolutePath());
            if (throwexception) {
                m.throwUncaughtException("");
            }
        }
    }

    public static void DeleteTree(File dir, boolean throwexception) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                FileUtils.DeleteTree(child, throwexception);
            }
        }
        FileUtils.DeleteFile(dir.getAbsolutePath(), throwexception);
    }

    public static void CopyTree(String from, String to, boolean overwrite, boolean throwexception) {
        File f = new File(from);
        if (f.isFile()) {
            FileUtils.CopyFile(from, to, overwrite, true, throwexception);
        } else if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                FileUtils.CopyTree(from + "/" + child.getName(), to + "/" + child.getName(), overwrite, throwexception);
            }
        } else {
            m.throwUncaughtException("Unhandled case.");
        }
    }

    public static void CopyFile(String infile, String outfile, boolean overwrite, boolean createfolder) {
        FileUtils.CopyFile(infile, outfile, overwrite, createfolder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void CopyFile(String infile, String outfile, boolean overwrite, boolean createfolder, boolean throwexception) {
        block21: {
            File in = new File(infile);
            File out = new File(outfile);
            AbstractInterruptibleChannel inchan = null;
            AbstractInterruptibleChannel outchan = null;
            if (out.exists()) {
                if (!overwrite) {
                    return;
                }
                FileUtils.DeleteFile(outfile, throwexception);
            }
            if (createfolder && !FileUtils.Exists(out.getParent())) {
                FileUtils.CreateFolder(out.getParent());
            }
            inchan = new FileInputStream(in).getChannel();
            outchan = new FileOutputStream(out).getChannel();
            ((FileChannel)inchan).transferTo(0L, ((FileChannel)inchan).size(), (WritableByteChannel)((Object)outchan));
            try {
                if (inchan != null) {
                    inchan.close();
                }
                if (outchan != null) {
                    outchan.close();
                }
                break block21;
            }
            catch (Exception e2) {
                m.err("Unable to close file copying channel.");
                if (throwexception) {
                    m.throwUncaughtException("");
                }
                break block21;
            }
            catch (Exception e3) {
                block22: {
                    try {
                        m.err("Unable to copy file ", infile, " to ", outfile);
                        if (!throwexception) break block22;
                        m.throwUncaughtException("");
                    }
                    catch (Throwable throwable) {
                        block23: {
                            try {
                                if (inchan != null) {
                                    inchan.close();
                                }
                                if (outchan != null) {
                                    outchan.close();
                                }
                            }
                            catch (Exception e4) {
                                m.err("Unable to close file copying channel.");
                                if (!throwexception) break block23;
                                m.throwUncaughtException("");
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (inchan != null) {
                        inchan.close();
                    }
                    if (outchan != null) {
                        outchan.close();
                    }
                }
                catch (Exception e5) {
                    m.err("Unable to close file copying channel.");
                    if (throwexception) {
                        m.throwUncaughtException("");
                    }
                }
            }
        }
    }

    public static void CopyModTime(String infile, String outfile) {
        long modtime = new File(infile).lastModified();
        new File(outfile).setLastModified(modtime);
    }

    public static byte[] ReadFile(String filename) {
        File file = new File(filename);
        return FileUtils.ReadFile(file);
    }

    public static String ReadFileAsString(File filename) {
        return new String(FileUtils.ReadFile(filename));
    }

    public static String ReadFileAsString(String filename) {
        File file = new File(filename);
        return FileUtils.ReadFileAsString(file);
    }

    public static Bytes ReadFileAsBytes(String filename) {
        File file = new File(filename);
        return FileUtils.ReadFileAsBytes(file);
    }

    public static Bytes ReadFileAsBytes(File filename) {
        return new Bytes(FileUtils.ReadFile(filename));
    }

    public static byte[] ReadFile(File filename) {
        try {
            FileInputStream reader = new FileInputStream(filename);
            int filelength = (int)filename.length();
            byte[] result = new byte[filelength];
            int bytesread = reader.read(result, 0, filelength);
            if (bytesread != filelength) {
                throw new Exception("Incorrect # of bytes read.");
            }
            reader.close();
            return result;
        }
        catch (Exception e2) {
            m.err("Error reading file:", filename.getAbsolutePath() + ": ( " + e2.getMessage(), " )");
            return null;
        }
    }

    public static void WriteFile(String filename, byte[] content, boolean createdirs) {
        File file = new File(filename);
        FileUtils.WriteFile(file, content, createdirs);
    }

    public static void WriteFile(String filename, byte[] content) {
        File file = new File(filename);
        FileUtils.WriteFile(file, content);
    }

    public static void WriteFile(String filename, Bytes content) {
        FileUtils.WriteFile(filename, content.getByteArray());
    }

    public static void WriteFile(File filename, byte[] content) {
        FileUtils.WriteFile(filename, content, false);
    }

    public static void WriteFile(File filename, byte[] content, boolean createdirs) {
        FileUtils.WriteFile(filename, content, createdirs, false);
    }

    public static void WriteFile(String filename, byte[] content, boolean createdirs, boolean throwexception) {
        FileUtils.WriteFile(new File(filename), content, createdirs, throwexception);
    }

    public static boolean WriteFile(File filename, byte[] content, boolean createdirs, boolean throwexception) {
        return FileUtils.WriteFile(filename, content, createdirs, throwexception, false, false);
    }

    public static boolean WriteFile(String filename, String content, boolean createdirs, boolean throwexception) {
        return FileUtils.WriteFile(new File(filename), b.StringToBytes(content), createdirs, throwexception);
    }

    public static boolean WriteFile(File filename, byte[] content, boolean createdirs, boolean throwexception, boolean printerror, boolean deletefirst) {
        boolean success;
        if (!createdirs || !(success = filename.getParentFile().mkdirs())) {
            // empty if block
        }
        if (deletefirst) {
            FileUtils.DeleteFile(filename, throwexception);
        }
        try {
            FileOutputStream writer = new FileOutputStream(filename);
            int filelength = content.length;
            writer.write(content);
            writer.flush();
            writer.close();
            int actuallength = (int)filename.length();
            if (actuallength != filelength) {
                throw new Exception("Error writing file, not correct length.");
            }
            return true;
        }
        catch (Exception e2) {
            String[] msg = new String[]{"Error writing file:", filename.getAbsolutePath() + ":" + e2.getMessage()};
            if (throwexception) {
                m.throwUncaughtException(msg);
            }
            if (printerror) {
                m.err(msg);
            }
            return false;
        }
    }

    public static void AppendText(String filename, String text) {
        try {
            FileOutputStream writer = new FileOutputStream(filename, true);
            byte[] bytes = b.StringToBytes(text);
            writer.write(bytes);
            writer.close();
        }
        catch (Exception e2) {
            m.err("Error appending file:", filename);
        }
    }

    public static void CreateFolder(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isDirectory()) {
                m.warn("Unable to create folder because there is already a file with that name: ", filename);
            }
        } else {
            boolean result = f.mkdirs();
            if (!result) {
                m.warn("Unable to create folder: ", filename);
            }
        }
    }
}

