/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class xml {
    static final boolean doValidate = false;
    static DocumentBuilder builder;
    Document doc;
    Element root;
    XPath xpath;

    public static String sanitise(String in) {
        in = in.replace("&", "&amp;");
        in = in.replace("\"", "&quot;");
        in = in.replace("'", "&apos;");
        in = in.replace("<", "&lt;");
        in = in.replace(">", "&gt;");
        return in;
    }

    public xml(byte[] data) {
        this(new ByteArrayInputStream(data));
    }

    public xml(InputStream in) {
        if (builder == null) {
            DocumentBuilderFactory docfact = DocumentBuilderFactory.newInstance();
            docfact.setValidating(false);
            try {
                builder = docfact.newDocumentBuilder();
                builder.setErrorHandler(new xmlErrorHandler());
            }
            catch (ParserConfigurationException e2) {
                throw new ConfigErrorException("Error creating parser.");
            }
        }
        if (this.xpath == null) {
            XPathFactory xpathfact = XPathFactory.newInstance();
            this.xpath = xpathfact.newXPath();
        }
        try {
            this.doc = builder.parse(in);
        }
        catch (SAXException e3) {
            throw new ConfigErrorException("Error parsing config. (SAXException)  The XML is probably invalid.");
        }
        catch (IOException e4) {
            throw new ConfigErrorException("Error parsing config. (IOException)  The XML is probably invalid.");
        }
        this.root = this.doc.getDocumentElement();
    }

    public Vector<String> getStrings(String xpathquery) {
        Vector<String> result = new Vector<String>();
        for (Node n : this.findNodes(xpathquery)) {
            result.add(n.getTextContent());
        }
        return result;
    }

    public String getString(String xpathquery) {
        Node queryresult = this.findNode(xpathquery);
        if (queryresult == null) {
            m.err("Unable to find property in xml list: ", xpathquery);
            return "";
        }
        String result = queryresult.getTextContent();
        return result;
    }

    public Node findNode(String xpathquery) {
        Object result2;
        try {
            result2 = this.xpath.compile(xpathquery).evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e2) {
            throw new ConfigErrorException("Error finding something in the config file.");
        }
        NodeList result = (NodeList)result2;
        Node result3 = result.getLength() > 0 ? result.item(0) : null;
        return result3;
    }

    public Vector<Node> findNodes(String xpathquery) {
        Object result2;
        try {
            result2 = this.xpath.compile(xpathquery).evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e2) {
            throw new ConfigErrorException("Error finding something in the config file.");
        }
        NodeList result3 = (NodeList)result2;
        Vector<Node> result = new Vector<Node>();
        int count = result3.getLength();
        for (int i = 0; i < count; ++i) {
            result.add(result3.item(i));
        }
        return result;
    }

    public static class ConfigErrorException
    extends RuntimeException {
        public ConfigErrorException(String msg) {
            super(msg);
            m.err(msg);
        }
    }

    public static class xmlErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException exception) {
            throw new ConfigErrorException("Error validating. Server's file may have a problem.");
        }

        public void fatalError(SAXParseException exception) {
            throw new ConfigErrorException("Error validating; Server's file is probably corrupt.");
        }

        public void warning(SAXParseException exception) {
            m.warn(exception.getMessage());
        }
    }
}

