/*
 * Decompiled with CFR 0.152.
 */
package export3ds;

import export3ds.MeshMatGroup;
import export3ds.Typeid;
import export3ds.check;
import export3ds.tdsobj;
import java.util.Vector;
import shared.IBytedeque;
import shared.ICompilable;
import shared.ShortTriplet;

public class FaceArray
extends tdsobj {
    public short facecount;
    public tdsface[] faces;
    public Vector<MeshMatGroup> mats = new Vector();

    private FaceArray() {
    }

    public static FaceArray createNull() {
        FaceArray result = new FaceArray();
        return result;
    }

    public static FaceArray create(ShortTriplet[] faces, String matname) {
        FaceArray result = new FaceArray();
        result.facecount = check.intToShort(faces.length);
        result.faces = new tdsface[result.facecount];
        for (int i = 0; i < faces.length; ++i) {
            short v1 = faces[i].p;
            short v2 = faces[i].q;
            short v3 = faces[i].r;
            short flags = 0;
            result.faces[i] = new tdsface(v1, v2, v3, flags);
        }
        short[] facesToApplyTo = new short[result.facecount];
        for (int i = 0; i < result.facecount; ++i) {
            facesToApplyTo[i] = (short)i;
        }
        result.mats.add(MeshMatGroup.create(matname, facesToApplyTo));
        return result;
    }

    @Override
    public Typeid type() {
        return Typeid.facearray;
    }

    @Override
    public void innercompile(IBytedeque c) {
        c.writeShort(this.facecount);
        c.writeArray(this.faces);
        c.writeVector(this.mats);
    }

    public static class tdsface
    implements ICompilable {
        short v1;
        short v2;
        short v3;
        short flags;

        public tdsface(short v1, short v2, short v3, short flags) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.flags = flags;
        }

        @Override
        public void compile(IBytedeque c) {
            c.writeShort(this.v1);
            c.writeShort(this.v2);
            c.writeShort(this.v3);
            c.writeShort(this.flags);
        }
    }
}

