/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String directory;
    private String cipherType;
    private byte[] decrypt;
    private byte[] encrypt;

    public static void main(String ... stringArray) throws SQLException {
        new ChangeFileEncryption().runTool(stringArray);
    }

    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        String string3 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dir")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-cipher")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-db")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-decrypt")) {
                cArray = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-encrypt")) {
                cArray2 = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string4);
        }
        if (cArray2 == null && cArray == null || string2 == null) {
            this.showUsage();
            throw new SQLException("Encryption or decryption password not set, or cipher not set");
        }
        try {
            this.process(string, string3, string2, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private static byte[] getFileEncryptionKey(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        SHA256 sHA256 = new SHA256();
        return sHA256.getKeyPasswordHash("file", cArray);
    }

    public static void execute(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        try {
            new ChangeFileEncryption().process(string, string2, string3, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private void process(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        ChangeFileEncryption changeFileEncryption = new ChangeFileEncryption();
        if (cArray2 != null) {
            for (char c : cArray2) {
                if (c != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
        }
        changeFileEncryption.out = this.out;
        changeFileEncryption.directory = string;
        changeFileEncryption.cipherType = string3;
        changeFileEncryption.decrypt = ChangeFileEncryption.getFileEncryptionKey(cArray);
        changeFileEncryption.encrypt = ChangeFileEncryption.getFileEncryptionKey(cArray2);
        Object object = FileLister.getDatabaseFiles(string, string2, true);
        FileLister.tryUnlockDatabase((ArrayList<String>)object, "encryption");
        object = FileLister.getDatabaseFiles(string, string2, false);
        if (((ArrayList)object).size() == 0 && !bl) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = string + "/temp.db";
            IOUtils.delete(string5);
            IOUtils.rename(string4, string5);
            IOUtils.rename(string5, string4);
        }
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string6 = (String)iterator.next();
            if (IOUtils.isDirectory(string6)) continue;
            changeFileEncryption.process(string6);
        }
    }

    private void process(String string) {
        FileStore fileStore = this.decrypt == null ? FileStore.open(null, string, "r") : FileStore.open(null, string, "r", this.cipherType, this.decrypt);
        fileStore.init();
        this.copy(string, fileStore, this.encrypt);
    }

    private void copy(String string, FileStore fileStore, byte[] byArray) {
        long l;
        if (IOUtils.isDirectory(string)) {
            return;
        }
        String string2 = this.directory + "/temp.db";
        IOUtils.delete(string2);
        FileStore fileStore2 = byArray == null ? FileStore.open(null, string2, "rw") : FileStore.open(null, string2, "rw", this.cipherType, byArray);
        fileStore2.init();
        byte[] byArray2 = new byte[4096];
        long l2 = l = fileStore.length() - 48L;
        fileStore.seek(48L);
        fileStore2.seek(48L);
        long l3 = System.currentTimeMillis();
        while (l > 0L) {
            if (System.currentTimeMillis() - l3 > 1000L) {
                this.out.println(string + ": " + (100L - 100L * l / l2) + "%");
                l3 = System.currentTimeMillis();
            }
            int n = (int)Math.min((long)byArray2.length, l);
            fileStore.readFully(byArray2, 0, n);
            fileStore2.write(byArray2, 0, n);
            l -= (long)n;
        }
        fileStore.close();
        fileStore2.close();
        IOUtils.delete(string);
        IOUtils.rename(string2, string);
    }
}

