/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import pythondec.PyObject;
import shared.IBytestream;
import shared.b;

public class PyComplex
extends PyObject {
    byte realn;
    byte[] realrawstr;
    byte imagn;
    byte[] imagrawstr;

    public PyComplex(IBytestream c) {
        this.realn = c.readByte();
        int count = b.ByteToInt32(this.realn);
        this.realrawstr = c.readBytes(count);
        this.imagn = c.readByte();
        count = b.ByteToInt32(this.imagn);
        this.imagrawstr = c.readBytes(count);
    }

    private PyComplex() {
    }

    public String toString() {
        return "PyComplex: " + b.BytesToString(this.realrawstr) + " + i*" + b.BytesToString(this.imagrawstr);
    }

    public String toJavaString() {
        String realstr = b.BytesToString(this.realrawstr);
        String imagstr = b.BytesToString(this.imagrawstr);
        if (realstr.equals("0.0")) {
            return imagstr + "j";
        }
        if (imagstr.equals("0.0")) {
            return "(" + realstr + "+" + imagstr + "j)";
        }
        return "(" + realstr + "+" + imagstr + "j)";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PyComplex)) {
            return false;
        }
        PyComplex o2 = (PyComplex)o;
        if (!b.isEqual(this.realrawstr, o2.realrawstr)) {
            return false;
        }
        return b.isEqual(this.imagrawstr, o2.imagrawstr);
    }

    @Override
    public boolean compare(PyObject o2) {
        return this.equals(o2);
    }
}

