/*
 * Decompiled with CFR 0.152.
 */
package shared.State;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import shared.State.common;
import shared.m;
import shared.nested;

public class LogBoxStateless
extends JTextPane {
    private boolean wordwrap = false;
    private StyledDocument doc;
    Style normalStyle;
    Style warningStyle;
    Style errorStyle;

    public LogBoxStateless() {
        this.Initialize();
    }

    public void ClearAll() {
        super.setText("");
    }

    @Override
    public void setText(String s) {
        this.ClearAll();
        this.append(s);
    }

    public void Alphabetise() {
        String alltext = this.getText();
        String[] lines = alltext.split("\n");
        List<String> list = Arrays.asList(lines);
        Collections.sort(list);
        int linecount = list.size();
        StringBuilder newtext = new StringBuilder();
        for (int i = 0; i < linecount; ++i) {
            newtext.append(list.get(i));
            newtext.append("\n");
        }
        this.setText(newtext.toString());
    }

    public void RemoveDuplicateLines() {
        String alltext = this.getText();
        String[] lines = alltext.split("\n");
        int linecount = lines.length;
        StringBuilder newtext = new StringBuilder();
        for (int i = 0; i < linecount; ++i) {
            String curline = lines[i];
            if (curline == null) continue;
            newtext.append(curline);
            newtext.append("\n");
            for (int j = i + 1; j < linecount; ++j) {
                if (!curline.equals(lines[j])) continue;
                lines[j] = null;
            }
        }
        this.setText(newtext.toString());
    }

    public void append(String s) {
        this.append(s, m.MessageType.normal);
    }

    public void append(String s, m.MessageType type) {
        Style style;
        switch (type) {
            case normal: {
                style = this.normalStyle;
                break;
            }
            case warning: {
                style = this.warningStyle;
                break;
            }
            case error: {
                style = this.errorStyle;
                break;
            }
            case console: {
                style = this.normalStyle;
                break;
            }
            case status: {
                style = this.normalStyle;
                break;
            }
            default: {
                style = this.normalStyle;
            }
        }
        try {
            this.doc.insertString(this.doc.getLength(), s, style);
        }
        catch (BadLocationException e2) {
            throw new nested(e2);
        }
    }

    public void setWordwrap(boolean value) {
        this.wordwrap = value;
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.wordwrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return false;
    }

    private void Initialize() {
        common.addSpecialMenu(null, this);
        this.setEditable(false);
        StyleContext sc = new StyleContext();
        Style defaultStyle = sc.getStyle("default");
        this.normalStyle = sc.addStyle("Normal", defaultStyle);
        this.warningStyle = sc.addStyle("Warning", this.normalStyle);
        Color warningColor = m.warningColor;
        StyleConstants.setForeground(this.warningStyle, warningColor);
        this.errorStyle = sc.addStyle("Error", this.normalStyle);
        Color errorColor = m.errorColor;
        StyleConstants.setForeground(this.errorStyle, errorColor);
        this.doc = this.getStyledDocument();
    }
}

