/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;

public class SanyoMakernoteDescriptor
extends TagDescriptor<SanyoMakernoteDirectory> {
    public SanyoMakernoteDescriptor(@NotNull SanyoMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 513: {
                return this.getSanyoQualityDescription();
            }
            case 514: {
                return this.getMacroDescription();
            }
            case 516: {
                return this.getDigitalZoomDescription();
            }
            case 526: {
                return this.getSequentialShotDescription();
            }
            case 527: {
                return this.getWideRangeDescription();
            }
            case 528: {
                return this.getColorAdjustmentModeDescription();
            }
            case 531: {
                return this.getQuickShotDescription();
            }
            case 532: {
                return this.getSelfTimerDescription();
            }
            case 534: {
                return this.getVoiceMemoDescription();
            }
            case 535: {
                return this.getRecordShutterDescription();
            }
            case 536: {
                return this.getFlickerReduceDescription();
            }
            case 537: {
                return this.getOptimalZoomOnDescription();
            }
            case 539: {
                return this.getDigitalZoomOnDescription();
            }
            case 541: {
                return this.getLightSourceSpecialDescription();
            }
            case 542: {
                return this.getResavedDescription();
            }
            case 543: {
                return this.getSceneSelectDescription();
            }
            case 548: {
                return this.getSequenceShotIntervalDescription();
            }
            case 549: {
                return this.getFlashModeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getSanyoQualityDescription() {
        Integer value = ((SanyoMakernoteDirectory)this._directory).getInteger(513);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal/Very Low";
            }
            case 1: {
                return "Normal/Low";
            }
            case 2: {
                return "Normal/Medium Low";
            }
            case 3: {
                return "Normal/Medium";
            }
            case 4: {
                return "Normal/Medium High";
            }
            case 5: {
                return "Normal/High";
            }
            case 6: {
                return "Normal/Very High";
            }
            case 7: {
                return "Normal/Super High";
            }
            case 256: {
                return "Fine/Very Low";
            }
            case 257: {
                return "Fine/Low";
            }
            case 258: {
                return "Fine/Medium Low";
            }
            case 259: {
                return "Fine/Medium";
            }
            case 260: {
                return "Fine/Medium High";
            }
            case 261: {
                return "Fine/High";
            }
            case 262: {
                return "Fine/Very High";
            }
            case 263: {
                return "Fine/Super High";
            }
            case 512: {
                return "Super Fine/Very Low";
            }
            case 513: {
                return "Super Fine/Low";
            }
            case 514: {
                return "Super Fine/Medium Low";
            }
            case 515: {
                return "Super Fine/Medium";
            }
            case 516: {
                return "Super Fine/Medium High";
            }
            case 517: {
                return "Super Fine/High";
            }
            case 518: {
                return "Super Fine/Very High";
            }
            case 519: {
                return "Super Fine/Super High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    private String getMacroDescription() {
        return this.getIndexedDescription(514, "Normal", "Macro", "View", "Manual");
    }

    @Nullable
    private String getDigitalZoomDescription() {
        return this.getDecimalRational(516, 3);
    }

    @Nullable
    private String getSequentialShotDescription() {
        return this.getIndexedDescription(526, "None", "Standard", "Best", "Adjust Exposure");
    }

    @Nullable
    private String getWideRangeDescription() {
        return this.getIndexedDescription(527, "Off", "On");
    }

    @Nullable
    private String getColorAdjustmentModeDescription() {
        return this.getIndexedDescription(528, "Off", "On");
    }

    @Nullable
    private String getQuickShotDescription() {
        return this.getIndexedDescription(531, "Off", "On");
    }

    @Nullable
    private String getSelfTimerDescription() {
        return this.getIndexedDescription(532, "Off", "On");
    }

    @Nullable
    private String getVoiceMemoDescription() {
        return this.getIndexedDescription(534, "Off", "On");
    }

    @Nullable
    private String getRecordShutterDescription() {
        return this.getIndexedDescription(535, "Record while down", "Press start, press stop");
    }

    @Nullable
    private String getFlickerReduceDescription() {
        return this.getIndexedDescription(536, "Off", "On");
    }

    @Nullable
    private String getOptimalZoomOnDescription() {
        return this.getIndexedDescription(537, "Off", "On");
    }

    @Nullable
    private String getDigitalZoomOnDescription() {
        return this.getIndexedDescription(539, "Off", "On");
    }

    @Nullable
    private String getLightSourceSpecialDescription() {
        return this.getIndexedDescription(541, "Off", "On");
    }

    @Nullable
    private String getResavedDescription() {
        return this.getIndexedDescription(542, "No", "Yes");
    }

    @Nullable
    private String getSceneSelectDescription() {
        return this.getIndexedDescription(543, "Off", "Sport", "TV", "Night", "User 1", "User 2", "Lamp");
    }

    @Nullable
    private String getSequenceShotIntervalDescription() {
        return this.getIndexedDescription(548, "5 frames/sec", "10 frames/sec", "15 frames/sec", "20 frames/sec");
    }

    @Nullable
    private String getFlashModeDescription() {
        return this.getIndexedDescription(549, "Auto", "Force", "Disabled", "Red eye");
    }
}

