/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractTableListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.tools.I18n;

public class MapListEditor
extends AbstractTableListEditor<Map<String, String>> {
    private final transient List<List<String>> dataKeys;
    private final transient List<List<String>> dataValues;
    private final transient List<String> dataLabels;

    public MapListEditor(JComponent gui, PrefEntry entry, MapListSetting setting) {
        super((Component)gui, I18n.tr("Change list of maps setting", new Object[0]), entry);
        List orig = (List)setting.getValue();
        this.dataKeys = new ArrayList<List<String>>();
        this.dataValues = new ArrayList<List<String>>();
        this.dataLabels = new ArrayList<String>();
        if (orig != null) {
            int index = 0;
            for (Map m : orig) {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry e : m.entrySet()) {
                    keys.add((String)e.getKey());
                    values.add((String)e.getValue());
                }
                this.dataKeys.add(keys);
                this.dataValues.add(values);
                this.dataLabels.add(m.getOrDefault("name", I18n.tr("Entry {0}", index + 1)));
                ++index;
            }
        }
    }

    @Override
    public List<Map<String, String>> getData() {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.dataKeys.size(); ++i) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (int j = 0; j < this.dataKeys.get(i).size(); ++j) {
                m.put(this.dataKeys.get(i).get(j), this.dataValues.get(i).get(j));
            }
            data.add(m);
        }
        return data;
    }

    @Override
    protected final JPanel build() {
        this.table.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Key", new Object[0]));
        this.table.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Value", new Object[0]));
        return super.build();
    }

    @Override
    protected final AbstractTableListEditor.AbstractEntryListModel newEntryListModel() {
        return new EntryListModel();
    }

    @Override
    protected final AbstractTableModel newTableModel() {
        return new MapTableModel();
    }

    private final class EntryListModel
    extends AbstractTableListEditor.AbstractEntryListModel {
        private EntryListModel() {
        }

        @Override
        public String getElementAt(int index) {
            return MapListEditor.this.dataLabels.get(index);
        }

        @Override
        public int getSize() {
            return MapListEditor.this.dataKeys.size();
        }

        @Override
        public void add() {
            MapListEditor.this.dataKeys.add(new ArrayList());
            MapListEditor.this.dataValues.add(new ArrayList());
            MapListEditor.this.dataLabels.add("");
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        @Override
        public void remove(int idx) {
            MapListEditor.this.dataKeys.remove(idx);
            MapListEditor.this.dataValues.remove(idx);
            MapListEditor.this.dataLabels.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }
    }

    private final class MapTableModel
    extends AbstractTableModel {
        private MapTableModel() {
        }

        private List<List<String>> data() {
            return MapListEditor.this.entryIdx == null ? Collections.emptyList() : Arrays.asList(MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx), MapListEditor.this.dataValues.get(MapListEditor.this.entryIdx));
        }

        private int size() {
            return MapListEditor.this.entryIdx == null ? 0 : MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx).size();
        }

        @Override
        public int getRowCount() {
            return MapListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? I18n.tr("Key", new Object[0]) : I18n.tr("Value", new Object[0]);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.size() == row ? "" : this.data().get(column).get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == this.size()) {
                this.data().get(0).add("");
                this.data().get(1).add("");
                this.data().get(column).set(row, s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                this.data().get(column).set(row, s);
                this.fireTableCellUpdated(row, column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

