/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.audio;

import java.awt.event.ActionEvent;
import java.io.IOException;
import org.openstreetmap.josm.actions.audio.AbstractAudioAction;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.AudioUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AudioFastSlowAction
extends AbstractAudioAction {
    private double multiplier = Config.getPref().getDouble("audio.fastfwdmultiplier", 1.3);

    public AudioFastSlowAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean fast) {
        super(name, iconName, tooltip, shortcut, true);
        if (!fast) {
            this.multiplier = 1.0 / this.multiplier;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double speed = AudioPlayer.speed();
        if (speed * this.multiplier <= 0.1) {
            return;
        }
        try {
            if (AudioPlayer.playing() || AudioPlayer.paused()) {
                AudioPlayer.play(AudioPlayer.url(), AudioPlayer.position(), speed * this.multiplier);
            }
        }
        catch (IOException | InterruptedException ex) {
            AudioUtil.audioMalfunction(ex);
        }
    }
}

