/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class Layer
extends AbstractMapViewPaintable
implements Destroyable,
ProjectionChangeListener {
    public static final String VISIBLE_PROP = Layer.class.getName() + ".visible";
    public static final String OPACITY_PROP = Layer.class.getName() + ".opacity";
    public static final String NAME_PROP = Layer.class.getName() + ".name";
    public static final String FILTER_STATE_PROP = Layer.class.getName() + ".filterstate";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean visible = true;
    private double opacity = 1.0;
    private boolean background;
    private String name;
    private boolean renamed;
    private File associatedFile;
    private boolean isDestroyed;

    protected Layer(String name) {
        this.setName(name);
    }

    public void hookUpMapView() {
    }

    public abstract Icon getIcon();

    public boolean hasColor() {
        return false;
    }

    public Color getColor() {
        return null;
    }

    public void setColor(Color color) {
    }

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public boolean isInfoResizable() {
        return false;
    }

    public abstract Action[] getMenuEntries();

    @Override
    public synchronized void destroy() {
        if (this.isDestroyed) {
            throw new IllegalStateException("The layer has already been destroyed: " + this);
        }
        this.isDestroyed = true;
    }

    public File getAssociatedFile() {
        return this.associatedFile;
    }

    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = Optional.ofNullable(name).orElse("");
        if (!this.name.equals(oldValue)) {
            this.propertyChangeSupport.firePropertyChange(NAME_PROP, oldValue, this.name);
        }
        this.invalidate();
    }

    public final void rename(String name) {
        this.renamed = true;
        this.setName(name);
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isBackgroundLayer() {
        return this.background;
    }

    public void setBackgroundLayer(boolean background) {
        this.background = background;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.isVisible();
        this.visible = visible;
        if (visible && this.opacity == 0.0) {
            this.setOpacity(1.0);
        } else if (oldValue != this.isVisible()) {
            this.fireVisibleChanged(oldValue, this.isVisible());
        }
    }

    public boolean isVisible() {
        return this.visible && this.opacity != 0.0;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        if (!(opacity >= 0.0) || !(opacity <= 1.0)) {
            throw new IllegalArgumentException("Opacity value must be between 0 and 1");
        }
        double oldOpacity = this.getOpacity();
        boolean oldVisible = this.isVisible();
        this.opacity = opacity;
        if (!Utils.equalsEpsilon(oldOpacity, this.getOpacity())) {
            this.fireOpacityChanged(oldOpacity, this.getOpacity());
        }
        if (oldVisible != this.isVisible()) {
            this.fireVisibleChanged(oldVisible, this.isVisible());
        }
    }

    public void setFilterStateChanged() {
        this.fireFilterStateChanged();
    }

    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireVisibleChanged(boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(VISIBLE_PROP, oldValue, newValue);
    }

    protected void fireOpacityChanged(double oldValue, double newValue) {
        this.propertyChangeSupport.firePropertyChange(OPACITY_PROP, oldValue, newValue);
    }

    protected void fireFilterStateChanged() {
        this.propertyChangeSupport.firePropertyChange(FILTER_STATE_PROP, null, null);
    }

    public boolean isProjectionSupported(Projection proj) {
        return proj != null;
    }

    public String nameSupportedProjections() {
        return I18n.tr("All projections are supported", new Object[0]);
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        if (!this.isProjectionSupported(newValue)) {
            String message = "<html><body><p>" + I18n.tr("The layer {0} does not support the new projection {1}.", Utils.escapeReservedCharactersHTML(this.getName()), newValue.toCode()) + "</p><p style='width: 450px;'>" + I18n.tr("Supported projections are: {0}", this.nameSupportedProjections()) + "</p>" + I18n.tr("Change the projection again or remove the layer.", new Object[0]);
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), message, I18n.tr("Warning", new Object[0]), 2));
        }
    }

    public void onPostLoadFromFile() {
    }

    public boolean isSavable() {
        return false;
    }

    public boolean checkSaveConditions() {
        return true;
    }

    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer", new Object[0]), "lay");
    }

    public LayerPositionStrategy getDefaultLayerPosition() {
        if (this.isBackgroundLayer()) {
            return LayerPositionStrategy.BEFORE_FIRST_BACKGROUND_LAYER;
        }
        return LayerPositionStrategy.AFTER_LAST_VALIDATION_LAYER;
    }

    public ProjectionBounds getViewProjectionBounds() {
        BoundingXYVisitor v = new BoundingXYVisitor();
        this.visitBoundingBox(v);
        return v.getBounds();
    }

    public String getChangesetSourceTag() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", associatedFile=" + this.associatedFile + ']';
    }

    public static class LayerGpxExportAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerGpxExportAction(Layer layer) {
            new ImageProvider("exportgpx").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Export the data to GPX file.", new Object[0]));
            this.putValue("Name", I18n.tr("Export to GPX...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GpxExportAction().export(this.layer);
        }
    }

    public static class LayerSaveAsAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAsAction(Layer layer) {
            new ImageProvider("save_as").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Save the current data to a new file.", new Object[0]));
            this.putValue("Name", I18n.tr("Save As...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveAsAction.getInstance().doSave(this.layer);
        }
    }

    public static class LayerSaveAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAction(Layer layer) {
            new ImageProvider("save").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Save the current data.", new Object[0]));
            this.putValue("Name", I18n.tr("Save", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveAction.getInstance().doSave(this.layer, true);
        }
    }

    public static class SeparatorLayerAction
    extends AbstractAction
    implements LayerAction {
        public static final SeparatorLayerAction INSTANCE = new SeparatorLayerAction();

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Component createMenuComponent() {
            return new JSeparator();
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface MultiLayerAction {
        public Action getMultiLayerAction(List<Layer> var1);
    }

    public static interface LayerAction {
        public boolean supportLayers(List<Layer> var1);

        public Component createMenuComponent();
    }
}

