/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.WordListValidatorTest;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleTest;

public class LanguageSpecificTest {
    private static final Map<String, Integer> idToExpectedMatches = new HashMap<String, Integer>();

    protected void runTests(Language lang) throws IOException {
        this.runTests(lang, null);
    }

    protected void runTests(Language lang, String onlyRunCode) throws IOException {
        new WordListValidatorTest().testWordListValidity(lang);
        this.testNoQuotesAroundSuggestion(lang);
        this.testJavaRules(onlyRunCode);
        this.countTempOffRules(lang);
        try {
            new DisambiguationRuleTest().testDisambiguationRulesFromXML();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testJavaRules(String onlyRunCode) throws IOException {
        HashMap<String, String> idsToClassName = new HashMap<String, String>();
        HashSet<Class> ruleClasses = new HashSet<Class>();
        for (Language language : Languages.getWithDemoLanguage()) {
            if (onlyRunCode != null && !language.getShortCodeWithCountryAndVariant().equals(onlyRunCode)) {
                System.out.println("Skipping " + language);
                continue;
            }
            JLanguageTool lt = new JLanguageTool(language);
            List allRules = lt.getAllRules();
            for (Rule rule : allRules) {
                if (rule instanceof AbstractPatternRule) continue;
                this.assertIdUniqueness(idsToClassName, ruleClasses, language, rule);
                this.assertIdValidity(language, rule);
                Assert.assertTrue((boolean)rule.supportsLanguage(language));
                this.testExamples(rule, lt);
            }
        }
    }

    private void testExampleAvailable(String onlyRunCode) {
        for (Language language : Languages.getWithDemoLanguage()) {
            if (onlyRunCode != null && !language.getShortCodeWithCountryAndVariant().equals(onlyRunCode)) {
                System.out.println("Skipping " + language);
                continue;
            }
            JLanguageTool lt = new JLanguageTool(language);
            List allRules = lt.getAllRules();
            for (Rule rule : allRules) {
                if (rule.getIncorrectExamples().size() != 0) continue;
                System.err.println("*** WARNING: " + language.getShortCodeWithCountryAndVariant() + " rule " + rule.getId() + " has no incorrect examples");
            }
        }
    }

    private void testNoQuotesAroundSuggestion(Language lang) throws IOException {
        if (lang.getShortCode().equals("fa") || lang.getShortCode().equals("zh")) {
            System.out.println("Skipping testNoQuotesAroundSuggestion for " + lang.getName());
            return;
        }
        String dirBase = JLanguageTool.getDataBroker().getRulesDir() + "/" + lang.getShortCode() + "/";
        for (String ruleFileName : lang.getRuleFileNames()) {
            if (ruleFileName.contains("-test-")) continue;
            InputStream is = this.getClass().getResourceAsStream(ruleFileName);
            List rules = new PatternRuleLoader().getRules(is, dirBase + "/" + ruleFileName);
            for (AbstractPatternRule rule : rules) {
                String message = rule.getMessage();
                if (!message.matches(".*['\"\u00ab\u00bb\u201c\u201d\u2019]<suggestion.*") || !message.matches(".*</suggestion>['\"\u00ab\u00bb\u201c\u201d\u2019].*")) continue;
                Assert.fail((String)(lang.getName() + " rule " + rule.getFullId() + " uses quotes around <suggestion>...<suggestion> in its <message>, this should be avoided: '" + message + "'"));
            }
        }
    }

    protected void testDemoText(Language lang, String text, List<String> expectedMatchIds) throws IOException {
        JLanguageTool lt = new JLanguageTool(lang);
        List matches = lt.check(text);
        int i = 0;
        ArrayList<String> actualRuleIds = new ArrayList<String>();
        for (RuleMatch match : matches) {
            actualRuleIds.add(match.getRule().getId());
        }
        if (expectedMatchIds.size() != actualRuleIds.size()) {
            this.failTest(lang, text, expectedMatchIds, actualRuleIds);
        }
        for (String actualRuleId : actualRuleIds) {
            if (!expectedMatchIds.get(i).equals(actualRuleId)) {
                this.failTest(lang, text, expectedMatchIds, actualRuleIds);
            }
            ++i;
        }
    }

    private void failTest(Language lang, String text, List<String> expectedMatchIds, List<String> actualRuleIds) {
        Assert.fail((String)("The website demo text matches for " + lang + " have changed. Demo text:\n" + text + "\nExpected rule matches:\n" + expectedMatchIds + "\nActual rule matches:\n" + actualRuleIds));
    }

    private void assertIdUniqueness(Map<String, String> ids, Set<Class> ruleClasses, Language language, Rule rule) {
        String ruleId = rule.getId();
        if (ids.containsKey(ruleId) && !ruleClasses.contains(rule.getClass())) {
            throw new RuntimeException("Rule id occurs more than once: '" + ruleId + "', one of them " + rule.getClass() + ", the other one " + ids.get(ruleId) + ", language: " + language);
        }
        ids.put(ruleId, rule.getClass().getName());
        ruleClasses.add(rule.getClass());
    }

    private void assertIdValidity(Language language, Rule rule) {
        String ruleId = rule.getId();
        if (!ruleId.matches("^[A-Z_][A-Z0-9_]+$")) {
            throw new RuntimeException("Invalid character in rule id: '" + ruleId + "', language: " + language + ", only [A-Z0-9_] are allowed and the first character must be in [A-Z_]");
        }
    }

    private void testExamples(Rule rule, JLanguageTool lt) throws IOException {
        this.testCorrectExamples(rule, lt);
        this.testIncorrectExamples(rule, lt);
    }

    private void testCorrectExamples(Rule rule, JLanguageTool lt) throws IOException {
        List correctExamples = rule.getCorrectExamples();
        for (CorrectExample correctExample : correctExamples) {
            String input = this.cleanMarkers(correctExample.getExample());
            this.enableOnlyOneRule(lt, rule);
            List ruleMatches = lt.check(input);
            Assert.assertEquals((String)("Got unexpected rule match for correct example sentence:\nText: " + input + "\nRule: " + rule.getId() + "\nMatches: " + ruleMatches), (long)0L, (long)ruleMatches.size());
        }
    }

    private void testIncorrectExamples(Rule rule, JLanguageTool lt) throws IOException {
        List incorrectExamples = rule.getIncorrectExamples();
        for (IncorrectExample incorrectExample : incorrectExamples) {
            String input = this.cleanMarkers(incorrectExample.getExample());
            this.enableOnlyOneRule(lt, rule);
            List ruleMatches = lt.check(input);
            Assert.assertEquals((String)("Did not get the expected rule match for the incorrect example sentence:\nText: " + input + "\nRule: " + rule.getId() + "\nMatches: " + ruleMatches), (long)idToExpectedMatches.getOrDefault(rule.getId(), 1).intValue(), (long)ruleMatches.size());
        }
    }

    private void enableOnlyOneRule(JLanguageTool lt, Rule ruleToActivate) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        lt.enableRule(ruleToActivate.getId());
    }

    private String cleanMarkers(String example) {
        return example.replace("<marker>", "").replace("</marker>", "");
    }

    private void countTempOffRules(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        int count = 0;
        for (Rule rule : lt.getAllRules()) {
            if (!rule.isDefaultTempOff()) continue;
            ++count;
        }
        System.out.println("Number of default='temp_off' rules for " + lang + ": " + count);
        int limit = 10;
        if (count > limit) {
            System.err.println("################################################################################################");
            System.err.println("WARNING: " + count + " default='temp_off' rules for " + lang + ", please make sure to turn on these");
            System.err.println("WARNING: rules after they have been tested (or use default='off' to turn them off permanently)");
            System.err.println("WARNING: (this warning appears if there are more than " + limit + " default='temp_off' rules)");
            System.err.println("################################################################################################");
        }
    }

    static {
        idToExpectedMatches.put("STYLE_REPEATED_WORD_RULE_DE", 2);
    }
}

