/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.io.LineHandler;
import java.io.File;
import java.io.FileFilter;

public class EasyReader {
    String root;
    boolean verbose = true;

    public EasyReader(String root) {
        this.root = root;
    }

    public EasyReader(String root, boolean verbose) {
        this.root = root;
        this.verbose = verbose;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(LineHandler handler, int size) throws Exception {
        File[] files;
        File rootFile = new File(this.root);
        if (rootFile.isDirectory()) {
            files = rootFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && !pathname.getName().endsWith(".bin");
                }
            });
            if (files == null) {
                if (!rootFile.isFile()) return;
                files = new File[]{rootFile};
            }
        } else {
            files = new File[]{rootFile};
        }
        int n = 0;
        int totalAddress = 0;
        long start = System.currentTimeMillis();
        for (File file : files) {
            if (size-- == 0) break;
            if (file.isDirectory()) continue;
            if (this.verbose) {
                System.out.printf("\u6b63\u5728\u5904\u7406%s, %d / %d\n", file.getName(), ++n, files.length);
            }
            IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(file.getAbsolutePath());
            while (lineIterator.hasNext()) {
                ++totalAddress;
                String line = lineIterator.next();
                if (line.length() == 0) continue;
                handler.handle(line);
            }
        }
        handler.done();
        if (!this.verbose) return;
        System.out.printf("\u5904\u7406\u4e86 %.2f \u4e07\u884c\uff0c\u82b1\u8d39\u4e86 %.2f min\n", (double)totalAddress / 10000.0, (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0);
    }

    public void read(LineHandler handler) throws Exception {
        this.read(handler, Integer.MAX_VALUE);
    }
}

