/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.OutputStream;
import java.util.Comparator;
import java.util.Map;
import opennlp.tools.cmdline.FineGrainedReportListener;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.util.SequenceCodec;

public class TokenNameFinderFineGrainedReportListener
extends FineGrainedReportListener
implements TokenNameFinderEvaluationMonitor {
    private SequenceCodec<String> sequenceCodec;

    public TokenNameFinderFineGrainedReportListener(SequenceCodec<String> seqCodec) {
        this(seqCodec, System.err);
    }

    public TokenNameFinderFineGrainedReportListener(SequenceCodec<String> seqCodec, OutputStream outputStream) {
        super(outputStream);
        this.sequenceCodec = seqCodec;
    }

    @Override
    public void missclassified(NameSample reference, NameSample prediction) {
        this.statsAdd(reference, prediction);
    }

    @Override
    public void correctlyClassified(NameSample reference, NameSample prediction) {
        this.statsAdd(reference, prediction);
    }

    private void statsAdd(NameSample reference, NameSample prediction) {
        String[] refTags = this.sequenceCodec.encode(reference.getNames(), reference.getSentence().length);
        String[] predTags = this.sequenceCodec.encode(prediction.getNames(), prediction.getSentence().length);
        this.getStats().add(new String[reference.getSentence().length], refTags, predTags);
    }

    @Override
    public Comparator<String> getMatrixLabelComparator(Map<String, FineGrainedReportListener.ConfusionMatrixLine> confusionMatrix) {
        return new FineGrainedReportListener.GroupedMatrixLabelComparator(confusionMatrix);
    }

    @Override
    public Comparator<String> getLabelComparator(Map<String, FineGrainedReportListener.Counter> map) {
        return new FineGrainedReportListener.GroupedLabelComparator(map);
    }

    @Override
    public void writeReport() {
        this.printGeneralStatistics();
        this.printTagsErrorRank();
        this.printGeneralConfusionTable();
    }
}

