/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.bitext.TabBitextReader;
import org.languagetool.commandline.CommandLineOptions;
import org.languagetool.commandline.CommandLineParser;
import org.languagetool.commandline.CommandLineTools;
import org.languagetool.commandline.UnknownParameterException;
import org.languagetool.commandline.WrongParameterNumberException;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.English;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.rules.Rule;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.tools.JnaTools;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.xml.sax.SAXException;

class Main {
    private final CommandLineOptions options;
    private MultiThreadedJLanguageTool lt;
    private boolean profileRules;
    private boolean bitextMode;
    private MultiThreadedJLanguageTool srcLt;
    private List<BitextRule> bRules;
    private Rule currentRule;

    Main(CommandLineOptions options) throws IOException {
        this.options = options;
        this.profileRules = false;
        this.bitextMode = false;
        this.srcLt = null;
        this.bRules = null;
        this.lt = new MultiThreadedJLanguageTool(options.getLanguage(), options.getMotherTongue());
        this.lt.setCleanOverlappingMatches(false);
        if (options.getRuleFile() != null) {
            this.addExternalRules(options.getRuleFile());
        }
        if (options.getLanguageModel() != null) {
            this.lt.activateLanguageModelRules(options.getLanguageModel());
        }
        if (options.getWord2VecModel() != null) {
            this.lt.activateWord2VecModelRules(options.getWord2VecModel());
        }
        if (options.getNeuralNetworkModel() != null) {
            this.lt.activateNeuralNetworkRules(options.getNeuralNetworkModel());
        }
        this.lt.activateRemoteRules(options.getRemoteRulesFile() != null ? new File(options.getRemoteRulesFile()) : null);
        Tools.selectRules(this.lt, options.getDisabledCategories(), options.getEnabledCategories(), new HashSet<String>(options.getDisabledRules()), new HashSet<String>(options.getEnabledRules()), options.isUseEnabledOnly(), options.isEnableTempOff());
    }

    private void addExternalRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        try (FileInputStream is = new FileInputStream(filename);){
            List<AbstractPatternRule> externalRules = ruleLoader.getRules(is, filename);
            for (AbstractPatternRule externalRule : externalRules) {
                this.lt.addRule(externalRule);
            }
        }
    }

    boolean isSpellCheckingActive() {
        List<Rule> rules = this.lt.getAllActiveRules();
        for (Rule rule : rules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            return true;
        }
        return false;
    }

    JLanguageTool getJLanguageTool() {
        return this.lt;
    }

    private void setListUnknownWords(boolean listUnknownWords) {
        this.lt.setListUnknownWords(listUnknownWords);
    }

    private void cleanUp() {
        if (this.lt != null) {
            this.lt.shutdown();
        }
        if (this.srcLt != null) {
            this.srcLt.shutdown();
        }
        JLanguageTool.removeTemporaryFiles();
    }

    private void setProfilingMode() {
        this.profileRules = true;
    }

    private void setBitextMode(Language sourceLang, List<String> disabledRules, List<String> enabledRules, File bitextRuleFile) throws IOException, ParserConfigurationException, SAXException {
        this.bitextMode = true;
        Language target = this.lt.getLanguage();
        this.lt = new MultiThreadedJLanguageTool(target, null);
        this.srcLt = new MultiThreadedJLanguageTool(sourceLang);
        Tools.selectRules(this.lt, disabledRules, enabledRules, true);
        Tools.selectRules(this.srcLt, disabledRules, enabledRules, true);
        this.bRules = Tools.getBitextRules(sourceLang, this.lt.getLanguage(), bitextRuleFile);
        ArrayList<BitextRule> bRuleList = new ArrayList<BitextRule>(this.bRules);
        for (BitextRule bitextRule : this.bRules) {
            for (String disabledRule : disabledRules) {
                if (!bitextRule.getId().equals(disabledRule)) continue;
                bRuleList.remove(bitextRule);
            }
        }
        this.bRules = bRuleList;
        if (enabledRules.size() > 0) {
            bRuleList = new ArrayList();
            for (String enabledRule : enabledRules) {
                for (BitextRule bitextRule : this.bRules) {
                    if (!bitextRule.getId().equals(enabledRule)) continue;
                    bRuleList.add(bitextRule);
                }
            }
            this.bRules = bRuleList;
        }
    }

    private void runOnFile(String filename, String encoding, boolean xmlFiltering) throws IOException {
        if (this.bitextMode) {
            TabBitextReader reader = new TabBitextReader(filename, encoding);
            if (this.options.isApplySuggestions()) {
                CommandLineTools.correctBitext(reader, this.srcLt, this.lt, this.bRules);
            } else {
                CommandLineTools.checkBitext(reader, this.srcLt, this.lt, this.bRules, this.options.isXmlFormat());
            }
        } else {
            String text = this.getFilteredText(filename, encoding, xmlFiltering);
            if (this.isStdIn(filename)) {
                System.err.println("Working on STDIN...");
            } else {
                System.err.println("Working on " + filename + "...");
            }
            if (this.options.isAutoDetect()) {
                Language language = this.detectLanguageOfString(text);
                if (language == null) {
                    System.err.println("Could not detect language well enough, using American English");
                    language = new AmericanEnglish();
                }
                this.changeLanguage(language, this.options.getMotherTongue(), this.options.getDisabledRules(), this.options.getEnabledRules());
                System.err.println("Using " + language.getName() + " for file " + filename);
            }
            if (this.options.isApplySuggestions()) {
                System.out.print(Tools.correctText(text, this.lt));
            } else if (this.profileRules) {
                CommandLineTools.profileRulesOnText(text, this.lt);
            } else if (!this.options.isTaggerOnly()) {
                CommandLineTools.checkText(text, this.lt, this.options.isXmlFormat(), this.options.isJsonFormat(), 0, this.options.getLevel(), this.options.isListUnknown());
            } else {
                CommandLineTools.tagText(text, this.lt);
            }
            if (this.options.isListUnknown() && !this.options.isXmlFormat() && !this.options.isJsonFormat()) {
                System.out.println("Unknown words: " + this.lt.getUnknownWords());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnFileLineByLine(String filename, String encoding, JLanguageTool.Level level) throws IOException {
        System.err.println("Warning: running in line by line mode. Cross-paragraph checks will not work.\n");
        if (this.options.isVerbose()) {
            this.lt.setOutput(System.err);
        }
        if (!this.options.isXmlFormat() && !this.options.isApplySuggestions()) {
            if (this.isStdIn(filename)) {
                System.err.println("Working on STDIN...");
            } else {
                System.err.println("Working on " + filename + "...");
            }
        }
        if (this.profileRules && this.isStdIn(filename)) {
            throw new IllegalArgumentException("Profiling mode cannot be used with input from STDIN");
        }
        int runCount = 1;
        List<Rule> rules = this.lt.getAllActiveRules();
        if (this.profileRules) {
            System.out.printf("Testing %d rules\n", rules.size());
            System.out.println("Rule ID\tTime\tSentences\tMatches\tSentences per sec.");
            runCount = rules.size();
        }
        int lineOffset = 0;
        int tmpLineOffset = 0;
        this.handleLine(StringTools.ApiPrintMode.START_API, 0, new StringBuilder(), level);
        StringBuilder sb = new StringBuilder();
        for (int ruleIndex = 0; !rules.isEmpty() && ruleIndex < runCount; ++ruleIndex) {
            this.currentRule = rules.get(ruleIndex);
            try (InputStreamReader isr = this.getInputStreamReader(filename, encoding);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                int lineCount = 0;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    if (++lineCount == 1 && this.options.isAutoDetect()) {
                        Language language = this.detectLanguageOfString(line);
                        if (language == null) {
                            System.err.println("Could not detect language well enough, using American English");
                            language = new AmericanEnglish();
                        }
                        System.err.println("Language used is: " + language.getName());
                        language.getSentenceTokenizer().setSingleLineBreaksMarksParagraph(this.options.isSingleLineBreakMarksParagraph());
                        this.changeLanguage(language, this.options.getMotherTongue(), this.options.getDisabledRules(), this.options.getEnabledRules());
                    }
                    sb.append('\n');
                    ++tmpLineOffset;
                    if (!this.isBreakPoint(line)) continue;
                    this.handleLine(StringTools.ApiPrintMode.CONTINUE_API, lineOffset, sb, level);
                    if (this.profileRules) {
                        this.lt.sentenceTokenize(sb.toString()).size();
                    }
                    sb = new StringBuilder();
                    lineOffset = tmpLineOffset;
                }
                continue;
            }
            finally {
                if (sb.length() > 0 && this.profileRules) {
                    this.lt.sentenceTokenize(sb.toString()).size();
                }
                this.handleLine(StringTools.ApiPrintMode.END_API, tmpLineOffset - 1, sb, level);
            }
        }
    }

    private void handleLine(StringTools.ApiPrintMode mode, int lineOffset, StringBuilder sb, JLanguageTool.Level level) throws IOException {
        int matches = 0;
        String s = StringTools.filterXML(sb.toString());
        if (this.options.isApplySuggestions()) {
            System.out.print(Tools.correctText(s, this.lt));
        } else if (this.profileRules) {
            Tools.profileRulesOnLine(s, this.lt, this.currentRule);
        } else if (!this.options.isTaggerOnly()) {
            CommandLineTools.checkText(s, this.lt, this.options.isXmlFormat(), this.options.isJsonFormat(), -1, lineOffset, matches, mode, this.options.isListUnknown(), level, Collections.emptyList());
        } else {
            CommandLineTools.tagText(s, this.lt);
        }
    }

    private boolean isBreakPoint(String line) {
        return this.lt.getLanguage().getSentenceTokenizer().singleLineBreaksMarksPara() || "".equals(line);
    }

    private InputStreamReader getInputStreamReader(String filename, String encoding) throws IOException {
        String charsetName = encoding != null ? encoding : Charset.defaultCharset().name();
        InputStream is = System.in;
        if (!this.isStdIn(filename)) {
            is = new FileInputStream(new File(filename));
            BOMInputStream bomIn = new BOMInputStream(is, true, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE);
            if (bomIn.hasBOM() && encoding == null) {
                charsetName = bomIn.getBOMCharsetName();
            }
            is = bomIn;
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(is), charsetName);
    }

    private boolean isStdIn(String filename) {
        return "-".equals(filename);
    }

    private void runRecursive(String filename, String encoding, boolean xmlFiltering, JLanguageTool.Level level) {
        File dir = new File(filename);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory, cannot use recursion");
        }
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    this.runRecursive(file.getAbsolutePath(), encoding, xmlFiltering, level);
                    continue;
                }
                if (this.options.isLineByLine()) {
                    this.runOnFileLineByLine(file.getAbsolutePath(), encoding, level);
                    continue;
                }
                this.runOnFile(file.getAbsolutePath(), encoding, xmlFiltering);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not check text in file " + file, e);
            }
        }
    }

    private String getFilteredText(String filename, String encoding, boolean xmlFiltering) throws IOException {
        if (this.options.isVerbose()) {
            this.lt.setOutput(System.err);
        }
        try (InputStreamReader reader = this.getInputStreamReader(filename, encoding);){
            String fileContents = StringTools.readerToString(reader);
            if (xmlFiltering) {
                String string = StringTools.filterXML(fileContents);
                return string;
            }
            String string = fileContents;
            return string;
        }
    }

    private void changeLanguage(Language language, Language motherTongue, List<String> disabledRules, List<String> enabledRules) {
        try {
            this.lt = new MultiThreadedJLanguageTool(language, motherTongue);
            Tools.selectRules(this.lt, disabledRules, enabledRules, true);
            if (this.options.isVerbose()) {
                this.lt.setOutput(System.err);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create LanguageTool instance for language " + language, e);
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        JnaTools.setBugWorkaroundProperty();
        CommandLineParser commandLineParser = new CommandLineParser();
        CommandLineOptions options = null;
        try {
            options = commandLineParser.parseOptions(args);
        }
        catch (WrongParameterNumberException e) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (UnknownParameterException e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                System.err.println(e);
            }
            commandLineParser.printUsage(System.err);
            System.exit(1);
        }
        if (options.isPrintUsage()) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        if (options.isPrintVersion()) {
            System.out.println("LanguageTool version 5.2 (" + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID + ")");
            System.exit(0);
        }
        if (options.isPrintLanguages()) {
            Main.printLanguages();
            System.exit(0);
        }
        if (options.getFilename() == null) {
            options.setFilename("-");
        }
        String languageHint = null;
        if (options.getLanguage() == null) {
            if (!options.isXmlFormat() && !options.isAutoDetect()) {
                System.err.println("No language specified, using English (no spell checking active, specify a language variant like 'en-GB' if available)");
            }
            options.setLanguage((Language)new English());
        } else if (!options.isXmlFormat() && !options.isApplySuggestions()) {
            languageHint = "Expected text language: " + options.getLanguage().getName();
        }
        options.getLanguage().getSentenceTokenizer().setSingleLineBreaksMarksParagraph(options.isSingleLineBreakMarksParagraph());
        Main prg = new Main(options);
        if (options.getFalseFriendFile() != null) {
            List<AbstractPatternRule> ffRules = prg.lt.loadFalseFriendRules(options.getFalseFriendFile());
            for (AbstractPatternRule ffRule : ffRules) {
                prg.lt.addRule(ffRule);
            }
        }
        if (prg.lt.getAllActiveRules().isEmpty()) {
            List catIds = options.getEnabledCategories().stream().map(i -> i.toString()).collect(Collectors.toList());
            throw new RuntimeException("No rules are active. Please make sure your rule ids (" + options.getEnabledRules() + ") and category ids (" + catIds + ") are correct");
        }
        if (languageHint != null) {
            String spellHint = "";
            if (!prg.isSpellCheckingActive()) {
                spellHint = prg.lt.getLanguage().isVariant() ? " (no spell checking active)" : " (no spell checking active, specify a language variant like 'en-GB' if available)";
            }
            System.err.println(languageHint + spellHint);
        }
        prg.setListUnknownWords(options.isListUnknown());
        if (options.isProfile()) {
            prg.setProfilingMode();
        }
        if (options.isBitext()) {
            if (options.getMotherTongue() == null) {
                throw new IllegalArgumentException("You have to set the source language (as mother tongue) in bitext mode");
            }
            File bitextRuleFile = options.getBitextRuleFile() != null ? new File(options.getBitextRuleFile()) : null;
            prg.setBitextMode(options.getMotherTongue(), options.getDisabledRules(), options.getEnabledRules(), bitextRuleFile);
        }
        if (options.isRecursive()) {
            prg.runRecursive(options.getFilename(), options.getEncoding(), options.isXmlFiltering(), options.getLevel());
        } else if (options.isLineByLine()) {
            prg.runOnFileLineByLine(options.getFilename(), options.getEncoding(), options.getLevel());
        } else {
            prg.runOnFile(options.getFilename(), options.getEncoding(), options.isXmlFiltering());
        }
        prg.cleanUp();
    }

    private static void printLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (Language language : Languages.get()) {
            languages.add(language.getShortCodeWithCountryAndVariant() + " " + language.getName());
        }
        Collections.sort(languages);
        for (String s : languages) {
            System.out.println(s);
        }
    }

    private Language detectLanguageOfString(String text) {
        LanguageIdentifier identifier = new LanguageIdentifier();
        identifier.enableFasttext(this.options.getFasttextBinary(), this.options.getFasttextModel());
        return identifier.detectLanguage(text);
    }
}

