/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;

public class Configuration {
    public static final short UNDERLINE_WAVE = 10;
    public static final short UNDERLINE_BOLDWAVE = 18;
    public static final short UNDERLINE_BOLD = 12;
    public static final short UNDERLINE_DASH = 5;
    static final int DEFAULT_SERVER_PORT = 8081;
    static final int DEFAULT_NUM_CHECK_PARAS = -1;
    static final int FONT_STYLE_INVALID = -1;
    static final int FONT_SIZE_INVALID = -1;
    static final boolean DEFAULT_DO_RESET = false;
    static final boolean DEFAULT_MULTI_THREAD = false;
    static final boolean DEFAULT_NO_BACKGROUND_CHECK = false;
    static final boolean DEFAULT_USE_QUEUE = true;
    static final boolean DEFAULT_USE_DOC_LANGUAGE = true;
    static final boolean DEFAULT_DO_REMOTE_CHECK = false;
    static final boolean DEFAULT_USE_OTHER_SERVER = false;
    static final boolean DEFAULT_MARK_SINGLE_CHAR_BOLD = false;
    static final boolean DEFAULT_USE_LT_DICTIONARY = true;
    static final boolean DEFAULT_NO_SYNONYMS_AS_SUGGESTIONS = true;
    static final boolean DEFAULT_SAVE_LO_CACHE = true;
    static final Color STYLE_COLOR = new Color(0, 175, 0);
    private static final String CONFIG_FILE = ".languagetool.cfg";
    private static final String CURRENT_PROFILE_KEY = "currentProfile";
    private static final String DEFINED_PROFILES_KEY = "definedProfiles";
    private static final String DISABLED_RULES_KEY = "disabledRules";
    private static final String ENABLED_RULES_KEY = "enabledRules";
    private static final String DISABLED_CATEGORIES_KEY = "disabledCategories";
    private static final String ENABLED_CATEGORIES_KEY = "enabledCategories";
    private static final String ENABLED_RULES_ONLY_KEY = "enabledRulesOnly";
    private static final String LANGUAGE_KEY = "language";
    private static final String MOTHER_TONGUE_KEY = "motherTongue";
    private static final String FIXED_LANGUAGE_KEY = "fixedLanguage";
    private static final String NGRAM_DIR_KEY = "ngramDir";
    private static final String WORD2VEC_DIR_KEY = "word2vecDir";
    private static final String AUTO_DETECT_KEY = "autoDetect";
    private static final String TAGGER_SHOWS_DISAMBIG_LOG_KEY = "taggerShowsDisambigLog";
    private static final String SERVER_RUN_KEY = "serverMode";
    private static final String SERVER_PORT_KEY = "serverPort";
    private static final String NO_DEFAULT_CHECK_KEY = "noDefaultCheck";
    private static final String PARA_CHECK_KEY = "numberParagraphs";
    private static final String RESET_CHECK_KEY = "doResetCheck";
    private static final String USE_QUEUE_KEY = "useTextLevelQueue";
    private static final String NO_BACKGROUND_CHECK_KEY = "noBackgroundCheck";
    private static final String USE_DOC_LANG_KEY = "useDocumentLanguage";
    private static final String USE_GUI_KEY = "useGUIConfig";
    private static final String FONT_NAME_KEY = "font.name";
    private static final String FONT_STYLE_KEY = "font.style";
    private static final String FONT_SIZE_KEY = "font.size";
    private static final String LF_NAME_KEY = "lookAndFeelName";
    private static final String ERROR_COLORS_KEY = "errorColors";
    private static final String UNDERLINE_COLORS_KEY = "underlineColors";
    private static final String UNDERLINE_RULE_COLORS_KEY = "underlineRuleColors";
    private static final String UNDERLINE_TYPES_KEY = "underlineTypes";
    private static final String UNDERLINE_RULE_TYPES_KEY = "underlineRuleTypes";
    private static final String CONFIGURABLE_RULE_VALUES_KEY = "configurableRuleValues";
    private static final String LT_SWITCHED_OFF_KEY = "ltSwitchedOff";
    private static final String IS_MULTI_THREAD_LO_KEY = "isMultiThread";
    private static final String EXTERNAL_RULE_DIRECTORY = "extRulesDirectory";
    private static final String DO_REMOTE_CHECK_KEY = "doRemoteCheck";
    private static final String OTHER_SERVER_URL_KEY = "otherServerUrl";
    private static final String USE_OTHER_SERVER_KEY = "useOtherServer";
    private static final String MARK_SINGLE_CHAR_BOLD_KEY = "markSingleCharBold";
    private static final String LOG_LEVEL_KEY = "logLevel";
    private static final String USE_LT_DICTIONARY_KEY = "UseLtDictionary";
    private static final String NO_SYNONYMS_AS_SUGGESTIONS_KEY = "noSynonymsAsSuggestions";
    private static final String SAVE_LO_CACHE_KEY = "saveLoCache";
    private static final String LT_VERSION_KEY = "ltVersion";
    private static final String DELIMITER = ",";
    private static final String COLOR_SPLITTER_REGEXP = "(?<=:#[0-9A-Fa-f]{6}),\\s*";
    private static final String COLOR_SPLITTER_REGEXP_COLON = ":(?=#[0-9A-Fa-f]{6})";
    private static final String CONFIGURABLE_RULE_SPLITTER_REGEXP = "(?<=[0-9]),\\s*";
    private static final String BLANK = "[ \t]";
    private static final String BLANK_REPLACE = "_";
    private static final String PROFILE_DELIMITER = "__";
    private final Map<String, String> configForOtherProfiles = new HashMap<String, String>();
    private final Map<String, String> configForOtherLanguages = new HashMap<String, String>();
    private final Map<ITSIssueType, Color> errorColors = new EnumMap<ITSIssueType, Color>(ITSIssueType.class);
    private final Map<String, Color> underlineColors = new HashMap<String, Color>();
    private final Map<String, Color> underlineRuleColors = new HashMap<String, Color>();
    private final Map<String, Short> underlineTypes = new HashMap<String, Short>();
    private final Map<String, Short> underlineRuleTypes = new HashMap<String, Short>();
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();
    private final Set<String> styleLikeCategories = new HashSet<String>();
    private final Map<String, String> specialTabCategories = new HashMap<String, String>();
    private Set<String> disabledRuleIds = new HashSet<String>();
    private Set<String> enabledRuleIds = new HashSet<String>();
    private Set<String> disabledCategoryNames = new HashSet<String>();
    private Set<String> enabledCategoryNames = new HashSet<String>();
    private List<String> definedProfiles = new ArrayList<String>();
    private List<String> allProfileKeys = new ArrayList<String>();
    private List<String> allProfileLangKeys = new ArrayList<String>();
    private Language lang;
    private File configFile;
    private File oldConfigFile;
    private boolean enabledRulesOnly = false;
    private Language language;
    private Language motherTongue = null;
    private Language fixedLanguage = null;
    private File ngramDirectory;
    private File word2vecDirectory;
    private boolean runServer;
    private boolean autoDetect;
    private boolean taggerShowsDisambigLog;
    private boolean guiConfig;
    private String fontName;
    private int fontStyle = -1;
    private int fontSize = -1;
    private int serverPort = 8081;
    private int numParasToCheck = -1;
    private boolean doResetCheck = false;
    private boolean isMultiThreadLO = false;
    private boolean noBackgroundCheck = false;
    private boolean useTextLevelQueue = true;
    private boolean useDocLanguage = true;
    private boolean doRemoteCheck = false;
    private boolean useOtherServer = false;
    private boolean markSingleCharBold = false;
    private boolean useLtDictionary = true;
    private boolean noSynonymsAsSuggestions = true;
    private boolean saveLoCache = true;
    private String externalRuleDirectory;
    private String lookAndFeelName;
    private String currentProfile = null;
    private String otherServerUrl = null;
    private String logLevel = null;
    private String ltVersion = null;
    private boolean switchOff = false;
    private boolean isOffice = false;
    private boolean isOpenOffice = false;

    public Configuration(Language lang) throws IOException {
        this(new File(System.getProperty("user.home")), CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, Language lang) throws IOException {
        this(baseDir, CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, String filename, Language lang) throws IOException {
        this(baseDir, filename, null, lang, false);
    }

    public Configuration(File baseDir, String filename, File oldConfigFile, Language lang, boolean isOffice) throws IOException {
        this.initOptions();
        this.lang = lang;
        this.isOffice = isOffice;
        this.isOpenOffice = isOffice && filename.contains("ooo");
        this.configFile = new File(baseDir, filename);
        this.oldConfigFile = oldConfigFile;
        this.setAllProfileKeys();
        this.loadConfiguration();
    }

    private Configuration() {
        this.lang = null;
    }

    public void initOptions() {
        this.configForOtherLanguages.clear();
        this.underlineColors.clear();
        this.underlineRuleColors.clear();
        this.underlineTypes.clear();
        this.underlineRuleTypes.clear();
        this.configurableRuleValues.clear();
        this.disabledRuleIds.clear();
        this.enabledRuleIds.clear();
        this.disabledCategoryNames.clear();
        this.enabledCategoryNames.clear();
        this.definedProfiles.clear();
        this.enabledRulesOnly = false;
        this.ngramDirectory = null;
        this.word2vecDirectory = null;
        this.runServer = false;
        this.autoDetect = false;
        this.taggerShowsDisambigLog = false;
        this.guiConfig = false;
        this.fontName = null;
        this.fontStyle = -1;
        this.fontSize = -1;
        this.serverPort = 8081;
        this.numParasToCheck = -1;
        this.doResetCheck = false;
        this.isMultiThreadLO = false;
        this.noBackgroundCheck = false;
        this.useTextLevelQueue = true;
        this.useDocLanguage = true;
        this.doRemoteCheck = false;
        this.useOtherServer = false;
        this.markSingleCharBold = false;
        this.useLtDictionary = true;
        this.noSynonymsAsSuggestions = true;
        this.saveLoCache = true;
        this.externalRuleDirectory = null;
        this.lookAndFeelName = null;
        this.currentProfile = null;
        this.otherServerUrl = null;
        this.logLevel = null;
        this.switchOff = false;
    }

    Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration();
        copy.restoreState(configuration);
        return copy;
    }

    void restoreState(Configuration configuration) {
        this.configFile = configuration.configFile;
        this.language = configuration.language;
        this.lang = configuration.lang;
        this.motherTongue = configuration.motherTongue;
        this.fixedLanguage = configuration.fixedLanguage;
        this.ngramDirectory = configuration.ngramDirectory;
        this.word2vecDirectory = configuration.word2vecDirectory;
        this.runServer = configuration.runServer;
        this.autoDetect = configuration.autoDetect;
        this.taggerShowsDisambigLog = configuration.taggerShowsDisambigLog;
        this.guiConfig = configuration.guiConfig;
        this.fontName = configuration.fontName;
        this.fontStyle = configuration.fontStyle;
        this.fontSize = configuration.fontSize;
        this.serverPort = configuration.serverPort;
        this.numParasToCheck = configuration.numParasToCheck;
        this.doResetCheck = configuration.doResetCheck;
        this.useTextLevelQueue = configuration.useTextLevelQueue;
        this.noBackgroundCheck = configuration.noBackgroundCheck;
        this.isMultiThreadLO = configuration.isMultiThreadLO;
        this.useDocLanguage = configuration.useDocLanguage;
        this.lookAndFeelName = configuration.lookAndFeelName;
        this.externalRuleDirectory = configuration.externalRuleDirectory;
        this.currentProfile = configuration.currentProfile;
        this.doRemoteCheck = configuration.doRemoteCheck;
        this.useOtherServer = configuration.useOtherServer;
        this.markSingleCharBold = configuration.markSingleCharBold;
        this.useLtDictionary = configuration.useLtDictionary;
        this.noSynonymsAsSuggestions = configuration.noSynonymsAsSuggestions;
        this.saveLoCache = configuration.saveLoCache;
        this.otherServerUrl = configuration.otherServerUrl;
        this.logLevel = configuration.logLevel;
        this.isOffice = configuration.isOffice;
        this.isOpenOffice = configuration.isOpenOffice;
        this.ltVersion = configuration.ltVersion;
        this.disabledRuleIds.clear();
        this.disabledRuleIds.addAll(configuration.disabledRuleIds);
        this.enabledRuleIds.clear();
        this.enabledRuleIds.addAll(configuration.enabledRuleIds);
        this.disabledCategoryNames.clear();
        this.disabledCategoryNames.addAll(configuration.disabledCategoryNames);
        this.enabledCategoryNames.clear();
        this.enabledCategoryNames.addAll(configuration.enabledCategoryNames);
        this.configForOtherLanguages.clear();
        for (String string : configuration.configForOtherLanguages.keySet()) {
            this.configForOtherLanguages.put(string, configuration.configForOtherLanguages.get(string));
        }
        this.underlineColors.clear();
        for (Map.Entry entry : configuration.underlineColors.entrySet()) {
            this.underlineColors.put((String)entry.getKey(), (Color)entry.getValue());
        }
        this.underlineRuleColors.clear();
        for (Map.Entry entry : configuration.underlineRuleColors.entrySet()) {
            this.underlineRuleColors.put((String)entry.getKey(), (Color)entry.getValue());
        }
        this.underlineTypes.clear();
        for (Map.Entry entry : configuration.underlineTypes.entrySet()) {
            this.underlineTypes.put((String)entry.getKey(), (Short)entry.getValue());
        }
        this.underlineRuleTypes.clear();
        for (Map.Entry entry : configuration.underlineRuleTypes.entrySet()) {
            this.underlineRuleTypes.put((String)entry.getKey(), (Short)entry.getValue());
        }
        this.configurableRuleValues.clear();
        for (Map.Entry entry : configuration.configurableRuleValues.entrySet()) {
            this.configurableRuleValues.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        this.styleLikeCategories.clear();
        this.styleLikeCategories.addAll(configuration.styleLikeCategories);
        this.specialTabCategories.clear();
        for (Map.Entry entry : configuration.specialTabCategories.entrySet()) {
            this.specialTabCategories.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.definedProfiles.clear();
        this.definedProfiles.addAll(configuration.definedProfiles);
        this.allProfileLangKeys.clear();
        this.allProfileLangKeys.addAll(configuration.allProfileLangKeys);
        this.allProfileKeys.clear();
        this.allProfileKeys.addAll(configuration.allProfileKeys);
        this.configForOtherProfiles.clear();
        for (Map.Entry entry : configuration.configForOtherProfiles.entrySet()) {
            this.configForOtherProfiles.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public Set<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public Set<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public Set<String> getDisabledCategoryNames() {
        return this.disabledCategoryNames;
    }

    public Set<String> getEnabledCategoryNames() {
        return this.enabledCategoryNames;
    }

    public void setDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds = ruleIds;
        this.enabledRuleIds.removeAll(ruleIds);
    }

    public void addDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds.addAll(ruleIds);
        this.enabledRuleIds.removeAll(ruleIds);
    }

    public void removeDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds.removeAll(ruleIds);
        this.enabledRuleIds.addAll(ruleIds);
    }

    public void setEnabledRuleIds(Set<String> ruleIds) {
        this.enabledRuleIds = ruleIds;
    }

    public void setDisabledCategoryNames(Set<String> categoryNames) {
        this.disabledCategoryNames = categoryNames;
    }

    public void setEnabledCategoryNames(Set<String> categoryNames) {
        this.enabledCategoryNames = categoryNames;
    }

    public boolean getEnabledRulesOnly() {
        return this.enabledRulesOnly;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Language getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    public Language getFixedLanguage() {
        return this.fixedLanguage;
    }

    public void setFixedLanguage(Language fixedLanguage) {
        this.fixedLanguage = fixedLanguage;
    }

    public Language getDefaultLanguage() {
        if (this.useDocLanguage) {
            return null;
        }
        return this.fixedLanguage;
    }

    public void setUseDocLanguage(boolean useDocLang) {
        this.useDocLanguage = useDocLang;
    }

    public boolean getUseDocLanguage() {
        return this.useDocLanguage;
    }

    public boolean getAutoDetect() {
        return this.autoDetect;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    public void setRemoteCheck(boolean doRemoteCheck) {
        this.doRemoteCheck = doRemoteCheck;
    }

    public boolean doRemoteCheck() {
        return this.doRemoteCheck;
    }

    public void setUseOtherServer(boolean useOtherServer) {
        this.useOtherServer = useOtherServer;
    }

    public boolean useOtherServer() {
        return this.useOtherServer;
    }

    public void setOtherServerUrl(String otherServerUrl) {
        this.otherServerUrl = otherServerUrl;
    }

    public String getServerUrl() {
        return this.useOtherServer ? this.otherServerUrl : null;
    }

    public String getlogLevel() {
        return this.logLevel;
    }

    public void setMarkSingleCharBold(boolean markSingleCharBold) {
        this.markSingleCharBold = markSingleCharBold;
    }

    public boolean markSingleCharBold() {
        return this.markSingleCharBold;
    }

    public void setUseLtDictionary(boolean useLtDictionary) {
        this.useLtDictionary = useLtDictionary;
    }

    public boolean useLtDictionary() {
        return this.useLtDictionary;
    }

    public void setNoSynonymsAsSuggestions(boolean noSynonymsAsSuggestions) {
        this.noSynonymsAsSuggestions = noSynonymsAsSuggestions;
    }

    public boolean noSynonymsAsSuggestions() {
        return this.noSynonymsAsSuggestions;
    }

    public void setSaveLoCache(boolean saveLoCache) {
        this.saveLoCache = saveLoCache;
    }

    public boolean saveLoCache() {
        return this.saveLoCache;
    }

    public boolean getTaggerShowsDisambigLog() {
        return this.taggerShowsDisambigLog;
    }

    public void setTaggerShowsDisambigLog(boolean taggerShowsDisambigLog) {
        this.taggerShowsDisambigLog = taggerShowsDisambigLog;
    }

    public boolean getRunServer() {
        return this.runServer;
    }

    public void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setUseGUIConfig(boolean useGUIConfig) {
        this.guiConfig = useGUIConfig;
    }

    public boolean getUseGUIConfig() {
        return this.guiConfig;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getExternalRuleDirectory() {
        return this.externalRuleDirectory;
    }

    public void setExternalRuleDirectory(String path) {
        this.externalRuleDirectory = path;
    }

    public int getNumParasToCheck() {
        return this.numParasToCheck;
    }

    public void setNumParasToCheck(int numParas) {
        this.numParasToCheck = numParas;
    }

    public boolean isResetCheck() {
        return this.doResetCheck;
    }

    public void setDoResetCheck(boolean resetCheck) {
        this.doResetCheck = resetCheck;
    }

    public boolean useTextLevelQueue() {
        return this.useTextLevelQueue;
    }

    public void setUseTextLevelQueue(boolean useTextLevelQueue) {
        this.useTextLevelQueue = useTextLevelQueue;
    }

    public void setNoBackgroundCheck(boolean noBackgroundCheck) {
        this.noBackgroundCheck = noBackgroundCheck;
    }

    public void saveNoBackgroundCheck(boolean noBackgroundCheck, Language lang) throws IOException {
        this.noBackgroundCheck = noBackgroundCheck;
        this.saveConfiguration(lang);
    }

    public boolean noBackgroundCheck() {
        return this.noBackgroundCheck;
    }

    public String getCurrentProfile() {
        return this.currentProfile;
    }

    public void setCurrentProfile(String profile) {
        this.currentProfile = profile;
    }

    public List<String> getDefinedProfiles() {
        return this.definedProfiles;
    }

    public void addProfile(String profile) {
        this.definedProfiles.add(profile);
    }

    public void addProfiles(List<String> profiles) {
        this.definedProfiles.clear();
        this.definedProfiles.addAll(profiles);
    }

    public void removeProfile(String profile) {
        this.definedProfiles.remove(profile);
    }

    public void setMultiThreadLO(boolean isMultiThread) {
        this.isMultiThreadLO = isMultiThread;
    }

    public boolean isMultiThread() {
        return this.isMultiThreadLO;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        this.lookAndFeelName = lookAndFeelName;
    }

    @Nullable
    public File getNgramDirectory() {
        return this.ngramDirectory;
    }

    public void setNgramDirectory(File dir) {
        this.ngramDirectory = dir;
    }

    @Nullable
    public File getWord2VecDirectory() {
        return this.word2vecDirectory;
    }

    public void setWord2VecDirectory(File dir) {
        this.word2vecDirectory = dir;
    }

    public Map<ITSIssueType, Color> getErrorColors() {
        return this.errorColors;
    }

    public boolean isStyleCategory(String category) {
        return this.styleLikeCategories.contains(category);
    }

    public void initStyleCategories(List<Rule> allRules) {
        for (Rule rule : allRules) {
            if (rule.getCategory().getTabName() != null && !this.specialTabCategories.containsKey(rule.getCategory().getName())) {
                this.specialTabCategories.put(rule.getCategory().getName(), rule.getCategory().getTabName());
            }
            if (!rule.getLocQualityIssueType().toString().equalsIgnoreCase("STYLE") && !rule.getLocQualityIssueType().toString().equalsIgnoreCase("REGISTER") && !rule.getCategory().getId().toString().equals("STYLE") && !rule.getCategory().getId().toString().equals("TYPOGRAPHY")) continue;
            this.styleLikeCategories.add(rule.getCategory().getName());
        }
    }

    public boolean isSpecialTabCategory(String category) {
        return this.specialTabCategories.containsKey(category);
    }

    public boolean isInSpecialTab(String category, String tabName) {
        if (this.specialTabCategories.containsKey(category)) {
            return this.specialTabCategories.get(category).equals(tabName);
        }
        return false;
    }

    public String[] getSpecialTabNames() {
        HashSet<String> tabNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            tabNames.add(entry.getValue());
        }
        return tabNames.toArray(new String[0]);
    }

    public Set<String> getSpecialTabCategories(String tabName) {
        HashSet<String> tabCategories = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            if (!entry.getKey().equals(tabName)) continue;
            tabCategories.add(entry.getKey());
        }
        return tabCategories;
    }

    public Map<String, Color> getUnderlineColors() {
        return this.underlineColors;
    }

    public Map<String, Color> getUnderlineRuleColors() {
        return this.underlineRuleColors;
    }

    public Color getUnderlineColor(String category, String ruleId) {
        if (ruleId != null && this.underlineRuleColors.containsKey(ruleId)) {
            return this.underlineRuleColors.get(ruleId);
        }
        if (this.underlineColors.containsKey(category)) {
            return this.underlineColors.get(category);
        }
        if (this.styleLikeCategories.contains(category)) {
            return STYLE_COLOR;
        }
        return Color.blue;
    }

    public void setUnderlineColor(String category, Color col) {
        this.underlineColors.put(category, col);
    }

    public void setUnderlineRuleColor(String ruleId, Color col) {
        this.underlineRuleColors.put(ruleId, col);
    }

    public void setDefaultUnderlineColor(String category) {
        this.underlineColors.remove(category);
    }

    public void setDefaultUnderlineRuleColor(String ruleId) {
        this.underlineRuleColors.remove(ruleId);
    }

    public Map<String, Short> getUnderlineTypes() {
        return this.underlineTypes;
    }

    public Map<String, Short> getUnderlineRuleTypes() {
        return this.underlineRuleTypes;
    }

    public Short getUnderlineType(String category, String ruleId) {
        if (ruleId != null && this.underlineRuleTypes.containsKey(ruleId)) {
            return this.underlineRuleTypes.get(ruleId);
        }
        if (this.underlineTypes.containsKey(category)) {
            return this.underlineTypes.get(category);
        }
        return (short)10;
    }

    public void setUnderlineType(String category, short type) {
        this.underlineTypes.put(category, type);
    }

    public void setUnderlineRuleType(String ruleID, short type) {
        this.underlineRuleTypes.put(ruleID, type);
    }

    public void setDefaultUnderlineType(String category) {
        this.underlineTypes.remove(category);
    }

    public void setDefaultUnderlineRuleType(String ruleID) {
        this.underlineRuleTypes.remove(ruleID);
    }

    public Map<String, Integer> getConfigurableValues() {
        return this.configurableRuleValues;
    }

    public int getConfigurableValue(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public void setConfigurableValue(String ruleID, int value) {
        this.configurableRuleValues.put(ruleID, value);
    }

    public boolean onlySingleParagraphMode() {
        return this.isOpenOffice;
    }

    public boolean isValidServerUrl(String url) {
        return !url.endsWith("/") && !url.endsWith("/v2") && Pattern.matches("https?://.+(:\\d+)?.*", url);
    }

    private void loadConfiguration() throws IOException {
        this.loadConfiguration(null);
    }

    public void loadConfiguration(String profile) throws IOException {
        String qualifier = this.getQualifier(this.lang);
        File cfgFile = this.configFile.exists() || this.oldConfigFile == null ? this.configFile : this.oldConfigFile;
        try (FileInputStream fis = new FileInputStream(cfgFile);){
            String motherTongueStr;
            Properties props = new Properties();
            props.load(fis);
            if (profile == null) {
                String curProfileStr = (String)props.get(CURRENT_PROFILE_KEY);
                if (curProfileStr != null) {
                    this.currentProfile = curProfileStr;
                }
            } else {
                this.currentProfile = profile;
            }
            this.definedProfiles.addAll(this.getListFromProperties(props, DEFINED_PROFILES_KEY));
            this.ltVersion = (String)props.get(LT_VERSION_KEY);
            if (this.ltVersion != null && (motherTongueStr = (String)props.get(MOTHER_TONGUE_KEY)) != null && !motherTongueStr.equals("xx")) {
                this.motherTongue = Languages.getLanguageForShortCode((String)motherTongueStr);
            }
            this.logLevel = (String)props.get(LOG_LEVEL_KEY);
            this.storeConfigForAllProfiles(props);
            String prefix = this.currentProfile == null ? "" : this.currentProfile;
            if (!prefix.isEmpty()) {
                prefix = prefix.replaceAll(BLANK, BLANK_REPLACE);
                prefix = prefix + PROFILE_DELIMITER;
            }
            this.loadCurrentProfile(props, prefix, qualifier);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void loadCurrentProfile(Properties props, String prefix, String qualifier) {
        String rulesValuesString;
        String saveLoCacheString;
        String noSynonymsAsSuggestionsString;
        String useLtDictionaryString;
        String markSingleCharBoldString;
        String useOtherServerString;
        String doRemoteCheckString;
        String isMultiThreadString;
        String switchOffString;
        String noBackgroundCheckString;
        String useTextLevelQueueString;
        String resetCheckString;
        String paraCheckString;
        String extRules;
        String word2vecDir;
        String ngramDir;
        String useDocLangString = (String)props.get(prefix + USE_DOC_LANG_KEY);
        if (useDocLangString != null) {
            this.useDocLanguage = Boolean.parseBoolean(useDocLangString);
        }
        if (this.ltVersion == null) {
            String motherTongueStr = (String)props.get(prefix + MOTHER_TONGUE_KEY);
            if (motherTongueStr != null && !motherTongueStr.equals("xx")) {
                if (this.isOffice) {
                    this.fixedLanguage = Languages.getLanguageForShortCode((String)motherTongueStr);
                } else {
                    this.motherTongue = Languages.getLanguageForShortCode((String)motherTongueStr);
                }
            }
        } else {
            String fixedLanguageStr = (String)props.get(prefix + FIXED_LANGUAGE_KEY);
            if (fixedLanguageStr != null) {
                this.fixedLanguage = Languages.getLanguageForShortCode((String)fixedLanguageStr);
            }
        }
        if (!this.useDocLanguage && this.fixedLanguage != null) {
            qualifier = this.getQualifier(this.fixedLanguage);
        }
        this.disabledRuleIds.addAll(this.getListFromProperties(props, prefix + DISABLED_RULES_KEY + qualifier));
        this.enabledRuleIds.addAll(this.getListFromProperties(props, prefix + ENABLED_RULES_KEY + qualifier));
        this.disabledCategoryNames.addAll(this.getListFromProperties(props, prefix + DISABLED_CATEGORIES_KEY + qualifier));
        this.enabledCategoryNames.addAll(this.getListFromProperties(props, prefix + ENABLED_CATEGORIES_KEY + qualifier));
        this.enabledRulesOnly = "true".equals(props.get(prefix + ENABLED_RULES_ONLY_KEY));
        String languageStr = (String)props.get(prefix + LANGUAGE_KEY);
        if (languageStr != null) {
            this.language = Languages.getLanguageForShortCode((String)languageStr);
        }
        if ((ngramDir = (String)props.get(prefix + NGRAM_DIR_KEY)) != null) {
            this.ngramDirectory = new File(ngramDir);
        }
        if ((word2vecDir = (String)props.get(prefix + WORD2VEC_DIR_KEY)) != null) {
            this.word2vecDirectory = new File(word2vecDir);
        }
        this.autoDetect = "true".equals(props.get(prefix + AUTO_DETECT_KEY));
        this.taggerShowsDisambigLog = "true".equals(props.get(prefix + TAGGER_SHOWS_DISAMBIG_LOG_KEY));
        this.guiConfig = "true".equals(props.get(prefix + USE_GUI_KEY));
        this.runServer = "true".equals(props.get(prefix + SERVER_RUN_KEY));
        this.fontName = (String)props.get(prefix + FONT_NAME_KEY);
        if (props.get(prefix + FONT_STYLE_KEY) != null) {
            try {
                this.fontStyle = Integer.parseInt((String)props.get(prefix + FONT_STYLE_KEY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (props.get(prefix + FONT_SIZE_KEY) != null) {
            try {
                this.fontSize = Integer.parseInt((String)props.get(prefix + FONT_SIZE_KEY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.lookAndFeelName = (String)props.get(prefix + LF_NAME_KEY);
        String serverPortString = (String)props.get(prefix + SERVER_PORT_KEY);
        if (serverPortString != null) {
            this.serverPort = Integer.parseInt(serverPortString);
        }
        if ((extRules = (String)props.get(prefix + EXTERNAL_RULE_DIRECTORY)) != null) {
            this.externalRuleDirectory = extRules;
        }
        if (Boolean.parseBoolean(paraCheckString = (String)props.get(prefix + NO_DEFAULT_CHECK_KEY)) && (paraCheckString = (String)props.get(prefix + PARA_CHECK_KEY)) != null) {
            this.numParasToCheck = Integer.parseInt(paraCheckString);
        }
        if ((resetCheckString = (String)props.get(prefix + RESET_CHECK_KEY)) != null) {
            this.doResetCheck = Boolean.parseBoolean(resetCheckString);
        }
        if ((useTextLevelQueueString = (String)props.get(prefix + USE_QUEUE_KEY)) != null) {
            this.useTextLevelQueue = Boolean.parseBoolean(useTextLevelQueueString);
        }
        if ((noBackgroundCheckString = (String)props.get(prefix + NO_BACKGROUND_CHECK_KEY)) != null) {
            this.noBackgroundCheck = Boolean.parseBoolean(noBackgroundCheckString);
        }
        if ((switchOffString = (String)props.get(prefix + LT_SWITCHED_OFF_KEY)) != null) {
            this.switchOff = Boolean.parseBoolean(switchOffString);
        }
        if ((isMultiThreadString = (String)props.get(prefix + IS_MULTI_THREAD_LO_KEY)) != null) {
            this.isMultiThreadLO = Boolean.parseBoolean(isMultiThreadString);
        }
        if ((doRemoteCheckString = (String)props.get(prefix + DO_REMOTE_CHECK_KEY)) != null) {
            this.doRemoteCheck = Boolean.parseBoolean(doRemoteCheckString);
        }
        if ((useOtherServerString = (String)props.get(prefix + USE_OTHER_SERVER_KEY)) != null) {
            this.useOtherServer = Boolean.parseBoolean(useOtherServerString);
        }
        this.otherServerUrl = (String)props.get(prefix + OTHER_SERVER_URL_KEY);
        if (this.otherServerUrl != null && !this.isValidServerUrl(this.otherServerUrl)) {
            this.otherServerUrl = null;
        }
        if ((markSingleCharBoldString = (String)props.get(prefix + MARK_SINGLE_CHAR_BOLD_KEY)) != null) {
            this.markSingleCharBold = Boolean.parseBoolean(markSingleCharBoldString);
        }
        if ((useLtDictionaryString = (String)props.get(prefix + USE_LT_DICTIONARY_KEY)) != null) {
            this.useLtDictionary = Boolean.parseBoolean(useLtDictionaryString);
        }
        if ((noSynonymsAsSuggestionsString = (String)props.get(prefix + NO_SYNONYMS_AS_SUGGESTIONS_KEY)) != null) {
            this.noSynonymsAsSuggestions = Boolean.parseBoolean(noSynonymsAsSuggestionsString);
        }
        if ((saveLoCacheString = (String)props.get(prefix + SAVE_LO_CACHE_KEY)) != null) {
            this.saveLoCache = Boolean.parseBoolean(saveLoCacheString);
        }
        if ((rulesValuesString = (String)props.get(prefix + CONFIGURABLE_RULE_VALUES_KEY + qualifier)) == null) {
            rulesValuesString = (String)props.get(prefix + CONFIGURABLE_RULE_VALUES_KEY);
        }
        this.parseConfigurableRuleValues(rulesValuesString);
        String colorsString = (String)props.get(prefix + ERROR_COLORS_KEY);
        this.parseErrorColors(colorsString);
        String underlineColorsString = (String)props.get(prefix + UNDERLINE_COLORS_KEY);
        this.parseUnderlineColors(underlineColorsString, this.underlineColors);
        String underlineRuleColorsString = (String)props.get(prefix + UNDERLINE_RULE_COLORS_KEY);
        this.parseUnderlineColors(underlineRuleColorsString, this.underlineRuleColors);
        String underlineTypesString = (String)props.get(prefix + UNDERLINE_TYPES_KEY);
        this.parseUnderlineTypes(underlineTypesString, this.underlineTypes);
        String underlineRulesTypesString = (String)props.get(prefix + UNDERLINE_RULE_TYPES_KEY);
        this.parseUnderlineTypes(underlineRulesTypesString, this.underlineRuleTypes);
        this.loadConfigForOtherLanguages(this.lang, props, prefix);
    }

    private void parseErrorColors(String colorsString) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                ITSIssueType type = ITSIssueType.getIssueType((String)typeAndColor[0]);
                String hexColor = typeAndColor[1];
                this.errorColors.put(type, Color.decode(hexColor));
            }
        }
    }

    private void parseUnderlineColors(String colorsString, Map<String, Color> underlineColors) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                underlineColors.put(typeAndColor[0], Color.decode(typeAndColor[1]));
            }
        }
    }

    private void parseUnderlineTypes(String typessString, Map<String, Short> underlineTypes) {
        if (StringUtils.isNotEmpty((CharSequence)typessString)) {
            String[] categoryToTypesList;
            for (String categoryToType : categoryToTypesList = typessString.split(CONFIGURABLE_RULE_SPLITTER_REGEXP)) {
                String[] categoryAndType = categoryToType.split(":");
                if (categoryAndType.length != 2) {
                    throw new RuntimeException("Could not parse category and type, colon expected: '" + categoryToType + "'");
                }
                underlineTypes.put(categoryAndType[0], Short.parseShort(categoryAndType[1]));
            }
        }
    }

    private void parseConfigurableRuleValues(String rulesValueString) {
        if (StringUtils.isNotEmpty((CharSequence)rulesValueString)) {
            String[] ruleToValueList;
            for (String ruleToValue : ruleToValueList = rulesValueString.split(CONFIGURABLE_RULE_SPLITTER_REGEXP)) {
                String[] ruleAndValue = ruleToValue.split(":");
                if (ruleAndValue.length != 2) {
                    throw new RuntimeException("Could not parse rule and value, colon expected: '" + ruleToValue + "'");
                }
                this.configurableRuleValues.put(ruleAndValue[0], Integer.parseInt(ruleAndValue[1]));
            }
        }
    }

    private String getQualifier(Language lang) {
        String qualifier = "";
        if (lang != null) {
            qualifier = "." + lang.getShortCodeWithCountryAndVariant();
        }
        return qualifier;
    }

    private void loadConfigForOtherLanguages(Language lang, Properties prop, String prefix) {
        for (Language otherLang : Languages.get()) {
            if (otherLang.equals((Object)lang)) continue;
            String languageSuffix = "." + otherLang.getShortCodeWithCountryAndVariant();
            this.storeConfigKeyFromProp(prop, prefix + DISABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + ENABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + DISABLED_CATEGORIES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + ENABLED_CATEGORIES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + CONFIGURABLE_RULE_VALUES_KEY + languageSuffix);
        }
    }

    private void storeConfigKeyFromProp(Properties prop, String key) {
        if (prop.containsKey(key)) {
            this.configForOtherLanguages.put(key, prop.getProperty(key));
        }
    }

    private Collection<? extends String> getListFromProperties(Properties props, String key) {
        String value = (String)props.get(key);
        ArrayList<String> list = new ArrayList<String>();
        if (value != null && !value.isEmpty()) {
            String[] names = value.split(DELIMITER);
            list.addAll(Arrays.asList(names));
        }
        return list;
    }

    public void saveConfiguration(Language lang) throws IOException {
        if (lang == null) {
            lang = this.lang;
        }
        Properties props = new Properties();
        String qualifier = this.getQualifier(lang);
        String[] versionParts = "5.6".split("-");
        props.setProperty(LT_VERSION_KEY, versionParts[0]);
        if (this.currentProfile != null && !this.currentProfile.isEmpty()) {
            props.setProperty(CURRENT_PROFILE_KEY, this.currentProfile);
        }
        if (!this.definedProfiles.isEmpty()) {
            props.setProperty(DEFINED_PROFILES_KEY, String.join((CharSequence)DELIMITER, this.definedProfiles));
        }
        if (this.motherTongue != null) {
            props.setProperty(MOTHER_TONGUE_KEY, this.motherTongue.getShortCodeWithCountryAndVariant());
        }
        if (this.logLevel != null) {
            props.setProperty(LOG_LEVEL_KEY, this.logLevel);
        }
        FileOutputStream fos = new FileOutputStream(this.configFile);
        Object object = null;
        try {
            props.store(fos, "LanguageTool configuration (5.6/" + JLanguageTool.BUILD_DATE + ")");
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fos != null) {
                if (object != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fos.close();
                }
            }
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("");
        object = this.definedProfiles.iterator();
        while (object.hasNext()) {
            String profile;
            String prefix = profile = (String)object.next();
            prefixes.add(prefix.replaceAll(BLANK, BLANK_REPLACE) + PROFILE_DELIMITER);
        }
        String currentPrefix = this.currentProfile == null ? "" : this.currentProfile;
        if (!currentPrefix.isEmpty()) {
            currentPrefix = currentPrefix.replaceAll(BLANK, BLANK_REPLACE);
            currentPrefix = currentPrefix + PROFILE_DELIMITER;
        }
        for (String prefix : prefixes) {
            props = new Properties();
            if (currentPrefix.equals(prefix)) {
                this.saveConfigForCurrentProfile(props, prefix, qualifier);
            } else {
                this.saveConfigForProfile(props, prefix);
            }
            FileOutputStream fos2 = new FileOutputStream(this.configFile, true);
            Throwable throwable = null;
            try {
                props.store(fos2, "Profile: " + (prefix.isEmpty() ? "Default" : prefix.substring(0, prefix.length() - 2)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fos2 == null) continue;
                if (throwable != null) {
                    try {
                        fos2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fos2.close();
            }
        }
        if (this.oldConfigFile != null && this.oldConfigFile.exists()) {
            this.oldConfigFile.delete();
        }
    }

    private void addListToProperties(Properties props, String key, Set<String> list) {
        if (list == null) {
            props.setProperty(key, "");
        } else {
            props.setProperty(key, String.join((CharSequence)DELIMITER, list));
        }
    }

    private void setAllProfileKeys() {
        this.allProfileKeys.add(LANGUAGE_KEY);
        this.allProfileKeys.add(FIXED_LANGUAGE_KEY);
        this.allProfileKeys.add(NGRAM_DIR_KEY);
        this.allProfileKeys.add(WORD2VEC_DIR_KEY);
        this.allProfileKeys.add(AUTO_DETECT_KEY);
        this.allProfileKeys.add(TAGGER_SHOWS_DISAMBIG_LOG_KEY);
        this.allProfileKeys.add(SERVER_RUN_KEY);
        this.allProfileKeys.add(SERVER_PORT_KEY);
        this.allProfileKeys.add(NO_DEFAULT_CHECK_KEY);
        this.allProfileKeys.add(PARA_CHECK_KEY);
        this.allProfileKeys.add(RESET_CHECK_KEY);
        this.allProfileKeys.add(USE_QUEUE_KEY);
        this.allProfileKeys.add(NO_BACKGROUND_CHECK_KEY);
        this.allProfileKeys.add(USE_DOC_LANG_KEY);
        this.allProfileKeys.add(USE_GUI_KEY);
        this.allProfileKeys.add(FONT_NAME_KEY);
        this.allProfileKeys.add(FONT_STYLE_KEY);
        this.allProfileKeys.add(FONT_SIZE_KEY);
        this.allProfileKeys.add(LF_NAME_KEY);
        this.allProfileKeys.add(ERROR_COLORS_KEY);
        this.allProfileKeys.add(UNDERLINE_COLORS_KEY);
        this.allProfileKeys.add(UNDERLINE_RULE_COLORS_KEY);
        this.allProfileKeys.add(UNDERLINE_TYPES_KEY);
        this.allProfileKeys.add(UNDERLINE_RULE_TYPES_KEY);
        this.allProfileKeys.add(LT_SWITCHED_OFF_KEY);
        this.allProfileKeys.add(IS_MULTI_THREAD_LO_KEY);
        this.allProfileKeys.add(EXTERNAL_RULE_DIRECTORY);
        this.allProfileKeys.add(DO_REMOTE_CHECK_KEY);
        this.allProfileKeys.add(OTHER_SERVER_URL_KEY);
        this.allProfileKeys.add(USE_OTHER_SERVER_KEY);
        this.allProfileKeys.add(MARK_SINGLE_CHAR_BOLD_KEY);
        this.allProfileKeys.add(USE_LT_DICTIONARY_KEY);
        this.allProfileKeys.add(NO_SYNONYMS_AS_SUGGESTIONS_KEY);
        this.allProfileKeys.add(SAVE_LO_CACHE_KEY);
        this.allProfileLangKeys.add(DISABLED_RULES_KEY);
        this.allProfileLangKeys.add(ENABLED_RULES_KEY);
        this.allProfileLangKeys.add(DISABLED_CATEGORIES_KEY);
        this.allProfileLangKeys.add(ENABLED_CATEGORIES_KEY);
        this.allProfileLangKeys.add(CONFIGURABLE_RULE_VALUES_KEY);
    }

    private void storeConfigForAllProfiles(Properties props) {
        ArrayList<String> prefix = new ArrayList<String>();
        prefix.add("");
        Iterator<String> iterator = this.definedProfiles.iterator();
        while (iterator.hasNext()) {
            String profile;
            String sPrefix = profile = iterator.next();
            prefix.add(sPrefix.replaceAll(BLANK, BLANK_REPLACE) + PROFILE_DELIMITER);
        }
        for (String sPrefix : prefix) {
            for (String key : this.allProfileLangKeys) {
                for (Language lang : Languages.get()) {
                    String preKey = sPrefix + key + "." + lang.getShortCodeWithCountryAndVariant();
                    if (!props.containsKey(preKey)) continue;
                    this.configForOtherProfiles.put(preKey, props.getProperty(preKey));
                }
            }
        }
        for (String sPrefix : prefix) {
            if (this.isOffice && this.ltVersion == null && props.containsKey(sPrefix + MOTHER_TONGUE_KEY)) {
                this.configForOtherProfiles.put(sPrefix + FIXED_LANGUAGE_KEY, props.getProperty(sPrefix + MOTHER_TONGUE_KEY));
            }
            for (String key : this.allProfileKeys) {
                String preKey = sPrefix + key;
                if (!props.containsKey(preKey)) continue;
                this.configForOtherProfiles.put(preKey, props.getProperty(preKey));
            }
        }
    }

    private void saveConfigForCurrentProfile(Properties props, String prefix, String qualifier) {
        StringBuilder sbUT;
        StringBuilder sbUC;
        String rgb;
        if (!this.disabledRuleIds.isEmpty()) {
            this.addListToProperties(props, prefix + DISABLED_RULES_KEY + qualifier, this.disabledRuleIds);
        }
        if (!this.enabledRuleIds.isEmpty()) {
            this.addListToProperties(props, prefix + ENABLED_RULES_KEY + qualifier, this.enabledRuleIds);
        }
        if (!this.disabledCategoryNames.isEmpty()) {
            this.addListToProperties(props, prefix + DISABLED_CATEGORIES_KEY + qualifier, this.disabledCategoryNames);
        }
        if (!this.enabledCategoryNames.isEmpty()) {
            this.addListToProperties(props, prefix + ENABLED_CATEGORIES_KEY + qualifier, this.enabledCategoryNames);
        }
        if (this.language != null && !this.language.isExternal()) {
            props.setProperty(prefix + LANGUAGE_KEY, this.language.getShortCodeWithCountryAndVariant());
        }
        if (this.fixedLanguage != null) {
            props.setProperty(prefix + FIXED_LANGUAGE_KEY, this.fixedLanguage.getShortCodeWithCountryAndVariant());
        }
        if (this.ngramDirectory != null) {
            props.setProperty(prefix + NGRAM_DIR_KEY, this.ngramDirectory.getAbsolutePath());
        }
        if (this.word2vecDirectory != null) {
            props.setProperty(prefix + WORD2VEC_DIR_KEY, this.word2vecDirectory.getAbsolutePath());
        }
        props.setProperty(prefix + AUTO_DETECT_KEY, Boolean.toString(this.autoDetect));
        props.setProperty(prefix + TAGGER_SHOWS_DISAMBIG_LOG_KEY, Boolean.toString(this.taggerShowsDisambigLog));
        props.setProperty(prefix + USE_GUI_KEY, Boolean.toString(this.guiConfig));
        props.setProperty(prefix + SERVER_RUN_KEY, Boolean.toString(this.runServer));
        props.setProperty(prefix + SERVER_PORT_KEY, Integer.toString(this.serverPort));
        if (this.numParasToCheck != -1) {
            props.setProperty(prefix + NO_DEFAULT_CHECK_KEY, Boolean.toString(true));
            props.setProperty(prefix + PARA_CHECK_KEY, Integer.toString(this.numParasToCheck));
        }
        if (this.doResetCheck) {
            props.setProperty(prefix + RESET_CHECK_KEY, Boolean.toString(this.doResetCheck));
        }
        if (!this.useTextLevelQueue) {
            props.setProperty(prefix + USE_QUEUE_KEY, Boolean.toString(this.useTextLevelQueue));
        }
        if (this.noBackgroundCheck) {
            props.setProperty(prefix + NO_BACKGROUND_CHECK_KEY, Boolean.toString(this.noBackgroundCheck));
        }
        if (!this.useDocLanguage) {
            props.setProperty(prefix + USE_DOC_LANG_KEY, Boolean.toString(this.useDocLanguage));
        }
        if (this.isMultiThreadLO) {
            props.setProperty(prefix + IS_MULTI_THREAD_LO_KEY, Boolean.toString(this.isMultiThreadLO));
        }
        if (this.doRemoteCheck) {
            props.setProperty(prefix + DO_REMOTE_CHECK_KEY, Boolean.toString(this.doRemoteCheck));
        }
        if (this.useOtherServer) {
            props.setProperty(prefix + USE_OTHER_SERVER_KEY, Boolean.toString(this.useOtherServer));
        }
        if (this.markSingleCharBold) {
            props.setProperty(prefix + MARK_SINGLE_CHAR_BOLD_KEY, Boolean.toString(this.markSingleCharBold));
        }
        if (!this.useLtDictionary) {
            props.setProperty(prefix + USE_LT_DICTIONARY_KEY, Boolean.toString(this.useLtDictionary));
        }
        if (!this.noSynonymsAsSuggestions) {
            props.setProperty(prefix + NO_SYNONYMS_AS_SUGGESTIONS_KEY, Boolean.toString(this.noSynonymsAsSuggestions));
        }
        if (!this.saveLoCache) {
            props.setProperty(prefix + SAVE_LO_CACHE_KEY, Boolean.toString(this.saveLoCache));
        }
        if (this.switchOff) {
            props.setProperty(prefix + LT_SWITCHED_OFF_KEY, Boolean.toString(this.switchOff));
        }
        if (this.otherServerUrl != null && this.isValidServerUrl(this.otherServerUrl)) {
            props.setProperty(prefix + OTHER_SERVER_URL_KEY, this.otherServerUrl);
        }
        if (this.fontName != null) {
            props.setProperty(prefix + FONT_NAME_KEY, this.fontName);
        }
        if (this.fontStyle != -1) {
            props.setProperty(prefix + FONT_STYLE_KEY, Integer.toString(this.fontStyle));
        }
        if (this.fontSize != -1) {
            props.setProperty(prefix + FONT_SIZE_KEY, Integer.toString(this.fontSize));
        }
        if (this.lookAndFeelName != null) {
            props.setProperty(prefix + LF_NAME_KEY, this.lookAndFeelName);
        }
        if (this.externalRuleDirectory != null) {
            props.setProperty(prefix + EXTERNAL_RULE_DIRECTORY, this.externalRuleDirectory);
        }
        if (!this.configurableRuleValues.isEmpty()) {
            StringBuilder sbRV = new StringBuilder();
            for (Map.Entry<String, Integer> entry : this.configurableRuleValues.entrySet()) {
                sbRV.append(entry.getKey()).append(':').append(entry.getValue()).append(", ");
            }
            props.setProperty(prefix + CONFIGURABLE_RULE_VALUES_KEY + qualifier, sbRV.toString());
        }
        if (!this.errorColors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Serializable> entry : this.errorColors.entrySet()) {
                rgb = Integer.toHexString(((Color)entry.getValue()).getRGB());
                rgb = rgb.substring(2);
                sb.append((Object)entry.getKey()).append(":#").append(rgb).append(", ");
            }
            props.setProperty(prefix + ERROR_COLORS_KEY, sb.toString());
        }
        if (!this.underlineColors.isEmpty()) {
            sbUC = new StringBuilder();
            for (Map.Entry<String, Serializable> entry : this.underlineColors.entrySet()) {
                rgb = Integer.toHexString(((Color)entry.getValue()).getRGB());
                rgb = rgb.substring(2);
                sbUC.append(entry.getKey()).append(":#").append(rgb).append(", ");
            }
            props.setProperty(prefix + UNDERLINE_COLORS_KEY, sbUC.toString());
        }
        if (!this.underlineRuleColors.isEmpty()) {
            sbUC = new StringBuilder();
            for (Map.Entry<String, Serializable> entry : this.underlineRuleColors.entrySet()) {
                rgb = Integer.toHexString(((Color)entry.getValue()).getRGB());
                rgb = rgb.substring(2);
                sbUC.append(entry.getKey()).append(":#").append(rgb).append(", ");
            }
            props.setProperty(prefix + UNDERLINE_RULE_COLORS_KEY, sbUC.toString());
        }
        if (!this.underlineTypes.isEmpty()) {
            sbUT = new StringBuilder();
            for (Map.Entry<String, Serializable> entry : this.underlineTypes.entrySet()) {
                sbUT.append(entry.getKey()).append(':').append(entry.getValue()).append(", ");
            }
            props.setProperty(prefix + UNDERLINE_TYPES_KEY, sbUT.toString());
        }
        if (!this.underlineRuleTypes.isEmpty()) {
            sbUT = new StringBuilder();
            for (Map.Entry<String, Serializable> entry : this.underlineRuleTypes.entrySet()) {
                sbUT.append(entry.getKey()).append(':').append(entry.getValue()).append(", ");
            }
            props.setProperty(prefix + UNDERLINE_RULE_TYPES_KEY, sbUT.toString());
        }
        for (String key : this.configForOtherLanguages.keySet()) {
            props.setProperty(key, this.configForOtherLanguages.get(key));
        }
    }

    private void saveConfigForProfile(Properties props, String prefix) {
        for (String key : this.allProfileLangKeys) {
            for (Language lang : Languages.get()) {
                String preKey = prefix + key + "." + lang.getShortCodeWithCountryAndVariant();
                if (!this.configForOtherProfiles.containsKey(preKey)) continue;
                props.setProperty(preKey, this.configForOtherProfiles.get(preKey));
            }
        }
        for (String key : this.allProfileKeys) {
            String preKey = prefix + key;
            if (!this.configForOtherProfiles.containsKey(preKey)) continue;
            props.setProperty(preKey, this.configForOtherProfiles.get(preKey));
        }
    }

    public void importProfile(File importFile) throws IOException {
        String qualifier = this.getQualifier(this.lang);
        try (FileInputStream fis = new FileInputStream(importFile);){
            Properties props = new Properties();
            props.load(fis);
            String curProfileStr = (String)props.get(CURRENT_PROFILE_KEY);
            if (curProfileStr == null || curProfileStr.isEmpty()) {
                return;
            }
            String prefix = this.currentProfile = curProfileStr;
            prefix = prefix.replaceAll(BLANK, BLANK_REPLACE);
            prefix = prefix + PROFILE_DELIMITER;
            this.loadCurrentProfile(props, prefix, qualifier);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void exportProfile(String profile, File exportFile) throws IOException {
        Properties props = new Properties();
        String qualifier = this.getQualifier(this.lang);
        if (this.currentProfile != null && !this.currentProfile.isEmpty()) {
            props.setProperty(CURRENT_PROFILE_KEY, profile);
        }
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            props.store(fos, "LanguageTool configuration (5.6/" + JLanguageTool.BUILD_DATE + ")");
        }
        String prefix = profile;
        if (!prefix.isEmpty()) {
            prefix = prefix.replaceAll(BLANK, BLANK_REPLACE);
            prefix = prefix + PROFILE_DELIMITER;
        }
        this.saveConfigForCurrentProfile(props, prefix, qualifier);
        try (FileOutputStream fos = new FileOutputStream(exportFile, true);){
            props.store(fos, "Profile: " + (prefix.isEmpty() ? "Default" : prefix.substring(0, prefix.length() - 2)));
        }
    }
}

