/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.CategoryIds;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tools.Tools;

public class ToolsTest {
    @Test
    public void testCorrectTextFromMatches() {
        RuleMatch match1 = new RuleMatch((Rule)new FakeRule(), null, 0, 9, "msg1");
        match1.setSuggestedReplacement("I've had");
        RuleMatch match2 = new RuleMatch((Rule)new FakeRule(), null, 0, 9, "msg2");
        match2.setSuggestedReplacement("I have");
        List<RuleMatch> matches = Arrays.asList(match1, match2);
        Assert.assertThat((Object)Tools.correctTextFromMatches((String)"I've have", matches), (Matcher)Is.is((Object)"I've had"));
    }

    @Test
    public void testSelectRules() {
        Demo demo = new Demo();
        this.expectDemoRuleId(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false, demo);
        this.expectNotDemoRuleId(Collections.emptySet(), Collections.emptySet(), Collections.singleton("DEMO_RULE"), Collections.emptySet(), false, demo);
        this.expectNotDemoRuleId(Collections.singleton(CategoryIds.MISC), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false, demo);
        this.expectDemoRuleId(Collections.singleton(CategoryIds.MISC), Collections.emptySet(), Collections.emptySet(), Collections.singleton("DEMO_RULE"), false, demo);
        this.expectDemoRuleId(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), true, demo);
        this.expectNotDemoRuleId(Collections.emptySet(), Collections.emptySet(), Collections.singleton("DEMO_RULE"), Collections.emptySet(), true, demo);
        this.expectNotDemoRuleId(Collections.singleton(CategoryIds.MISC), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), true, demo);
        this.expectDemoRuleId(Collections.emptySet(), Collections.singleton(CategoryIds.MISC), Collections.emptySet(), Collections.emptySet(), true, demo);
        this.expectNotDemoRuleId(Collections.emptySet(), Collections.singleton(CategoryIds.CASING), Collections.emptySet(), Collections.emptySet(), true, demo);
    }

    private void expectDemoRuleId(Set<CategoryId> disabledCategories, Set<CategoryId> enabledCategories, Set<String> disabledRules, Set<String> enabledRules, boolean useEnabledOnly, Demo demo) {
        JLanguageTool lt = new JLanguageTool((Language)demo);
        Tools.selectRules((JLanguageTool)lt, disabledCategories, enabledCategories, disabledRules, enabledRules, (boolean)useEnabledOnly, (boolean)false);
        Assert.assertTrue((boolean)this.getRuleIds(lt).contains("DEMO_RULE"));
    }

    private void expectNotDemoRuleId(Set<CategoryId> disabledCategories, Set<CategoryId> enabledCategories, Set<String> disabledRules, Set<String> enabledRules, boolean useEnabledOnly, Demo demo) {
        JLanguageTool lt = new JLanguageTool((Language)demo);
        Tools.selectRules((JLanguageTool)lt, disabledCategories, enabledCategories, disabledRules, enabledRules, (boolean)useEnabledOnly, (boolean)false);
        Assert.assertFalse((boolean)this.getRuleIds(lt).contains("DEMO_RULE"));
    }

    private List<String> getRuleIds(JLanguageTool lt) {
        List allActiveRules = lt.getAllActiveRules();
        return allActiveRules.stream().map(Rule::getId).collect(Collectors.toList());
    }

    private static class FakeRule
    extends PatternRule {
        FakeRule() {
            super("FAKE_ID", TestTools.getDemoLanguage(), Collections.singletonList(new PatternToken("foo", true, false, false)), "My fake description", "Fake message", "Fake short message");
        }
    }
}

