/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.OrderingReadFromAccessor;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.AsyncConnectionProvider;
import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.masterreplica.ReplicaUtils;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.protocol.ConnectionIntent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MasterReplicaConnectionProvider<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterReplicaConnectionProvider.class);
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final RedisURI initialRedisUri;
    private final AsyncConnectionProvider<ConnectionKey, StatefulRedisConnection<K, V>, CompletionStage<StatefulRedisConnection<K, V>>> connectionProvider;
    private List<RedisNodeDescription> knownNodes = new ArrayList<RedisNodeDescription>();
    private boolean autoFlushCommands = true;
    private final Object stateLock = new Object();
    private ReadFrom readFrom;

    MasterReplicaConnectionProvider(RedisClient redisClient, RedisCodec<K, V> redisCodec, RedisURI initialRedisUri, Map<RedisURI, StatefulRedisConnection<K, V>> initialConnections) {
        this.initialRedisUri = initialRedisUri;
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory(redisClient, redisCodec);
        this.connectionProvider = new AsyncConnectionProvider(connectionFactory);
        for (Map.Entry<RedisURI, StatefulRedisConnection<K, V>> entry : initialConnections.entrySet()) {
            this.connectionProvider.register(MasterReplicaConnectionProvider.toConnectionKey(entry.getKey()), (StatefulRedisConnection<ConnectionKey, V>)entry.getValue());
        }
    }

    public StatefulRedisConnection<K, V> getConnection(ConnectionIntent intent) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ")");
        }
        try {
            return this.getConnectionAsync(intent).get();
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ConnectionIntent intent) {
        if (this.debugEnabled) {
            logger.debug("getConnectionAsync(" + (Object)((Object)intent) + ")");
        }
        if (this.readFrom != null && intent == ConnectionIntent.READ) {
            List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                @Override
                public List<RedisNodeDescription> getNodes() {
                    return MasterReplicaConnectionProvider.this.knownNodes;
                }

                @Override
                public Iterator<RedisNodeDescription> iterator() {
                    return MasterReplicaConnectionProvider.this.knownNodes.iterator();
                }
            });
            if (selection.isEmpty()) {
                throw new RedisException(String.format("Cannot determine a node to read (Known nodes: %s) with setting %s", this.knownNodes, this.readFrom));
            }
            try {
                Flux connections = Flux.empty();
                for (RedisNodeDescription node : selection) {
                    connections = connections.concatWith((Publisher)Mono.fromFuture(this.getConnection(node)));
                }
                if (OrderingReadFromAccessor.isOrderSensitive(this.readFrom) || selection.size() == 1) {
                    return connections.filter(StatefulConnection::isOpen).next().switchIfEmpty(connections.next()).toFuture();
                }
                return connections.filter(StatefulConnection::isOpen).collectList().filter(it -> !it.isEmpty()).map(it -> {
                    int index = ThreadLocalRandom.current().nextInt(it.size());
                    return (StatefulRedisConnection)it.get(index);
                }).switchIfEmpty(connections.next()).toFuture();
            }
            catch (RuntimeException e) {
                throw Exceptions.bubble(e);
            }
        }
        return this.getConnection(this.getMaster());
    }

    protected CompletableFuture<StatefulRedisConnection<K, V>> getConnection(RedisNodeDescription redisNodeDescription) {
        RedisURI uri = redisNodeDescription.getUri();
        return this.connectionProvider.getConnection(MasterReplicaConnectionProvider.toConnectionKey(uri)).toCompletableFuture();
    }

    protected long getConnectionCount() {
        return this.connectionProvider.getConnectionCount();
    }

    private Set<ConnectionKey> getStaleConnectionKeys() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.connectionProvider.forEach(map::put);
        HashSet<ConnectionKey> stale = new HashSet<ConnectionKey>();
        for (ConnectionKey connectionKey : map.keySet()) {
            if (connectionKey.host != null && ReplicaUtils.findNodeByHostAndPort(this.knownNodes, connectionKey.host, connectionKey.port) != null) continue;
            stale.add(connectionKey);
        }
        return stale;
    }

    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        Set<ConnectionKey> stale = this.getStaleConnectionKeys();
        for (ConnectionKey connectionKey : stale) {
            this.connectionProvider.close(connectionKey);
        }
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    public void reset() {
        this.connectionProvider.forEach(StatefulConnection::reset);
    }

    public void close() {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.connectionProvider.close();
    }

    public void flushCommands() {
        this.connectionProvider.forEach(StatefulConnection::flushCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoFlushCommands(boolean autoFlush) {
        Object object = this.stateLock;
        synchronized (object) {
            this.autoFlushCommands = autoFlush;
            this.connectionProvider.forEach(connection -> connection.setAutoFlushCommands(autoFlush));
        }
    }

    @Deprecated
    protected Collection<StatefulRedisConnection<K, V>> allConnections() {
        ConcurrentHashMap.KeySetView set2 = ConcurrentHashMap.newKeySet();
        this.connectionProvider.forEach(set2::add);
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownNodes(Collection<RedisNodeDescription> knownNodes) {
        Object object = this.stateLock;
        synchronized (object) {
            this.knownNodes.clear();
            this.knownNodes.addAll(knownNodes);
            this.closeStaleConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadFrom getReadFrom() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.readFrom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
        }
    }

    public RedisNodeDescription getMaster() {
        for (RedisNodeDescription knownNode : this.knownNodes) {
            if (!knownNode.getRole().isUpstream()) continue;
            return knownNode;
        }
        throw new RedisException(String.format("Master is currently unknown: %s", this.knownNodes));
    }

    private static ConnectionKey toConnectionKey(RedisURI redisURI) {
        return new ConnectionKey(redisURI.getHost(), redisURI.getPort());
    }

    static class ConnectionKey {
        private final String host;
        private final int port;

        ConnectionKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.host == null ? that.host != null : !this.host.equals(that.host));
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    class DefaultConnectionFactory
    implements Function<ConnectionKey, CompletionStage<StatefulRedisConnection<K, V>>> {
        private final RedisClient redisClient;
        private final RedisCodec<K, V> redisCodec;

        DefaultConnectionFactory(RedisClient redisClient, RedisCodec<K, V> redisCodec) {
            this.redisClient = redisClient;
            this.redisCodec = redisCodec;
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> apply(ConnectionKey key) {
            RedisURI.Builder builder = RedisURI.builder(MasterReplicaConnectionProvider.this.initialRedisUri).withHost(key.host).withPort(key.port);
            ConnectionFuture connectionFuture = this.redisClient.connectAsync(this.redisCodec, builder.build());
            connectionFuture.thenAccept(connection -> {
                Object object = MasterReplicaConnectionProvider.this.stateLock;
                synchronized (object) {
                    connection.setAutoFlushCommands(MasterReplicaConnectionProvider.this.autoFlushCommands);
                }
            });
            return connectionFuture;
        }
    }
}

