/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Bundle;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class NavigatorPanelImpl
extends Children.Keys<SymbolInformation>
implements NavigatorPanel,
LSPBindings.BackgroundTask,
LookupListener {
    private static final NavigatorPanelImpl INSTANCE = new NavigatorPanelImpl();
    private final ExplorerManager manager = new ExplorerManager();
    private JComponent view;
    private Lookup.Result<FileObject> result;
    private FileObject file;

    public NavigatorPanelImpl() {
        this.manager.setRootContext((Node)new AbstractNode((Children)this));
    }

    public String getDisplayName() {
        return Bundle.DN_Symbols();
    }

    public String getDisplayHint() {
        return "symbols";
    }

    public JComponent getComponent() {
        if (this.view == null) {
            class View
            extends JPanel
            implements ExplorerManager.Provider {
                public View() {
                    this.setLayout(new BorderLayout());
                    BeanTreeView btv = new BeanTreeView();
                    this.add((Component)btv, "Center");
                    btv.setRootVisible(false);
                }

                public ExplorerManager getExplorerManager() {
                    return NavigatorPanelImpl.this.manager;
                }
            }
            this.view = new View();
        }
        return this.view;
    }

    public void panelActivated(Lookup context) {
        this.result = context.lookupResult(FileObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.updateFile();
    }

    public void panelDeactivated() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
        this.updateFile();
    }

    private void updateFile() {
        if (this.file != null) {
            LSPBindings.removeBackgroundTask(this.file, this);
            this.setKeys(Collections.emptyList());
            this.file = null;
        }
        List files = this.result != null ? this.result.allInstances() : Collections.emptyList();
        FileObject fileObject = this.file = files.isEmpty() ? null : (FileObject)files.iterator().next();
        if (this.file != null) {
            LSPBindings.addBackgroundTask(this.file, this);
        }
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        if (file.equals(this.file)) {
            try {
                String uri = Utils.toURI(file);
                List<? extends SymbolInformation> symbols = bindings.getTextDocumentService().documentSymbol(new DocumentSymbolParams(new TextDocumentIdentifier(uri))).get();
                this.setKeys(symbols);
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            System.err.println("!!!");
        }
    }

    protected Node[] createNodes(SymbolInformation sym) {
        AbstractNode n = new AbstractNode(LEAF);
        n.setDisplayName(sym.getName());
        n.setIconBaseWithExtension(Icons.getSymbolIconBase(sym.getKind()));
        return new Node[]{n};
    }

    public void resultChanged(LookupEvent arg0) {
        this.updateFile();
    }

    public static final class DynamicRegistrationImpl
    implements NavigatorPanel.DynamicRegistration {
        public Collection<? extends NavigatorPanel> panelsFor(URI uri) {
            try {
                FileObject file = URLMapper.findFileObject((URL)uri.toURL());
                if (file != null) {
                    return LSPBindings.getBindings(file) != null ? Collections.singletonList(INSTANCE) : Collections.emptyList();
                }
                return Collections.emptyList();
            }
            catch (MalformedURLException ex) {
                return Collections.emptyList();
            }
        }
    }
}

