/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.editor.DialogSupport;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.openide.util.NbBundle;

public class BookmarkKeyChooser
implements KeyListener,
ActionListener {
    private static BookmarkKeyChooser INSTANCE = new BookmarkKeyChooser();
    private BookmarkInfo result;
    private Runnable runOnClose;
    private Map<Character, BookmarkInfo> key2bookmark;
    private Dialog dialog;
    private JButton closeButton;

    public static BookmarkKeyChooser get() {
        return INSTANCE;
    }

    private BookmarkKeyChooser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Component parent, Runnable runOnClose) {
        this.runOnClose = runOnClose;
        this.key2bookmark = new HashMap<Character, BookmarkInfo>(92, 0.5f);
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            for (ProjectBookmarks projectBookmarks : lockedBookmarkManager.activeProjectBookmarks()) {
                for (FileBookmarks fileBookmarks : projectBookmarks.getFileBookmarks()) {
                    for (BookmarkInfo bookmark : fileBookmarks.getBookmarks()) {
                        String key = bookmark.getKey();
                        if (key == null || key.length() <= 0) continue;
                        this.key2bookmark.put(Character.valueOf(key.charAt(0)), bookmark);
                    }
                }
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
        JPanel cellPanel = new JPanel();
        if (this.key2bookmark.size() > 0) {
            cellPanel.setLayout(new GridLayout(4, 10, 2, 2));
            this.addCells(cellPanel, 40, '1', '9', '0', '0', 'A', 'Z');
        } else {
            cellPanel.setLayout(new GridLayout(2, 1, 2, 2));
            JLabel noKeysLabel = new JLabel(NbBundle.getMessage(BookmarkKeyChooser.class, (String)"LBL_keyChooserNoActiveKeys"), 0);
            JLabel noKeysHelpLabel = new JLabel(NbBundle.getMessage(BookmarkKeyChooser.class, (String)"LBL_keyChooserNoActiveKeysHelp"), 0);
            cellPanel.add(noKeysLabel);
            cellPanel.add(noKeysHelpLabel);
        }
        cellPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.closeButton = new JButton(NbBundle.getMessage(BookmarkKeyChooser.class, (String)"CTL_keyChooserCloseButton"));
        this.dialog = DialogSupport.createDialog((String)NbBundle.getMessage(BookmarkKeyChooser.class, (String)"CTL_keyChooserTitle"), (JPanel)cellPanel, (boolean)true, (JButton[])new JButton[]{this.closeButton}, (boolean)false, (int)0, (int)0, (ActionListener)this);
        this.dialog.pack();
        Point parentMidPoint = new Point(parent.getWidth() / 2, parent.getHeight() / 2);
        SwingUtilities.convertPointToScreen(parentMidPoint, parent);
        this.dialog.setBounds(parentMidPoint.x - this.dialog.getWidth() / 2, parentMidPoint.y - this.dialog.getHeight() / 2, this.dialog.getWidth(), this.dialog.getHeight());
        this.closeButton.addKeyListener(this);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setVisible(true);
    }

    public BookmarkInfo getandClearResult() {
        BookmarkInfo ret = this.result;
        this.result = null;
        return ret;
    }

    private void dispose() {
        this.closeButton.removeKeyListener(this);
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.key2bookmark = null;
        this.closeButton = null;
        this.dialog = null;
        Runnable r = this.runOnClose;
        this.runOnClose = null;
        r.run();
    }

    private void addCells(JPanel cellPanel, int cellCount, char ... startToLastPairs) {
        Color foreColor = UIManager.getColor("Table.foreground");
        Color backColor = UIManager.getColor("Table.background");
        Color selForeColor = UIManager.getColor("Table.selectionForeground");
        Color selBackColor = UIManager.getColor("Table.selectionBackground");
        LineBorder cellBorder = new LineBorder(Color.BLACK, 1, true);
        int cellId = 0;
        int i = 0;
        while (i < startToLastPairs.length) {
            char start = startToLastPairs[i++];
            char last = startToLastPairs[i++];
            while (start <= last) {
                JLabel cell = new JLabel(" " + start + " ", 0){

                    @Override
                    public void paintComponent(Graphics g) {
                        Rectangle clip = g.getClipBounds();
                        Color origColor = g.getColor();
                        g.setColor(this.getBackground());
                        g.fillRect(clip.x, clip.y, clip.width, clip.height);
                        g.setColor(origColor);
                        super.paintComponent(g);
                    }
                };
                final BookmarkInfo bookmark = this.key2bookmark.get(Character.valueOf(start));
                if (bookmark != null) {
                    cell.setForeground(selForeColor);
                    cell.setBackground(selBackColor);
                    cell.setToolTipText(bookmark.getDescription(true, false, false));
                    cell.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 1) {
                                BookmarkKeyChooser.this.result = bookmark;
                                BookmarkKeyChooser.this.dispose();
                            }
                        }
                    });
                } else {
                    cell.setForeground(foreColor);
                    cell.setBackground(backColor);
                    cell.setToolTipText(NbBundle.getMessage(BookmarkKeyChooser.class, (String)"CTL_keyChooserUnoccupiedBookmarkKey"));
                }
                cell.setBorder(cellBorder);
                cellPanel.add(cell);
                ++cellId;
                start = (char)(start + '\u0001');
            }
        }
        while (cellId < cellCount) {
            cellPanel.add(new JPanel());
            ++cellId;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        BookmarkInfo bookmark;
        int keyCode = e.getKeyCode();
        char ch = '\u0000';
        if (48 <= keyCode && keyCode <= 57) {
            ch = (char)(keyCode - 48 + 48);
        } else if (65 <= keyCode && keyCode <= 90) {
            ch = (char)(keyCode - 65 + 65);
        }
        if (ch != '\u0000' && (bookmark = this.key2bookmark.get(Character.valueOf(ch))) != null) {
            this.result = bookmark;
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

