/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.eclipse.jgit.ignore.internal.Strings;

public class FastIgnoreRule {
    public static final char PATH_SEPARATOR = '/';
    private static final NoResultMatcher NO_MATCH = new NoResultMatcher();
    private final IMatcher matcher;
    private final boolean inverse;
    private final boolean dirOnly;

    public FastIgnoreRule(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null!");
        }
        if (pattern.length() == 0) {
            this.dirOnly = false;
            this.inverse = false;
            this.matcher = NO_MATCH;
            return;
        }
        boolean bl = this.inverse = pattern.charAt(0) == '!';
        if (this.inverse && (pattern = pattern.substring(1)).length() == 0) {
            this.dirOnly = false;
            this.matcher = NO_MATCH;
            return;
        }
        if (pattern.charAt(0) == '#') {
            this.matcher = NO_MATCH;
            this.dirOnly = false;
        } else {
            IMatcher m;
            boolean bl2 = this.dirOnly = pattern.charAt(pattern.length() - 1) == '/';
            if (this.dirOnly && (pattern = Strings.stripTrailing(pattern, '/')).length() == 0) {
                this.matcher = NO_MATCH;
                return;
            }
            try {
                m = PathMatcher.createPathMatcher(pattern, Character.valueOf('/'), this.dirOnly);
            }
            catch (InvalidPatternException e) {
                m = NO_MATCH;
            }
            this.matcher = m;
        }
    }

    public boolean isMatch(String path, boolean directory) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        boolean match = this.matcher.matches(path, directory);
        return match;
    }

    public boolean getNameOnly() {
        return !(this.matcher instanceof PathMatcher);
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.inverse;
    }

    public boolean getResult() {
        return !this.inverse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.inverse) {
            sb.append('!');
        }
        sb.append(this.matcher);
        if (this.dirOnly) {
            sb.append('/');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inverse ? 1231 : 1237);
        result = 31 * result + (this.dirOnly ? 1231 : 1237);
        result = 31 * result + (this.matcher == null ? 0 : this.matcher.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FastIgnoreRule)) {
            return false;
        }
        FastIgnoreRule other = (FastIgnoreRule)obj;
        if (this.inverse != other.inverse) {
            return false;
        }
        if (this.dirOnly != other.dirOnly) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }

    static final class NoResultMatcher
    implements IMatcher {
        NoResultMatcher() {
        }

        public boolean matches(String path, boolean assumeDirectory) {
            return false;
        }

        public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
            return false;
        }
    }
}

