/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ProcedureNodeProvider
extends NodeProvider {
    private static final Logger LOG = Logger.getLogger(ProcedureNodeProvider.class.getName());
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Schema> schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private String schemaName;
    private static final Comparator<Node> procedureComparator = new Comparator<Node>(){

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareTo(model2.getDisplayName());
        }
    };
    private Set<String> validObjects = null;
    private Map<String, ProcedureNode.Type> object2type = null;

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ProcedureNodeProvider(Lookup lookup) {
        super(lookup, procedureComparator);
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Schema schema = (Schema)ProcedureNodeProvider.this.schemaHandle.resolve(metaData);
                        if (schema != null) {
                            ProcedureNodeProvider.this.schemaName = schema.getName();
                            Collection procedures = schema.getProcedures();
                            for (Procedure procedure : procedures) {
                                MetadataElementHandle handle = MetadataElementHandle.create((MetadataElement)procedure);
                                Collection matches = ProcedureNodeProvider.this.getNodes(handle);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(ProcedureNodeProvider.this.connection);
                                lookup.add(handle);
                                newList.add(ProcedureNode.create(lookup, ProcedureNodeProvider.this, schema.getName()));
                            }
                        } else {
                            ProcedureNodeProvider.this.schemaName = null;
                        }
                    }
                });
                this.refreshObjects();
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        this.refreshObjects();
    }

    private synchronized void refreshObjects() {
        if (this.connection != null && "MySQL".equalsIgnoreCase(this.connection.getDriverName())) {
            boolean connected = this.connection.isConnected();
            MetadataModel metaDataModel = this.connection.getMetadataModel();
            if (connected && metaDataModel != null) {
                try {
                    metaDataModel.runReadAction((Action)new Action<Metadata>(){

                        public void run(Metadata metaData) {
                            ProcedureNodeProvider.this.object2type = new HashMap();
                            ProcedureNodeProvider.this.validObjects = new HashSet();
                            String query = "SELECT NAME, TYPE FROM mysql.proc WHERE TYPE = 'PROCEDURE' OR TYPE = 'FUNCTION'";
                            try (Statement stmt = ProcedureNodeProvider.this.connection.getJDBCConnection().createStatement();
                                 ResultSet rs = stmt.executeQuery(query);){
                                while (rs.next()) {
                                    String objectName = rs.getString("NAME");
                                    String objectType = rs.getString("TYPE");
                                    if ("PROCEDURE".equals(objectType)) {
                                        ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Procedure);
                                    } else if ("FUNCTION".equals(objectType)) {
                                        ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Function);
                                    } else assert (false) : "Unknown type " + objectType;
                                    ProcedureNodeProvider.this.validObjects.add(objectName);
                                }
                            }
                            catch (SQLException ex) {
                                LOG.log(Level.INFO, ex + "{0} while refreshStatuses() of triggers in schema {1}", new Object[]{ex, ProcedureNodeProvider.this.schemaName});
                            }
                            String query2 = "SELECT TRIGGER_NAME FROM information_schema.triggers";
                            try (Statement stmt = ProcedureNodeProvider.this.connection.getJDBCConnection().createStatement();
                                 ResultSet rs = stmt.executeQuery(query2);){
                                while (rs.next()) {
                                    String objectName = rs.getString("TRIGGER_NAME");
                                    ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Trigger);
                                    ProcedureNodeProvider.this.validObjects.add(objectName);
                                }
                            }
                            catch (SQLException ex) {
                                LOG.log(Level.INFO, ex + "{0} while refreshStatuses() of triggers in schema {1}", new Object[]{ex, ProcedureNodeProvider.this.schemaName});
                            }
                        }
                    });
                }
                catch (MetadataModelException e) {
                    NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
                }
            }
        } else if (this.connection != null && this.connection.getDriverName() != null && this.connection.getDriverName().startsWith("Oracle")) {
            boolean connected = this.connection.isConnected();
            MetadataModel metaDataModel = this.connection.getMetadataModel();
            if (this.schemaName == null) {
                LOG.log(Level.INFO, "No schema for {0}", this);
                return;
            }
            if (connected && metaDataModel != null) {
                try {
                    metaDataModel.runReadAction((Action)new Action<Metadata>(){

                        public void run(Metadata metaData) {
                            ProcedureNodeProvider.this.validObjects = new HashSet();
                            ProcedureNodeProvider.this.object2type = new HashMap();
                            String schemaEscaped = ProcedureNodeProvider.this.schemaName.replace("'", "''");
                            String query = "SELECT OBJECT_NAME, STATUS, OBJECT_TYPE FROM SYS.ALL_OBJECTS  WHERE OWNER='" + schemaEscaped + "'  AND ( OBJECT_TYPE = 'PROCEDURE' OR OBJECT_TYPE = 'TRIGGER' OR OBJECT_TYPE = 'FUNCTION' )";
                            try (Statement stmt = ProcedureNodeProvider.this.connection.getJDBCConnection().createStatement();
                                 ResultSet rs = stmt.executeQuery(query);){
                                while (rs.next()) {
                                    String objectType;
                                    String objectName = rs.getString("OBJECT_NAME");
                                    String status = rs.getString("STATUS");
                                    boolean valid = "VALID".equals(status);
                                    if (valid) {
                                        ProcedureNodeProvider.this.validObjects.add(objectName);
                                    }
                                    if ("PROCEDURE".equals(objectType = rs.getString("OBJECT_TYPE"))) {
                                        ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Procedure);
                                        continue;
                                    }
                                    if ("FUNCTION".equals(objectType)) {
                                        ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Function);
                                        continue;
                                    }
                                    if ("TRIGGER".equals(objectType)) {
                                        ProcedureNodeProvider.this.object2type.put(objectName, ProcedureNode.Type.Trigger);
                                        continue;
                                    }
                                    assert (false) : "Unknown type " + objectType;
                                }
                            }
                            catch (SQLException ex) {
                                LOG.log(Level.INFO, "{0} while refreshStatuses() of procedures in schema {1}", new Object[]{ex, ProcedureNodeProvider.this.schemaName});
                            }
                        }
                    });
                }
                catch (MetadataModelException e) {
                    NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
                }
            }
        }
    }

    public boolean getStatus(String name) {
        if (this.validObjects == null) {
            this.refreshObjects();
        }
        return this.validObjects.contains(name);
    }

    public ProcedureNode.Type getType(String name) {
        if (this.object2type == null || this.object2type.get(name) == null) {
            this.refreshObjects();
        }
        return this.object2type.get(name);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ProcedureNodeProvider createInstance(Lookup lookup) {
                ProcedureNodeProvider provider = new ProcedureNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

