/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.ElementIdStack;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.streaming.XMLReaderException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.Text;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlTreeReader
extends XMLReaderBase {
    protected SOAPElement root;
    protected SOAPElement currentNode;
    protected int state;
    protected QName name;
    protected ElementIdStack elementIds;
    protected int elementId;
    protected String currentValue;
    protected AttributesAdapter attributes = new AttributesAdapter();

    public XmlTreeReader(SOAPElement root) {
        this.elementIds = new ElementIdStack();
        this.setRoot(root);
    }

    private void setRoot(SOAPElement root) {
        this.root = root;
        this.state = 0;
    }

    public void close() {
        this.state = 5;
    }

    public Attributes getAttributes() {
        this.attributes.initialize();
        return this.attributes;
    }

    public int getElementId() {
        return this.elementId;
    }

    public int getLineNumber() {
        return 0;
    }

    public String getLocalName() {
        return this.currentNode.getElementName().getLocalName();
    }

    public Element getCurrentNode() {
        return this.currentNode;
    }

    public QName getName() {
        if (this.name == null) {
            this.name = new QName(this.getURI(), this.getLocalName());
        }
        return this.name;
    }

    public Iterator getPrefixes() {
        return this.currentNode.getVisibleNamespacePrefixes();
    }

    public int getState() {
        return this.state;
    }

    public String getURI() {
        return this.currentNode.getElementName().getURI();
    }

    public String getURI(String prefix) {
        return this.currentNode.getNamespaceURI(prefix);
    }

    public String getValue() {
        this.currentNode.normalize();
        return this.currentNode.getValue();
    }

    public int next() {
        if (this.state == 5) {
            return 5;
        }
        this.name = null;
        this.attributes.unintialize();
        this.parse();
        switch (this.state) {
            case 1: {
                this.elementId = this.elementIds.pushNext();
                break;
            }
            case 2: {
                this.elementId = this.elementIds.pop();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new XMLReaderException("xmlreader.illegalStateEncountered", Integer.toString(this.state));
            }
        }
        return this.state;
    }

    public void parse() {
        switch (this.state) {
            case 0: {
                this.currentNode = this.root;
                this.state = 1;
                break;
            }
            case 1: {
                this.currentNode.normalize();
                Node first = this.currentNode.getFirstChild();
                if (first != null) {
                    if (first instanceof Text) {
                        Node sec = first.getNextSibling();
                        if (sec != null) {
                            this.currentNode = (SOAPElement)sec;
                            this.state = 1;
                            break;
                        }
                        this.state = 3;
                        this.currentValue = this.currentNode.getValue();
                        if (this.currentValue != null) break;
                        this.state = 2;
                        break;
                    }
                    if (first instanceof SOAPElement) {
                        this.state = 1;
                        this.currentNode = (SOAPElement)first;
                        break;
                    }
                    throw new XMLReaderException("xmlreader.illegalType " + first.getClass());
                }
                this.state = 2;
                break;
            }
            case 2: {
                Node nextNode = this.currentNode.getNextSibling();
                if (nextNode != null && nextNode instanceof Text) {
                    nextNode = nextNode.getNextSibling();
                }
                if (nextNode == null) {
                    if (this.currentNode == this.root) {
                        this.state = 5;
                        break;
                    }
                    this.state = 2;
                    this.currentNode = this.currentNode.getParentElement();
                    break;
                }
                this.state = 1;
                this.currentNode = (SOAPElement)nextNode;
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
            default: {
                throw new XMLReaderException("xmlreader.illegalStateEncountered", Integer.toString(this.state));
            }
        }
    }

    public XMLReader recordElement() {
        this.state = 2;
        return new XmlTreeReader(this.currentNode);
    }

    public void skipElement(int elementId) {
        if (this.state == 5) {
            return;
        }
        while (this.elementId != elementId) {
            this.currentNode = this.currentNode.getParentElement();
            this.elementId = this.elementIds.pop();
        }
        this.state = 2;
    }

    public class AttributesAdapter
    implements Attributes {
        static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
        private boolean initialized = false;
        ArrayList attributeUris = new ArrayList();
        ArrayList attributePrefixes = new ArrayList();
        ArrayList attributeNames = new ArrayList();
        ArrayList attributeValues = new ArrayList();
        ArrayList attributeQNames = new ArrayList();

        void unintialize() {
            if (this.initialized) {
                this.attributeUris.clear();
                this.attributePrefixes.clear();
                this.attributeNames.clear();
                this.attributeValues.clear();
                this.attributeQNames.clear();
                this.initialized = false;
            }
        }

        void initialize() {
            if (!this.initialized) {
                Iterator eachAttribute = XmlTreeReader.this.currentNode.getAllAttributes();
                while (eachAttribute.hasNext()) {
                    Name name = (Name)eachAttribute.next();
                    this.attributeUris.add(name.getURI());
                    this.attributePrefixes.add(name.getPrefix());
                    this.attributeNames.add(name.getLocalName());
                    this.attributeValues.add(XmlTreeReader.this.currentNode.getAttributeValue(name));
                    this.attributeQNames.add(null);
                }
                this.initialized = true;
            }
        }

        public int getLength() {
            this.initialize();
            return this.attributeValues.size();
        }

        public boolean isNamespaceDeclaration(int index) {
            this.initialize();
            return XMLNS_NAMESPACE_URI.equals(this.getURI(index));
        }

        public QName getName(int index) {
            this.initialize();
            if (this.attributeQNames.get(index) == null) {
                QName qname = new QName(this.getURI(index), this.getLocalName(index));
                this.attributeQNames.set(index, qname);
            }
            return (QName)this.attributeQNames.get(index);
        }

        public String getURI(int index) {
            this.initialize();
            return (String)this.attributeUris.get(index);
        }

        public String getLocalName(int index) {
            this.initialize();
            return (String)this.attributeNames.get(index);
        }

        public String getPrefix(int index) {
            this.initialize();
            String prefix = (String)this.attributePrefixes.get(index);
            if (prefix != null && prefix.equals("")) {
                prefix = null;
            }
            return prefix;
        }

        public String getValue(int index) {
            this.initialize();
            return (String)this.attributeValues.get(index);
        }

        public int getIndex(QName name) {
            return this.getIndex(name.getNamespaceURI(), name.getLocalPart());
        }

        public int getIndex(String uri, String localName) {
            this.initialize();
            for (int index = 0; index < this.attributeNames.size(); ++index) {
                if (!this.attributeUris.get(index).equals(uri) || !this.attributeNames.get(index).equals(localName)) continue;
                return index;
            }
            return -1;
        }

        public int getIndex(String localName) {
            this.initialize();
            for (int index = 0; index < this.attributeNames.size(); ++index) {
                if (!this.attributeNames.get(index).equals(localName)) continue;
                return index;
            }
            return -1;
        }

        public String getValue(QName name) {
            int index = this.getIndex(name);
            if (index != -1) {
                return (String)this.attributeValues.get(index);
            }
            return null;
        }

        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index != -1) {
                return (String)this.attributeValues.get(index);
            }
            return null;
        }

        public String getValue(String localName) {
            int index = this.getIndex(localName);
            if (index != -1) {
                return (String)this.attributeValues.get(index);
            }
            return null;
        }
    }
}

