/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import com.sun.xml.ws.security.opt.impl.util.LocalStringManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalStringManagerImpl
implements LocalStringManager {
    private static Logger _logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Class defaultClass;

    public LocalStringManagerImpl(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    @Override
    public String getLocalString(Class callerClass, String key, String defaultValue) {
        Class stopClass = this.defaultClass.getSuperclass();
        Class startClass = callerClass != null ? callerClass : this.defaultClass;
        ResourceBundle resources = null;
        boolean globalDone = false;
        for (Class c = startClass; c != stopClass && c != null; c = c.getSuperclass()) {
            globalDone = c == this.defaultClass;
            try {
                String value;
                StringBuilder resFileName = new StringBuilder(c.getName().substring(0, c.getName().lastIndexOf(".")));
                resFileName.append(".LocalStrings");
                resources = ResourceBundle.getBundle(resFileName.toString(), Locale.getDefault(), c.getClassLoader());
                if (resources == null || (value = resources.getString(key)) == null) continue;
                return value;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!globalDone) {
            return this.getLocalString(null, key, defaultValue);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "No local string for " + key);
        }
        return defaultValue;
    }

    @Override
    public String getLocalString(String key, String defaultValue) {
        return this.getLocalString(null, key, defaultValue);
    }

    @Override
    public String getLocalString(Class callerClass, String key, String defaultFormat, Object ... arguments) {
        MessageFormat f = new MessageFormat(this.getLocalString(callerClass, key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        return f.format(arguments);
    }

    public String getLocalString(String key, String defaultFormat, Object ... arguments) {
        return this.getLocalString(null, key, defaultFormat, arguments);
    }
}

