/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;

public class VersionOutputProcessorFactory
implements ExecutionDescriptor.InputProcessorFactory2 {
    private final Pattern versionPattern;
    volatile String version;

    public VersionOutputProcessorFactory(String versionPattern) {
        assert (versionPattern != null);
        this.versionPattern = Pattern.compile(versionPattern, 2);
    }

    public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
        return InputProcessors.bridge((LineProcessor)new LineProcessor(){

            public void processLine(String line) {
                if (VersionOutputProcessorFactory.this.version == null) {
                    VersionOutputProcessorFactory.this.version = VersionOutputProcessorFactory.this.parseVersion(line);
                }
            }

            public void reset() {
            }

            public void close() {
            }
        });
    }

    public String getVersion() {
        return this.version;
    }

    @CheckForNull
    public String parseVersion(String line) {
        Matcher matcher = this.versionPattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

