/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class JsonElementTypeAdapter
extends TypeAdapter<Object> {
    private final Gson gson;

    public JsonElementTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public JsonElement read(JsonReader in) throws IOException {
        return (JsonElement)TypeAdapters.JSON_ELEMENT.read(in);
    }

    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof JsonElement) {
            TypeAdapters.JSON_ELEMENT.write(out, (Object)((JsonElement)value));
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new JsonElementTypeAdapter(gson);
        }
    }
}

