/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveMessageRequestMarshaller
implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {
    @Override
    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {
        DefaultRequest<ReceiveMessageRequest> request = new DefaultRequest<ReceiveMessageRequest>(receiveMessageRequest, "AmazonSQS");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2009-02-01");
        if (receiveMessageRequest != null && receiveMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(receiveMessageRequest.getQueueUrl()));
        }
        if (receiveMessageRequest != null) {
            List<String> attributeNamesList = receiveMessageRequest.getAttributeNames();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString(attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (receiveMessageRequest != null && receiveMessageRequest.getMaxNumberOfMessages() != null) {
            request.addParameter("MaxNumberOfMessages", StringUtils.fromInteger(receiveMessageRequest.getMaxNumberOfMessages()));
        }
        if (receiveMessageRequest != null && receiveMessageRequest.getVisibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringUtils.fromInteger(receiveMessageRequest.getVisibilityTimeout()));
        }
        return request;
    }
}

