/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public abstract class Rule<E extends Element> {
    public final ErrorDescription[] execute(E subject, ProblemContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            return this.apply(subject, ctx);
        }
        return null;
    }

    protected abstract ErrorDescription[] apply(E var1, ProblemContext var2);

    protected abstract boolean isApplicable(E var1, ProblemContext var2);

    public static ErrorDescription createProblem(Element subject, ProblemContext ctx, String description) {
        return Rule.createProblem(subject, ctx, description, Severity.ERROR, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element subject, ProblemContext ctx, String description, Severity severity) {
        return Rule.createProblem(subject, ctx, description, severity, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element subject, ProblemContext ctx, String description, Severity severity, Fix fix) {
        return Rule.createProblem(subject, ctx, description, severity, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, ProblemContext ctx, String description, Fix fix) {
        return Rule.createProblem(subject, ctx, description, Severity.ERROR, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, ProblemContext ctx, String description, Severity severity, List<Fix> fixes) {
        Tree elementTree;
        ErrorDescription err = null;
        List<Object> fixList = fixes == null ? Collections.emptyList() : fixes;
        Tree tree = elementTree = ctx.getElementToAnnotate() == null ? ctx.getCompilationInfo().getTrees().getTree(subject) : ctx.getElementToAnnotate();
        if (elementTree != null) {
            Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
            err = ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, fixList, (FileObject)ctx.getFileObject(), (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset());
        }
        return err;
    }
}

