/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.BootstrapResolver;
import org.apache.xml.resolver.helpers.Debug;

public class NbCatalogManager
extends CatalogManager {
    private static String pFiles = "xml.catalog.files";
    private static String pVerbosity = "xml.catalog.verbosity";
    private static String pPrefer = "xml.catalog.prefer";
    private static String pStatic = "xml.catalog.staticCatalog";
    private static String pAllowPI = "xml.catalog.allowPI";
    private static String pClassname = "xml.catalog.className";
    private static String pIgnoreMissing = "xml.catalog.ignoreMissing";
    private static NbCatalogManager staticManager = new NbCatalogManager();
    private BootstrapResolver bResolver = new BootstrapResolver();
    private boolean ignoreMissingProperties = System.getProperty(pIgnoreMissing) != null || System.getProperty(pFiles) != null;
    private ResourceBundle resources;
    private String propertyFile = "CatalogManager.properties";
    private URL propertyFileURI = null;
    private String defaultCatalogFiles = "./xcatalog";
    private String catalogFiles = null;
    private boolean fromPropertiesFile = false;
    private int defaultVerbosity = 1;
    private Integer verbosity = null;
    private boolean defaultPreferPublic = true;
    private Boolean preferPublic = null;
    private boolean defaultUseStaticCatalog = true;
    private Boolean useStaticCatalog = null;
    private static Catalog staticCatalog = null;
    private boolean defaultOasisXMLCatalogPI = true;
    private Boolean oasisXMLCatalogPI = null;
    private boolean defaultRelativeCatalogs = true;
    private Boolean relativeCatalogs = null;
    private String catalogClassName = null;
    public Debug debug = null;

    public NbCatalogManager() {
        this.debug = new Debug();
    }

    public NbCatalogManager(String string) {
        this.propertyFile = string;
        this.debug = new Debug();
    }

    @Override
    public void setBootstrapResolver(BootstrapResolver bootstrapResolver) {
        this.bResolver = bootstrapResolver;
    }

    @Override
    public BootstrapResolver getBootstrapResolver() {
        return this.bResolver;
    }

    private synchronized void readProperties() {
        Object object;
        block10: {
            if (this.propertyFile == null) {
                return;
            }
            try {
                this.propertyFileURI = NbCatalogManager.class.getResource("/" + this.propertyFile);
                object = NbCatalogManager.class.getResourceAsStream("/" + this.propertyFile);
                if (object == null) {
                    if (!this.ignoreMissingProperties) {
                        this.debug.message(2, "Cannot find " + this.propertyFile);
                        this.ignoreMissingProperties = true;
                    }
                    return;
                }
                this.resources = new PropertyResourceBundle((InputStream)object);
            }
            catch (MissingResourceException missingResourceException) {
                if (!this.ignoreMissingProperties) {
                    System.err.println("Cannot read " + this.propertyFile);
                }
            }
            catch (IOException iOException) {
                if (this.ignoreMissingProperties) break block10;
                System.err.println("Failure trying to read " + this.propertyFile);
            }
        }
        if (this.verbosity == null) {
            try {
                object = this.resources.getString("verbosity");
                int n = Integer.parseInt(((String)object).trim());
                this.debug.setDebug(n);
                this.verbosity = new Integer(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static CatalogManager getStaticManager() {
        return staticManager;
    }

    @Override
    public boolean getIgnoreMissingProperties() {
        return this.ignoreMissingProperties;
    }

    @Override
    public void setIgnoreMissingProperties(boolean bl) {
        this.ignoreMissingProperties = bl;
    }

    @Override
    public void ignoreMissingProperties(boolean bl) {
        this.setIgnoreMissingProperties(bl);
    }

    private int queryVerbosity() {
        String string = Integer.toString(this.defaultVerbosity);
        String string2 = System.getProperty(pVerbosity);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources != null) {
                try {
                    string2 = this.resources.getString("verbosity");
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = string;
                }
            } else {
                string2 = string;
            }
        }
        int n = this.defaultVerbosity;
        try {
            n = Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            System.err.println("Cannot parse verbosity: \"" + string2 + "\"");
        }
        if (this.verbosity == null) {
            this.debug.setDebug(n);
            this.verbosity = new Integer(n);
        }
        return n;
    }

    @Override
    public int getVerbosity() {
        if (this.verbosity == null) {
            this.verbosity = new Integer(this.queryVerbosity());
        }
        return this.verbosity;
    }

    @Override
    public void setVerbosity(int n) {
        this.verbosity = new Integer(n);
        this.debug.setDebug(n);
    }

    @Override
    public int verbosity() {
        return this.getVerbosity();
    }

    private boolean queryRelativeCatalogs() {
        if (this.resources == null) {
            this.readProperties();
        }
        if (this.resources == null) {
            return this.defaultRelativeCatalogs;
        }
        try {
            String string = this.resources.getString("relative-catalogs");
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
        }
        catch (MissingResourceException missingResourceException) {
            return this.defaultRelativeCatalogs;
        }
    }

    @Override
    public boolean getRelativeCatalogs() {
        if (this.relativeCatalogs == null) {
            this.relativeCatalogs = new Boolean(this.queryRelativeCatalogs());
        }
        return this.relativeCatalogs;
    }

    @Override
    public void setRelativeCatalogs(boolean bl) {
        this.relativeCatalogs = new Boolean(bl);
    }

    @Override
    public boolean relativeCatalogs() {
        return this.getRelativeCatalogs();
    }

    private String queryCatalogFiles() {
        String string = System.getProperty(pFiles);
        this.fromPropertiesFile = false;
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources != null) {
                try {
                    string = this.resources.getString("catalogs");
                    this.fromPropertiesFile = true;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println(this.propertyFile + ": catalogs not found.");
                    string = null;
                }
            }
        }
        if (string == null) {
            string = this.defaultCatalogFiles;
        }
        return string;
    }

    @Override
    public Vector getCatalogFiles() {
        if (this.catalogFiles == null) {
            this.catalogFiles = this.queryCatalogFiles();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.catalogFiles, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            URL uRL = null;
            if (this.fromPropertiesFile && !this.relativeCatalogs()) {
                try {
                    uRL = new URL(this.propertyFileURI, string);
                    string = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            vector.add(string);
        }
        return vector;
    }

    @Override
    public void setCatalogFiles(String string) {
        this.catalogFiles = string;
        this.fromPropertiesFile = false;
    }

    @Override
    public Vector catalogFiles() {
        return this.getCatalogFiles();
    }

    private boolean queryPreferPublic() {
        String string = System.getProperty(pPrefer);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultPreferPublic;
            }
            try {
                string = this.resources.getString("prefer");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultPreferPublic;
            }
        }
        if (string == null) {
            return this.defaultPreferPublic;
        }
        return string.equalsIgnoreCase("public");
    }

    @Override
    public boolean getPreferPublic() {
        if (this.preferPublic == null) {
            this.preferPublic = new Boolean(this.queryPreferPublic());
        }
        return this.preferPublic;
    }

    @Override
    public void setPreferPublic(boolean bl) {
        this.preferPublic = new Boolean(bl);
    }

    @Override
    public boolean preferPublic() {
        return this.getPreferPublic();
    }

    private boolean queryUseStaticCatalog() {
        String string = System.getProperty(pStatic);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultUseStaticCatalog;
            }
            try {
                string = this.resources.getString("static-catalog");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultUseStaticCatalog;
            }
        }
        if (string == null) {
            return this.defaultUseStaticCatalog;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    @Override
    public boolean getUseStaticCatalog() {
        if (this.useStaticCatalog == null) {
            this.useStaticCatalog = new Boolean(this.queryUseStaticCatalog());
        }
        return this.useStaticCatalog;
    }

    @Override
    public void setUseStaticCatalog(boolean bl) {
        this.useStaticCatalog = new Boolean(bl);
    }

    @Override
    public boolean staticCatalog() {
        return this.getUseStaticCatalog();
    }

    @Override
    public Catalog getPrivateCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            this.useStaticCatalog = new Boolean(this.getUseStaticCatalog());
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            try {
                String string = this.getCatalogClassName();
                if (string == null) {
                    catalog = new Catalog();
                } else {
                    try {
                        catalog = (Catalog)Class.forName(string).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.debug.message(1, "Catalog class named '" + string + "' could not be found. Using default.");
                        catalog = new Catalog();
                    }
                    catch (ClassCastException classCastException) {
                        this.debug.message(1, "Class named '" + string + "' is not a Catalog. Using default.");
                        catalog = new Catalog();
                    }
                }
                catalog.setCatalogManager(this);
                catalog.setupReaders();
                catalog.loadSystemCatalogs();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    @Override
    public Catalog getCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            this.useStaticCatalog = new Boolean(this.getUseStaticCatalog());
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            catalog = this.getPrivateCatalog();
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    @Override
    public boolean queryAllowOasisXMLCatalogPI() {
        String string = System.getProperty(pAllowPI);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultOasisXMLCatalogPI;
            }
            try {
                string = this.resources.getString("allow-oasis-xml-catalog-pi");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultOasisXMLCatalogPI;
            }
        }
        if (string == null) {
            return this.defaultOasisXMLCatalogPI;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    @Override
    public boolean getAllowOasisXMLCatalogPI() {
        if (this.oasisXMLCatalogPI == null) {
            this.oasisXMLCatalogPI = new Boolean(this.queryAllowOasisXMLCatalogPI());
        }
        return this.oasisXMLCatalogPI;
    }

    @Override
    public void setAllowOasisXMLCatalogPI(boolean bl) {
        this.oasisXMLCatalogPI = new Boolean(bl);
    }

    @Override
    public boolean allowOasisXMLCatalogPI() {
        return this.getAllowOasisXMLCatalogPI();
    }

    @Override
    public String queryCatalogClassName() {
        String string = System.getProperty(pClassname);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return null;
            }
            try {
                return this.resources.getString("catalog-class-name");
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return string;
    }

    @Override
    public String getCatalogClassName() {
        if (this.catalogClassName == null) {
            this.catalogClassName = this.queryCatalogClassName();
        }
        return this.catalogClassName;
    }

    @Override
    public void setCatalogClassName(String string) {
        this.catalogClassName = string;
    }

    @Override
    public String catalogClassName() {
        return this.getCatalogClassName();
    }
}

