/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;

public class ResultsView
extends JPanel {
    private Component mainToolbar;
    private Component currentToolbar;
    private final List<Component> toolbars = new ArrayList<Component>();
    private JTabbedPane tabs;
    private Component firstView;
    private String firstName;
    private Icon firstIcon;
    private String firstDescription;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();

    public ResultsView() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(0, 0));
    }

    public final void setMainToolbar(Component toolbar) {
        if (this.mainToolbar == toolbar) {
            return;
        }
        this.mainToolbar = toolbar;
        this.setToolbar(this.mainToolbar);
    }

    public final void addView(String name, Icon icon, String description, Component view, Component toolbar) {
        if (view == null) {
            return;
        }
        if (this.tabs == null) {
            if (this.firstView == null) {
                this.firstView = view;
                this.firstName = name;
                this.firstIcon = icon;
                this.firstDescription = description;
                this.toolbars.add(toolbar);
                this.add(view, "Center");
                this.setToolbar(toolbar);
                this.fireViewOrIndexChanged();
            } else {
                this.remove(this.firstView);
                this.toolbars.add(toolbar);
                this.tabs = this.createTabs();
                this.tabs.addTab(this.firstName, this.firstIcon, this.firstView, this.firstDescription);
                this.tabs.addTab(name, icon, view, description);
                this.add((Component)this.tabs, "Center");
                this.firstView = null;
                this.firstName = null;
                this.firstIcon = null;
                this.firstDescription = null;
            }
        } else {
            if (this.tabs.indexOfComponent(view) != -1) {
                return;
            }
            this.tabs.addTab(name, icon, view, description);
            this.toolbars.add(toolbar);
        }
    }

    public final void removeView(Component view) {
        if (view == null) {
            return;
        }
        if (this.tabs != null) {
            int viewIndex = this.tabs.indexOfComponent(view);
            if (viewIndex == -1) {
                return;
            }
            if (this.tabs.getTabCount() > 2) {
                this.toolbars.remove(viewIndex);
                this.tabs.remove(view);
            } else {
                this.tabs.remove(view);
                this.firstView = this.tabs.getComponentAt(0);
                this.firstName = this.tabs.getTitleAt(0);
                this.firstIcon = this.tabs.getIconAt(0);
                this.firstDescription = this.tabs.getToolTipTextAt(0);
                this.remove(this.tabs);
                this.add(this.firstView);
                this.setToolbar(this.toolbars.get(0));
                this.tabs = null;
            }
        } else if (this.firstView == view) {
            this.remove(this.firstView);
            this.setToolbar(null);
            this.toolbars.clear();
            this.firstView = null;
            this.firstName = null;
            this.firstIcon = null;
            this.firstDescription = null;
            this.fireViewOrIndexChanged();
        }
    }

    public final void removeViews() {
        if (this.getViewsCount() == 0) {
            return;
        }
        this.setToolbar(null);
        this.removeAll();
        this.toolbars.clear();
        this.tabs = null;
        this.firstView = null;
        this.firstName = null;
        this.firstIcon = null;
        this.firstDescription = null;
        this.fireViewOrIndexChanged();
    }

    public final void setViewName(Component view, String name) {
        int viewIndex = this.getViewIndex(view);
        if (viewIndex == -1) {
            return;
        }
        if (this.tabs == null) {
            this.firstName = name;
        } else {
            this.tabs.setTitleAt(viewIndex, name);
        }
    }

    public final String getViewName(Component view) {
        int viewIndex = this.getViewIndex(view);
        if (viewIndex == -1) {
            return null;
        }
        if (this.tabs == null) {
            return this.firstName;
        }
        return this.tabs.getTitleAt(viewIndex);
    }

    public final void setViewEnabled(Component view, boolean enabled) {
        int viewIndex = this.getViewIndex(view);
        if (viewIndex == -1) {
            return;
        }
        if (this.tabs != null) {
            this.tabs.setEnabledAt(viewIndex, enabled);
        }
    }

    public final boolean isViewEnabled(Component view) {
        int viewIndex = this.getViewIndex(view);
        if (viewIndex == -1) {
            return false;
        }
        return this.tabs == null ? false : this.tabs.isEnabledAt(viewIndex);
    }

    public final void selectView(Component view) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.setSelectedComponent(view);
    }

    public final void selectView(int index) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.setSelectedIndex(index);
    }

    public final void selectPreviousView() {
        if (this.tabs == null) {
            return;
        }
        int index = UIUtils.getPreviousSubTabIndex(this.tabs, this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(index);
    }

    public final void selectNextView() {
        if (this.tabs == null) {
            return;
        }
        int index = UIUtils.getNextSubTabIndex(this.tabs, this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(index);
    }

    public final Component getSelectedView() {
        return this.tabs != null ? this.tabs.getSelectedComponent() : (this.firstView != null ? this.firstView : null);
    }

    public final int getSelectedViewIndex() {
        return this.tabs != null ? this.tabs.getSelectedIndex() : (this.firstView != null ? 0 : -1);
    }

    public final int getViewsCount() {
        return this.tabs != null ? this.tabs.getTabCount() : (this.firstView != null ? 1 : 0);
    }

    public final void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public final void fireViewOrIndexChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private int getViewIndex(Component view) {
        if (view == null) {
            return -1;
        }
        if (this.tabs != null) {
            return this.tabs.indexOfComponent(view);
        }
        return view == this.firstView ? 0 : -1;
    }

    private void setToolbar(Component toolbar) {
        if (this.currentToolbar == toolbar) {
            return;
        }
        if (this.currentToolbar != null) {
            this.remove(this.currentToolbar);
        }
        this.currentToolbar = toolbar != null ? toolbar : this.mainToolbar;
        if (this.currentToolbar != null) {
            this.add(this.currentToolbar, "North");
        }
        this.revalidate();
        this.repaint();
    }

    private void updateToolbar() {
        this.setToolbar(this.toolbars.get(this.getSelectedViewIndex()));
    }

    private JTabbedPane createTabs() {
        JTabbedPane tp = new JTabbedPane(3){

            @Override
            protected final void fireStateChanged() {
                super.fireStateChanged();
                ResultsView.this.updateToolbar();
                ResultsView.this.fireViewOrIndexChanged();
            }
        };
        tp.setOpaque(false);
        if (UIUtils.isAquaLookAndFeel()) {
            tp.setBorder(BorderFactory.createEmptyBorder(-13, -11, 0, -10));
        } else {
            tp.setBorder(BorderFactory.createEmptyBorder());
            Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
            if (i != null) {
                tp.setBorder(BorderFactory.createEmptyBorder(-i.top, -i.left, 0, -i.right));
            }
        }
        tp.getActionMap().getParent().remove("navigatePageUp");
        tp.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsView.this.selectPreviousView();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsView.this.selectNextView();
            }
        });
        return tp;
    }
}

