/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AnnotationComponent;
import org.netbeans.modules.classfile.ArrayElementValue;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassElementValue;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ElementValue;
import org.netbeans.modules.classfile.EnclosingMethod;
import org.netbeans.modules.classfile.EnumElementValue;
import org.netbeans.modules.classfile.Field;
import org.netbeans.modules.classfile.InnerClass;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.LocalVariableTypeTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.NestedElementValue;
import org.netbeans.modules.classfile.Variable;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryName;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.LongHashMap;
import org.netbeans.modules.java.source.usages.UsagesData;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.SuspendSupport;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class BinaryAnalyser {
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";
    private static final String OUTHER_THIS_PREFIX = "this$";
    private static final String ACCESS_METHOD_PREFIX = "access$";
    private static final String ASSERTIONS_DISABLED = "$assertionsDisabled";
    private static final String ROOT = "/";
    private static final String TIME_STAMPS = "timestamps.properties";
    private static final String CRC = "crc.properties";
    private static final Logger LOGGER = Logger.getLogger(BinaryAnalyser.class.getName());
    private static final String JCOMPONENT = JComponent.class.getName();
    static final String OBJECT = Object.class.getName();
    private final ClassIndexImpl.Writer writer;
    private final File cacheRoot;
    private final List<Pair<Pair<BinaryName, String>, Object[]>> refs = new ArrayList<Pair<Pair<BinaryName, String>, Object[]>>();
    private final Set<Pair<String, String>> toDelete = new HashSet<Pair<String, String>>();
    private final LowMemoryWatcher lmListener;
    private final Config cfg;
    private Pair<LongHashMap<String>, Set<String>> timeStamps;

    BinaryAnalyser(@NonNull ClassIndexImpl.Writer writer, @NonNull File cacheRoot) {
        Parameters.notNull((CharSequence)"writer", (Object)writer);
        Parameters.notNull((CharSequence)"cacheRoot", (Object)cacheRoot);
        this.writer = writer;
        this.cacheRoot = cacheRoot;
        this.lmListener = LowMemoryWatcher.getInstance();
        this.cfg = Config.getDefault();
    }

    @NonNull
    public final Changes analyse(@NonNull Context ctx) throws IOException, IllegalArgumentException {
        return this.analyse(ctx, ctx.getRootURI());
    }

    @NonNull
    public final Changes analyse(@NonNull Context ctx, URL processRoot) throws IOException, IllegalArgumentException {
        return this.analyse(ctx, this.createProcessor(ctx, processRoot));
    }

    @NonNull
    public final Changes analyse(@NonNull Context ctx, File root, Iterable<File> files) throws IOException, IllegalArgumentException {
        return this.analyse(ctx, new EnumerateFilesProcessor(ctx, root, files));
    }

    @NonNull
    private Changes analyse(@NonNull Context ctx, @NonNull RootProcessor p) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"ctx", (Object)ctx);
        if (p.execute()) {
            if (!p.hasChanges() && this.timeStampsEmpty()) {
                assert (this.refs.isEmpty());
                assert (this.toDelete.isEmpty());
                return Changes.UP_TO_DATE;
            }
            List<Pair<ElementHandle<TypeElement>, Long>> newState = p.result();
            List<Pair<ElementHandle<TypeElement>, Long>> oldState = this.loadCRCs(this.cacheRoot);
            boolean preBuildArgs = p.preBuildArgs();
            this.store();
            this.storeCRCs(this.cacheRoot, newState);
            this.storeTimeStamps();
            return BinaryAnalyser.diff(oldState, newState, preBuildArgs);
        }
        this.writer.rollback();
        return Changes.FAILURE;
    }

    @Deprecated
    public final Changes analyse(@NonNull URL url) throws IOException, IllegalArgumentException {
        Context ctx = SPIAccessor.getInstance().createContext(FileUtil.createMemoryFileSystem().getRoot(), url, "java", 15, null, false, false, false, SuspendSupport.NOP, null, null);
        return this.analyse(ctx, ctx.getRootURI());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private RootProcessor createProcessor(@NonNull Context ctx, URL root) throws IOException {
        RootProcessor rootProcessor;
        String mainP = root.getProtocol();
        if ("jar".equals(mainP)) {
            RootProcessor rootProcessor2;
            URL innerURL = FileUtil.getArchiveFile((URL)root);
            if ("file".equals(innerURL.getProtocol())) {
                File archive = BaseUtilities.toFile((URI)URI.create(innerURL.toExternalForm()));
                if (!archive.canRead()) return new DeletedRootProcessor(ctx);
                if (this.isUpToDate(ROOT, archive.lastModified())) return RootProcessor.UP_TO_DATE;
                try {
                    return new ArchiveProcessor(archive, ctx);
                }
                catch (ZipException e) {
                    LOGGER.log(Level.WARNING, "Broken zip file: {0}", archive.getAbsolutePath());
                    return RootProcessor.UP_TO_DATE;
                }
            }
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) return new DeletedRootProcessor(ctx);
            if (this.isUpToDate(ROOT, rootFo.lastModified().getTime())) return RootProcessor.UP_TO_DATE;
            Object path = rootFo.getAttribute(Path.class.getName());
            if (path instanceof Path) {
                rootProcessor2 = new PathProcessor(root, (Path)path, ctx);
                return rootProcessor2;
            }
            rootProcessor2 = new NBFSProcessor(rootFo, ctx);
            return rootProcessor2;
        }
        if ("file".equals(mainP)) {
            File rootFile = BaseUtilities.toFile((URI)URI.create(root.toExternalForm()));
            if (rootFile.isDirectory()) {
                return new FolderProcessor(rootFile, ctx);
            }
            if (rootFile.exists()) return RootProcessor.UP_TO_DATE;
            return new DeletedRootProcessor(ctx);
        }
        FileObject rootFo = URLMapper.findFileObject((URL)root);
        if (rootFo == null) return new DeletedRootProcessor(ctx);
        if (this.isUpToDate(ROOT, rootFo.lastModified().getTime())) return RootProcessor.UP_TO_DATE;
        Object path = rootFo.getAttribute(Path.class.getName());
        if (path instanceof Path) {
            rootProcessor = new PathProcessor(root, (Path)path, ctx);
            return rootProcessor;
        }
        rootProcessor = new NBFSProcessor(rootFo, ctx);
        return rootProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<ElementHandle<TypeElement>, Long>> loadCRCs(File indexFolder) throws IOException {
        LinkedList<Pair<ElementHandle<TypeElement>, Long>> result;
        block8: {
            result = new LinkedList<Pair<ElementHandle<TypeElement>, Long>>();
            File file = new File(indexFolder, CRC);
            if (file.canRead()) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                block5: while (true) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] parts = line.split("=");
                        if (parts.length != 2) continue;
                        try {
                            ElementHandle handle = ElementHandleAccessor.getInstance().create(ElementKind.OTHER, parts[0]);
                            Long crc = Long.parseLong(parts[1]);
                            result.add((Pair<ElementHandle<TypeElement>, Long>)Pair.of((Object)handle, (Object)crc));
                            continue block5;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    in.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCRCs(File indexFolder, List<Pair<ElementHandle<TypeElement>, Long>> state) throws IOException {
        File file = new File(indexFolder, CRC);
        if (state.isEmpty()) {
            file.delete();
        } else {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                for (Pair<ElementHandle<TypeElement>, Long> pair : state) {
                    StringBuilder sb = new StringBuilder(((ElementHandle)pair.first()).getBinaryName());
                    sb.append('=');
                    sb.append((Long)pair.second());
                    out.println(sb.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Pair<LongHashMap<String>, Set<String>> getTimeStamps() throws IOException {
        if (this.timeStamps == null) {
            LongHashMap<String> map;
            block9: {
                map = new LongHashMap<String>();
                File f = new File(this.cacheRoot, TIME_STAMPS);
                if (f.exists()) {
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                    block5: while (true) {
                        String line;
                        while (null != (line = in.readLine())) {
                            int idx = line.indexOf(61);
                            if (idx == -1) continue;
                            try {
                                long ts = Long.parseLong(line.substring(idx + 1));
                                map.put(line.substring(0, idx), ts);
                                continue block5;
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.log(Level.FINE, "Invalid timestamp: line={0}, timestamps={1}, exception={2}", new Object[]{line, f.getPath(), nfe});
                            }
                        }
                        break block9;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
            }
            this.timeStamps = Pair.of(map, new HashSet(map.keySet()));
        }
        return this.timeStamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTimeStamps() throws IOException {
        File f = new File(this.cacheRoot, TIME_STAMPS);
        if (this.timeStamps == null) {
            f.delete();
        } else {
            ((LongHashMap)this.timeStamps.first()).keySet().removeAll((Collection)this.timeStamps.second());
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            try {
                for (LongHashMap.Entry entry : ((LongHashMap)this.timeStamps.first()).entrySet()) {
                    out.write((String)entry.getKey());
                    out.write(61);
                    out.write(Long.toString(entry.getValue()));
                    out.newLine();
                }
                out.flush();
            }
            finally {
                this.timeStamps = null;
                out.close();
            }
        }
    }

    private boolean timeStampsEmpty() {
        return this.timeStamps == null || ((Set)this.timeStamps.second()).isEmpty();
    }

    private boolean isUpToDate(String resourceName, long timeStamp) throws IOException {
        Pair<LongHashMap<String>, Set<String>> ts = this.getTimeStamps();
        long oldTime = ((LongHashMap)ts.first()).put(resourceName, timeStamp);
        ((Set)ts.second()).remove(resourceName);
        return oldTime == timeStamp;
    }

    static Changes diff(List<Pair<ElementHandle<TypeElement>, Long>> oldState, List<Pair<ElementHandle<TypeElement>, Long>> newState, boolean preBuildArgs) {
        LinkedList<Object> changed = new LinkedList<Object>();
        LinkedList<Object> removed = new LinkedList<Object>();
        LinkedList<Object> added = new LinkedList<Object>();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> oldIt = oldState.iterator();
        Iterator<Pair<ElementHandle<TypeElement>, Long>> newIt = newState.iterator();
        Pair<ElementHandle<TypeElement>, Long> oldE = null;
        Pair<ElementHandle<TypeElement>, Long> newE = null;
        while (oldIt.hasNext() && newIt.hasNext()) {
            int ni;
            if (oldE == null) {
                oldE = oldIt.next();
            }
            if (newE == null) {
                newE = newIt.next();
            }
            if ((ni = ((ElementHandle)oldE.first()).getBinaryName().compareTo(((ElementHandle)newE.first()).getBinaryName())) == 0) {
                if ((Long)oldE.second() == 0L || ((Long)oldE.second()).longValue() != ((Long)newE.second()).longValue()) {
                    changed.add(oldE.first());
                }
                newE = null;
                oldE = null;
                continue;
            }
            if (ni < 0) {
                removed.add(oldE.first());
                oldE = null;
                continue;
            }
            if (ni <= 0) continue;
            added.add(newE.first());
            newE = null;
        }
        if (oldE != null) {
            removed.add(oldE.first());
        }
        while (oldIt.hasNext()) {
            removed.add(oldIt.next().first());
        }
        if (newE != null) {
            added.add(newE.first());
        }
        while (newIt.hasNext()) {
            added.add(newIt.next().first());
        }
        return new Changes(true, added, removed, changed, preBuildArgs);
    }

    private void releaseData() {
        this.refs.clear();
        this.toDelete.clear();
    }

    private void flush() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.writer.deleteAndFlush(this.refs, this.toDelete);
            }
        }
        finally {
            this.releaseData();
        }
    }

    private void store() throws IOException {
        try {
            this.writer.deleteAndStore(this.refs, this.toDelete);
        }
        finally {
            this.releaseData();
        }
    }

    private void delete(@NullAllowed String className, @NullAllowed String fileName) throws IOException {
        assert (className != null || fileName != null);
        this.toDelete.add((Pair<String, String>)Pair.of((Object)className, (Object)fileName));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassFileProcessor cfp = this.cfg.createProcessor(classFile);
        this.delete(cfp.getClassName(), cfp.getFileName());
        UsagesData usages = cfp.analyse();
        Pair pair = Pair.of((Object)BinaryName.create(cfp.getClassName(), BinaryAnalyser.getElementKind(classFile), BinaryAnalyser.isLocal(classFile), BinaryAnalyser.getSimpleNameIndex(classFile)), (Object)cfp.getFileName());
        this.addReferences((Pair<BinaryName, String>)pair, usages);
    }

    private void addReferences(@NonNull Pair<BinaryName, String> name, @NonNull UsagesData<ClassName> usages) {
        assert (name != null);
        assert (usages != null);
        Object[] cr = new Object[]{usages.usagesToStrings(), usages.featureIdentsToString(), usages.identsToString()};
        this.refs.add((Pair<Pair<BinaryName, String>, Object[]>)Pair.of(name, (Object)cr));
    }

    private static ElementKind getElementKind(@NonNull ClassFile cf) {
        if (cf.isEnum()) {
            return ElementKind.ENUM;
        }
        if (cf.isAnnotation()) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (cf.isModule()) {
            return ElementKind.MODULE;
        }
        if ((cf.getAccess() & 0x200) == 512) {
            return ElementKind.INTERFACE;
        }
        return ElementKind.CLASS;
    }

    private static boolean isLocal(@NonNull ClassFile cf) {
        return cf.getEnclosingMethod() != null;
    }

    private static int getSimpleNameIndex(@NonNull ClassFile cf) {
        if (cf.isModule()) {
            return 0;
        }
        ClassName me = cf.getName();
        String simpleName = BinaryAnalyser.getInternalSimpleName(me);
        int len = simpleName.length();
        for (InnerClass ic : cf.getInnerClasses()) {
            int sepIndex;
            if (!me.equals((Object)ic.getName())) continue;
            String innerName = ic.getSimpleName();
            boolean found = false;
            if (innerName != null && !innerName.isEmpty()) {
                if (simpleName.endsWith(innerName)) {
                    len = innerName.length();
                    found = true;
                }
            } else {
                String encSimpleName;
                EnclosingMethod enclosingMethod = cf.getEnclosingMethod();
                if (enclosingMethod != null && simpleName.startsWith(encSimpleName = BinaryAnalyser.getInternalSimpleName(enclosingMethod.getClassName()))) {
                    len -= encSimpleName.length() + 1;
                    found = true;
                }
            }
            if (found || (sepIndex = simpleName.lastIndexOf(36)) <= 0) break;
            len -= sepIndex + 1;
            break;
        }
        return me.getInternalName().length() - len;
    }

    private static String getInternalSimpleName(@NonNull ClassName name) {
        String pkg = name.getPackage();
        String internalName = name.getInternalName();
        return pkg.isEmpty() ? internalName : internalName.substring(pkg.length() + 1);
    }

    private final class DeletedRootProcessor
    extends RootProcessor {
        DeletedRootProcessor(Context ctx) throws IOException {
            super(ctx);
            Pair ts = BinaryAnalyser.this.getTimeStamps();
            if (!((LongHashMap)ts.first()).isEmpty()) {
                this.markChanged();
            }
        }

        @Override
        @NonNull
        protected boolean executeImpl() throws IOException {
            if (this.hasChanges()) {
                BinaryAnalyser.this.writer.clear();
            }
            return true;
        }
    }

    private final class NBFSProcessor
    extends RootProcessor {
        private final Enumeration<? extends FileObject> todo;
        private final FileObject root;

        NBFSProcessor(@NonNull FileObject root, Context ctx) throws IOException {
            super(ctx);
            assert (root != null);
            BinaryAnalyser.this.writer.clear();
            this.root = root;
            this.todo = root.getData(true);
            this.markChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        protected boolean executeImpl() throws IOException {
            while (this.todo.hasMoreElements()) {
                FileObject fo = this.todo.nextElement();
                if (this.accepts(fo.getNameExt())) {
                    String rp = FileObjects.stripExtension(FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo));
                    this.report(ElementHandleAccessor.getInstance().create(ElementKind.OTHER, FileObjects.convertFolder2Package(rp)), 0L);
                    try (BufferedInputStream in = new BufferedInputStream(fo.getInputStream());){
                        BinaryAnalyser.this.analyse(in);
                    }
                    if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                        BinaryAnalyser.this.flush();
                    }
                }
                if (!this.isCancelled()) continue;
                return false;
            }
            return true;
        }
    }

    private final class PathProcessor
    extends RootProcessor {
        private final URL rootURL;
        private final Path rootPath;

        PathProcessor(@NonNull URL rootURL, @NonNull Path rootPath, Context ctx) {
            super(ctx);
            assert (rootURL != null);
            assert (rootPath != null);
            this.rootURL = rootURL;
            this.rootPath = rootPath;
            this.markChanged();
        }

        @Override
        protected boolean executeImpl() throws IOException {
            final boolean[] cancelled = new boolean[1];
            final char separator = this.rootPath.getFileSystem().getSeparator().charAt(0);
            Files.walkFileTree(this.rootPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String simpleName = file.getName(file.getNameCount() - 1).toString();
                    if (PathProcessor.this.accepts(simpleName)) {
                        String fqn = FileObjects.convertFolder2Package(FileObjects.stripExtension(PathProcessor.this.rootPath.relativize(file).toString()), separator);
                        PathProcessor.this.report(ElementHandleAccessor.getInstance().create(ElementKind.OTHER, fqn), attrs.lastModifiedTime().toMillis());
                        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ));){
                            BinaryAnalyser.this.analyse(in);
                        }
                        catch (RuntimeException | InvalidClassFormatException icf) {
                            LOGGER.log(Level.WARNING, "Invalid class file format: {0} in: {1}", new Object[]{file, PathProcessor.this.rootURL});
                            LOGGER.log(Level.INFO, "Class File Exception Details", icf);
                        }
                        catch (IOException x) {
                            Exceptions.attachMessage((Throwable)x, (String)String.format("While scanning: %s in: %s", file, PathProcessor.this.rootURL));
                            throw x;
                        }
                        if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                            BinaryAnalyser.this.flush();
                        }
                    }
                    return this.handleCancel();
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    LOGGER.log(Level.WARNING, "Cannot read file: {0}", file);
                    LOGGER.log(Level.FINE, null, exc);
                    return this.handleCancel();
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                private FileVisitResult handleCancel() {
                    if (PathProcessor.this.isCancelled()) {
                        cancelled[0] = true;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return !cancelled[0];
        }
    }

    private final class EnumerateFilesProcessor
    extends RootProcessor {
        private final File todoRoot;
        private final Iterable<File> todo;

        public EnumerateFilesProcessor(@NonNull Context ctx, @NonNull File todoRoot, Iterable<File> todo) throws IOException {
            super(ctx);
            this.todoRoot = todoRoot;
            this.todo = todo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        protected boolean executeImpl() throws IOException {
            for (File file : this.todo) {
                long fileMTime = file.lastModified();
                String relativePath = FileObjects.convertFolder2Package(FileObjects.getRelativePath(this.todoRoot, file), File.separatorChar);
                this.report(ElementHandleAccessor.getInstance().create(ElementKind.OTHER, relativePath), fileMTime);
                if (!BinaryAnalyser.this.isUpToDate(relativePath, fileMTime)) {
                    this.markChanged();
                    BinaryAnalyser.this.toDelete.add(Pair.of((Object)relativePath, null));
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                        BinaryAnalyser.this.analyse(in);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Cannot read file: {0}", file.getAbsolutePath());
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                        BinaryAnalyser.this.flush();
                    }
                }
                if (!this.isCancelled()) continue;
                return false;
            }
            for (String deleted : (Set)BinaryAnalyser.this.getTimeStamps().second()) {
                if ("module-info".equals(deleted)) {
                    BinaryAnalyser.this.delete(null, String.format("%s.%s", "module-info", "class"));
                } else {
                    BinaryAnalyser.this.delete(deleted, null);
                }
                this.markChanged();
            }
            return true;
        }
    }

    private final class FolderProcessor
    extends RootProcessor {
        private final LinkedList<File> todo;
        private final String rootPath;

        public FolderProcessor(@NonNull File root, Context ctx) throws IOException {
            super(ctx);
            assert (root != null);
            String path = root.getAbsolutePath();
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path = path + File.separatorChar;
            }
            this.todo = new LinkedList();
            this.rootPath = path;
            File[] children = root.listFiles();
            if (children != null) {
                Collections.addAll(this.todo, children);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        protected boolean executeImpl() throws IOException {
            while (!this.todo.isEmpty()) {
                File file = this.todo.removeFirst();
                if (file.isDirectory()) {
                    File[] c = file.listFiles();
                    if (c != null) {
                        Collections.addAll(this.todo, c);
                    }
                } else if (this.accepts(file.getName())) {
                    int slashIndex;
                    String filePath = file.getAbsolutePath();
                    long fileMTime = file.lastModified();
                    int dotIndex = filePath.lastIndexOf(46);
                    int endPos = dotIndex > (slashIndex = filePath.lastIndexOf(File.separatorChar)) ? dotIndex : filePath.length();
                    String relativePath = FileObjects.convertFolder2Package(filePath.substring(this.rootPath.length(), endPos), File.separatorChar);
                    this.report(ElementHandleAccessor.getInstance().create(ElementKind.OTHER, relativePath), fileMTime);
                    if (!BinaryAnalyser.this.isUpToDate(relativePath, fileMTime)) {
                        this.markChanged();
                        BinaryAnalyser.this.toDelete.add(Pair.of((Object)relativePath, null));
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                            BinaryAnalyser.this.analyse(in);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Cannot read file: {0}", file.getAbsolutePath());
                            LOGGER.log(Level.FINE, null, ex);
                        }
                        if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                            BinaryAnalyser.this.flush();
                        }
                    }
                }
                if (!this.isCancelled()) continue;
                return false;
            }
            for (String deleted : (Set)BinaryAnalyser.this.getTimeStamps().second()) {
                if ("module-info".equals(deleted)) {
                    BinaryAnalyser.this.delete(null, String.format("%s.%s", "module-info", "class"));
                } else {
                    BinaryAnalyser.this.delete(deleted, null);
                }
                this.markChanged();
            }
            return true;
        }
    }

    private final class ArchiveProcessor
    extends RootProcessor {
        private final ZipFile zipFile;
        private final Enumeration<? extends ZipEntry> entries;
        private boolean brokenLogged;

        ArchiveProcessor(@NonNull File file, Context ctx) throws IOException {
            super(ctx);
            assert (file != null);
            BinaryAnalyser.this.writer.clear();
            this.zipFile = new ZipFile(file);
            this.entries = this.zipFile.entries();
            this.markChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NonNull
        protected boolean executeImpl() throws IOException {
            try {
                while (this.entries.hasMoreElements()) {
                    ZipEntry ze;
                    try {
                        ze = this.entries.nextElement();
                    }
                    catch (InternalError err) {
                        LOGGER.log(Level.INFO, "Broken zip file: {0}, reason: {1}", new Object[]{this.zipFile.getName(), err.getMessage()});
                        boolean bl = true;
                        this.zipFile.close();
                        return bl;
                    }
                    catch (RuntimeException re) {
                        if (re instanceof NoSuchElementException) {
                            throw (NoSuchElementException)re;
                        }
                        if (this.brokenLogged) continue;
                        LOGGER.log(Level.INFO, "Broken zip file: {0}, reason: {1}", new Object[]{this.zipFile.getName(), re.getMessage()});
                        this.brokenLogged = true;
                        continue;
                    }
                    if (!ze.isDirectory() && this.accepts(ze.getName())) {
                        this.report(ElementHandleAccessor.getInstance().create(ElementKind.OTHER, FileObjects.convertFolder2Package(FileObjects.stripExtension(ze.getName()))), ze.getCrc());
                        try (BufferedInputStream in = new BufferedInputStream(this.zipFile.getInputStream(ze));){
                            BinaryAnalyser.this.analyse(in);
                        }
                        if (BinaryAnalyser.this.lmListener.isLowMemory()) {
                            BinaryAnalyser.this.flush();
                        }
                    }
                    if (!this.isCancelled()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.zipFile.close();
            }
        }
    }

    private static abstract class RootProcessor {
        private static final Comparator<Pair<ElementHandle<TypeElement>, Long>> COMPARATOR = new Comparator<Pair<ElementHandle<TypeElement>, Long>>(){

            @Override
            public int compare(Pair<ElementHandle<TypeElement>, Long> o1, Pair<ElementHandle<TypeElement>, Long> o2) {
                return ((ElementHandle)o1.first()).getBinaryName().compareTo(((ElementHandle)o2.first()).getBinaryName());
            }
        };
        static final RootProcessor UP_TO_DATE = new RootProcessor(){

            @Override
            @NonNull
            protected boolean executeImpl() throws IOException {
                return true;
            }
        };
        private final List<Pair<ElementHandle<TypeElement>, Long>> result;
        private final Context ctx;
        private boolean changed;
        private byte preBuildArgsState;

        RootProcessor(@NonNull Context ctx) {
            assert (ctx != null);
            this.ctx = ctx;
            this.result = new ArrayList<Pair<ElementHandle<TypeElement>, Long>>();
        }

        private RootProcessor() {
            this.ctx = null;
            this.result = Collections.emptyList();
        }

        @NonNull
        protected final boolean execute() throws IOException {
            boolean res = this.executeImpl();
            if (res) {
                Collections.sort(this.result, COMPARATOR);
            }
            return res;
        }

        protected final boolean hasChanges() {
            return this.changed;
        }

        protected final boolean preBuildArgs() {
            return this.preBuildArgsState == 3;
        }

        @NonNull
        protected final List<Pair<ElementHandle<TypeElement>, Long>> result() {
            return this.result;
        }

        protected final void report(ElementHandle<TypeElement> te, long crc) {
            this.result.add((Pair<ElementHandle<TypeElement>, Long>)Pair.of(te, (Object)crc));
            String binName = te.getBinaryName();
            if (OBJECT.equals(binName)) {
                this.preBuildArgsState = (byte)(this.preBuildArgsState | 1);
            } else if (JCOMPONENT.equals(binName)) {
                this.preBuildArgsState = (byte)(this.preBuildArgsState | 2);
            }
        }

        protected final void markChanged() {
            this.changed = true;
        }

        protected final boolean isCancelled() {
            return this.ctx.isCancelled();
        }

        protected final boolean accepts(String name) {
            int index = name.lastIndexOf(46);
            if (index == -1 || index + 1 == name.length()) {
                return false;
            }
            return "class".equalsIgnoreCase(name.substring(index + 1));
        }

        @NonNull
        protected abstract boolean executeImpl() throws IOException;
    }

    private static final class FullIndexProcessor
    extends ClassSignatureProcessor {
        FullIndexProcessor(@NonNull ClassFile classFile, @NonNull Config.IdentLevel idLvl) {
            super(classFile, idLvl);
        }

        @Override
        void visit(@NonNull ClassFile cf) {
            ClassName name;
            this.handleAnnotations(cf.getAnnotations(), false);
            ConstantPool constantPool = cf.getConstantPool();
            for (CPFieldInfo field : constantPool.getAllConstants(CPFieldInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(field.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.FIELD_REFERENCE);
            }
            for (CPMethodInfo method : constantPool.getAllConstants(CPMethodInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            for (CPMethodInfo method : constantPool.getAllConstants(CPInterfaceMethodInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            super.visit(cf);
            for (CPClassInfo ci : constantPool.getAllConstants(CPClassInfo.class)) {
                ClassName ciName = ClassFileUtil.getType(ci);
                if (ciName == null || this.hasUsage(ciName)) continue;
                this.addUsage(ciName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }

        @Override
        void visit(@NonNull Method m) {
            Code code;
            CPClassInfo[] classInfos;
            this.handleAnnotations(m.getAnnotations(), false);
            String jvmTypeId = m.getReturnType();
            ClassName type = ClassFileUtil.getType(jvmTypeId);
            if (type != null) {
                this.addUsage(type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            List params = m.getParameters();
            for (CPClassInfo[] param : params) {
                jvmTypeId = param.getDescriptor();
                type = ClassFileUtil.getType(jvmTypeId);
                if (type == null) continue;
                this.addUsage(type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            for (CPClassInfo classInfo : classInfos = m.getExceptionClasses()) {
                type = classInfo.getClassName();
                if (type == null) continue;
                this.addUsage(type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            jvmTypeId = m.getTypeSignature();
            if (jvmTypeId != null) {
                try {
                    ClassName[] typeSigNames;
                    for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromMethodTypeSignature(jvmTypeId)) {
                        this.addUsage(typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException is) {
                    LOGGER.log(Level.WARNING, "Invalid method signature: {0}::{1} signature is:{2}", new Object[]{this.getClassName(), m.getName(), jvmTypeId});
                }
            }
            if ((code = m.getCode()) != null) {
                LocalVariableTypeTableEntry[] varTypes;
                LocalVariableTableEntry[] vars;
                for (LocalVariableTableEntry var : vars = code.getLocalVariableTable()) {
                    type = ClassFileUtil.getType(var.getDescription());
                    if (type == null) continue;
                    this.addUsage(type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                for (LocalVariableTypeTableEntry varType : varTypes = m.getCode().getLocalVariableTypeTable()) {
                    try {
                        ClassName[] typeSigNames;
                        for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(varType.getSignature())) {
                            this.addUsage(typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                    }
                    catch (IllegalStateException is) {
                        LOGGER.log(Level.WARNING, "Invalid local variable signature: {0}::{1}", new Object[]{this.getClassName(), m.getName()});
                    }
                }
            }
            super.visit(m);
        }

        @Override
        void visit(Variable v) {
            this.handleAnnotations(v.getAnnotations(), false);
            String jvmTypeId = v.getDescriptor();
            ClassName type = ClassFileUtil.getType(jvmTypeId);
            if (type != null) {
                this.addUsage(type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            if ((jvmTypeId = v.getTypeSignature()) != null) {
                try {
                    ClassName[] typeSigNames;
                    for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(jvmTypeId)) {
                        this.addUsage(typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException is) {
                    LOGGER.log(Level.WARNING, "Invalid field signature: {0}::{1} signature is: {2}", new Object[]{this.getClassName(), v.getName(), jvmTypeId});
                }
            }
            super.visit(v);
        }
    }

    private static final class ExecVarRefsProcessor
    extends ClassSignatureProcessor {
        ExecVarRefsProcessor(@NonNull ClassFile classFile, @NonNull Config.IdentLevel idLvl) {
            super(classFile, idLvl);
        }

        @Override
        void visit(@NonNull ClassFile cf) {
            ClassName name;
            ConstantPool constantPool = cf.getConstantPool();
            for (CPFieldInfo field : constantPool.getAllConstants(CPFieldInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(field.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.FIELD_REFERENCE);
            }
            for (CPMethodInfo method : constantPool.getAllConstants(CPMethodInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            for (CPMethodInfo method : constantPool.getAllConstants(CPInterfaceMethodInfo.class)) {
                name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
                if (name == null) continue;
                this.addUsage(name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            super.visit(cf);
        }
    }

    private static class ClassSignatureProcessor
    extends ClassFileProcessor {
        ClassSignatureProcessor(@NonNull ClassFile classFile, @NonNull Config.IdentLevel idLvl) {
            super(classFile, idLvl);
        }

        @Override
        void visit(@NonNull ClassFile cf) {
            ClassName scName;
            String signature = cf.getTypeSignature();
            if (signature != null) {
                try {
                    for (ClassName className : ClassFileUtil.getTypesFromClassTypeSignature(signature)) {
                        this.addUsage(className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (RuntimeException re) {
                    StackTraceElement[] elements;
                    StringBuilder message = new StringBuilder("BinaryAnalyser: Cannot read type: " + signature + " cause: " + re.getLocalizedMessage() + '\n');
                    for (StackTraceElement e : elements = re.getStackTrace()) {
                        message.append(e.toString());
                        message.append('\n');
                    }
                    LOGGER.warning(message.toString());
                }
            }
            if ((scName = cf.getSuperClass()) != null) {
                this.addUsage(scName, ClassIndexImpl.UsageType.SUPER_CLASS);
            }
            Collection interfaces = cf.getInterfaces();
            for (ClassName className : interfaces) {
                this.addUsage(className, ClassIndexImpl.UsageType.SUPER_INTERFACE);
            }
            this.handleAnnotations(cf.getAnnotations(), true);
            super.visit(cf);
        }

        @Override
        void visit(@NonNull Method m) {
            String name = m.getName();
            if (this.getIdentLevel().accepts((Field)m) && !m.isSynthetic() && !ClassSignatureProcessor.isInit(name) && !ClassSignatureProcessor.isAccessorMethod(name)) {
                this.addIdent(name);
            }
            super.visit(m);
        }

        @Override
        void visit(@NonNull Variable v) {
            String name = v.getName();
            if (this.getIdentLevel().accepts((Field)v) && !v.isSynthetic() && !ClassSignatureProcessor.isOutherThis(name) && !ClassSignatureProcessor.isDisableAssertions(name)) {
                this.addIdent(name);
            }
            super.visit(v);
        }

        private static boolean isInit(@NonNull String name) {
            return BinaryAnalyser.INIT.equals(name) || BinaryAnalyser.CLINIT.equals(name);
        }

        private static boolean isOutherThis(@NonNull String name) {
            return name.startsWith(BinaryAnalyser.OUTHER_THIS_PREFIX);
        }

        private static boolean isAccessorMethod(@NonNull String name) {
            return name.startsWith(BinaryAnalyser.ACCESS_METHOD_PREFIX);
        }

        private static boolean isDisableAssertions(@NonNull String name) {
            return BinaryAnalyser.ASSERTIONS_DISABLED.equals(name);
        }
    }

    private static class ClassFileProcessor {
        private static final Convertor<ClassName, String> CONVERTOR = p -> p.getInternalName().replace('/', '.');
        private final ClassFile classFile;
        private final Config.IdentLevel idLvl;
        private final String className;
        private final String fileName;
        private final UsagesData<ClassName> usages = new UsagesData<ClassName>(CONVERTOR);

        ClassFileProcessor(@NonNull ClassFile classFile, @NonNull Config.IdentLevel idLvl) {
            this.classFile = classFile;
            ClassName name = classFile.getName();
            if (classFile.isModule()) {
                this.className = classFile.getModule().getName();
                String simpleName = name.getSimpleName();
                assert ("module-info".equals(simpleName));
                this.fileName = String.format("%s.%s", simpleName, "class");
            } else {
                this.className = (String)CONVERTOR.convert((Object)name);
                this.fileName = null;
            }
            this.idLvl = idLvl;
        }

        @NonNull
        final String getClassName() {
            return this.className;
        }

        @CheckForNull
        final String getFileName() {
            return this.fileName;
        }

        @NonNull
        final Config.IdentLevel getIdentLevel() {
            return this.idLvl;
        }

        final UsagesData analyse() {
            this.visit(this.classFile);
            return this.usages;
        }

        void visit(@NonNull ClassFile cf) {
            for (Method method : cf.getMethods()) {
                this.visit(method);
            }
            for (Variable var : cf.getVariables()) {
                this.visit(var);
            }
        }

        void visit(@NonNull Method m) {
        }

        void visit(@NonNull Variable v) {
        }

        final void addIdent(@NonNull CharSequence ident) {
            assert (ident != null);
            this.usages.addFeatureIdent(ident);
        }

        final void addUsage(@NonNull ClassName name, @NonNull ClassIndexImpl.UsageType usage) {
            if (OBJECT.equals(name.getExternalName())) {
                return;
            }
            this.usages.addUsage(name, usage);
        }

        final boolean hasUsage(@NonNull ClassName name) {
            return this.usages.hasUsage(name);
        }

        final void handleAnnotations(@NonNull Iterable<? extends Annotation> annotations, boolean onlyTopLevel) {
            for (Annotation annotation : annotations) {
                this.addUsage(annotation.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                if (onlyTopLevel) continue;
                LinkedList<ElementValue> toProcess = new LinkedList<ElementValue>();
                for (AnnotationComponent ac : annotation.getComponents()) {
                    toProcess.add(ac.getValue());
                }
                while (!toProcess.isEmpty()) {
                    String type;
                    ClassName className;
                    ElementValue ev = (ElementValue)toProcess.remove(0);
                    if (ev instanceof ArrayElementValue) {
                        toProcess.addAll(Arrays.asList(((ArrayElementValue)ev).getValues()));
                    }
                    if (ev instanceof NestedElementValue) {
                        Annotation nested = ((NestedElementValue)ev).getNestedValue();
                        this.addUsage(nested.getType(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        for (AnnotationComponent ac : nested.getComponents()) {
                            toProcess.add(ac.getValue());
                        }
                    }
                    if (ev instanceof ClassElementValue) {
                        this.addUsage(((ClassElementValue)ev).getClassName(), ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    if (!(ev instanceof EnumElementValue) || (className = ClassFileUtil.getType(type = ((EnumElementValue)ev).getEnumType())) == null) continue;
                    this.addUsage(className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
        }
    }

    public static abstract class Config {
        @NonNull
        protected abstract UsagesLevel getUsagesLevel();

        @NonNull
        protected abstract IdentLevel getIdentLevel();

        @NonNull
        final ClassFileProcessor createProcessor(@NonNull ClassFile cf) {
            UsagesLevel ul = this.getUsagesLevel();
            switch (ul) {
                case BASIC: {
                    return new ClassSignatureProcessor(cf, this.getIdentLevel());
                }
                case EXEC_VAR_REFS: {
                    return new ExecVarRefsProcessor(cf, this.getIdentLevel());
                }
                case ALL: {
                    return new FullIndexProcessor(cf, this.getIdentLevel());
                }
            }
            throw new IllegalStateException(String.valueOf((Object)ul));
        }

        @NonNull
        static Config getDefault() {
            Config res = (Config)Lookup.getDefault().lookup(Config.class);
            if (res == null) {
                res = new DefaultConfig();
            }
            return res;
        }

        private static final class DefaultConfig
        extends Config {
            private static final String PROP_FULL_INDEX = "org.netbeans.modules.java.source.usages.BinaryAnalyser.fullIndex";
            private static final String PROP_USG_LVL = "org.netbeans.modules.java.source.usages.BinaryAnalyser.usages";
            private static final String PROP_ID_LVL = "org.netbeans.modules.java.source.usages.BinaryAnalyser.idents";
            private static final UsagesLevel DEFAULT_USAGES_LEVEL = UsagesLevel.EXEC_VAR_REFS;
            private static final IdentLevel DEFAULT_IDENT_LEVEL = IdentLevel.VISIBLE;
            private final UsagesLevel usgLvl = DefaultConfig.resolveUsagesLevel();
            private final IdentLevel idLvl = DefaultConfig.resolveIdentLevel();

            @Override
            @NonNull
            public UsagesLevel getUsagesLevel() {
                return this.usgLvl;
            }

            @Override
            @NonNull
            public IdentLevel getIdentLevel() {
                return this.idLvl;
            }

            @NonNull
            private static UsagesLevel resolveUsagesLevel() {
                UsagesLevel lvl;
                UsagesLevel usagesLevel = lvl = Boolean.getBoolean(PROP_FULL_INDEX) ? UsagesLevel.ALL : null;
                if (lvl == null && (lvl = UsagesLevel.forName(System.getProperty(PROP_USG_LVL))) == null) {
                    lvl = DEFAULT_USAGES_LEVEL;
                }
                return lvl;
            }

            @NonNull
            private static IdentLevel resolveIdentLevel() {
                IdentLevel lvl = IdentLevel.forName(System.getProperty(PROP_ID_LVL));
                if (lvl == null) {
                    lvl = DEFAULT_IDENT_LEVEL;
                }
                return lvl;
            }
        }

        public static enum IdentLevel {
            NONE("none"){

                @Override
                boolean accepts(Field f) {
                    return false;
                }
            }
            ,
            VISIBLE("exported"){

                @Override
                boolean accepts(Field f) {
                    return !f.isPrivate();
                }
            }
            ,
            ALL("all"){

                @Override
                boolean accepts(Field f) {
                    return true;
                }
            };

            private static final Map<String, IdentLevel> byName;
            private final String name;

            private IdentLevel(String name) {
                this.name = name;
            }

            @NonNull
            public final String getName() {
                return this.name;
            }

            @CheckForNull
            public static IdentLevel forName(@NullAllowed String name) {
                return name == null ? null : byName.get(name);
            }

            abstract boolean accepts(@NonNull Field var1);

            static {
                byName = new HashMap<String, IdentLevel>();
                for (IdentLevel lvl : IdentLevel.values()) {
                    byName.put(lvl.getName(), lvl);
                }
            }
        }

        public static enum UsagesLevel {
            BASIC("basic"),
            EXEC_VAR_REFS("refs"),
            ALL("all");

            private static final Map<String, UsagesLevel> byName;
            private final String name;

            private UsagesLevel(String name) {
                this.name = name;
            }

            @NonNull
            public final String getName() {
                return this.name;
            }

            @CheckForNull
            public static UsagesLevel forName(@NullAllowed String name) {
                return name == null ? null : byName.get(name);
            }

            static {
                byName = new HashMap<String, UsagesLevel>();
                for (UsagesLevel lvl : UsagesLevel.values()) {
                    byName.put(lvl.getName(), lvl);
                }
            }
        }
    }

    public static final class Changes {
        private static final Changes UP_TO_DATE = new Changes(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
        private static final Changes FAILURE = new Changes(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
        public final List<ElementHandle<TypeElement>> added;
        public final List<ElementHandle<TypeElement>> removed;
        public final List<ElementHandle<TypeElement>> changed;
        public final boolean preBuildArgs;
        public final boolean done;

        private Changes(boolean done, List<ElementHandle<TypeElement>> added, List<ElementHandle<TypeElement>> removed, List<ElementHandle<TypeElement>> changed, boolean preBuildArgs) {
            this.done = done;
            this.added = added;
            this.removed = removed;
            this.changed = changed;
            this.preBuildArgs = preBuildArgs;
        }
    }
}

