/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.misc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.util.BowerUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.util.RequestProcessor;

public final class BowerLibrariesUsageLogger
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(BowerLibrariesUsageLogger.class);
    private final BowerJson bowerJson;

    private BowerLibrariesUsageLogger(Project project) {
        assert (project != null);
        this.bowerJson = new BowerJson(project.getProjectDirectory());
    }

    void startListening() {
        this.bowerJson.addPropertyChangeListener(this);
    }

    void stopListening() {
        this.bowerJson.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("DEPENDENCIES".equals(propertyName) || "DEV_DEPENDENCIES".equals(propertyName)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    BowerLibrariesUsageLogger.this.logLibraries();
                }
            });
        }
    }

    void logLibraries() {
        BowerJson.BowerDependencies dependencies = this.bowerJson.getDependencies();
        this.logLibraries("REGULAR", dependencies.dependencies);
        this.logLibraries("DEVELOPMENT", dependencies.devDependencies);
    }

    private void logLibraries(String type, Map<String, String> dependencies) {
        for (Map.Entry<String, String> dependency : dependencies.entrySet()) {
            BowerUtils.logUsageBowerLibrary(type, dependency.getKey(), dependency.getValue());
        }
    }

    public static BowerLibrariesUsageLogger usageLogger(Project project) {
        return new BowerLibrariesUsageLogger(project);
    }

    public static ProjectOpenedHook projectOpenedHook(Project project) {
        return new BowerProjectOpenedHook(project);
    }

    private static final class BowerProjectOpenedHook
    extends ProjectOpenedHook {
        private final Project project;

        public BowerProjectOpenedHook(Project project) {
            assert (project != null);
            this.project = project;
        }

        protected void projectOpened() {
            this.getUsageLogger().startListening();
        }

        protected void projectClosed() {
            this.getUsageLogger().stopListening();
        }

        private BowerLibrariesUsageLogger getUsageLogger() {
            BowerLibrariesUsageLogger usageLogger = (BowerLibrariesUsageLogger)this.project.getLookup().lookup(BowerLibrariesUsageLogger.class);
            assert (usageLogger != null) : "Usage logger must be found in lookup of: " + this.project.getClass().getName();
            return usageLogger;
        }
    }
}

