/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.IOException;
import java.io.InputStream;
import nu.validator.io.StreamObserver;

public class ObservableInputStream
extends InputStream {
    private StreamObserver observer;
    private InputStream delegate;

    public ObservableInputStream(InputStream delegate, StreamObserver obs) {
        this.delegate = delegate;
        this.observer = obs;
    }

    @Override
    public int available() throws IOException {
        try {
            return this.delegate.available();
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.observer.closeCalled();
            this.delegate.close();
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public void mark(int arg0) {
        try {
            this.delegate.mark(arg0);
        }
        catch (RuntimeException e) {
            try {
                this.observer.exceptionOccurred(e);
            }
            catch (IOException e1) {
                throw new RuntimeException("The observer threw against the  API contract.", e1);
            }
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.delegate.markSupported();
        }
        catch (RuntimeException e) {
            try {
                this.observer.exceptionOccurred(e);
            }
            catch (IOException e1) {
                throw new RuntimeException("The observer threw against the  API contract.", e1);
            }
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.delegate.read();
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        try {
            return this.delegate.read(arg0);
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        try {
            return this.delegate.read(arg0, arg1, arg2);
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.delegate.reset();
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    @Override
    public long skip(long arg0) throws IOException {
        try {
            return this.delegate.skip(arg0);
        }
        catch (RuntimeException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
        catch (IOException e) {
            this.observer.exceptionOccurred(e);
            throw new RuntimeException("The observer failed to throw per API contract.");
        }
    }

    protected void finalize() throws Throwable {
        this.observer.finalizerCalled();
        super.finalize();
    }
}

