/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.sun.share.SecurityMasterListModel;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.GroupTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.util.NbBundle;

public class SecurityAddGroupPanel
extends JPanel
implements ListSelectionListener {
    private final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final GroupTableModel groupModel;
    private Dimension initialPreferredSize;
    private String groupName;
    private JTable existingGroupsTable;
    private SecurityMasterListModel existingGroupsModel;
    private ButtonGroup buttonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLblGroupName;
    private JTextField jTxtGroupName;

    public SecurityAddGroupPanel(GroupTableModel gml) {
        this.groupModel = gml;
        this.groupName = null;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getGrouplName() {
        return this.groupName;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLblGroupName = new JLabel();
        this.jTxtGroupName = new JTextField();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.customizerBundle.getString("LBL_GroupEntryDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLblGroupName.setLabelFor(this.jTxtGroupName);
        this.jLblGroupName.setText(this.customizerBundle.getString("LBL_GroupName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblGroupName, gridBagConstraints);
        this.jTxtGroupName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SecurityAddGroupPanel.this.jTxtGroupNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtGroupName, gridBagConstraints);
        this.jTxtGroupName.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_GroupName"));
        this.jTxtGroupName.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_GroupName"));
        this.jLabel2.setText(this.customizerBundle.getString("LBL_GroupTableDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void jTxtGroupNameKeyReleased(KeyEvent evt) {
        this.groupName = this.jTxtGroupName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.initialPreferredSize = this.getPreferredSize();
        this.existingGroupsTable = new FixedHeightJTable();
        this.existingGroupsTable.setSelectionMode(0);
        this.existingGroupsTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.existingGroupsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 11, 11, 11);
        this.add((Component)scrollPane, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_AddGroupName"));
        this.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_AddGroupName"));
    }

    private void initFields() {
        this.existingGroupsModel = SecurityMasterListModel.getGroupMasterModel();
        this.existingGroupsTable.setModel(this.existingGroupsModel);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtGroupName.setText(this.groupName);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object entry;
        int selectedRow;
        ListSelectionModel selModel = this.existingGroupsTable.getSelectionModel();
        if (!selModel.getValueIsAdjusting() && (selectedRow = this.existingGroupsTable.getSelectedRow()) != -1 && (entry = this.existingGroupsModel.getRow(selectedRow)) instanceof String) {
            this.groupName = (String)entry;
            this.updateTextFields();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    Collection getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        String newGroupName = this.getGrouplName();
        if (!Utils.notEmpty(newGroupName)) {
            errors.add(this.customizerBundle.getString("ERR_BlankGroupName"));
        }
        if (newGroupName != null && this.groupModel.contains(newGroupName)) {
            errors.add(MessageFormat.format(this.customizerBundle.getString("ERR_GroupExists"), newGroupName));
        }
        return errors;
    }

    private void commit() {
        String newGroupName = this.getGrouplName();
        this.groupModel.addElement(newGroupName);
        if (!this.existingGroupsModel.contains(newGroupName)) {
            this.existingGroupsModel.addElement(newGroupName);
        }
    }

    static void addGroupName(JPanel parent, GroupTableModel model) {
        SecurityAddGroupPanel addGroupPanel = new SecurityAddGroupPanel(model);
        addGroupPanel.displayDialog(parent, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle").getString("TITLE_AddGroup"), "AS_CFG_SecurityRoleNewGroup");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        do {
            int dialogChoice = dialog.display();
            if (dialogChoice == 0) break;
            if (dialogChoice != 1) continue;
            Collection errors = this.getErrors();
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            this.commit();
        } while (dialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityAddGroupPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, SecurityAddGroupPanel childPanel) {
            super(parent, title);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)childPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList errors = new ArrayList();
            errors.addAll(this.dialogPanel.getErrors());
            this.setErrors(errors);
        }

        @Override
        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

