/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.rest.client.ClientGenerationStrategy;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.HttpParams;
import org.netbeans.modules.websvc.rest.client.OAuthHelper;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.openide.nodes.Node;

class JerseyGenerationStrategy
extends ClientGenerationStrategy {
    JerseyGenerationStrategy() {
    }

    @Override
    public ClassTree generateFields(TreeMaker maker, WorkingCopy copy, ClassTree classTree, String resourceURI, Security security) {
        ModifiersTree fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.WebResource");
        VariableTree fieldTree = maker.Variable(fieldModif, (CharSequence)"webResource", (Tree)typeTree, null);
        ClassTree modifiedClass = maker.addClassMember(classTree, (Tree)fieldTree);
        fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        typeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.Client");
        fieldTree = maker.Variable(fieldModif, (CharSequence)"client", (Tree)typeTree, null);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        HashSet<Modifier> modifiersSet = new HashSet<Modifier>();
        modifiersSet.add(Modifier.PRIVATE);
        modifiersSet.add(Modifier.STATIC);
        modifiersSet.add(Modifier.FINAL);
        fieldModif = maker.Modifiers(modifiersSet);
        typeTree = maker.Identifier((CharSequence)"String");
        String baseUri = resourceURI;
        if (security.isSSL() && resourceURI.startsWith("http:")) {
            baseUri = "https:" + resourceURI.substring(5);
        }
        fieldTree = maker.Variable(fieldModif, (CharSequence)"BASE_URI", (Tree)typeTree, (ExpressionTree)maker.Literal((Object)baseUri));
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        return modifiedClass;
    }

    @Override
    protected void buildQueryFormParams(StringBuilder queryString) {
        queryString.append(".queryParams(getQueryOrFormParams(queryParamNames, queryParamValues))");
    }

    @Override
    protected void buildQParams(StringBuilder queryString) {
        queryString.append(".queryParams(getQParams(optionalQueryParams))");
    }

    @Override
    boolean requiresJersey(Node context, Security security) {
        return true;
    }

    @Override
    MethodTree generateConstructor(TreeMaker maker, WorkingCopy copy, ClassTree classTree, ClientJavaSourceHelper.PathFormat pf, Security security) {
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        TypeElement clientEl = copy.getElements().getTypeElement("com.sun.jersey.api.client.Client");
        boolean isSubresource = pf.getArguments().length > 0;
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (isSubresource) {
            for (String arg : pf.getArguments()) {
                IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)argTypeTree, null);
                paramList.add(argFieldTree);
            }
        }
        String resURI = null;
        String subresourceExpr = "";
        if (isSubresource) {
            subresourceExpr = "    String resourcePath = " + this.getPathExpression(pf) + ";";
            resURI = "resourcePath";
        } else {
            resURI = this.getPathExpression(pf);
        }
        String SSLExpr = security.isSSL() ? "// SSL configuration\nconfig.getProperties().put(com.sun.jersey.client.urlconnection.HTTPSProperties.PROPERTY_HTTPS_PROPERTIES, new com.sun.jersey.client.urlconnection.HTTPSProperties(getHostnameVerifier(), getSSLContext()));" : "";
        String body = "{   com.sun.jersey.api.client.config.ClientConfig config = new com.sun.jersey.api.client.config.DefaultClientConfig();" + SSLExpr + "   client = " + (clientEl == null ? "com.sun.jersey.api.client." : "") + "Client.create(config);" + subresourceExpr + ("\"\"".equals(resURI) ? "   webResource = client.resource(BASE_URI);" : "   webResource = client.resource(BASE_URI).path(" + resURI + ");") + "}";
        return maker.Constructor(methodModifier, Collections.emptyList(), paramList, Collections.emptyList(), body);
    }

    @Override
    MethodTree generateSubresourceMethod(TreeMaker maker, WorkingCopy copy, ClassTree classTree, ClientJavaSourceHelper.PathFormat pf) {
        String body = "{   String resourcePath = " + this.getPathExpression(pf) + ";   webResource = client.resource(BASE_URI).path(resourcePath);}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        for (String arg : pf.getArguments()) {
            IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)argTypeTree, null);
            paramList.add(argFieldTree);
        }
        return maker.Method(methodModifier, (CharSequence)"setResourcePath", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), paramList, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateBasicAuth(TreeMaker maker, WorkingCopy copy, List<VariableTree> authParams) {
        ModifiersTree methodModifier = maker.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        String body = "{   client.addFilter(new com.sun.jersey.api.client.filter.HTTPBasicAuthFilter(username, password));}";
        return maker.Method(methodModifier, (CharSequence)"setUsernamePassword", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), authParams, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateClose(TreeMaker maker, WorkingCopy copy) {
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        return maker.Method(methodModifier, (CharSequence)"close", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{   client.destroy();}", null);
    }

    @Override
    MethodTree generateHttpGETMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType mimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        MethodTree method;
        String methodName = Wadl2JavaHelper.makeJavaIdentifier(saasMethod.getName()) + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
        IdentifierTree responseTree = maker.Identifier((CharSequence)"T");
        String bodyParam = "responseType";
        List<TypeParameterTree> typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        StringBuilder queryP = new StringBuilder();
        StringBuilder queryParamPart = new StringBuilder();
        StringBuilder commentBuffer = new StringBuilder("@param responseType Class representing the response\n");
        if (httpParams.hasQueryParams() || httpParams.hasHeaderParams()) {
            this.addQueryParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
            this.addHeaderParams(maker, httpParams, paramList, queryP, commentBuffer);
        }
        commentBuffer.append("@return response object (instance of responseType class)");
        String body = "{" + queryParamPart + (mimeType == null ? "   return webResource" + queryP + ".get(" + bodyParam + ");" : "   return webResource" + queryP + ".accept(" + mimeType.getMediaType() + ").get(" + bodyParam + ");") + "}";
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body, null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    @Override
    MethodTree generateHttpPOSTMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType requestMimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        String body;
        MethodTree method;
        String methodName = saasMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        String methodPrefix = saasMethod.getWadlMethod().getName().toLowerCase();
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        List response = saasMethod.getWadlMethod().getResponse();
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        IdentifierTree responseTree = null;
        List<Object> typeParams = null;
        String bodyParam1 = "";
        String bodyParam2 = "";
        String ret = "";
        if (response != null && !response.isEmpty()) {
            VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam1 = "responseType";
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
            if (classParam != null) {
                paramList.add(classParam);
            }
            ret = "return ";
        } else {
            responseTree = maker.Identifier((CharSequence)"void");
            typeParams = Collections.emptyList();
        }
        StringBuilder queryP = new StringBuilder();
        StringBuilder queryParamPart = new StringBuilder();
        StringBuilder commentBuffer = new StringBuilder("@param responseType Class representing the response\n");
        if (httpParams.hasFormParams() || httpParams.hasQueryParams() || httpParams.hasHeaderParams()) {
            this.addQueryParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
            this.addHeaderParams(maker, httpParams, paramList, queryP, commentBuffer);
        }
        if (requestMimeType != null) {
            if (requestMimeType == ClientJavaSourceHelper.HttpMimeType.FORM && httpParams.hasFormParams()) {
                bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "getQueryOrFormParams(formParamNames, formParamValues)";
            } else {
                VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
                paramList.add(0, objectParam);
                bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "requestEntity";
                commentBuffer.append("@param requestEntity request data");
            }
        }
        commentBuffer.append("@return response object (instance of responseType class)");
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body = "{" + queryParamPart + (requestMimeType == null ? "   " + ret + "webResource" + queryP + "." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource" + queryP + ".type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}", null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    @Override
    MethodTree generateFormMethod(TreeMaker maker, WorkingCopy copy) {
        String mvMapClass = "javax.ws.rs.core.MultivaluedMap";
        TypeElement mvMapEl = copy.getElements().getTypeElement(mvMapClass);
        String mvType = mvMapEl == null ? mvMapClass : "MultivaluedMap";
        String body = "{" + mvType + "<String,String> qParams = new com.sun.jersey.api.representation.Form();for (int i=0;i< paramNames.length;i++) {    if (paramValues[i] != null) {        qParams.add(paramNames[i], paramValues[i]);    }}return qParams;}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)mvMapClass) : copy.getTreeMaker().QualIdent((Element)mvMapEl);
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        paramList.add(maker.Variable(paramModifier, (CharSequence)"paramNames", (Tree)maker.Identifier((CharSequence)"String[]"), null));
        paramList.add(maker.Variable(paramModifier, (CharSequence)"paramValues", (Tree)maker.Identifier((CharSequence)"String[]"), null));
        return maker.Method(methodModifier, (CharSequence)"getQueryOrFormParams", (Tree)returnTree, Collections.emptyList(), paramList, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateOptionalFormMethod(TreeMaker maker, WorkingCopy copy) {
        String mvMapClass = "javax.ws.rs.core.MultivaluedMap";
        TypeElement mvMapEl = copy.getElements().getTypeElement(mvMapClass);
        String mvType = mvMapEl == null ? mvMapClass : "MultivaluedMap";
        String body = "{" + mvType + "<String,String> qParams = new com.sun.jersey.api.representation.Form();for (String qParam : optionalParams) {    String[] qPar = qParam.split(\"=\");    if (qPar.length > 1) qParams.add(qPar[0], qPar[1])}return qParams;}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)mvMapClass) : copy.getTreeMaker().QualIdent((Element)mvMapEl);
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree param = maker.Variable(paramModifier, (CharSequence)"optionalParams", (Tree)maker.Identifier((CharSequence)"String..."), null);
        return maker.Method(methodModifier, (CharSequence)"getQParams", (Tree)returnTree, Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), body, null);
    }

    @Override
    ClassTree generateOAuthMethods(String projectType, WorkingCopy copy, ClassTree classTree, Metadata oauthMetadata) {
        return OAuthHelper.addOAuthMethods(projectType, copy, classTree, oauthMetadata, classTree.getSimpleName().toString());
    }

    Collection<MethodTree> generateHttpGETMethod(WorkingCopy copy, HttpMethod httpMethod, ClientJavaSourceHelper.HttpMimeType mimeType, boolean multipleMimeTypes) {
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(2);
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam = "";
        List<Object> typeParams = null;
        if (String.class.getName().equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            bodyParam = "String.class";
            typeParams = Collections.emptyList();
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        StringBuilder body = new StringBuilder("{ WebResource resource = webResource;");
        StringBuilder resourceBuilder = new StringBuilder();
        if (path.length() == 0) {
            if (mimeType != null) {
                resourceBuilder.append(".accept(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
            this.buildQueryParams(body, httpMethod, paramList, maker);
        } else {
            ClientJavaSourceHelper.PathFormat pf = JerseyGenerationStrategy.getPathFormat(path);
            for (String arg : pf.getArguments()) {
                IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
                paramList.add(fieldTree);
            }
            this.buildQueryParams(body, httpMethod, paramList, maker);
            body.append("resource=resource.path(");
            body.append(this.getPathExpression(pf));
            body.append(')');
            if (mimeType != null) {
                resourceBuilder.append(".accept(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
        }
        body.append("return resource");
        body.append((CharSequence)resourceBuilder);
        body.append(".get(");
        body.append(bodyParam);
        body.append(");");
        body.append('}');
        MethodTree method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body.toString(), null);
        result.add(method);
        return result;
    }

    @Override
    MethodTree generateHttpPOSTMethod(WorkingCopy copy, HttpMethod httpMethod, ClientJavaSourceHelper.HttpMimeType requestMimeType, boolean multipleMimeTypes) {
        String methodPrefix = httpMethod.getType().toLowerCase();
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam1 = "";
        String ret = "";
        List<Object> typeParams = Collections.emptyList();
        if ("javax.ws.rs.core.Response".equals(responseType)) {
            TypeElement clientResponseEl = copy.getElements().getTypeElement("com.sun.jersey.api.client.ClientResponse");
            ret = "return ";
            responseTree = clientResponseEl == null ? copy.getTreeMaker().Identifier((CharSequence)"com.sun.jersey.api.client.ClientResponse") : copy.getTreeMaker().QualIdent((Element)clientResponseEl);
            bodyParam1 = clientResponseEl == null ? "com.sun.jersey.api.client.ClientResponse.class" : "ClientResponse.class";
        } else if ("void".equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"void");
        } else if (String.class.getName().equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            ret = "return ";
            bodyParam1 = "String.class";
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            ret = "return ";
            bodyParam1 = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        String bodyParam2 = "";
        if (requestMimeType != null && requestMimeType != ClientJavaSourceHelper.HttpMimeType.FORM) {
            VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
            paramList.add(objectParam);
            bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "requestEntity";
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        if (path.length() == 0) {
            String body = "{" + (requestMimeType == null ? "   " + ret + "webResource." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource.type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}";
            return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
        }
        ClientJavaSourceHelper.PathFormat pf = JerseyGenerationStrategy.getPathFormat(path);
        for (String arg : pf.getArguments()) {
            IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
            paramList.add(fieldTree);
        }
        String body = "{" + (requestMimeType == null ? "   " + ret + "webResource.path(" + this.getPathExpression(pf) + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource.path(" + this.getPathExpression(pf) + ").type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}";
        return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
    }
}

