/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.refactoring.utils.TypeFinder;
import org.openide.filesystems.FileObject;

public final class TypeResolver {
    private TypeResolver() {
    }

    public static ClassNode resolveType(AstPath path, FileObject fo) {
        ASTNode leaf = path.leaf();
        ASTNode leafParent = path.leafParent();
        if (leaf instanceof VariableExpression) {
            return TypeResolver.resolveType(path, (Expression)((VariableExpression)leaf), fo);
        }
        if (leaf instanceof ConstantExpression) {
            if (leafParent instanceof MethodCallExpression) {
                return TypeResolver.resolveMethodType(path, (MethodCallExpression)leafParent, fo);
            }
            if (leafParent instanceof PropertyExpression) {
                return TypeResolver.resolveVariableType(path, (PropertyExpression)leafParent, fo);
            }
        }
        return null;
    }

    private static ClassNode resolveVariableType(AstPath path, PropertyExpression propertyExpression, FileObject fo) {
        return TypeResolver.resolveType(path, propertyExpression.getObjectExpression(), fo);
    }

    private static ClassNode resolveMethodType(AstPath path, MethodCallExpression methodCall, FileObject fo) {
        return TypeResolver.resolveType(path, methodCall.getObjectExpression(), fo);
    }

    private static ClassNode resolveType(AstPath path, Expression expression, FileObject fo) {
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            Variable variable = variableExpression.getAccessedVariable();
            if (variable == null) {
                return ASTUtils.getOwningClass((AstPath)path);
            }
            if (variable instanceof FieldNode) {
                return ((FieldNode)variable).getOwner();
            }
            if (variable instanceof VariableExpression) {
                return variable.getType();
            }
            if (variable instanceof DynamicVariable) {
                Set<ClassNode> types = TypeFinder.findTypes(fo, variable.getName());
                if (!types.isEmpty()) {
                    return types.iterator().next();
                }
                return null;
            }
        } else {
            if (expression instanceof ClassExpression) {
                return ((ClassExpression)expression).getType();
            }
            if (expression instanceof ConstructorCallExpression) {
                return ((ConstructorCallExpression)expression).getType();
            }
        }
        assert (false);
        return null;
    }
}

