/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.document.ComplexPositions;
import org.openide.util.Parameters;

class CaretUndoEdit
extends AbstractUndoableEdit {
    static final int COMPLEX_POSITIONS_MARKER = Integer.MAX_VALUE;
    static final int BACKWARD_BIAS_BIT = Integer.MIN_VALUE;
    final Document doc;
    protected int dotOffsetAndBias;

    public static UndoableEdit create(@NonNull Caret caret, @NonNull Document doc) {
        CaretUndoEdit ret;
        if (caret instanceof EditorCaret) {
            EditorCaret eCaret = (EditorCaret)caret;
            List<CaretInfo> carets = eCaret.getCarets();
            int caretsSize = carets.size();
            CaretInfo caretInfo = carets.get(0);
            Position dotPos = caretInfo.getDotPosition();
            Position.Bias dotBias = caretInfo.getDotBias();
            Position markPos = caretInfo.getMarkPosition();
            Position.Bias markBias = caretInfo.getMarkBias();
            if (dotPos != null) {
                boolean complexPos;
                if (markPos == null) {
                    markPos = dotPos;
                }
                int dotOffsetAndBias = CaretUndoEdit.toOffsetAndBias(dotPos.getOffset(), dotBias);
                int markOffsetAndBias = CaretUndoEdit.toOffsetAndBias(markPos.getOffset(), markBias);
                int dotSplitOffset = ComplexPositions.getSplitOffset((Position)dotPos);
                int markSplitOffset = ComplexPositions.getSplitOffset((Position)markPos);
                boolean bl = complexPos = dotSplitOffset != 0 || markSplitOffset != 0;
                if (caretsSize == 1) {
                    ret = !complexPos ? (dotOffsetAndBias == markOffsetAndBias && dotBias == markBias ? new CaretUndoEdit(doc, dotOffsetAndBias) : new ComplexEdit(doc, dotOffsetAndBias, markOffsetAndBias, null)) : new ComplexEdit(doc, dotOffsetAndBias, Integer.MAX_VALUE, new int[]{dotSplitOffset, markOffsetAndBias, markSplitOffset});
                } else {
                    int caretIndex;
                    int i;
                    int[] offsets;
                    if (!complexPos) {
                        offsets = new int[(caretsSize << 1) - 2];
                        i = 0;
                        for (caretIndex = 1; caretIndex < caretsSize; ++caretIndex) {
                            caretInfo = carets.get(caretIndex);
                            dotPos = caretInfo.getDotPosition();
                            dotBias = caretInfo.getDotBias();
                            markPos = caretInfo.getMarkPosition();
                            markBias = caretInfo.getMarkBias();
                            if (markPos == null) {
                                markPos = dotPos;
                            }
                            dotSplitOffset = ComplexPositions.getSplitOffset((Position)dotPos);
                            markSplitOffset = ComplexPositions.getSplitOffset((Position)markPos);
                            if (dotSplitOffset != 0 || markSplitOffset != 0) {
                                int[] newOffsets = new int[(caretsSize << 2) - 1];
                                newOffsets[1] = markOffsetAndBias;
                                int newI = 3;
                                for (int j = 0; j < i; ++j) {
                                    newOffsets[newI++] = offsets[j];
                                    ++newI;
                                }
                                markOffsetAndBias = Integer.MAX_VALUE;
                                offsets = newOffsets;
                                i = newI;
                                break;
                            }
                            offsets[i++] = CaretUndoEdit.toOffsetAndBias(dotPos.getOffset(), dotBias);
                            offsets[i++] = CaretUndoEdit.toOffsetAndBias(markPos.getOffset(), markBias);
                        }
                    } else {
                        offsets = new int[(caretsSize << 2) - 1];
                        offsets[0] = dotSplitOffset;
                        offsets[1] = markOffsetAndBias;
                        offsets[2] = markSplitOffset;
                        markOffsetAndBias = Integer.MAX_VALUE;
                        i = 3;
                    }
                    while (caretIndex < caretsSize) {
                        caretInfo = carets.get(caretIndex);
                        dotPos = caretInfo.getDotPosition();
                        dotBias = caretInfo.getDotBias();
                        markPos = caretInfo.getMarkPosition();
                        markBias = caretInfo.getMarkBias();
                        offsets[i++] = CaretUndoEdit.toOffsetAndBias(dotPos.getOffset(), dotBias);
                        offsets[i++] = CaretUndoEdit.toOffsetAndBias(markPos.getOffset(), markBias);
                        offsets[i++] = ComplexPositions.getSplitOffset((Position)dotPos);
                        offsets[i++] = ComplexPositions.getSplitOffset((Position)markPos);
                        ++caretIndex;
                    }
                    ret = new ComplexEdit(doc, dotOffsetAndBias, markOffsetAndBias, offsets);
                }
            } else {
                ret = null;
            }
        } else {
            int dotOffset = caret.getDot();
            int markOffset = caret.getMark();
            ret = markOffset != dotOffset ? new ComplexEdit(doc, dotOffset, markOffset, null) : new CaretUndoEdit(doc, dotOffset);
        }
        return ret;
    }

    static int toOffsetAndBias(int offset, Position.Bias bias) {
        assert (bias != null) : "Null bias not allowed";
        if (bias == Position.Bias.Backward) {
            offset |= Integer.MIN_VALUE;
        }
        return offset;
    }

    static int getOffset(int offsetAndBias) {
        return offsetAndBias & Integer.MAX_VALUE;
    }

    static Position.Bias getBias(int offsetAndBias) {
        return (offsetAndBias & Integer.MIN_VALUE) != 0 ? Position.Bias.Backward : Position.Bias.Forward;
    }

    static boolean isBackwardBias(int offsetAndBias) {
        return (offsetAndBias & Integer.MIN_VALUE) != 0;
    }

    CaretUndoEdit(Document doc, int dotOffsetAndBias) {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        this.doc = doc;
        this.dotOffsetAndBias = dotOffsetAndBias;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.restoreCaret();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.restoreCaret();
    }

    @Override
    public boolean isSignificant() {
        return super.isSignificant();
    }

    private void restoreCaret() {
        JTextComponent c = EditorRegistry.findComponent(this.doc);
        if (c != null) {
            Caret caret = c.getCaret();
            if (caret instanceof EditorCaret) {
                try {
                    this.restoreEditorCaret((EditorCaret)caret);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.restoreLegacyCaret(caret);
            }
        }
    }

    protected void restoreEditorCaret(EditorCaret caret) throws BadLocationException {
        Position dotPos = this.doc.createPosition(CaretUndoEdit.getOffset(this.dotOffsetAndBias));
        List<Position.Bias> biases = CaretUndoEdit.isBackwardBias(this.dotOffsetAndBias) ? Arrays.asList(Position.Bias.Backward, Position.Bias.Backward) : null;
        caret.replaceCarets(Arrays.asList(dotPos, dotPos), biases);
    }

    protected void restoreLegacyCaret(Caret caret) {
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setDot(CaretUndoEdit.getOffset(this.dotOffsetAndBias), CaretUndoEdit.getBias(this.dotOffsetAndBias));
        } else {
            caret.setDot(CaretUndoEdit.getOffset(this.dotOffsetAndBias));
        }
    }

    static final class ComplexEdit
    extends CaretUndoEdit {
        int markOffsetAndBias;
        int[] extraOffsets;

        ComplexEdit(Document doc, int dotOffsetAndBias, int markOffsetAndBias, int[] extraOffsets) {
            super(doc, dotOffsetAndBias);
            this.markOffsetAndBias = markOffsetAndBias;
            this.extraOffsets = extraOffsets;
        }

        @Override
        protected void restoreEditorCaret(EditorCaret caret) throws BadLocationException {
            List<Object> dotAndMarkPosPairs;
            Position dotPos = this.doc.createPosition(ComplexEdit.getOffset(this.dotOffsetAndBias));
            List<Position.Bias> biases = ComplexEdit.addBias(null, this.dotOffsetAndBias, 0);
            int biasIndex = 1;
            if (this.markOffsetAndBias != Integer.MAX_VALUE) {
                Position markPos = this.doc.createPosition(ComplexEdit.getOffset(this.markOffsetAndBias));
                biases = ComplexEdit.addBias(biases, this.markOffsetAndBias, biasIndex++);
                if (this.extraOffsets != null) {
                    dotAndMarkPosPairs = new ArrayList(2 + this.extraOffsets.length);
                    dotAndMarkPosPairs.add(dotPos);
                    dotAndMarkPosPairs.add(markPos);
                    for (int i = 0; i < this.extraOffsets.length; ++i) {
                        int offsetAndBias = this.extraOffsets[i];
                        dotAndMarkPosPairs.add(this.doc.createPosition(ComplexEdit.getOffset(offsetAndBias)));
                        biases = ComplexEdit.addBias(biases, offsetAndBias, biasIndex++);
                    }
                } else {
                    dotAndMarkPosPairs = Arrays.asList(dotPos, markPos);
                }
            } else {
                int splitOffset = this.extraOffsets[0];
                int i = 1;
                dotAndMarkPosPairs = new ArrayList<Position>(this.extraOffsets.length + 1 >> 1);
                Position pos = dotPos;
                while (true) {
                    pos = ComplexPositions.create((Position)pos, (int)splitOffset);
                    dotAndMarkPosPairs.add(pos);
                    if (i >= this.extraOffsets.length) break;
                    int offsetAndBias = this.extraOffsets[i++];
                    splitOffset = this.extraOffsets[i++];
                    pos = this.doc.createPosition(ComplexEdit.getOffset(offsetAndBias));
                    biases = ComplexEdit.addBias(biases, offsetAndBias, biasIndex++);
                }
            }
            caret.replaceCarets(dotAndMarkPosPairs, biases);
        }

        @Override
        protected void restoreLegacyCaret(Caret caret) {
            int markOffsetAndBias = this.markOffsetAndBias;
            if (markOffsetAndBias == Integer.MAX_VALUE) {
                markOffsetAndBias = this.extraOffsets[1];
            }
            int markOffset = ComplexEdit.getOffset(markOffsetAndBias);
            int dotOffset = ComplexEdit.getOffset(this.dotOffsetAndBias);
            if (caret instanceof DefaultCaret) {
                DefaultCaret dCaret = (DefaultCaret)caret;
                dCaret.setDot(markOffset, ComplexEdit.getBias(markOffsetAndBias));
                dCaret.moveDot(dotOffset, ComplexEdit.getBias(this.dotOffsetAndBias));
            } else {
                caret.setDot(markOffset);
                caret.moveDot(dotOffset);
            }
        }

        static List<Position.Bias> addBias(List<Position.Bias> biases, int offsetAndBias, int index) {
            if ((offsetAndBias & Integer.MIN_VALUE) != 0) {
                if (biases == null) {
                    biases = new ArrayList<Position.Bias>(index + 1);
                    while (--index >= 0) {
                        biases.add(Position.Bias.Forward);
                    }
                }
                biases.add(Position.Bias.Backward);
            } else if (biases != null) {
                biases.add(Position.Bias.Forward);
            }
            return biases;
        }
    }
}

