/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.design.multiview.MultiViewSupport;
import org.netbeans.modules.websvc.design.multiview.ShowComponentCookie;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = 4403502726950453345L;
    private transient JComponent toolbar;
    private transient MultiViewElementCallback multiViewCallback;
    private transient Lookup myLookup;

    public SourceMultiViewElement() {
        this.initialize();
    }

    public SourceMultiViewElement(Lookup context) {
        super((CloneableEditorSupport)context.lookup(DataEditorSupport.class));
        this.initialize();
    }

    private void initialize() {
        ShowComponentCookie showCookie = new ShowComponentCookie(){

            @Override
            public void show(Object param) {
                if (!(param instanceof ElementHandle)) {
                    return;
                }
                final ElementHandle handle = (ElementHandle)param;
                try {
                    final JavaSource targetSource = JavaSource.forFileObject((FileObject)SourceMultiViewElement.this.getEditorSupport().getDataObject().getPrimaryFile());
                    CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

                        public void run(WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement webSvc = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                            Element element = handle.resolve((CompilationInfo)workingCopy);
                            if (element == null) {
                                return;
                            }
                            SourcePositions srcPos = workingCopy.getTrees().getSourcePositions();
                            int position = -1;
                            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                                BlockTree methodBody;
                                Element webServiceMethod = workingCopy.getElementUtilities().getImplementationOf((ExecutableElement)element, webSvc);
                                if (webServiceMethod instanceof ExecutableElement) {
                                    element = (ExecutableElement)webServiceMethod;
                                }
                                MethodTree methodTree = workingCopy.getTrees().getTree((ExecutableElement)element);
                                Tree tree = methodBody = methodTree.getBody();
                                if (!methodBody.getStatements().isEmpty()) {
                                    tree = methodBody.getStatements().get(0);
                                }
                                position = (int)srcPos.getStartPosition(workingCopy.getCompilationUnit(), tree);
                            }
                            if (position > 0) {
                                SourceMultiViewElement.this.getEditorPane().setCaretPosition(position);
                            }
                        }

                        public void cancel() {
                        }
                    };
                    targetSource.runWhenScanFinished((Task)new Task<CompilationController>((CancellableTask)task){
                        final /* synthetic */ CancellableTask val$task;
                        {
                            this.val$task = cancellableTask;
                        }

                        public void run(CompilationController arg0) throws Exception {
                            targetSource.runModificationTask((Task)this.val$task).commit();
                        }
                    }, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.myLookup = Lookups.fixed((Object[])new Object[]{showCookie});
    }

    public JComponent getToolbarRepresentation() {
        Document doc;
        JEditorPane editorPane = this.getEditorPane();
        if (editorPane != null && (doc = editorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
            if (this.toolbar == null) {
                this.toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(this.getEditorPane());
            }
            return this.toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void updateName() {
        super.updateName();
        this.updateMultiViewHtmlDisplayName();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.multiViewCallback = callback;
        this.updateMultiViewHtmlDisplayName();
    }

    private void updateMultiViewHtmlDisplayName() {
        if (this.multiViewCallback != null) {
            if (EventQueue.isDispatchThread()) {
                this.multiViewCallback.getTopComponent().setHtmlDisplayName(this.getHtmlDisplayName());
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SourceMultiViewElement.this.multiViewCallback.getTopComponent().setHtmlDisplayName(SourceMultiViewElement.this.getHtmlDisplayName());
                    }
                });
            }
        }
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        super.componentShowing();
        DataObject dobj = this.getEditorSupport().getDataObject();
        if (dobj == null || !dobj.isValid()) {
            this.setActivatedNodes(new Node[0]);
        } else {
            this.setActivatedNodes(new Node[]{this.getEditorSupport().getDataObject().getNodeDelegate()});
        }
    }

    public void componentHidden() {
        super.componentHidden();
        this.setActivatedNodes(new Node[0]);
    }

    public void open() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestVisible();
        } else {
            super.open();
        }
    }

    public void requestVisible() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public UndoRedo getUndoRedo() {
        return super.getUndoRedo();
    }

    protected boolean closeLast() {
        if (MultiViewSupport.getNumberOfClones(this.multiViewCallback.getTopComponent()) == 0) {
            return super.closeLast();
        }
        return true;
    }

    public CloseOperationState canCloseElement() {
        if (!this.getEditorSupport().isModified() || MultiViewSupport.getNumberOfClones(this.multiViewCallback.getTopComponent()) > 1) {
            return CloseOperationState.STATE_OK;
        }
        AbstractAction save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    SourceMultiViewElement.this.getEditorSupport().saveDocument();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        save.putValue("LongDescription", NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.getEditorSupport().getDataObject().getPrimaryFile().getNameExt()));
        return MultiViewFactory.createUnsafeCloseState((String)"ID_JAXWS_CLOSING", (Action)save, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.cloneableEditorSupport();
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{super.getLookup(), this.myLookup, this.getEditorSupport().getDataObject().getLookup()});
    }
}

