/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.LanguagesManager;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.text.NbDocument;

public class EditorTokenInput
extends TokenInput {
    private TokenSequence tokenSequence;
    private Language language;
    private List tokens = new ArrayList();
    private int index = 0;
    private Set<Integer> filter;
    private StyledDocument doc;
    private String mimeType;

    public static EditorTokenInput create(Set<Integer> filter, StyledDocument doc) {
        return new EditorTokenInput(filter, doc);
    }

    private EditorTokenInput(Set<Integer> filter, StyledDocument doc) {
        this.tokenSequence = TokenHierarchy.get((Document)doc).tokenSequence();
        this.mimeType = this.tokenSequence.language().mimeType();
        try {
            this.language = LanguagesManager.get().getLanguage(this.mimeType);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        this.filter = filter;
        this.doc = doc;
    }

    @Override
    public ASTToken next(int i) {
        while (this.index + i - 1 >= this.tokens.size()) {
            ASTToken token = this.nextToken();
            if (token == null) {
                return null;
            }
            this.tokens.add(token);
        }
        return (ASTToken)this.tokens.get(this.index + i - 1);
    }

    private ASTToken nextToken() {
        do {
            if (this.tokenSequence.moveNext()) continue;
            return null;
        } while (this.filter.contains(this.tokenSequence.token().id().ordinal()));
        Token token = this.tokenSequence.token();
        return ASTToken.create(this.language, token.id().ordinal(), token.text().toString(), this.tokenSequence.offset());
    }

    @Override
    public boolean eof() {
        return this.next(1) == null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getOffset() {
        ASTToken t = null;
        if (this.eof()) {
            if (this.getIndex() == 0) {
                return 0;
            }
            t = (ASTToken)this.tokens.get(this.tokens.size() - 1);
            return t.getOffset() + t.getLength();
        }
        t = this.next(1);
        return t.getOffset();
    }

    @Override
    public ASTToken read() {
        ASTToken next = this.next(1);
        ++this.index;
        return next;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public String getString(int from) {
        throw new InternalError();
    }

    public String toString() {
        int offset = this.next(1) == null ? this.doc.getLength() : this.next(1).getOffset();
        int lineNumber = NbDocument.findLineNumber((StyledDocument)this.doc, (int)offset);
        return (String)this.doc.getProperty("title") + ":" + (lineNumber + 1) + "," + (offset - NbDocument.findLineOffset((StyledDocument)this.doc, (int)lineNumber) + 1);
    }
}

