/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.tools.model.Problem;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificationVariableStateObject
extends SimpleStateObject {
    private IManagedType managedType;
    private IMapping mapping;
    private IType type;
    private ITypeDeclaration typeDeclaration;
    private boolean virtual;
    public static final String DEFINED_PROPERTY = "defined";

    public IdentificationVariableStateObject(StateObject parent) {
        super(parent);
    }

    public IdentificationVariableStateObject(StateObject parent, String variable) {
        super(parent, variable);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addProblems(List<Problem> problems) {
        super.addProblems(problems);
    }

    protected void checkIntegrity(String text) {
        if (ExpressionTools.valuesAreDifferent(this.getText(), text)) {
            this.clearResolvedObjects();
        }
    }

    protected void clearResolvedObjects() {
        this.type = null;
        this.managedType = null;
        this.typeDeclaration = null;
    }

    @Override
    public IdentificationVariable getExpression() {
        return (IdentificationVariable)super.getExpression();
    }

    public IManagedType getManagedType() {
        if (this.managedType == null && this.mapping == null) {
            this.managedType = this.resolveManagedType();
        }
        return this.managedType;
    }

    public IMapping getMapping() {
        if (this.managedType == null && this.mapping == null) {
            this.mapping = this.resolveMapping();
        }
        return this.mapping;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.resolveType();
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.resolveTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            IdentificationVariableStateObject variable = (IdentificationVariableStateObject)stateObject;
            return ExpressionTools.stringsAreEqualIgnoreCase(this.getText(), variable.getText());
        }
        return false;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    protected IManagedType resolveManagedType() {
        return this.getManagedTypeProvider().getManagedType(this.getType());
    }

    protected IMapping resolveMapping() {
        return null;
    }

    protected IType resolveType() {
        return this.getTypeDeclaration().getType();
    }

    protected ITypeDeclaration resolveTypeDeclaration() {
        return null;
    }

    public void setExpression(IdentificationVariable expression) {
        super.setExpression(expression);
    }

    @Override
    public void setText(String text) {
        this.checkIntegrity(text);
        super.setText(text);
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (!this.virtual) {
            super.toTextInternal(writer);
        }
    }
}

