/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;

public class CrossBorderLayout
implements LayoutManager2 {
    private static final int NONE = Integer.MIN_VALUE;
    private Map<Component, Integer[]> map = new HashMap<Component, Integer[]>();
    private Component north;
    private Component west;
    private Component south;
    private Component east;
    private Component center;

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Integer[])) {
            throw new IllegalArgumentException("Illegal constraints: " + constraints);
        }
        this.addLayoutComponent(comp, (Integer[])constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.center) {
                this.center = null;
                this.map.remove(this.center);
            } else if (comp == this.north) {
                this.north = null;
                this.map.remove(this.north);
            } else if (comp == this.south) {
                this.south = null;
                this.map.remove(this.south);
            } else if (comp == this.east) {
                this.east = null;
                this.map.remove(this.east);
            } else if (comp == this.west) {
                this.west = null;
                this.map.remove(this.west);
            }
        }
    }

    public Component getLayoutComponent(int constraint) {
        if (constraint == 1) {
            return this.north;
        }
        if (constraint == 7) {
            return this.west;
        }
        if (constraint == 5) {
            return this.south;
        }
        if (constraint == 3) {
            return this.east;
        }
        if (constraint == 0) {
            return this.center;
        }
        throw new IllegalArgumentException("Illegal constraint: " + CrossBorderLayout.constraintName(constraint));
    }

    public Object getConstraints(Component comp) {
        if (comp == null) {
            return null;
        }
        return this.map.get(comp);
    }

    public Object getConstraints(int constraint) {
        Component comp = this.getLayoutComponent(constraint);
        if (comp == null) {
            return null;
        }
        return this.map.get(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension cen;
            Dimension dim = new Dimension(0, 0);
            Dimension dimension = cen = this.center != null ? this.center.getPreferredSize() : null;
            if (this.north != null) {
                dim.height += this.north.getPreferredSize().height;
            }
            if (cen != null) {
                dim.height += cen.height;
            }
            if (this.south != null) {
                dim.height += this.south.getPreferredSize().height;
            }
            if (this.west != null) {
                dim.width += this.west.getPreferredSize().width;
            }
            if (cen != null) {
                dim.width += cen.width;
            }
            if (this.east != null) {
                dim.width += this.east.getPreferredSize().width;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension cen;
            Dimension dim = new Dimension(0, 0);
            Dimension dimension = cen = this.center != null ? this.center.getMinimumSize() : null;
            if (this.north != null) {
                dim.height += this.north.getMinimumSize().height;
            }
            if (cen != null) {
                dim.height += cen.height;
            }
            if (this.south != null) {
                dim.height += this.south.getMinimumSize().height;
            }
            if (this.west != null) {
                dim.width += this.west.getMinimumSize().width;
            }
            if (cen != null) {
                dim.width += cen.width;
            }
            if (this.east != null) {
                dim.width += this.east.getMinimumSize().width;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int bottomOffset;
            int topOffset;
            int rightOffset;
            int leftOffset;
            Integer[] constraints;
            int eastWidth;
            Insets insets = parent.getInsets();
            int top = insets.top;
            int bottom = parent.getHeight() - insets.bottom;
            int height = parent.getHeight() - insets.bottom - insets.top;
            int left = insets.left;
            int right = parent.getWidth() - insets.right;
            int width = parent.getWidth() - insets.right - insets.left;
            int northHeight = this.north != null ? this.north.getPreferredSize().height : 0;
            int southHeight = this.south != null ? this.south.getPreferredSize().height : 0;
            int westWidth = this.west != null ? this.west.getPreferredSize().width : 0;
            int n = eastWidth = this.east != null ? this.east.getPreferredSize().width : 0;
            if (this.center != null) {
                this.center.setBounds(left + westWidth, top + northHeight, width - eastWidth - westWidth, height - southHeight - northHeight);
            }
            if (this.north != null) {
                constraints = this.map.get(this.north);
                leftOffset = constraints[0] != Integer.MIN_VALUE ? westWidth : 0;
                rightOffset = constraints[2] != Integer.MIN_VALUE ? eastWidth : 0;
                this.north.setBounds(left + westWidth - leftOffset, top, width - eastWidth - westWidth + leftOffset + rightOffset, northHeight);
            }
            if (this.south != null) {
                constraints = this.map.get(this.south);
                leftOffset = constraints[0] != Integer.MIN_VALUE ? westWidth : 0;
                rightOffset = constraints[2] != Integer.MIN_VALUE ? eastWidth : 0;
                this.south.setBounds(left + westWidth - leftOffset, bottom - southHeight, width - eastWidth - westWidth + leftOffset + rightOffset, southHeight);
            }
            if (this.west != null) {
                constraints = this.map.get(this.west);
                topOffset = constraints[0] != Integer.MIN_VALUE ? northHeight : 0;
                bottomOffset = constraints[2] != Integer.MIN_VALUE ? southHeight : 0;
                this.west.setBounds(left, top + northHeight - topOffset, westWidth, height - southHeight - northHeight + topOffset + bottomOffset);
            }
            if (this.east != null) {
                constraints = this.map.get(this.east);
                topOffset = constraints[0] != Integer.MIN_VALUE ? northHeight : 0;
                bottomOffset = constraints[2] != Integer.MIN_VALUE ? southHeight : 0;
                this.east.setBounds(right - eastWidth, top + northHeight - topOffset, eastWidth, height - southHeight - northHeight + topOffset + bottomOffset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLayoutComponent(Component comp, Integer[] constraints) {
        if (constraints.length == 0) {
            throw new IllegalArgumentException("At least one location is required: " + CrossBorderLayout.toString(constraints));
        }
        if (constraints.length > 3) {
            throw new IllegalArgumentException("Up to three locations are required: " + CrossBorderLayout.toString(constraints));
        }
        constraints = CrossBorderLayout.normalizedConstraints(constraints);
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (CrossBorderLayout.isNorth(constraints)) {
                this.north = comp;
                this.map.put(comp, constraints);
            } else if (CrossBorderLayout.isWest(constraints)) {
                this.west = comp;
                this.map.put(comp, constraints);
            } else if (CrossBorderLayout.isSouth(constraints)) {
                this.south = comp;
                this.map.put(comp, constraints);
            } else if (CrossBorderLayout.isEast(constraints)) {
                this.east = comp;
                this.map.put(comp, constraints);
            } else if (CrossBorderLayout.isCenter(constraints)) {
                this.center = comp;
                this.map.put(comp, constraints);
            }
        }
    }

    private static boolean isNorth(Integer[] constraints) {
        return constraints[1] == 1;
    }

    private static boolean isWest(Integer[] constraints) {
        return constraints[1] == 7;
    }

    private static boolean isSouth(Integer[] constraints) {
        return constraints[1] == 5;
    }

    private static boolean isEast(Integer[] constraints) {
        return constraints[1] == 3;
    }

    private static boolean isCenter(Integer[] constraints) {
        return constraints[1] == 0;
    }

    private static boolean isBasis(int constraint) {
        if (constraint == 1) {
            return true;
        }
        if (constraint == 7) {
            return true;
        }
        if (constraint == 5) {
            return true;
        }
        if (constraint == 3) {
            return true;
        }
        return constraint == 0;
    }

    private static void checkSupported(int constraint) {
        if (constraint == 1) {
            return;
        }
        if (constraint == 7) {
            return;
        }
        if (constraint == 5) {
            return;
        }
        if (constraint == 3) {
            return;
        }
        if (constraint == 8) {
            return;
        }
        if (constraint == 2) {
            return;
        }
        if (constraint == 6) {
            return;
        }
        if (constraint == 4) {
            return;
        }
        if (constraint == 0) {
            return;
        }
        throw new IllegalArgumentException("Unsupported constraint: " + constraint);
    }

    private static void checkDefining(Integer[] constraints) {
        boolean b3;
        boolean b1 = CrossBorderLayout.isBasis(constraints[0]);
        boolean b2 = constraints.length > 1 ? CrossBorderLayout.isBasis(constraints[1]) : false;
        boolean bl = b3 = constraints.length == 3 ? CrossBorderLayout.isBasis(constraints[2]) : false;
        if (!(b1 || b2 || b3)) {
            throw new IllegalArgumentException("Constraint does not define position: " + CrossBorderLayout.toString(constraints));
        }
        if (b1 && b2 || b1 && b3 || b2 && b3) {
            throw new IllegalArgumentException("Constraint defines more than one position: " + CrossBorderLayout.toString(constraints));
        }
    }

    private static Integer[] normalizedConstraints(Integer[] constraints) {
        int basis;
        Integer[] integerArray = constraints;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int c = integerArray[i];
            CrossBorderLayout.checkSupported(c);
        }
        CrossBorderLayout.checkDefining(constraints);
        Integer[] normalized = null;
        normalized = constraints.length == 1 ? new Integer[]{Integer.MIN_VALUE, constraints[0], Integer.MIN_VALUE} : (constraints.length == 2 ? new Integer[]{constraints[0], constraints[1], Integer.MIN_VALUE} : constraints);
        if (CrossBorderLayout.isBasis(normalized[0])) {
            basis = normalized[0];
            normalized[0] = normalized[1];
            normalized[1] = basis;
        } else if (CrossBorderLayout.isBasis(normalized[2])) {
            basis = normalized[2];
            normalized[2] = normalized[1];
            normalized[1] = basis;
        }
        int c0 = normalized[0];
        int c2 = normalized[2];
        if (c0 != Integer.MIN_VALUE && c0 == c2) {
            throw new IllegalArgumentException("Duplicite constraints: " + CrossBorderLayout.toString(constraints));
        }
        if (CrossBorderLayout.isCenter(normalized)) {
            if (c0 != Integer.MIN_VALUE || c2 != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Constraint CENTER must be used standalone: " + CrossBorderLayout.toString(constraints));
            }
        } else {
            if (CrossBorderLayout.isNorth(normalized)) {
                if (c0 == 2) {
                    normalized[2] = c0;
                    normalized[0] = c2;
                }
                c0 = normalized[0];
                c2 = normalized[2];
                if (c0 != Integer.MIN_VALUE && c0 != 8) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
                if (c2 != Integer.MIN_VALUE && c2 != 2) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
            } else if (CrossBorderLayout.isSouth(normalized)) {
                if (c0 == 4) {
                    normalized[2] = c0;
                    normalized[0] = c2;
                }
                c0 = normalized[0];
                c2 = normalized[2];
                if (c0 != Integer.MIN_VALUE && c0 != 6) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
                if (c2 != Integer.MIN_VALUE && c2 != 4) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
            } else if (CrossBorderLayout.isWest(normalized)) {
                if (c0 == 6) {
                    normalized[2] = c0;
                    normalized[0] = c2;
                }
                c0 = normalized[0];
                c2 = normalized[2];
                if (c0 != Integer.MIN_VALUE && c0 != 8) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
                if (c2 != Integer.MIN_VALUE && c2 != 6) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
            }
            if (CrossBorderLayout.isEast(normalized)) {
                if (c0 == 4) {
                    normalized[2] = c0;
                    normalized[0] = c2;
                }
                c0 = normalized[0];
                c2 = normalized[2];
                if (c0 != Integer.MIN_VALUE && c0 != 2) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
                if (c2 != Integer.MIN_VALUE && c2 != 4) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(constraints));
                }
            }
        }
        return normalized;
    }

    private static String toString(Integer[] constraints) {
        StringBuilder buffer = new StringBuilder();
        Integer[] integerArray = constraints;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int constraint = integerArray[i];
            buffer.append(buffer.length() == 0 ? CrossBorderLayout.constraintName(constraint) : ", " + CrossBorderLayout.constraintName(constraint));
        }
        if (buffer.length() == 0) {
            buffer.append("[");
        } else {
            buffer.insert(0, "[");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static String constraintName(int constraint) {
        if (constraint == 1) {
            return "NORTH";
        }
        if (constraint == 7) {
            return "WEST";
        }
        if (constraint == 5) {
            return "SOUTH";
        }
        if (constraint == 3) {
            return "EAST";
        }
        if (constraint == 8) {
            return "NORTH_WEST";
        }
        if (constraint == 2) {
            return "NORTH_EAST";
        }
        if (constraint == 6) {
            return "SOUTH_WEST";
        }
        if (constraint == 4) {
            return "SOUTH_EAST";
        }
        if (constraint == 0) {
            return "CENTER";
        }
        return "UNSUPPORTED_CONSTRAINT (value=" + constraint + ")";
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("CrossBorderLayout.addLayoutComponent(String, Component) not supported, use CrossBorderLayout.addLayoutComponent(Component, Object)");
    }
}

