/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.tx.at.TransactionalFeature;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.tx.at.WSATConstants;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import com.sun.xml.ws.tx.at.tube.WSATServer;
import com.sun.xml.ws.tx.at.tube.WSATServerHelper;
import com.sun.xml.ws.tx.at.tube.WSATTubeHelper;

public class WSATServerTube
extends AbstractFilterTubeImpl
implements WSATConstants {
    private static final String WSATATTRIBUTE = ".wsee.wsat.attribute";
    ServerTubelineAssemblyContext m_context;
    private WSDLPort m_port;
    private TransactionalFeature m_transactionalFeature;
    WSATServer m_wsatServerHelper = new WSATServerHelper();

    public WSATServerTube(Tube next, ServerTubelineAssemblyContext context, TransactionalFeature feature) {
        super(next);
        this.m_context = context;
        this.m_port = context.getWsdlPort();
        this.m_transactionalFeature = feature;
    }

    public WSATServerTube(WSATServerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.m_context = that.m_context;
        this.m_port = that.m_port;
        this.m_transactionalFeature = that.m_transactionalFeature;
    }

    @Override
    @NotNull
    public NextAction processRequest(Packet request) {
        TransactionalAttribute tx = WSATTubeHelper.getTransactionalAttribute(this.m_transactionalFeature, request, this.m_port);
        tx.setSoapVersion(this.m_context.getEndpoint().getBinding().getSOAPVersion());
        request.invocationProperties.put(WSATATTRIBUTE, tx);
        MessageHeaders headers = request.getMessage().getHeaders();
        this.m_wsatServerHelper.doHandleRequest(headers, tx);
        return super.processRequest(request);
    }

    @Override
    @NotNull
    public NextAction processResponse(Packet response) {
        TransactionalAttribute tx = (TransactionalAttribute)response.invocationProperties.get(WSATATTRIBUTE);
        this.m_wsatServerHelper.doHandleResponse(tx);
        return super.processResponse(response);
    }

    @Override
    @NotNull
    public NextAction processException(Throwable t) {
        this.m_wsatServerHelper.doHandleException(t);
        return super.processException(t);
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new WSATServerTube(this, cloner);
    }

    NextAction doProcessResponse(Packet request) {
        return super.processResponse(request);
    }
}

