/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.CloneExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EchoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.PostfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.PrefixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnusedVariableCustomizer;
import org.openide.filesystems.FileObject;

public class UnusedVariableHint
extends HintRule
implements CustomisableRule {
    private static final String HINT_ID = "Unused.Variable.Hint";
    private static final String CHECK_UNUSED_FORMAL_PARAMETERS = "php.verification.check.unused.formal.parameters";
    private static final String CHECK_INHERITED_METHOD_PARAMETERS = "php.verification.check.inherited.method.parameters";
    private static final List<String> UNCHECKED_VARIABLES = new ArrayList<String>();
    private Preferences preferences;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc, this.getInheritedMethods(context));
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            hints.addAll(checkVisitor.getHints());
        }
    }

    private Map<String, List<String>> getInheritedMethods(PHPRuleContext context) {
        if (!this.checkUnusedFormalParameters(this.preferences) || this.checkInheritedMethodParameters(this.preferences)) {
            return Collections.emptyMap();
        }
        FileScope fileScope = context.fileScope;
        Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
        ElementQuery.Index index = context.getIndex();
        HashMap<String, List<String>> allInheritedMethods = new HashMap<String, List<String>>();
        for (ClassScope classScope : allClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return Collections.emptyMap();
            }
            Set<MethodElement> inheritedMethods = this.getInheritedMethods(classScope, index);
            for (MethodElement inheritedMethod : inheritedMethods) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyMap();
                }
                ArrayList<String> methodElements = (ArrayList<String>)allInheritedMethods.get(inheritedMethod.getName());
                if (methodElements == null) {
                    methodElements = new ArrayList<String>();
                    methodElements.add(classScope.getName());
                    allInheritedMethods.put(inheritedMethod.getName(), methodElements);
                    continue;
                }
                methodElements.add(classScope.getName());
            }
        }
        return allInheritedMethods;
    }

    private Set<MethodElement> getInheritedMethods(ClassScope classScope, ElementQuery.Index index) {
        HashSet<MethodElement> inheritedMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> declaredSuperMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> accessibleSuperMethods = new HashSet<MethodElement>();
        Collection<? extends ClassScope> superClasses = classScope.getSuperClasses();
        for (ClassScope classScope2 : superClasses) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(classScope2));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(classScope2, classScope));
        }
        Collection<? extends InterfaceScope> superInterface = classScope.getSuperInterfaceScopes();
        for (InterfaceScope interfaceScope : superInterface) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(interfaceScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(interfaceScope, classScope));
        }
        Collection collection = classScope.getTraits();
        for (TraitScope traitScope : collection) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(traitScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(traitScope, classScope));
        }
        inheritedMethods.addAll(declaredSuperMethods);
        inheritedMethods.addAll(accessibleSuperMethods);
        return inheritedMethods;
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnusedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnusedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        UnusedVariableCustomizer customizer = new UnusedVariableCustomizer(preferences, this);
        this.setCheckUnusedFormalParameters(preferences, this.checkUnusedFormalParameters(preferences));
        this.setCheckInheritedMethodParameters(preferences, this.checkInheritedMethodParameters(preferences));
        return customizer;
    }

    public void setCheckUnusedFormalParameters(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, isEnabled);
    }

    public boolean checkUnusedFormalParameters(Preferences preferences) {
        return preferences.getBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, true);
    }

    public void setCheckInheritedMethodParameters(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_INHERITED_METHOD_PARAMETERS, isEnabled);
    }

    public boolean checkInheritedMethodParameters(Preferences preferences) {
        return preferences.getBoolean(CHECK_INHERITED_METHOD_PARAMETERS, true);
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private static final class HintVariable {
        private final ASTNode node;
        private final String name;

        static HintVariable create(ASTNode node, String name) {
            return new HintVariable(node, name);
        }

        private HintVariable(ASTNode node, String name) {
            this.node = node;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getStartOffset() {
            return this.node.getStartOffset() + 1;
        }

        public int getEndOffset() {
            return this.node.getEndOffset();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HintVariable other = (HintVariable)obj;
            return Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.name);
            return hash;
        }
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final ArrayDeque<ASTNode> parentNodes = new ArrayDeque();
        private final Map<ASTNode, List<HintVariable>> unusedVariables = new HashMap<ASTNode, List<HintVariable>>();
        private final Map<ASTNode, List<HintVariable>> usedVariables = new HashMap<ASTNode, List<HintVariable>>();
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;
        private boolean forceVariableAsUsed;
        private boolean forceVariableAsUnused;
        private boolean isInInheritedMethod;
        private String className = "";
        private final Map<String, List<String>> allInheritedMethods;
        private final Map<ArrowFunctionDeclaration, Set<String>> arrowFunctionParameters = new HashMap<ArrowFunctionDeclaration, Set<String>>();
        private ArrowFunctionDeclaration firstArrowFunctionNode = null;
        private ArrowFunctionDeclaration currentArrowFunctionNode = null;

        CheckVisitor(FileObject fileObject, BaseDocument baseDocument, Map<String, List<String>> allInheritedMethods) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.allInheritedMethods = allInheritedMethods;
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            for (List<HintVariable> scopeVariables : this.unusedVariables.values()) {
                for (HintVariable variable : scopeVariables) {
                    this.createHint(variable);
                }
            }
            return Collections.unmodifiableList(this.hints);
        }

        private void createHint(HintVariable variable) {
            int end;
            int start = variable.getStartOffset();
            OffsetRange offsetRange = new OffsetRange(start, end = variable.getEndOffset());
            if (UnusedVariableHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)UnusedVariableHint.this, Bundle.UnusedVariableHintCustom(variable.getName()), this.fileObject, offsetRange, null, 500));
            }
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }

        private List<HintVariable> getUsedScopeVariables(ASTNode parentNode) {
            List<HintVariable> usedScopeVariables = this.usedVariables.get(parentNode);
            if (usedScopeVariables == null) {
                usedScopeVariables = new ArrayList<HintVariable>();
                this.usedVariables.put(parentNode, usedScopeVariables);
            }
            return usedScopeVariables;
        }

        private List<HintVariable> getUnusedScopeVariables(ASTNode parentNode) {
            List<HintVariable> unusedScopeVariables = this.unusedVariables.get(parentNode);
            if (unusedScopeVariables == null) {
                unusedScopeVariables = new ArrayList<HintVariable>();
                this.unusedVariables.put(parentNode, unusedScopeVariables);
            }
            return unusedScopeVariables;
        }

        @CheckForNull
        private HintVariable getUnusedVariable(String currentVarName, List<HintVariable> unusedScopeVariables) {
            HintVariable retval = null;
            for (HintVariable variable : unusedScopeVariables) {
                String varName = variable.getName();
                if (!currentVarName.equals(varName)) continue;
                retval = variable;
                break;
            }
            return retval;
        }

        private boolean isVariableUsed(String currentVarName, List<HintVariable> usedScopeVariables) {
            boolean retval = false;
            for (HintVariable variable : usedScopeVariables) {
                String varName = variable.getName();
                if (!currentVarName.equals(varName)) continue;
                retval = true;
                break;
            }
            return retval;
        }

        private void forceVariableAsUnused(HintVariable node, List<HintVariable> unusedScopeVariables) {
            HintVariable unusedVariable = this.getUnusedVariable(node.getName(), unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
            unusedScopeVariables.add(node);
        }

        private void forceVariableAsUsed(HintVariable hintVariable, List<HintVariable> usedScopeVariables, List<HintVariable> unusedScopeVariables) {
            String currentVarName = hintVariable.getName();
            if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                return;
            }
            usedScopeVariables.add(hintVariable);
            HintVariable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
        }

        @Override
        public void visit(Variable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Identifier identifier = this.getIdentifier(node);
            if (identifier != null && !this.isInGlobalContext()) {
                if (this.parentNodes.peek() instanceof ArrowFunctionDeclaration && !this.isArrowFunctionParameter(node)) {
                    return;
                }
                this.process(HintVariable.create(node, identifier.getName()));
            }
        }

        private boolean isInGlobalContext() {
            return this.parentNodes.peek() instanceof Program || this.parentNodes.peek() instanceof NamespaceDeclaration;
        }

        private boolean isArrowFunctionParameter(Variable variable) {
            Set<String> params = this.arrowFunctionParameters.get(this.currentArrowFunctionNode);
            return params != null && params.contains(CodeUtils.extractVariableName(variable));
        }

        private void process(HintVariable hintVariable) {
            if (hintVariable != null && !UNCHECKED_VARIABLES.contains(hintVariable.getName())) {
                ASTNode parentNode = this.parentNodes.peek();
                if (parentNode instanceof ArrowFunctionDeclaration && this.currentArrowFunctionNode != null) {
                    parentNode = this.currentArrowFunctionNode;
                }
                String currentVarName = hintVariable.getName();
                List<HintVariable> usedScopeVariables = this.getUsedScopeVariables(parentNode);
                List<HintVariable> unusedScopeVariables = this.getUnusedScopeVariables(parentNode);
                if (this.forceVariableAsUnused) {
                    this.forceVariableAsUnused(hintVariable, unusedScopeVariables);
                    return;
                }
                if (this.forceVariableAsUsed) {
                    this.forceVariableAsUsed(hintVariable, usedScopeVariables, unusedScopeVariables);
                    return;
                }
                if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                    return;
                }
                HintVariable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
                if (unusedVariable != null) {
                    unusedScopeVariables.remove(unusedVariable);
                    usedScopeVariables.add(hintVariable);
                    return;
                }
                unusedScopeVariables.add(hintVariable);
            }
        }

        @Override
        public void visit(Program node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getBody() != null) {
                this.parentNodes.push(node);
                super.visit(node);
                this.parentNodes.pop();
            }
        }

        @Override
        public void visit(EchoStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpressions());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ExpressionStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getExpression() instanceof Variable) {
                this.forceVariableAsUnused = true;
                this.scan(node.getExpression());
                this.forceVariableAsUnused = false;
            } else {
                this.scan(node.getExpression());
            }
        }

        @Override
        public void visit(Include node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(FunctionInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            String functionName = CodeUtils.extractFunctionName(node);
            if ("compact".equals(functionName)) {
                this.handleCompactFunction(node);
            }
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        private void handleCompactFunction(FunctionInvocation node) {
            List<Expression> parameters = node.getParameters();
            for (Expression parameter : parameters) {
                this.handleFunctionParameter(parameter);
            }
        }

        private void handleFunctionParameter(Expression parameter) {
            if (parameter instanceof Scalar) {
                this.handleScalar((Scalar)parameter);
            }
        }

        private void handleScalar(Scalar scalar) {
            if (scalar.getScalarType().equals((Object)Scalar.Type.STRING)) {
                this.process(HintVariable.create(scalar, this.extractVariableName(scalar.getStringValue())));
            }
        }

        private String extractVariableName(String quotedValue) {
            String result = quotedValue;
            if (quotedValue.startsWith("'") && quotedValue.endsWith("'") || quotedValue.startsWith("\"") && quotedValue.endsWith("\"")) {
                result = quotedValue.substring(1, quotedValue.length() - 1);
            }
            return result;
        }

        @Override
        public void visit(MethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getDispatcher());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(IfStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getTrueStatement());
            this.scan(node.getFalseStatement());
        }

        @Override
        public void visit(InstanceOfExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.scan(node.getClassName());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PostfixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PrefixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReflectionVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            Expression name = node.getName();
            if (name instanceof Scalar) {
                this.handleScalar((Scalar)name);
            } else {
                this.scan(name);
            }
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CloneExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CastExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getLeftHandSide());
            this.forceVariableAsUsed = true;
            this.scan(node.getRightHandSide());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ConditionalExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.scan(node.getIfTrue());
            this.scan(node.getIfFalse());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReturnStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(SwitchStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(ThrowStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(UnaryOperation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.className = node.getName().getName();
            this.scan(node.getBody());
            this.className = "";
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getClassName());
            this.scan(node.ctorParams());
            this.scan(node.getBody());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(DoStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(DeclareStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getBody());
        }

        @Override
        public void visit(CatchClause node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Block body = node.getBody();
            if (!body.getStatements().isEmpty()) {
                this.scan(node.getVariable());
            }
            this.scan(body);
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (UnusedVariableHint.this.checkUnusedFormalParameters(UnusedVariableHint.this.preferences) && !UnusedVariableHint.this.checkInheritedMethodParameters(UnusedVariableHint.this.preferences)) {
                String methodName = node.getFunction().getFunctionName().getName();
                List<String> classNames = this.allInheritedMethods.get(methodName);
                if (classNames != null) {
                    for (String clsName : classNames) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (!this.className.equals(clsName)) continue;
                        this.isInInheritedMethod = true;
                        break;
                    }
                }
                super.visit(node);
                this.isInInheritedMethod = false;
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(FormalParameter node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (UnusedVariableHint.this.checkUnusedFormalParameters(UnusedVariableHint.this.preferences) && !this.isInInheritedMethod) {
                this.scan(node.getParameterName());
            } else {
                this.forceVariableAsUsed = true;
                this.scan(node.getParameterName());
                this.forceVariableAsUsed = false;
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getKey());
            this.scan(node.getValue());
            this.scan(node.getStatement());
        }

        @Override
        public void visit(ForStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getInitializers());
            this.scan(node.getConditions());
            this.scan(node.getUpdaters());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getDispatcher());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(WhileStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.firstArrowFunctionNode == null) {
                this.firstArrowFunctionNode = node;
            }
            if (this.currentArrowFunctionNode == null || this.parentNodes.peek() instanceof LambdaFunctionDeclaration) {
                this.currentArrowFunctionNode = node;
            }
            this.isInInheritedMethod = false;
            this.collectArrowFunctionParameters(node);
            Expression expression = node.getExpression();
            while (expression instanceof ArrowFunctionDeclaration) {
                expression = ((ArrowFunctionDeclaration)expression).getExpression();
            }
            this.forceVariableAsUsed = true;
            if (expression instanceof LambdaFunctionDeclaration) {
                this.scan(((LambdaFunctionDeclaration)expression).getLexicalVariables());
            } else {
                this.scan(expression);
            }
            this.forceVariableAsUsed = false;
            this.parentNodes.push(node);
            this.scan(node.getFormalParameters());
            this.scan(node.getExpression());
            this.parentNodes.pop();
            if (this.firstArrowFunctionNode == node) {
                this.firstArrowFunctionNode = null;
                this.currentArrowFunctionNode = null;
                this.arrowFunctionParameters.clear();
            }
        }

        private void collectArrowFunctionParameters(ArrowFunctionDeclaration node) {
            Set<String> arrowFunctionParams = this.arrowFunctionParameters.get(this.currentArrowFunctionNode);
            if (arrowFunctionParams == null) {
                arrowFunctionParams = new HashSet<String>();
                this.arrowFunctionParameters.put(this.currentArrowFunctionNode, arrowFunctionParams);
            }
            node.getFormalParameters().stream().map(param -> CodeUtils.extractFormalParameterName(param)).filter(parameterName -> parameterName != null).forEachOrdered(parameterName -> this.arrowFunctionParameters.get(this.currentArrowFunctionNode).add((String)parameterName));
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInInheritedMethod = false;
            this.forceVariableAsUsed = true;
            this.scan(node.getLexicalVariables());
            this.forceVariableAsUsed = false;
            this.parentNodes.push(node);
            this.scan(node.getLexicalVariables());
            this.scan(node.getFormalParameters());
            this.scan(node.getBody());
            this.parentNodes.pop();
        }

        @Override
        public void visit(StaticFieldAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.forceVariableAsUsed = true;
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(InterfaceDeclaration node) {
        }

        @Override
        public void visit(FieldsDeclaration node) {
        }

        @Override
        public void visit(PHPDocBlock node) {
        }

        @Override
        public void visit(PHPDocTypeTag node) {
        }

        @Override
        public void visit(PHPDocMethodTag node) {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
        }

        @Override
        public void visit(PHPDocStaticAccessType node) {
        }

        @Override
        public void visit(PHPVarComment node) {
        }

        @Override
        public void visit(ConstantDeclaration node) {
        }

        @Override
        public void visit(ContinueStatement node) {
        }

        @Override
        public void visit(SingleFieldDeclaration node) {
        }

        @Override
        public void visit(UseStatement node) {
        }

        @Override
        public void visit(SingleUseStatementPart node) {
        }

        @Override
        public void visit(GroupUseStatementPart node) {
        }

        @Override
        public void visit(GotoLabel node) {
        }

        @Override
        public void visit(GotoStatement node) {
        }
    }
}

